/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.SharedUndoRedoStacksHolder;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoRedo;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.text.StringUtil;

class Undo
extends UndoRedo {
    Undo(UndoManagerImpl manager2, FileEditor editor) {
        super(manager2, editor);
    }

    @Override
    protected UndoRedoStacksHolder getStacksHolder() {
        return this.myManager.getUndoStacksHolder();
    }

    @Override
    protected UndoRedoStacksHolder getReverseStacksHolder() {
        return this.myManager.getRedoStacksHolder();
    }

    @Override
    protected SharedUndoRedoStacksHolder getSharedStacksHolder() {
        return this.myManager.getSharedUndoStacksHolder();
    }

    @Override
    protected SharedUndoRedoStacksHolder getSharedReverseStacksHolder() {
        return this.myManager.getSharedRedoStacksHolder();
    }

    @Override
    protected String getActionName() {
        return IdeBundle.message((String)"undo.dialog.title", (Object[])new Object[0]);
    }

    @Override
    protected String getActionName(String commandName2) {
        if (StringUtil.isEmpty((String)commandName2)) {
            commandName2 = ActionsBundle.message((String)"action.undo.description.empty", (Object[])new Object[0]);
        }
        return IdeBundle.message((String)"undo.command", (Object[])new Object[]{commandName2});
    }

    @Override
    protected void performAction() throws UnexpectedUndoException {
        this.myUndoableGroup.undo();
    }

    @Override
    protected EditorAndState getBeforeState() {
        return this.myUndoableGroup.getStateAfter();
    }

    @Override
    protected EditorAndState getAfterState() {
        return this.myUndoableGroup.getStateBefore();
    }

    @Override
    protected void setBeforeState(EditorAndState state) {
        this.myUndoableGroup.setStateAfter(state);
    }

    @Override
    protected boolean isRedo() {
        return false;
    }
}

