/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.DocumentReferenceByDocument;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoRedoStacksHolderBase;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

final class UndoRedoStacksHolder
extends UndoRedoStacksHolderBase<UndoableGroup> {
    private final LinkedList<UndoableGroup> myGlobalStack = new LinkedList();

    UndoRedoStacksHolder(boolean isUndo) {
        super(isUndo);
    }

    boolean canBeUndoneOrRedone(@NotNull Collection<? extends DocumentReference> refs) {
        if (refs == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(0);
        }
        if (refs.isEmpty()) {
            return !this.myGlobalStack.isEmpty() && this.myGlobalStack.getLast().isValid();
        }
        for (DocumentReference documentReference : refs) {
            if (this.getStack(documentReference).isEmpty() || !((UndoableGroup)this.getStack(documentReference).getLast()).isValid()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    UndoableGroup getLastAction(@NotNull Collection<? extends DocumentReference> refs) {
        if (refs == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(1);
        }
        if (refs.isEmpty()) {
            UndoableGroup undoableGroup = this.myGlobalStack.getLast();
            if (undoableGroup == null) {
                UndoRedoStacksHolder.$$$reportNull$$$0(2);
            }
            return undoableGroup;
        }
        UndoableGroup mostRecentAction = null;
        int mostRecentDocTimestamp = 0;
        for (DocumentReference documentReference : refs) {
            LinkedList stack = this.getStack(documentReference);
            if (stack.isEmpty()) continue;
            UndoableGroup lastAction = (UndoableGroup)stack.getLast();
            int timestamp = lastAction.getCommandTimestamp();
            if (mostRecentAction != null && (!lastAction.isTemporary() || mostRecentAction.isTemporary()) && (lastAction.isTemporary() != mostRecentAction.isTemporary() || !(this.myUndo ? timestamp > mostRecentDocTimestamp : timestamp < mostRecentDocTimestamp))) continue;
            mostRecentAction = lastAction;
            mostRecentDocTimestamp = timestamp;
        }
        UndoableGroup undoableGroup = mostRecentAction;
        if (undoableGroup == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(3);
        }
        return undoableGroup;
    }

    @NotNull
    Set<DocumentReference> collectClashingActions(@NotNull UndoableGroup group2) {
        UndoableGroup last;
        if (group2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(4);
        }
        HashSet<DocumentReference> result2 = new HashSet<DocumentReference>();
        for (DocumentReference each : group2.getAffectedDocuments()) {
            UndoableGroup last2 = (UndoableGroup)this.getStack(each).peekLast();
            if (last2 == null || last2 == group2) continue;
            result2.addAll(last2.getAffectedDocuments());
        }
        if (group2.isGlobal() && (last = this.myGlobalStack.peekLast()) != null && last != group2) {
            result2.addAll(last.getAffectedDocuments());
        }
        HashSet<DocumentReference> hashSet = result2;
        if (hashSet == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    void addToStacks(@NotNull UndoableGroup group2) {
        if (group2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(6);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding to " + this.getStacksDescription() + ": " + group2.dumpState());
        }
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(group2)) {
            if (this.myUndo && !group2.isTemporary()) {
                UndoRedoStacksHolder.convertTemporaryActionsToPermanent(each);
            }
            this.doAddToStack(each, group2, each == this.myGlobalStack ? UndoManagerImpl.getGlobalUndoLimit() : UndoManagerImpl.getDocumentUndoLimit());
        }
    }

    private void doAddToStack(@NotNull LinkedList<UndoableGroup> stack, @NotNull UndoableGroup group2, int limit) {
        if (stack == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(7);
        }
        if (group2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(8);
        }
        if (!group2.isUndoable() && stack.isEmpty()) {
            return;
        }
        stack.add(group2);
        while (stack.size() > limit) {
            this.clearStacksFrom(stack.getFirst());
        }
    }

    void removeFromStacks(@NotNull UndoableGroup group2) {
        if (group2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(9);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing from " + this.getStacksDescription() + ": " + group2.dumpState());
        }
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(group2)) {
            assert (each.getLast() == group2);
            each.removeLast();
        }
    }

    void clearStacks(boolean clearGlobal, @NotNull Set<? extends DocumentReference> refs) {
        if (refs == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(10);
        }
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(clearGlobal, refs)) {
            while (!each.isEmpty()) {
                this.clearStacksFrom(each.getLast());
            }
        }
        this.removeEmptyStacks();
    }

    @Override
    void clearDocumentReferences(@NotNull Document document) {
        if (document == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(11);
        }
        super.clearDocumentReferences(document);
        DocumentReference referenceFile = DocumentReferenceManager.getInstance().create(document);
        DocumentReferenceByDocument referenceDoc = new DocumentReferenceByDocument(document);
        this.myGlobalStack.removeIf(group2 -> ContainerUtil.and(group2.getAffectedDocuments(), ref -> ref.equals(referenceFile) || ref.equals(referenceDoc)));
    }

    private static void convertTemporaryActionsToPermanent(LinkedList<UndoableGroup> each) {
        UndoableGroup group1;
        for (int i2 = each.size() - 1; i2 >= 0 && (group1 = each.get(i2)).isTemporary(); --i2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Converting to permanent: " + group1);
            }
            group1.makePermanent();
        }
    }

    private void clearStacksFrom(@NotNull UndoableGroup from2) {
        if (from2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(12);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Clearing " + this.getStacksDescription() + " from " + from2.dumpState());
        }
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(from2)) {
            int pos = each.indexOf(from2);
            if (pos == -1) continue;
            if (pos > 0) {
                int top = each.size() - pos;
                this.clearStacksFrom(each.get(pos - 1));
                assert (each.size() == top && each.indexOf(from2) == 0);
            }
            each.removeFirst();
        }
        from2.invalidateChangeRanges();
    }

    @NotNull
    private List<LinkedList<UndoableGroup>> getAffectedStacks(@NotNull UndoableGroup group2) {
        if (group2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(13);
        }
        return this.getAffectedStacks(group2.isGlobal(), group2.getAffectedDocuments());
    }

    @NotNull
    private List<LinkedList<UndoableGroup>> getAffectedStacks(boolean global, @NotNull Collection<? extends DocumentReference> refs) {
        if (refs == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(14);
        }
        ArrayList<LinkedList<UndoableGroup>> result2 = new ArrayList<LinkedList<UndoableGroup>>(refs.size() + 1);
        if (global) {
            result2.add(this.myGlobalStack);
        }
        for (DocumentReference documentReference : refs) {
            result2.add(this.getStack(documentReference));
        }
        ArrayList<LinkedList<UndoableGroup>> arrayList = result2;
        if (arrayList == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @TestOnly
    void clearAllStacksInTests() {
        this.clearStacks(true, this.getAffectedDocuments());
        this.myGlobalStack.clear();
        this.myDocumentStacks.clear();
        this.myDocumentsWithStacks.clear();
        this.myNonlocalVirtualFilesWithStacks.clear();
    }

    void collectAllAffectedDocuments(@NotNull Collection<? super DocumentReference> result2) {
        if (result2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(16);
        }
        for (UndoableGroup each : this.myGlobalStack) {
            result2.addAll(each.getAffectedDocuments());
        }
        this.collectLocalAffectedDocuments(result2);
    }

    private void collectLocalAffectedDocuments(@NotNull Collection<? super DocumentReference> result2) {
        if (result2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(17);
        }
        result2.addAll(this.myDocumentStacks.keySet());
        DocumentReferenceManager documentReferenceManager = DocumentReferenceManager.getInstance();
        for (Document each : this.myDocumentsWithStacks) {
            result2.add((DocumentReference)documentReferenceManager.create(each));
        }
        for (Document each : this.myNonlocalVirtualFilesWithStacks) {
            result2.add((DocumentReference)documentReferenceManager.create((VirtualFile)each));
        }
    }

    @NotNull
    private Set<DocumentReference> getAffectedDocuments() {
        HashSet<DocumentReference> result2 = new HashSet<DocumentReference>();
        this.collectAllAffectedDocuments(result2);
        HashSet<DocumentReference> hashSet = result2;
        if (hashSet == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(18);
        }
        return hashSet;
    }

    int getLastCommandTimestamp(@NotNull DocumentReference r) {
        LinkedList stack;
        if (r == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(19);
        }
        if ((stack = this.getStack(r)).isEmpty()) {
            return 0;
        }
        return Math.max(((UndoableGroup)stack.getFirst()).getCommandTimestamp(), ((UndoableGroup)stack.getLast()).getCommandTimestamp());
    }

    void invalidateActionsFor(@NotNull DocumentReference ref) {
        if (ref == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(20);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invalidating actions in " + this.getStacksDescription() + " for " + ref);
        }
        for (List list2 : this.getAffectedStacks(true, Collections.singleton(ref))) {
            for (UndoableGroup eachGroup : list2) {
                eachGroup.invalidateActionsFor(ref);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/UndoRedoStacksHolder";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/UndoRedoStacksHolder";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClashingActions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedStacks";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedDocuments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canBeUndoneOrRedone";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLastAction";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 15: 
            case 18: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectClashingActions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addToStacks";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doAddToStack";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeFromStacks";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "clearStacks";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "clearDocumentReferences";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "clearStacksFrom";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedStacks";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectAllAffectedDocuments";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectLocalAffectedDocuments";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommandTimestamp";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "invalidateActionsFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

