/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageBraceMatching;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlipCommaIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.name.flip", (Object[])new Object[0]);
        if (string == null) {
            FlipCommaIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.family.name.flip", (Object[])new Object[0]);
        if (string == null) {
            FlipCommaIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement comma;
        if (project == null) {
            FlipCommaIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            FlipCommaIntention.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            FlipCommaIntention.$$$reportNull$$$0(4);
        }
        if ((comma = FlipCommaIntention.currentCommaElement(editor, file2)) == null) {
            return false;
        }
        PsiElement left = FlipCommaIntention.smartAdvance(comma, false);
        PsiElement right = FlipCommaIntention.smartAdvance(comma, true);
        return left != null && right != null && !left.getText().equals(right.getText()) && Flipper.isCanFlip(left, right);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement element2;
        if (project == null) {
            FlipCommaIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            FlipCommaIntention.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            FlipCommaIntention.$$$reportNull$$$0(7);
        }
        if ((element2 = FlipCommaIntention.currentCommaElement(editor, file2)) != null) {
            FlipCommaIntention.swapAtComma(element2);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static void swapAtComma(@NotNull PsiElement comma) {
        if (comma == null) {
            FlipCommaIntention.$$$reportNull$$$0(8);
        }
        PsiElement prev2 = FlipCommaIntention.smartAdvance(comma, false);
        PsiElement next = FlipCommaIntention.smartAdvance(comma, true);
        if (prev2 != null && next != null) {
            if (Flipper.tryFlip(prev2, next)) {
                return;
            }
            FlipCommaIntention.swapViaDocument(comma, prev2, next);
        }
    }

    private static void swapViaDocument(@NotNull PsiElement comma, PsiElement prev2, PsiElement next) {
        DocumentEx document;
        if (comma == null) {
            FlipCommaIntention.$$$reportNull$$$0(9);
        }
        if ((document = (DocumentEx)comma.getContainingFile().getViewProvider().getDocument()) == null) {
            return;
        }
        String prevText = prev2.getText();
        String nextText = next.getText();
        TextRange prevRange = prev2.getTextRange();
        TextRange nextRange = next.getTextRange();
        document.replaceString(prevRange.getStartOffset(), prevRange.getEndOffset(), nextText);
        nextRange = nextRange.shiftRight(nextText.length() - prevText.length());
        document.replaceString(nextRange.getStartOffset(), nextRange.getEndOffset(), prevText);
    }

    private static PsiElement currentCommaElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement element2;
        if (editor == null) {
            FlipCommaIntention.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            FlipCommaIntention.$$$reportNull$$$0(11);
        }
        if (!FlipCommaIntention.isComma(element2 = FlipCommaIntention.leftElement(editor, file2)) && !FlipCommaIntention.isComma(element2 = FlipCommaIntention.rightElement(editor, file2))) {
            return null;
        }
        return element2;
    }

    @Nullable
    private static PsiElement leftElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            FlipCommaIntention.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            FlipCommaIntention.$$$reportNull$$$0(13);
        }
        return file2.findElementAt(editor.getCaretModel().getOffset() - 1);
    }

    @Nullable
    private static PsiElement rightElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            FlipCommaIntention.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            FlipCommaIntention.$$$reportNull$$$0(15);
        }
        return file2.findElementAt(editor.getCaretModel().getOffset());
    }

    private static boolean isComma(@Nullable PsiElement element2) {
        return element2 != null && element2.textMatches((CharSequence)",");
    }

    @NotNull
    private static JBIterable<PsiElement> getSiblings(PsiElement element2, boolean fwd) {
        SyntaxTraverser.ApiEx api = fwd ? SyntaxTraverser.psiApi() : SyntaxTraverser.psiApiReversed();
        JBIterable flatSiblings = JBIterable.generate((Object)element2, arg_0 -> ((SyntaxTraverser.ApiEx)api).next(arg_0)).skip(1);
        JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.syntaxTraverser((SyntaxTraverser.Api)api).withRoots((Iterable)flatSiblings)).expandAndSkip(e -> api.typeOf(e) == GeneratedParserUtilBase.DUMMY_BLOCK)).traverse();
        if (jBIterable == null) {
            FlipCommaIntention.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    private static boolean isFlippable(PsiElement e) {
        if (e instanceof PsiWhiteSpace || e instanceof PsiComment) {
            return false;
        }
        return StringUtil.isNotEmpty((String)e.getText());
    }

    @Nullable
    private static PsiElement smartAdvance(PsiElement element2, boolean fwd) {
        PsiElement candidate = (PsiElement)FlipCommaIntention.getSiblings(element2, fwd).filter(e -> FlipCommaIntention.isFlippable(e)).first();
        if (candidate != null && FlipCommaIntention.isBrace(candidate)) {
            return null;
        }
        return candidate;
    }

    private static boolean isBrace(@NotNull PsiElement candidate) {
        PairedBraceMatcher braceMatcher;
        ASTNode node2;
        if (candidate == null) {
            FlipCommaIntention.$$$reportNull$$$0(17);
        }
        if ((node2 = candidate.getNode()) != null && node2.getFirstChildNode() == null && (braceMatcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(candidate.getLanguage())) != null) {
            IElementType elementType = node2.getElementType();
            for (BracePair pair : braceMatcher.getPairs()) {
                if (elementType != pair.getLeftBraceType() && elementType != pair.getRightBraceType()) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actions/FlipCommaIntention";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comma";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actions/FlipCommaIntention";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "swapAtComma";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "swapViaDocument";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "currentCommaElement";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "leftElement";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "rightElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isBrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Flipper {
        public static final LanguageExtension<Flipper> EXTENSION = new LanguageExtension("com.intellij.flipCommaIntention.flipper");

        public boolean flip(@NotNull PsiElement var1, @NotNull PsiElement var2);

        default public boolean canFlip(@NotNull PsiElement left, @NotNull PsiElement right) {
            if (left == null) {
                Flipper.$$$reportNull$$$0(0);
            }
            if (right == null) {
                Flipper.$$$reportNull$$$0(1);
            }
            return true;
        }

        public static boolean tryFlip(PsiElement left, PsiElement right) {
            Language language = left.getLanguage();
            for (Flipper handler2 : EXTENSION.allForLanguage(language)) {
                if (!handler2.flip(left, right)) continue;
                return true;
            }
            return false;
        }

        public static boolean isCanFlip(PsiElement left, PsiElement right) {
            Language language = left.getLanguage();
            for (Flipper handler2 : EXTENSION.allForLanguage(language)) {
                if (handler2.canFlip(left, right)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "left";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "right";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/actions/FlipCommaIntention$Flipper";
            objectArray[2] = "canFlip";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

