/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.util.text.ImmutableCharSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class EditorActionPlan
implements ActionPlan {
    private ImmutableCharSequence myText;
    private final Editor myEditor;
    private int myCaretOffset;
    private final List<Replacement> myReplacements;

    EditorActionPlan(@NotNull Editor editor) {
        if (editor == null) {
            EditorActionPlan.$$$reportNull$$$0(0);
        }
        this.myReplacements = new ArrayList<Replacement>();
        this.myEditor = editor;
        this.myText = (ImmutableCharSequence)editor.getDocument().getImmutableCharSequence();
        this.myCaretOffset = editor.getCaretModel().getOffset();
    }

    @NotNull
    public ImmutableCharSequence getText() {
        ImmutableCharSequence immutableCharSequence = this.myText;
        if (immutableCharSequence == null) {
            EditorActionPlan.$$$reportNull$$$0(1);
        }
        return immutableCharSequence;
    }

    public void replace(int begin, int end, String s) {
        this.myText = this.myText.replace(begin, end, (CharSequence)s);
        this.myReplacements.add(new Replacement(begin, end, s));
        if (this.myCaretOffset == end) {
            this.myCaretOffset += s.length() - (end - begin);
        }
    }

    public int getCaretOffset() {
        return this.myCaretOffset;
    }

    public void setCaretOffset(int offset) {
        this.myCaretOffset = offset;
    }

    public List<Replacement> getReplacements() {
        return Collections.unmodifiableList(this.myReplacements);
    }

    public int getCaretShift() {
        return this.myCaretOffset - this.myEditor.getCaretModel().getOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorActionPlan";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorActionPlan";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Replacement {
        private final int myBegin;
        private final int myEnd;
        private final String myText;

        Replacement(int begin, int end, String text2) {
            this.myBegin = begin;
            this.myEnd = end;
            this.myText = text2;
        }

        public int getBegin() {
            return this.myBegin;
        }

        public int getEnd() {
            return this.myEnd;
        }

        public String getText() {
            return this.myText;
        }
    }
}

