/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LazyRangeMarkerFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class LazyRangeMarkerFactoryImpl
extends LazyRangeMarkerFactory {
    private final Project myProject;

    public LazyRangeMarkerFactoryImpl(@NotNull Project project) {
        if (project == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull VirtualFile file2, int offset) {
        if (file2 == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(1);
        }
        RangeMarker rangeMarker = (RangeMarker)ReadAction.compute(() -> DocumentImpl.createRangeMarkerForVirtualFile(file2, offset, offset, -1, -1, -1, -1, false));
        if (rangeMarker == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(2);
        }
        return rangeMarker;
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull VirtualFile file2, int line, int column2, boolean persistent) {
        if (file2 == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(3);
        }
        RangeMarker rangeMarker = (RangeMarker)ReadAction.compute(() -> {
            Document document;
            Document document2 = document = file2.getFileType().isBinary() ? null : FileDocumentManager.getInstance().getDocument(file2);
            if (document != null) {
                int myTabSize = CodeStyle.getFacade((Project)this.myProject, (Document)document, (FileType)file2.getFileType()).getTabSize();
                int offset = LazyRangeMarkerFactoryImpl.calculateOffset(document, line, column2, myTabSize);
                return DocumentImpl.createRangeMarkerForVirtualFile(file2, offset, offset, line, column2, line, column2, persistent);
            }
            return DocumentImpl.createRangeMarkerForVirtualFile(file2, 0, 0, line, column2, line, column2, persistent);
        });
        if (rangeMarker == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(4);
        }
        return rangeMarker;
    }

    private static int calculateOffset(@NotNull Document document, int line, int column2, int tabSize) {
        int offset;
        if (document == null) {
            LazyRangeMarkerFactoryImpl.$$$reportNull$$$0(5);
        }
        if (0 <= line && line < document.getLineCount()) {
            int lineStart = document.getLineStartOffset(line);
            int lineEnd = document.getLineEndOffset(line);
            CharSequence docText = document.getCharsSequence();
            offset = lineStart;
            for (int col = 0; offset < lineEnd && col < column2; col += docText.charAt(offset) == '\t' ? tabSize : 1, ++offset) {
            }
        } else {
            offset = document.getTextLength();
        }
        return offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createRangeMarker";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calculateOffset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

