/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autolink;

import com.intellij.CommonBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTracker;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemProjectLinkListener;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemUnlinkedProjectAware;
import com.intellij.openapi.externalSystem.autolink.UnlinkedProjectUtilsKt;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.DisposableWrapperList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@com.intellij.openapi.components.State(name="UnlinkedProjectNotification", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0017\u0018B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0007J\b\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0016\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bR2\u0010\u0006\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/externalSystem/autolink/UnlinkedProjectNotificationAware;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/openapi/externalSystem/autolink/UnlinkedProjectNotificationAware$State;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "disabledNotifications", "", "", "kotlin.jvm.PlatformType", "", "notifiedNotifications", "Lcom/intellij/util/containers/DisposableWrapperList;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "getProjectsWithNotification", "getState", "loadState", "", "state", "notify", "unlinkedProjectAware", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemUnlinkedProjectAware;", "externalProjectPath", "Companion", "State", "intellij.platform.externalSystem.impl"})
public final class UnlinkedProjectNotificationAware
implements PersistentStateComponent<State> {
    private final Set<String> disabledNotifications;
    private final DisposableWrapperList<ExternalSystemProjectId> notifiedNotifications;
    private final Project project;
    private static final String NOTIFICATION_GROUP_ID = "External System Auto-Link Notification Group";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void notify(@NotNull ExternalSystemUnlinkedProjectAware unlinkedProjectAware, @NotNull String externalProjectPath) {
        Intrinsics.checkNotNullParameter((Object)unlinkedProjectAware, (String)"unlinkedProjectAware");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        ApplicationManager.getApplication().assertIsDispatchThread();
        ProjectSystemId systemId2 = unlinkedProjectAware.getSystemId();
        ExternalSystemProjectId projectId = UnlinkedProjectUtilsKt.getProjectId(unlinkedProjectAware, externalProjectPath);
        String string = systemId2.getReadableName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"systemId.readableName");
        String systemName = string;
        if (this.disabledNotifications.contains(systemId2.getId())) {
            return;
        }
        if (this.notifiedNotifications.contains((Object)projectId)) {
            AutoImportProjectTracker.Companion.getLOG().debug("Unlinked " + projectId.getReadableName() + " project notification is already notified");
            return;
        }
        NotificationGroupManager notificationManager2 = NotificationGroupManager.getInstance();
        NotificationGroup notificationGroup = notificationManager2.getNotificationGroup(NOTIFICATION_GROUP_ID);
        String string2 = ExternalSystemBundle.message((String)"unlinked.project.notification.title", (Object[])new Object[]{systemName});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"unlinked.projec\u2026ation.title\", systemName)");
        Notification notification = notificationGroup.createNotification(string2, NotificationType.INFORMATION);
        Disposable notificationDisposable = UnlinkedProjectUtilsKt.createExtensionDisposable(this.project, unlinkedProjectAware);
        this.notifiedNotifications.add((Object)projectId, notificationDisposable);
        notification.whenExpired(new Runnable(notificationDisposable){
            final /* synthetic */ Disposable $notificationDisposable;

            public final void run() {
                Disposer.dispose((Disposable)this.$notificationDisposable);
            }
            {
                this.$notificationDisposable = disposable2;
            }
        });
        unlinkedProjectAware.subscribe(this.project, new ExternalSystemProjectLinkListener(notification){
            final /* synthetic */ Notification $notification;

            public void onProjectLinked(@NotNull String externalProjectPath) {
                Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
                this.$notification.expire();
            }
            {
                this.$notification = $captured_local_variable$0;
            }

            public void onProjectUnlinked(@NotNull String externalProjectPath) {
                Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
                ExternalSystemProjectLinkListener.DefaultImpls.onProjectUnlinked((ExternalSystemProjectLinkListener)this, (String)externalProjectPath);
            }
        }, notificationDisposable);
        notification.addAction((AnAction)NotificationAction.createSimple((String)unlinkedProjectAware.getNotificationText(), (Runnable)new Runnable(this, notification, unlinkedProjectAware, externalProjectPath){
            final /* synthetic */ UnlinkedProjectNotificationAware this$0;
            final /* synthetic */ Notification $notification;
            final /* synthetic */ ExternalSystemUnlinkedProjectAware $unlinkedProjectAware;
            final /* synthetic */ String $externalProjectPath;

            public final void run() {
                this.$notification.expire();
                UnlinkedProjectUtilsKt.linkAndLoadProjectWithLoadingConfirmation(this.$unlinkedProjectAware, UnlinkedProjectNotificationAware.access$getProject$p(this.this$0), this.$externalProjectPath);
            }
            {
                this.this$0 = unlinkedProjectNotificationAware;
                this.$notification = notification;
                this.$unlinkedProjectAware = externalSystemUnlinkedProjectAware;
                this.$externalProjectPath = string;
            }
        }));
        notification.addAction((AnAction)NotificationAction.createSimple((String)ExternalSystemBundle.message((String)"unlinked.project.notification.skip.action", (Object[])new Object[0]), (Runnable)new Runnable(this, notification, systemId2){
            final /* synthetic */ UnlinkedProjectNotificationAware this$0;
            final /* synthetic */ Notification $notification;
            final /* synthetic */ ProjectSystemId $systemId;

            public final void run() {
                this.$notification.expire();
                UnlinkedProjectNotificationAware.access$getDisabledNotifications$p(this.this$0).add(this.$systemId.getId());
            }
            {
                this.this$0 = unlinkedProjectNotificationAware;
                this.$notification = notification;
                this.$systemId = projectSystemId;
            }
        }));
        notification.setContextHelpAction((AnAction)new DumbAwareAction(systemName, CommonBundle.getHelpButtonText(), ExternalSystemBundle.message((String)"unlinked.project.notification.help.text", (Object[])new Object[]{systemName}), null){
            final /* synthetic */ String $systemName;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
            {
                this.$systemName = $captured_local_variable$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        });
        notification.notify(this.project);
        AutoImportProjectTracker.Companion.getLOG().debug("Notified unlinked " + projectId.getReadableName() + " project notification");
    }

    @TestOnly
    @NotNull
    public final Set<ExternalSystemProjectId> getProjectsWithNotification() {
        return CollectionsKt.toSet((Iterable)((Iterable)this.notifiedNotifications));
    }

    @NotNull
    public State getState() {
        Set<String> set2 = this.disabledNotifications;
        Intrinsics.checkNotNullExpressionValue(set2, (String)"disabledNotifications");
        return new State(set2);
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.disabledNotifications.clear();
        this.disabledNotifications.addAll((Collection<String>)state.getDisabledNotifications());
    }

    public UnlinkedProjectNotificationAware(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.disabledNotifications = Collections.newSetFromMap(new ConcurrentHashMap());
        this.notifiedNotifications = new DisposableWrapperList();
    }

    public static final /* synthetic */ Project access$getProject$p(UnlinkedProjectNotificationAware $this) {
        return $this.project;
    }

    @JvmStatic
    @NotNull
    public static final UnlinkedProjectNotificationAware getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    public static final void enableNotifications(@NotNull Project project, @NotNull ProjectSystemId systemId2) {
        Companion.enableNotifications(project, systemId2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0004H\u00d6\u0001R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/externalSystem/autolink/UnlinkedProjectNotificationAware$State;", "", "disabledNotifications", "", "", "(Ljava/util/Set;)V", "getDisabledNotifications", "()Ljava/util/Set;", "setDisabledNotifications", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.externalSystem.impl"})
    public static final class State {
        @NotNull
        private Set<String> disabledNotifications;

        @NotNull
        public final Set<String> getDisabledNotifications() {
            return this.disabledNotifications;
        }

        public final void setDisabledNotifications(@NotNull Set<String> set2) {
            Intrinsics.checkNotNullParameter(set2, (String)"<set-?>");
            this.disabledNotifications = set2;
        }

        public State(@NotNull Set<String> disabledNotifications) {
            Intrinsics.checkNotNullParameter(disabledNotifications, (String)"disabledNotifications");
            this.disabledNotifications = disabledNotifications;
        }

        public /* synthetic */ State(Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                set2 = SetsKt.emptySet();
            }
            this(set2);
        }

        public State() {
            this(null, 1, null);
        }

        @NotNull
        public final Set<String> component1() {
            return this.disabledNotifications;
        }

        @NotNull
        public final State copy(@NotNull Set<String> disabledNotifications) {
            Intrinsics.checkNotNullParameter(disabledNotifications, (String)"disabledNotifications");
            return new State(disabledNotifications);
        }

        public static /* synthetic */ State copy$default(State state, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                set2 = state.disabledNotifications;
            }
            return state.copy(set2);
        }

        @NotNull
        public String toString() {
            return "State(disabledNotifications=" + this.disabledNotifications + ")";
        }

        public int hashCode() {
            Set<String> set2 = this.disabledNotifications;
            return set2 != null ? ((Object)set2).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof State)) break block3;
                    State state = (State)object;
                    if (!Intrinsics.areEqual(this.disabledNotifications, state.disabledNotifications)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/externalSystem/autolink/UnlinkedProjectNotificationAware$Companion;", "", "()V", "NOTIFICATION_GROUP_ID", "", "enableNotifications", "", "project", "Lcom/intellij/openapi/project/Project;", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getInstance", "Lcom/intellij/openapi/externalSystem/autolink/UnlinkedProjectNotificationAware;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final UnlinkedProjectNotificationAware getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(UnlinkedProjectNotificationAware.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(Unlin\u2026icationAware::class.java)");
            return (UnlinkedProjectNotificationAware)object;
        }

        @JvmStatic
        public final void enableNotifications(@NotNull Project project, @NotNull ProjectSystemId systemId2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)systemId2, (String)"systemId");
            this.getInstance(project).disabledNotifications.remove(systemId2.getId());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

