/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autolink;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.externalSystem.autoimport.AsyncFileChangeListenerBase;
import com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTracker;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemProjectLinkListener;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemUnlinkedProjectAware;
import com.intellij.openapi.externalSystem.autolink.UnlinkedProjectNotificationAware;
import com.intellij.openapi.externalSystem.autolink.UnlinkedProjectUtilsKt;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\b0\u0007\"\u0004\b\u0000\u0010\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\u00070\u000bH\u0002J6\u0010\f\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000b0\r0\b0\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J>\u0010\f\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132$\u0010\u0015\u001a \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000b0\u0017\u0012\u0004\u0012\u00020\u00140\u0016H\u0002J,\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000b0\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J@\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000b0\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000e2\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000b0\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J4\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000e2\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000b0\u001aH\u0002J&\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001fH\u0002J.\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u001f2\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\u0018\u0010!\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\"\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\"\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\b*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\f\u0010%\u001a\u00020&*\u00020\u0011H\u0002J\f\u0010'\u001a\u00020&*\u00020\u0011H\u0002J\f\u0010(\u001a\u00020&*\u00020\u0011H\u0002J\f\u0010)\u001a\u00020&*\u00020\u0011H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/openapi/externalSystem/autolink/UnlinkedProjectStartupActivity;", "Lcom/intellij/openapi/startup/StartupActivity$Background;", "()V", "backgroundExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "allOf", "Ljava/util/concurrent/CompletableFuture;", "", "T", "futures", "", "findUnlinkedProjectBuildFiles", "Lkotlin/Pair;", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemUnlinkedProjectAware;", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "externalProjectPath", "", "", "callback", "Lkotlin/Function1;", "", "unlinkedProjectAware", "collectBuildFiles", "Lkotlin/Function0;", "linkProjectIfUnlinkedProjectsFound", "runActivity", "showNotificationIfUnlinkedProjectsFound", "buildFiles", "", "possibleBuildFiles", "showNotificationWhenBuildToolPluginEnabled", "showNotificationWhenNewBuildFileCreated", "showNotificationWhenNonEmptyProjectUnlinked", "getBuildFiles", "isEmptyModel", "", "isNewExternalProject", "isNewPlatformProject", "isOpenedWithEmptyModel", "NewBuildFilesListener", "intellij.platform.externalSystem.impl"})
public final class UnlinkedProjectStartupActivity
implements StartupActivity.Background {
    private final ExecutorService backgroundExecutor;

    public void runActivity(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = object.getPath()) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.guessProjectDir()?.path ?: return");
        Object externalProjectPath = object;
        this.showNotificationWhenNonEmptyProjectUnlinked(project);
        this.showNotificationWhenBuildToolPluginEnabled(project, (String)externalProjectPath);
        this.showNotificationWhenNewBuildFileCreated(project, (String)externalProjectPath);
        if (!this.isNewExternalProject(project)) {
            if (!this.isNewPlatformProject(project) && this.isOpenedWithEmptyModel(project)) {
                this.linkProjectIfUnlinkedProjectsFound(project, (String)externalProjectPath);
            } else {
                this.showNotificationIfUnlinkedProjectsFound(project, (String)externalProjectPath);
            }
        }
    }

    private final boolean isNewExternalProject(Project $this$isNewExternalProject) {
        return ExternalSystemUtil.isNewProject($this$isNewExternalProject);
    }

    private final boolean isNewPlatformProject(Project $this$isNewPlatformProject) {
        return PlatformProjectOpenProcessor.Companion.isNewProject($this$isNewPlatformProject);
    }

    private final boolean isOpenedWithEmptyModel(Project $this$isOpenedWithEmptyModel) {
        return PlatformProjectOpenProcessor.Companion.isConfiguredByPlatformProcessor($this$isOpenedWithEmptyModel) || this.isEmptyModel($this$isOpenedWithEmptyModel);
    }

    private final boolean isEmptyModel(Project $this$isEmptyModel) {
        ModuleManager moduleManager;
        ModuleManager moduleManager2 = moduleManager = ModuleManager.getInstance((Project)$this$isEmptyModel);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager2, (String)"moduleManager");
        Module[] moduleArray = moduleManager2.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"moduleManager.modules");
        Module[] moduleArray2 = moduleArray;
        boolean bl = false;
        return moduleArray2.length == 0;
    }

    private final void linkProjectIfUnlinkedProjectsFound(Project project, String externalProjectPath) {
        this.findUnlinkedProjectBuildFiles(project, externalProjectPath, (Function1<? super Map<ExternalSystemUnlinkedProjectAware, ? extends Collection<? extends VirtualFile>>, Unit>)((Function1)new Function1<Map<ExternalSystemUnlinkedProjectAware, ? extends Collection<? extends VirtualFile>>, Unit>(project, externalProjectPath){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $externalProjectPath;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Map<ExternalSystemUnlinkedProjectAware, ? extends Collection<? extends VirtualFile>> it) {
                void $this$filterTo$iv$iv;
                void $this$filterTo$iv$iv2;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Map<ExternalSystemUnlinkedProjectAware, ? extends Collection<? extends VirtualFile>> $this$filter$iv = it;
                boolean $i$f$filter = false;
                Map<ExternalSystemUnlinkedProjectAware, ? extends Collection<? extends VirtualFile>> map2 = $this$filter$iv;
                Map<ExternalSystemUnlinkedProjectAware, ? extends Collection<? extends VirtualFile>> destination$iv$iv = (Map<ExternalSystemUnlinkedProjectAware, ? extends Collection<? extends VirtualFile>>)new LinkedHashMap<K, V>();
                boolean $i$f$filterTo = false;
                void var8_12 = $this$filterTo$iv$iv2;
                boolean bl = false;
                Iterator<Map.Entry<K, V>> iterator2 = var8_12.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<K, V> element$iv$iv;
                    Map.Entry<K, V> $dstr$_u24__u24$buildFiles = element$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    Object object = $dstr$_u24__u24$buildFiles;
                    boolean bl3 = false;
                    Collection buildFiles = (Collection)object.getValue();
                    object = buildFiles;
                    bl3 = false;
                    if (!(!object.isEmpty())) continue;
                    destination$iv$iv.put((ExternalSystemUnlinkedProjectAware)element$iv$iv.getKey(), (Collection<? extends VirtualFile>)element$iv$iv.getValue());
                }
                Map<ExternalSystemUnlinkedProjectAware, ? extends Collection<? extends VirtualFile>> unlinkedProjects = destination$iv$iv;
                Map<ExternalSystemUnlinkedProjectAware, ? extends Collection<? extends VirtualFile>> $this$filter$iv2 = it;
                boolean $i$f$filter2 = false;
                destination$iv$iv = $this$filter$iv2;
                Map<ExternalSystemUnlinkedProjectAware, ? extends Collection<? extends VirtualFile>> destination$iv$iv2 = (Map<ExternalSystemUnlinkedProjectAware, ? extends Collection<? extends VirtualFile>>)new LinkedHashMap<K, V>();
                boolean $i$f$filterTo2 = false;
                void var9_16 = $this$filterTo$iv$iv;
                boolean bl4 = false;
                Iterator<Map.Entry<K, V>> iterator3 = var9_16.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry<K, V> element$iv$iv;
                    Map.Entry<K, V> $dstr$upa$_u24__u24 = element$iv$iv = iterator3.next();
                    boolean bl5 = false;
                    Map.Entry<K, V> entry2 = $dstr$upa$_u24__u24;
                    boolean bl6 = false;
                    ExternalSystemUnlinkedProjectAware upa = (ExternalSystemUnlinkedProjectAware)entry2.getKey();
                    if (!upa.isLinkedProject(this.$project, this.$externalProjectPath)) continue;
                    destination$iv$iv2.put((ExternalSystemUnlinkedProjectAware)element$iv$iv.getKey(), (Collection<? extends VirtualFile>)element$iv$iv.getValue());
                }
                Map<ExternalSystemUnlinkedProjectAware, ? extends Collection<? extends VirtualFile>> linkedProjects = destination$iv$iv2;
                if (unlinkedProjects.size() == 1 && linkedProjects.isEmpty() && !Registry.is((String)"external.system.auto.import.disabled")) {
                    ExternalSystemUnlinkedProjectAware unlinkedProject = (ExternalSystemUnlinkedProjectAware)CollectionsKt.single((Iterable)unlinkedProjects.keySet());
                    if (AutoImportProjectTracker.Companion.getLOG().isDebugEnabled()) {
                        ExternalSystemProjectId projectId = UnlinkedProjectUtilsKt.getProjectId(unlinkedProject, this.$externalProjectPath);
                        AutoImportProjectTracker.Companion.getLOG().debug("Auto-linked " + projectId.getReadableName() + " project");
                    }
                    UnlinkedProjectUtilsKt.linkAndLoadProjectWithLoadingConfirmation(unlinkedProject, this.$project, this.$externalProjectPath);
                } else {
                    UnlinkedProjectNotificationAware notificationAware = UnlinkedProjectNotificationAware.Companion.getInstance(this.$project);
                    destination$iv$iv2 = unlinkedProjects;
                    boolean bl7 = false;
                    Iterator<Map.Entry<ExternalSystemUnlinkedProjectAware, ? extends Collection<? extends VirtualFile>>> iterator4 = destination$iv$iv2.entrySet().iterator();
                    while (iterator4.hasNext()) {
                        Map.Entry<ExternalSystemUnlinkedProjectAware, ? extends Collection<? extends VirtualFile>> entry3;
                        Map.Entry<ExternalSystemUnlinkedProjectAware, ? extends Collection<? extends VirtualFile>> entry4 = entry3 = iterator4.next();
                        boolean bl8 = false;
                        ExternalSystemUnlinkedProjectAware unlinkedProjectAware = entry4.getKey();
                        notificationAware.notify(unlinkedProjectAware, this.$externalProjectPath);
                    }
                }
            }
            {
                this.$project = project;
                this.$externalProjectPath = string;
                super(1);
            }
        }));
    }

    private final void showNotificationIfUnlinkedProjectsFound(Project project, String externalProjectPath) {
        ExternalSystemUnlinkedProjectAware.Companion.getEP_NAME().forEachExtensionSafe(new Consumer(this, project, externalProjectPath){
            final /* synthetic */ UnlinkedProjectStartupActivity this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $externalProjectPath;

            public final void accept(ExternalSystemUnlinkedProjectAware it) {
                ExternalSystemUnlinkedProjectAware externalSystemUnlinkedProjectAware = it;
                Intrinsics.checkNotNullExpressionValue((Object)externalSystemUnlinkedProjectAware, (String)"it");
                UnlinkedProjectStartupActivity.access$showNotificationIfUnlinkedProjectsFound(this.this$0, this.$project, this.$externalProjectPath, externalSystemUnlinkedProjectAware);
            }
            {
                this.this$0 = unlinkedProjectStartupActivity;
                this.$project = project;
                this.$externalProjectPath = string;
            }
        });
    }

    private final void showNotificationIfUnlinkedProjectsFound(Project project, String externalProjectPath, Set<? extends VirtualFile> buildFiles) {
        ExternalSystemUnlinkedProjectAware.Companion.getEP_NAME().forEachExtensionSafe(new Consumer(this, project, externalProjectPath, buildFiles){
            final /* synthetic */ UnlinkedProjectStartupActivity this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $externalProjectPath;
            final /* synthetic */ Set $buildFiles;

            public final void accept(ExternalSystemUnlinkedProjectAware it) {
                ExternalSystemUnlinkedProjectAware externalSystemUnlinkedProjectAware = it;
                Intrinsics.checkNotNullExpressionValue((Object)externalSystemUnlinkedProjectAware, (String)"it");
                UnlinkedProjectStartupActivity.access$showNotificationIfUnlinkedProjectsFound(this.this$0, this.$project, this.$externalProjectPath, this.$buildFiles, externalSystemUnlinkedProjectAware);
            }
            {
                this.this$0 = unlinkedProjectStartupActivity;
                this.$project = project;
                this.$externalProjectPath = string;
                this.$buildFiles = set2;
            }
        });
    }

    private final void showNotificationIfUnlinkedProjectsFound(Project project, String externalProjectPath, ExternalSystemUnlinkedProjectAware unlinkedProjectAware) {
        this.showNotificationIfUnlinkedProjectsFound(project, externalProjectPath, unlinkedProjectAware, (Function0<? extends Collection<? extends VirtualFile>>)((Function0)new Function0<Collection<? extends VirtualFile>>(this, unlinkedProjectAware, project, externalProjectPath){
            final /* synthetic */ UnlinkedProjectStartupActivity this$0;
            final /* synthetic */ ExternalSystemUnlinkedProjectAware $unlinkedProjectAware;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $externalProjectPath;

            @NotNull
            public final Collection<VirtualFile> invoke() {
                return UnlinkedProjectStartupActivity.access$getBuildFiles(this.this$0, this.$unlinkedProjectAware, this.$project, this.$externalProjectPath);
            }
            {
                this.this$0 = unlinkedProjectStartupActivity;
                this.$unlinkedProjectAware = externalSystemUnlinkedProjectAware;
                this.$project = project;
                this.$externalProjectPath = string;
                super(0);
            }
        }));
    }

    private final void showNotificationIfUnlinkedProjectsFound(Project project, String externalProjectPath, Set<? extends VirtualFile> possibleBuildFiles, ExternalSystemUnlinkedProjectAware unlinkedProjectAware) {
        this.showNotificationIfUnlinkedProjectsFound(project, externalProjectPath, unlinkedProjectAware, (Function0<? extends Collection<? extends VirtualFile>>)((Function0)new Function0<Collection<? extends VirtualFile>>(possibleBuildFiles, unlinkedProjectAware, project){
            final /* synthetic */ Set $possibleBuildFiles;
            final /* synthetic */ ExternalSystemUnlinkedProjectAware $unlinkedProjectAware;
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Collection<VirtualFile> invoke() {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.$possibleBuildFiles;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    VirtualFile it = (VirtualFile)element$iv$iv;
                    boolean bl = false;
                    if (!this.$unlinkedProjectAware.isBuildFile(this.$project, it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.$possibleBuildFiles = set2;
                this.$unlinkedProjectAware = externalSystemUnlinkedProjectAware;
                this.$project = project;
                super(0);
            }
        }));
    }

    private final void showNotificationIfUnlinkedProjectsFound(Project project, String externalProjectPath, ExternalSystemUnlinkedProjectAware unlinkedProjectAware, Function0<? extends Collection<? extends VirtualFile>> collectBuildFiles) {
        this.findUnlinkedProjectBuildFiles(project, externalProjectPath, unlinkedProjectAware, collectBuildFiles).whenComplete(new BiConsumer(project, unlinkedProjectAware, externalProjectPath){
            final /* synthetic */ Project $project;
            final /* synthetic */ ExternalSystemUnlinkedProjectAware $unlinkedProjectAware;
            final /* synthetic */ String $externalProjectPath;

            public final void accept(Collection<? extends VirtualFile> buildFiles, Throwable $noName_1) {
                Collection<? extends VirtualFile> collection = buildFiles;
                Intrinsics.checkNotNullExpressionValue(collection, (String)"buildFiles");
                Collection<? extends VirtualFile> collection2 = collection;
                boolean bl = false;
                if (!collection2.isEmpty()) {
                    UnlinkedProjectNotificationAware notificationAware = UnlinkedProjectNotificationAware.Companion.getInstance(this.$project);
                    notificationAware.notify(this.$unlinkedProjectAware, this.$externalProjectPath);
                }
            }
            {
                this.$project = project;
                this.$unlinkedProjectAware = externalSystemUnlinkedProjectAware;
                this.$externalProjectPath = string;
            }
        });
    }

    private final void findUnlinkedProjectBuildFiles(Project project, String externalProjectPath, Function1<? super Map<ExternalSystemUnlinkedProjectAware, ? extends Collection<? extends VirtualFile>>, Unit> callback2) {
        this.findUnlinkedProjectBuildFiles(project, externalProjectPath).thenAccept(new Consumer(callback2){
            final /* synthetic */ Function1 $callback;

            public final void accept(List<? extends Pair<? extends ExternalSystemUnlinkedProjectAware, ? extends Collection<? extends VirtualFile>>> it) {
                List<? extends Pair<? extends ExternalSystemUnlinkedProjectAware, ? extends Collection<? extends VirtualFile>>> list2 = it;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"it");
                this.$callback.invoke((Object)MapsKt.toMap((Iterable)list2));
            }
            {
                this.$callback = function1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture<List<Pair<ExternalSystemUnlinkedProjectAware, Collection<VirtualFile>>>> findUnlinkedProjectBuildFiles(Project project, String externalProjectPath) {
        Collection<CompletionStage> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list2 = ExternalSystemUnlinkedProjectAware.Companion.getEP_NAME().getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"EP_NAME.extensionList");
        Iterable iterable = list2;
        UnlinkedProjectStartupActivity unlinkedProjectStartupActivity = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void unlinkedProjectAware;
            ExternalSystemUnlinkedProjectAware externalSystemUnlinkedProjectAware = (ExternalSystemUnlinkedProjectAware)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v1 = unlinkedProjectAware;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"unlinkedProjectAware");
            CompletionStage completionStage = this.findUnlinkedProjectBuildFiles(project, externalProjectPath, (ExternalSystemUnlinkedProjectAware)v1).thenApply(new Function((ExternalSystemUnlinkedProjectAware)unlinkedProjectAware){
                final /* synthetic */ ExternalSystemUnlinkedProjectAware $unlinkedProjectAware;

                public final Pair<ExternalSystemUnlinkedProjectAware, Collection<VirtualFile>> apply(Collection<? extends VirtualFile> buildFiles) {
                    return TuplesKt.to((Object)this.$unlinkedProjectAware, buildFiles);
                }
                {
                    this.$unlinkedProjectAware = externalSystemUnlinkedProjectAware;
                }
            });
            collection.add(completionStage);
        }
        collection = (List)destination$iv$iv;
        return unlinkedProjectStartupActivity.allOf((Collection)collection);
    }

    private final <T> CompletableFuture<List<T>> allOf(Collection<? extends CompletableFuture<T>> futures) {
        Collection<CompletableFuture<CompletableFuture>> $this$toTypedArray$iv = futures;
        boolean $i$f$toTypedArray = false;
        Collection<CompletableFuture<CompletableFuture>> thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        if (completableFutureArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        CompletionStage completionStage = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length)).thenApply(new Function(futures){
            final /* synthetic */ Collection $futures;

            /*
             * WARNING - void declaration
             */
            public final List<T> apply(Void it) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.$futures;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    CompletableFuture completableFuture = (CompletableFuture)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    T t = it2.get();
                    collection.add(t);
                }
                return (List)destination$iv$iv;
            }
            {
                this.$futures = collection;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"CompletableFuture.allOf(\u2026utures.map { it.get() } }");
        return completionStage;
    }

    private final CompletableFuture<Collection<VirtualFile>> findUnlinkedProjectBuildFiles(Project project, String externalProjectPath, ExternalSystemUnlinkedProjectAware unlinkedProjectAware) {
        return this.findUnlinkedProjectBuildFiles(project, externalProjectPath, unlinkedProjectAware, (Function0<? extends Collection<? extends VirtualFile>>)((Function0)new Function0<Collection<? extends VirtualFile>>(this, unlinkedProjectAware, project, externalProjectPath){
            final /* synthetic */ UnlinkedProjectStartupActivity this$0;
            final /* synthetic */ ExternalSystemUnlinkedProjectAware $unlinkedProjectAware;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $externalProjectPath;

            @NotNull
            public final Collection<VirtualFile> invoke() {
                return UnlinkedProjectStartupActivity.access$getBuildFiles(this.this$0, this.$unlinkedProjectAware, this.$project, this.$externalProjectPath);
            }
            {
                this.this$0 = unlinkedProjectStartupActivity;
                this.$unlinkedProjectAware = externalSystemUnlinkedProjectAware;
                this.$project = project;
                this.$externalProjectPath = string;
                super(0);
            }
        }));
    }

    private final CompletableFuture<Collection<VirtualFile>> findUnlinkedProjectBuildFiles(Project project, String externalProjectPath, ExternalSystemUnlinkedProjectAware unlinkedProjectAware, Function0<? extends Collection<? extends VirtualFile>> collectBuildFiles) {
        CompletableFuture completableFuture;
        if (unlinkedProjectAware.isLinkedProject(project, externalProjectPath)) {
            CompletableFuture completableFuture2 = CompletableFuture.completedFuture(CollectionsKt.emptyList());
            completableFuture = completableFuture2;
            Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"CompletableFuture.completedFuture(emptyList())");
        } else {
            CompletableFuture completableFuture3 = Promises.asCompletableFuture((Promise)((Promise)new AsyncPromise()));
            boolean bl = false;
            boolean bl2 = false;
            CompletableFuture $this$apply = completableFuture3;
            boolean bl3 = false;
            Object object = collectBuildFiles;
            if (object != null) {
                Function0<? extends Collection<? extends VirtualFile>> function0 = object;
                object = new Callable(function0){
                    private final /* synthetic */ Function0 function;
                    {
                        this.function = function0;
                    }

                    public final /* synthetic */ Object call() {
                        return this.function.invoke();
                    }
                };
            }
            ReadAction.nonBlocking((Callable)((Callable)object)).expireWith(UnlinkedProjectUtilsKt.createExtensionDisposable(project, unlinkedProjectAware)).finishOnUiThread(ModalityState.defaultModalityState(), new Consumer($this$apply, this, collectBuildFiles, project, unlinkedProjectAware, externalProjectPath){
                final /* synthetic */ CompletableFuture $this_apply;
                final /* synthetic */ UnlinkedProjectStartupActivity this$0;
                final /* synthetic */ Function0 $collectBuildFiles$inlined;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ ExternalSystemUnlinkedProjectAware $unlinkedProjectAware$inlined;
                final /* synthetic */ String $externalProjectPath$inlined;
                {
                    this.$this_apply = completableFuture;
                    this.this$0 = unlinkedProjectStartupActivity;
                    this.$collectBuildFiles$inlined = function0;
                    this.$project$inlined = project;
                    this.$unlinkedProjectAware$inlined = externalSystemUnlinkedProjectAware;
                    this.$externalProjectPath$inlined = string;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void accept(Collection<? extends VirtualFile> buildFiles) {
                    if (AutoImportProjectTracker.Companion.getLOG().isDebugEnabled()) {
                        Collection<? extends VirtualFile> collection = buildFiles;
                        Intrinsics.checkNotNullExpressionValue(collection, (String)"buildFiles");
                        Collection<? extends VirtualFile> collection2 = collection;
                        boolean bl = false;
                        if (!collection2.isEmpty()) {
                            Collection<String> collection3;
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            ExternalSystemProjectId projectId = UnlinkedProjectUtilsKt.getProjectId(this.$unlinkedProjectAware$inlined, this.$externalProjectPath$inlined);
                            Iterable iterable = buildFiles;
                            StringBuilder stringBuilder = new StringBuilder().append("Found unlinked ").append(projectId.getReadableName()).append(" project; buildFiles=");
                            Logger logger = AutoImportProjectTracker.Companion.getLOG();
                            boolean $i$f$map = false;
                            void var7_8 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void p1;
                                VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                                collection3 = destination$iv$iv;
                                boolean bl2 = false;
                                String string = p1.getPath();
                                collection3.add(string);
                            }
                            collection3 = (List)destination$iv$iv;
                            logger.debug(stringBuilder.append(collection3).toString());
                        }
                    }
                    this.$this_apply.complete(buildFiles);
                }
            }).submit((Executor)this.backgroundExecutor);
            completableFuture = completableFuture3;
        }
        return completableFuture;
    }

    private final void showNotificationWhenNonEmptyProjectUnlinked(Project project) {
        ExternalSystemUnlinkedProjectAware.Companion.getEP_NAME().forEachExtensionSafe(new Consumer(this, project){
            final /* synthetic */ UnlinkedProjectStartupActivity this$0;
            final /* synthetic */ Project $project;

            public final void accept(ExternalSystemUnlinkedProjectAware it) {
                ExternalSystemUnlinkedProjectAware externalSystemUnlinkedProjectAware = it;
                Intrinsics.checkNotNullExpressionValue((Object)externalSystemUnlinkedProjectAware, (String)"it");
                UnlinkedProjectStartupActivity.access$showNotificationWhenNonEmptyProjectUnlinked(this.this$0, this.$project, externalSystemUnlinkedProjectAware);
            }
            {
                this.this$0 = unlinkedProjectStartupActivity;
                this.$project = project;
            }
        });
        ExternalSystemUnlinkedProjectAware.Companion.getEP_NAME().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ExternalSystemUnlinkedProjectAware>(this, project){
            final /* synthetic */ UnlinkedProjectStartupActivity this$0;
            final /* synthetic */ Project $project;

            public void extensionAdded(@NotNull ExternalSystemUnlinkedProjectAware extension2, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                UnlinkedProjectStartupActivity.access$showNotificationWhenNonEmptyProjectUnlinked(this.this$0, this.$project, extension2);
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
            }
        }, (Disposable)project);
    }

    private final void showNotificationWhenNonEmptyProjectUnlinked(Project project, ExternalSystemUnlinkedProjectAware unlinkedProjectAware) {
        Disposable extensionDisposable = UnlinkedProjectUtilsKt.createExtensionDisposable(project, unlinkedProjectAware);
        unlinkedProjectAware.subscribe(project, new ExternalSystemProjectLinkListener(this, project){
            final /* synthetic */ UnlinkedProjectStartupActivity this$0;
            final /* synthetic */ Project $project;

            public void onProjectUnlinked(@NotNull String externalProjectPath) {
                Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
                UnlinkedProjectStartupActivity.access$showNotificationIfUnlinkedProjectsFound(this.this$0, this.$project, externalProjectPath);
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
            }

            public void onProjectLinked(@NotNull String externalProjectPath) {
                Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
                ExternalSystemProjectLinkListener.DefaultImpls.onProjectLinked((ExternalSystemProjectLinkListener)this, (String)externalProjectPath);
            }
        }, extensionDisposable);
    }

    private final void showNotificationWhenBuildToolPluginEnabled(Project project, String externalProjectPath) {
        ExternalSystemUnlinkedProjectAware.Companion.getEP_NAME().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ExternalSystemUnlinkedProjectAware>(this, project, externalProjectPath){
            final /* synthetic */ UnlinkedProjectStartupActivity this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $externalProjectPath;

            public void extensionAdded(@NotNull ExternalSystemUnlinkedProjectAware extension2, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                UnlinkedProjectStartupActivity.access$showNotificationIfUnlinkedProjectsFound(this.this$0, this.$project, this.$externalProjectPath, extension2);
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
                this.$externalProjectPath = $captured_local_variable$2;
            }
        }, (Disposable)project);
    }

    private final void showNotificationWhenNewBuildFileCreated(Project project, String externalProjectPath) {
        NewBuildFilesListener asyncNewFilesListener = new NewBuildFilesListener(project, externalProjectPath);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"VirtualFileManager.getInstance()");
        VirtualFileManager fileManager = virtualFileManager;
        fileManager.addAsyncFileListener((AsyncFileListener)asyncNewFilesListener, (Disposable)project);
    }

    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> getBuildFiles(ExternalSystemUnlinkedProjectAware $this$getBuildFiles, Project project, String externalProjectPath) {
        void $this$filterTo$iv$iv;
        LocalFileSystem localFilesSystem = LocalFileSystem.getInstance();
        VirtualFile externalProjectDir = localFilesSystem.findFileByPath(externalProjectPath);
        if (externalProjectDir == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile[] virtualFileArray = externalProjectDir.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"externalProjectDir.children");
        VirtualFile[] $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        VirtualFile[] virtualFileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var11_11 = $this$filterTo$iv$iv;
        int n = ((void)var11_11).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = var11_11[j];
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            if (!$this$getBuildFiles.isBuildFile(project, (VirtualFile)v1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public UnlinkedProjectStartupActivity() {
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"UnlinkedProjectTracker.backgroundExecutor", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"AppExecutorUtil.createBo\u2026r.backgroundExecutor\", 1)");
        this.backgroundExecutor = executorService;
    }

    public static final /* synthetic */ void access$showNotificationIfUnlinkedProjectsFound(UnlinkedProjectStartupActivity $this, Project project, String externalProjectPath, ExternalSystemUnlinkedProjectAware unlinkedProjectAware) {
        $this.showNotificationIfUnlinkedProjectsFound(project, externalProjectPath, unlinkedProjectAware);
    }

    public static final /* synthetic */ void access$showNotificationIfUnlinkedProjectsFound(UnlinkedProjectStartupActivity $this, Project project, String externalProjectPath, Set possibleBuildFiles, ExternalSystemUnlinkedProjectAware unlinkedProjectAware) {
        $this.showNotificationIfUnlinkedProjectsFound(project, externalProjectPath, possibleBuildFiles, unlinkedProjectAware);
    }

    public static final /* synthetic */ List access$getBuildFiles(UnlinkedProjectStartupActivity $this, ExternalSystemUnlinkedProjectAware $this$access_u24getBuildFiles, Project project, String externalProjectPath) {
        return $this.getBuildFiles($this$access_u24getBuildFiles, project, externalProjectPath);
    }

    public static final /* synthetic */ void access$showNotificationWhenNonEmptyProjectUnlinked(UnlinkedProjectStartupActivity $this, Project project, ExternalSystemUnlinkedProjectAware unlinkedProjectAware) {
        $this.showNotificationWhenNonEmptyProjectUnlinked(project, unlinkedProjectAware);
    }

    public static final /* synthetic */ void access$showNotificationIfUnlinkedProjectsFound(UnlinkedProjectStartupActivity $this, Project project, String externalProjectPath) {
        $this.showNotificationIfUnlinkedProjectsFound(project, externalProjectPath);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/externalSystem/autolink/UnlinkedProjectStartupActivity$NewBuildFilesListener;", "Lcom/intellij/openapi/externalSystem/autoimport/AsyncFileChangeListenerBase;", "project", "Lcom/intellij/openapi/project/Project;", "externalProjectPath", "", "(Lcom/intellij/openapi/externalSystem/autolink/UnlinkedProjectStartupActivity;Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "buildFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "apply", "", "init", "isRelevant", "", "file", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "updateFile", "intellij.platform.externalSystem.impl"})
    public final class NewBuildFilesListener
    extends AsyncFileChangeListenerBase {
        private Set<VirtualFile> buildFiles;
        private final Project project;
        private final String externalProjectPath;

        @Override
        protected void init() {
            this.buildFiles = new HashSet();
        }

        @Override
        protected void apply() {
            Set<VirtualFile> set2 = this.buildFiles;
            if (set2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buildFiles");
            }
            if (set2.isEmpty()) {
                return;
            }
            Set<VirtualFile> set3 = this.buildFiles;
            if (set3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buildFiles");
            }
            UnlinkedProjectStartupActivity.this.showNotificationIfUnlinkedProjectsFound(this.project, this.externalProjectPath, set3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean isRelevant(@NotNull VirtualFile file2, @NotNull VFileEvent event) {
            ExternalSystemUnlinkedProjectAware it;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!(event instanceof VFileCreateEvent)) return false;
            if (!FileUtil.pathsEqual((String)PathUtil.getParentPath((String)file2.getPath()), (String)this.externalProjectPath)) return false;
            List list2 = ExternalSystemUnlinkedProjectAware.Companion.getEP_NAME().getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"EP_NAME.extensionList");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (ExternalSystemUnlinkedProjectAware)element$iv;
                boolean bl = false;
            } while (!it.isBuildFile(this.project, file2));
            return true;
        }

        @Override
        protected void updateFile(@NotNull VirtualFile file2, @NotNull VFileEvent event) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Set<VirtualFile> set2 = this.buildFiles;
            if (set2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buildFiles");
            }
            set2.add(file2);
        }

        public NewBuildFilesListener(@NotNull Project project, String externalProjectPath) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
            this.project = project;
            this.externalProjectPath = externalProjectPath;
        }
    }
}

