/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.CustomizeColoredTreeCellRendererReplacement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.NewErrorTreeRenderer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.CustomizeColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.Color;
import java.awt.Component;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTree;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationMessageElement
extends NavigatableMessageElement {
    public static final String MSG_STYLE = "messageStyle";
    public static final String LINK_STYLE = "linkStyle";
    @NotNull
    private final CustomizeColoredTreeCellRenderer myLeftTreeCellRenderer;
    @NotNull
    private final CustomizeColoredTreeCellRenderer myRightTreeCellRenderer;

    public NotificationMessageElement(final @NotNull ErrorTreeElementKind kind, @Nullable GroupingElement parent, String[] message2, @NotNull Navigatable navigatable, String exportText, String rendererTextPrefix) {
        if (kind == null) {
            NotificationMessageElement.$$$reportNull$$$0(0);
        }
        if (navigatable == null) {
            NotificationMessageElement.$$$reportNull$$$0(1);
        }
        super(kind, parent, message2, navigatable, exportText, rendererTextPrefix);
        this.myLeftTreeCellRenderer = new CustomizeColoredTreeCellRenderer(){

            public void customizeCellRenderer(SimpleColoredComponent renderer2, JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
                renderer2.setIcon(this.getIcon(kind));
                renderer2.setFont(tree.getFont());
                renderer2.append(NewErrorTreeRenderer.calcPrefix(NotificationMessageElement.this));
            }

            @NotNull
            private Icon getIcon(@NotNull ErrorTreeElementKind kind2) {
                if (kind2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                Icon icon2 = EmptyIcon.ICON_16;
                switch (kind2) {
                    case INFO: {
                        icon2 = AllIcons.General.Information;
                        break;
                    }
                    case ERROR: {
                        icon2 = AllIcons.General.Error;
                        break;
                    }
                    case WARNING: {
                        icon2 = AllIcons.General.Warning;
                        break;
                    }
                    case NOTE: {
                        icon2 = AllIcons.General.Tip;
                        break;
                    }
                    case GENERIC: {
                        icon2 = EmptyIcon.ICON_16;
                    }
                }
                Icon icon3 = icon2;
                if (icon3 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return icon3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "kind";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/externalSystem/service/notification/NotificationMessageElement$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/externalSystem/service/notification/NotificationMessageElement$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getIcon";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myRightTreeCellRenderer = new MyCustomizeColoredTreeCellRendererReplacement();
    }

    @Override
    @Nullable
    public CustomizeColoredTreeCellRenderer getRightSelfRenderer() {
        return this.myRightTreeCellRenderer;
    }

    @Override
    @Nullable
    public CustomizeColoredTreeCellRenderer getLeftSelfRenderer() {
        return this.myLeftTreeCellRenderer;
    }

    protected JEditorPane installJep(@NotNull JEditorPane myEditorPane) {
        if (myEditorPane == null) {
            NotificationMessageElement.$$$reportNull$$$0(2);
        }
        String message2 = StringUtil.join((String[])this.getText(), (String)"<br>");
        myEditorPane.setEditable(false);
        myEditorPane.setOpaque(false);
        myEditorPane.setEditorKit(UIUtil.getHTMLEditorKit());
        myEditorPane.setHighlighter(null);
        StyleSheet styleSheet = ((HTMLDocument)myEditorPane.getDocument()).getStyleSheet();
        Style style = styleSheet.addStyle(MSG_STYLE, null);
        styleSheet.addStyle(LINK_STYLE, style);
        myEditorPane.setText(message2);
        return myEditorPane;
    }

    protected void updateStyle(@NotNull JEditorPane editorPane, @Nullable JTree tree, Object value2, boolean selected2, boolean hasFocus) {
        if (editorPane == null) {
            NotificationMessageElement.$$$reportNull$$$0(3);
        }
        HTMLDocument htmlDocument = (HTMLDocument)editorPane.getDocument();
        Style style = htmlDocument.getStyleSheet().getStyle(MSG_STYLE);
        if (value2 instanceof LoadingNode) {
            StyleConstants.setForeground(style, (Color)JBColor.GRAY);
        } else {
            StyleConstants.setForeground(style, UIUtil.getTreeForeground((boolean)selected2, (boolean)hasFocus));
        }
        if (tree != null && WideSelectionTreeUI.isWideSelection((JTree)tree)) {
            editorPane.setOpaque(false);
        } else {
            editorPane.setOpaque(selected2 && hasFocus);
        }
        htmlDocument.setCharacterAttributes(0, htmlDocument.getLength(), style, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myEditorPane";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorPane";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/notification/NotificationMessageElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "installJep";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateStyle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyCustomizeColoredTreeCellRendererReplacement
    extends CustomizeColoredTreeCellRendererReplacement {
        @NotNull
        private final JEditorPane myEditorPane;

        private MyCustomizeColoredTreeCellRendererReplacement() {
            this.myEditorPane = NotificationMessageElement.this.installJep(new MyEditorPane());
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            NotificationMessageElement.this.updateStyle(this.myEditorPane, tree, value2, selected2, hasFocus);
            return this.myEditorPane;
        }

        private class MyEditorPane
        extends JEditorPane {
            private MyEditorPane() {
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    return new AccessibleMyEditorPane();
                }
                return this.accessibleContext;
            }

            protected class AccessibleMyEditorPane
            extends JComponent.AccessibleJComponent {
                protected AccessibleMyEditorPane() {
                    super(MyEditorPane.this);
                }

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.LABEL;
                }

                @Override
                public String getAccessibleName() {
                    try {
                        Document document = MyEditorPane.this.getDocument();
                        String result2 = document.getText(0, document.getLength());
                        @NlsSafe String resultWithPunctuation = AccessibleContextUtil.replaceLineSeparatorsWithPunctuation((String)result2);
                        return resultWithPunctuation;
                    }
                    catch (BadLocationException e) {
                        return super.getAccessibleName();
                    }
                }
            }
        }
    }
}

