/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcher;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcherImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsState;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemRunManagerListener;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemShortcutsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.TaskActivationState;
import com.intellij.openapi.externalSystem.util.CompositeRunnable;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExternalProjectsManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ExternalProjectsManagerImpl
implements ExternalProjectsManager,
PersistentStateComponent<ExternalProjectsState>,
Disposable {
    private static final Logger LOG = Logger.getInstance(ExternalProjectsManager.class);
    private final AtomicBoolean isInitializationFinished;
    private final AtomicBoolean isInitializationStarted;
    private final AtomicBoolean isDisposed;
    private final CompositeRunnable myPostInitializationActivities;
    @NotNull
    private ExternalProjectsState myState;
    @NotNull
    private final Project myProject;
    private final ExternalSystemRunManagerListener myRunManagerListener;
    private final ExternalSystemTaskActivator myTaskActivator;
    private final ExternalSystemShortcutsManager myShortcutsManager;
    private final List<ExternalProjectsView> myProjectsViews;
    private final ExternalSystemProjectsWatcherImpl myWatcher;

    public ExternalProjectsManagerImpl(@NotNull Project project) {
        if (project == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(0);
        }
        this.isInitializationFinished = new AtomicBoolean();
        this.isInitializationStarted = new AtomicBoolean();
        this.isDisposed = new AtomicBoolean();
        this.myPostInitializationActivities = new CompositeRunnable();
        this.myState = new ExternalProjectsState();
        this.myProjectsViews = new SmartList();
        this.myProject = project;
        this.myShortcutsManager = new ExternalSystemShortcutsManager(project);
        Disposer.register((Disposable)this, (Disposable)this.myShortcutsManager);
        this.myTaskActivator = new ExternalSystemTaskActivator(project);
        this.myRunManagerListener = new ExternalSystemRunManagerListener(this);
        this.myWatcher = new ExternalSystemProjectsWatcherImpl(this.myProject);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)project).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                Set availableES = ExternalSystemManager.EP_NAME.getExtensionList().stream().map(ExternalSystemManager::getSystemId).collect(Collectors.toSet());
                Iterator<ExternalProjectsView> iterator2 = ExternalProjectsManagerImpl.this.myProjectsViews.iterator();
                while (iterator2.hasNext()) {
                    ExternalProjectsView view = iterator2.next();
                    if (!availableES.contains(view.getSystemId())) {
                        iterator2.remove();
                    }
                    if (!(view instanceof Disposable)) continue;
                    Disposer.dispose((Disposable)((Disposable)view));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl$1", "pluginUnloaded"));
            }
        });
    }

    public static ExternalProjectsManagerImpl getInstance(@NotNull Project project) {
        if (project == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(1);
        }
        return (ExternalProjectsManagerImpl)project.getService(ExternalProjectsManager.class);
    }

    @Nullable
    public static Project setupCreatedProject(@Nullable Project project) {
        if (project != null) {
            ExternalProjectsManagerImpl.getInstance(project).setStoreExternally(true);
        }
        return project;
    }

    public void setStoreExternally(boolean value2) {
        ExternalStorageConfigurationManager externalStorageConfigurationManager = ExternalStorageConfigurationManager.getInstance((Project)this.myProject);
        if (externalStorageConfigurationManager.isEnabled() == value2) {
            return;
        }
        externalStorageConfigurationManager.setEnabled(value2);
        try {
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                if (module.isDisposed()) continue;
                ExternalSystemModulePropertyManager.getInstance((Module)module).swapStore();
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                if (!(moduleRootManager instanceof ModuleRootManagerImpl)) continue;
                ((ModuleRootManagerImpl)moduleRootManager).stateChanged();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(2);
        }
        return project;
    }

    public ExternalSystemShortcutsManager getShortcutsManager() {
        return this.myShortcutsManager;
    }

    public ExternalSystemTaskActivator getTaskActivator() {
        return this.myTaskActivator;
    }

    public ExternalSystemProjectsWatcher getExternalProjectsWatcher() {
        return this.myWatcher;
    }

    public void registerView(@NotNull ExternalProjectsView externalProjectsView) {
        if (externalProjectsView == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(3);
        }
        assert (this.getExternalProjectsView(externalProjectsView.getSystemId()) == null);
        this.myProjectsViews.add(externalProjectsView);
        if (externalProjectsView instanceof ExternalProjectsViewImpl) {
            ExternalProjectsViewImpl view = (ExternalProjectsViewImpl)externalProjectsView;
            view.loadState(this.myState.getExternalSystemsState().get(externalProjectsView.getSystemId().getId()).getProjectsViewState());
            view.init();
        }
    }

    @Nullable
    public ExternalProjectsView getExternalProjectsView(@NotNull ProjectSystemId systemId2) {
        if (systemId2 == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(4);
        }
        for (ExternalProjectsView projectsView : this.myProjectsViews) {
            if (!projectsView.getSystemId().equals((Object)systemId2)) continue;
            return projectsView;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        ProgressManager.checkCanceled();
        if (this.isInitializationStarted.getAndSet(true)) {
            return;
        }
        ExternalProjectsDataStorage.getInstance(this.myProject).load();
        this.myRunManagerListener.attach();
        this.myShortcutsManager.init();
        for (ExternalSystemManager systemManager : ExternalSystemManager.EP_NAME.getIterable()) {
            Collection<ExternalProjectInfo> externalProjects = ExternalProjectsDataStorage.getInstance(this.myProject).list(systemManager.getSystemId());
            for (ExternalProjectInfo externalProject : externalProjects) {
                if (externalProject.getExternalProjectStructure() == null) continue;
                Collection taskData = ExternalSystemApiUtil.findAllRecursively((DataNode)externalProject.getExternalProjectStructure(), (Key)ProjectKeys.TASK);
                this.myShortcutsManager.scheduleKeymapUpdate(taskData);
            }
            if (externalProjects.isEmpty()) continue;
            this.myShortcutsManager.scheduleRunConfigurationKeymapUpdate(systemManager.getSystemId());
        }
        this.myTaskActivator.init();
        AtomicBoolean atomicBoolean = this.isInitializationFinished;
        synchronized (atomicBoolean) {
            this.isInitializationFinished.set(true);
            this.invokeLater(() -> {
                this.myPostInitializationActivities.run();
                this.myPostInitializationActivities.clear();
            });
        }
    }

    public void refreshProject(@NotNull String externalProjectPath, @NotNull ImportSpec importSpec) {
        if (externalProjectPath == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(5);
        }
        if (importSpec == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(6);
        }
        ExternalSystemUtil.refreshProject(externalProjectPath, importSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenInitialized(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(7);
        }
        if (this.isDisposed.get()) {
            return;
        }
        AtomicBoolean atomicBoolean = this.isInitializationFinished;
        synchronized (atomicBoolean) {
            if (this.isInitializationFinished.get()) {
                this.invokeLater(runnable2);
            } else {
                this.myPostInitializationActivities.add(runnable2);
            }
        }
    }

    private void invokeLater(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().invokeLater(runnable2, o -> this.myProject.isDisposed() || this.isDisposed.get());
    }

    public void updateExternalProjectData(ExternalProjectInfo externalProject) {
        ExternalProjectsDataStorage.getInstance(this.myProject).update(externalProject);
        if (externalProject.getExternalProjectStructure() != null) {
            ProjectData projectData2 = (ProjectData)externalProject.getExternalProjectStructure().getData();
            ExternalSystemUtil.scheduleExternalViewStructureUpdate(this.myProject, projectData2.getOwner());
            Collection taskData = ExternalSystemApiUtil.findAllRecursively((DataNode)externalProject.getExternalProjectStructure(), (Key)ProjectKeys.TASK);
            this.myShortcutsManager.scheduleKeymapUpdate(taskData);
            this.myShortcutsManager.scheduleRunConfigurationKeymapUpdate(projectData2.getOwner());
        }
    }

    public void forgetExternalProjectData(@NotNull ProjectSystemId projectSystemId, @NotNull String linkedProjectPath) {
        if (projectSystemId == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(9);
        }
        if (linkedProjectPath == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(10);
        }
        ExternalProjectsDataStorage.getInstance(this.myProject).remove(projectSystemId, linkedProjectPath);
        ExternalSystemUtil.scheduleExternalViewStructureUpdate(this.myProject, projectSystemId);
    }

    @NotNull
    public ExternalProjectsState getState() {
        ApplicationManager.getApplication().assertIsWriteThread();
        for (ExternalProjectsView externalProjectsView : this.myProjectsViews) {
            if (!(externalProjectsView instanceof ExternalProjectsViewImpl)) continue;
            ExternalProjectsViewState externalProjectsViewState = ((ExternalProjectsViewImpl)externalProjectsView).getState();
            ExternalProjectsState.State state = this.myState.getExternalSystemsState().get(externalProjectsView.getSystemId().getId());
            assert (state != null);
            state.setProjectsViewState(externalProjectsViewState);
        }
        ExternalProjectsState externalProjectsState = this.myState;
        if (externalProjectsState == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(11);
        }
        return externalProjectsState;
    }

    @NotNull
    public ExternalProjectsStateProvider getStateProvider() {
        return new ExternalProjectsStateProvider(){

            @Override
            public List<ExternalProjectsStateProvider.TasksActivation> getAllTasksActivation() {
                SmartList result2 = new SmartList();
                Map<String, ProjectSystemId> systemIds = ExternalSystemApiUtil.getAllManagers().stream().collect(Collectors.toMap(o -> o.getSystemId().getId(), o -> o.getSystemId()));
                for (Map.Entry<String, ExternalProjectsState.State> systemState : ExternalProjectsManagerImpl.this.myState.getExternalSystemsState().entrySet()) {
                    ProjectSystemId systemId2 = systemIds.get(systemState.getKey());
                    if (systemId2 == null) continue;
                    for (Map.Entry<String, TaskActivationState> activationStateEntry : systemState.getValue().getExternalSystemsTaskActivation().entrySet()) {
                        result2.add(new ExternalProjectsStateProvider.TasksActivation(systemId2, activationStateEntry.getKey(), activationStateEntry.getValue()));
                    }
                }
                return result2;
            }

            @Override
            public List<ExternalProjectsStateProvider.TasksActivation> getTasksActivation(@NotNull ProjectSystemId systemId2) {
                if (systemId2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                Set<Map.Entry<String, TaskActivationState>> entries2 = ExternalProjectsManagerImpl.this.myState.getExternalSystemsState().get(systemId2.getId()).getExternalSystemsTaskActivation().entrySet();
                return ContainerUtil.map(entries2, entry2 -> new ExternalProjectsStateProvider.TasksActivation(systemId2, (String)entry2.getKey(), (TaskActivationState)entry2.getValue()));
            }

            @Override
            public TaskActivationState getTasksActivation(@NotNull ProjectSystemId systemId2, @NotNull String projectPath) {
                if (systemId2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (projectPath == null) {
                    2.$$$reportNull$$$0(2);
                }
                return ExternalProjectsManagerImpl.this.myState.getExternalSystemsState().get(systemId2.getId()).getExternalSystemsTaskActivation().get(projectPath);
            }

            @Override
            public Map<String, TaskActivationState> getProjectsTasksActivationMap(@NotNull ProjectSystemId systemId2) {
                if (systemId2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                return ExternalProjectsManagerImpl.this.myState.getExternalSystemsState().get(systemId2.getId()).getExternalSystemsTaskActivation();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "systemId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectPath";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getTasksActivation";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getProjectsTasksActivationMap";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public boolean isIgnored(@NotNull ProjectSystemId systemId2, @NotNull String projectPath) {
        ExternalProjectInfo projectInfo;
        if (systemId2 == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(12);
        }
        if (projectPath == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(13);
        }
        if ((projectInfo = ExternalSystemUtil.getExternalProjectInfo(this.myProject, systemId2, projectPath)) == null) {
            return true;
        }
        return ExternalProjectsDataStorage.getInstance(this.myProject).isIgnored(projectInfo.getExternalProjectPath(), projectPath, ProjectKeys.MODULE);
    }

    public void setIgnored(@NotNull DataNode<?> dataNode, boolean isIgnored) {
        if (dataNode == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(14);
        }
        ExternalProjectsDataStorage.getInstance(this.myProject).setIgnored(dataNode, isIgnored);
        ExternalSystemKeymapExtension.updateActions(this.myProject, ExternalSystemApiUtil.findAllRecursively(dataNode, (Key)ProjectKeys.TASK));
    }

    public void loadState(@NotNull ExternalProjectsState state) {
        if (state == null) {
            ExternalProjectsManagerImpl.$$$reportNull$$$0(15);
        }
        this.myState = state;
        if (this.myState.storeExternally) {
            this.myState.storeExternally = false;
            ExternalStorageConfigurationManager.getInstance((Project)this.myProject).setEnabled(true);
        }
    }

    public void dispose() {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        this.myPostInitializationActivities.clear();
        this.myProjectsViews.clear();
        this.myRunManagerListener.detach();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectsView";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpec";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNode";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerView";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectsView";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "refreshProject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runWhenInitialized";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "forgetExternalProjectData";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setIgnored";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ExternalProjectsStateProvider {
        public List<TasksActivation> getAllTasksActivation();

        public List<TasksActivation> getTasksActivation(@NotNull ProjectSystemId var1);

        public TaskActivationState getTasksActivation(@NotNull ProjectSystemId var1, @NotNull String var2);

        public Map<String, TaskActivationState> getProjectsTasksActivationMap(@NotNull ProjectSystemId var1);

        public static class TasksActivation {
            public final ProjectSystemId systemId;
            public final String projectPath;
            public final TaskActivationState state;

            public TasksActivation(ProjectSystemId systemId2, String projectPath, TaskActivationState state) {
                this.systemId = systemId2;
                this.projectPath = projectPath;
                this.state = state;
            }
        }
    }
}

