/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.TaskActivationState;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ExternalSystemRunManagerListener
implements RunManagerListener {
    private volatile Disposable eventDisposable;
    private final ExternalProjectsManagerImpl myManager;
    private final ConcurrentIntObjectMap<Pair<String, RunnerAndConfigurationSettings>> myMap = ConcurrentCollectionFactory.createConcurrentIntObjectMap();

    ExternalSystemRunManagerListener(ExternalProjectsManager manager2) {
        this.myManager = (ExternalProjectsManagerImpl)manager2;
    }

    @Override
    public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings2) {
        if (settings2 == null) {
            ExternalSystemRunManagerListener.$$$reportNull$$$0(0);
        }
        ExternalSystemRunManagerListener.add(this.myMap, settings2);
    }

    @Override
    public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings2) {
        if (settings2 == null) {
            ExternalSystemRunManagerListener.$$$reportNull$$$0(1);
        }
        if (settings2.getConfiguration() instanceof ExternalSystemRunConfiguration) {
            Pair pair = (Pair)this.myMap.remove(System.identityHashCode(settings2));
            if (pair == null) {
                return;
            }
            ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider = this.myManager.getStateProvider();
            ExternalSystemTaskExecutionSettings taskExecutionSettings = ((ExternalSystemRunConfiguration)settings2.getConfiguration()).getSettings();
            if (taskExecutionSettings.getExternalProjectPath() == null) {
                return;
            }
            TaskActivationState activation = stateProvider.getTasksActivation(taskExecutionSettings.getExternalSystemId(), taskExecutionSettings.getExternalProjectPath());
            block0: for (ExternalSystemTaskActivator.Phase phase : ExternalSystemTaskActivator.Phase.values()) {
                Iterator<String> iterator2 = activation.getTasks(phase).iterator();
                while (iterator2.hasNext()) {
                    String task2 = iterator2.next();
                    if (!((String)pair.first).equals(task2)) continue;
                    iterator2.remove();
                    continue block0;
                }
            }
        }
    }

    @Override
    public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings2) {
        Pair pair;
        if (settings2 == null) {
            ExternalSystemRunManagerListener.$$$reportNull$$$0(2);
        }
        if (settings2.getConfiguration() instanceof ExternalSystemRunConfiguration && (pair = (Pair)this.myMap.get(System.identityHashCode(settings2))) != null) {
            ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider = this.myManager.getStateProvider();
            ExternalSystemTaskExecutionSettings taskExecutionSettings = ((ExternalSystemRunConfiguration)settings2.getConfiguration()).getSettings();
            if (taskExecutionSettings.getExternalProjectPath() == null) {
                return;
            }
            TaskActivationState activation = stateProvider.getTasksActivation(taskExecutionSettings.getExternalSystemId(), taskExecutionSettings.getExternalProjectPath());
            block0: for (ExternalSystemTaskActivator.Phase phase : ExternalSystemTaskActivator.Phase.values()) {
                List<String> modifiableActivationTasks = activation.getTasks(phase);
                for (String task2 : new ArrayList<String>(modifiableActivationTasks)) {
                    if (!((String)pair.first).equals(task2)) continue;
                    modifiableActivationTasks.remove(task2);
                    String runConfigurationActivationTaskName = ExternalSystemTaskActivator.getRunConfigurationActivationTaskName(settings2);
                    modifiableActivationTasks.add(runConfigurationActivationTaskName);
                    this.myMap.put(System.identityHashCode(settings2), (Object)Pair.create((Object)runConfigurationActivationTaskName, (Object)settings2));
                    continue block0;
                }
            }
        }
    }

    public void attach() {
        Project project = this.myManager.getProject();
        this.eventDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)project, (Disposable)this.eventDisposable);
        project.getMessageBus().connect(this.eventDisposable).subscribe(RunManagerListener.TOPIC, (Object)this);
    }

    @Override
    public void stateLoaded(@NotNull RunManager runManager, boolean isFirstLoadState) {
        if (runManager == null) {
            ExternalSystemRunManagerListener.$$$reportNull$$$0(3);
        }
        this.myMap.clear();
        for (ExternalSystemManager systemManager : ExternalSystemApiUtil.getAllManagers()) {
            AbstractExternalSystemTaskConfigurationType configurationType = ExternalSystemUtil.findConfigurationType(systemManager.getSystemId());
            if (configurationType == null) continue;
            for (RunnerAndConfigurationSettings configurationSettings : runManager.getConfigurationSettingsList((ConfigurationType)configurationType)) {
                ExternalSystemRunManagerListener.add(this.myMap, configurationSettings);
            }
        }
    }

    public void detach() {
        this.myMap.clear();
        Disposable disposable2 = this.eventDisposable;
        if (disposable2 != null) {
            this.eventDisposable = null;
            Disposer.dispose((Disposable)disposable2);
        }
    }

    private static void add(@NotNull ConcurrentIntObjectMap<Pair<String, RunnerAndConfigurationSettings>> map2, @NotNull RunnerAndConfigurationSettings settings2) {
        if (map2 == null) {
            ExternalSystemRunManagerListener.$$$reportNull$$$0(4);
        }
        if (settings2 == null) {
            ExternalSystemRunManagerListener.$$$reportNull$$$0(5);
        }
        if (settings2.getConfiguration() instanceof ExternalSystemRunConfiguration) {
            map2.put(System.identityHashCode(settings2), (Object)Pair.create((Object)ExternalSystemTaskActivator.getRunConfigurationActivationTaskName(settings2), (Object)settings2));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemRunManagerListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runConfigurationAdded";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runConfigurationRemoved";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runConfigurationChanged";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "stateLoaded";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

