/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemNode;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemNodeDescriptor;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalSystemTasksTreeModel
extends DefaultTreeModel {
    @NotNull
    private static final Comparator<TreeNode> NODE_COMPARATOR = (t1, t2) -> {
        Object e1 = ((ExternalSystemNode)t1).getDescriptor().getElement();
        Object e2 = ((ExternalSystemNode)t2).getDescriptor().getElement();
        if (e1 instanceof ExternalProjectPojo) {
            if (e2 instanceof ExternalTaskExecutionInfo) {
                return 1;
            }
            return ((ExternalProjectPojo)e1).getName().compareTo(((ExternalProjectPojo)e2).getName());
        }
        if (e2 instanceof ExternalProjectPojo) {
            return -1;
        }
        return ExternalSystemTasksTreeModel.getTaskName((ExternalTaskExecutionInfo)e1).compareTo(ExternalSystemTasksTreeModel.getTaskName((ExternalTaskExecutionInfo)e2));
    };
    @NotNull
    private final ExternalSystemUiAware myUiAware;
    @NotNull
    private final ProjectSystemId myExternalSystemId;

    public ExternalSystemTasksTreeModel(@NotNull ProjectSystemId externalSystemId2) {
        if (externalSystemId2 == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(0);
        }
        super(new ExternalSystemNode<String>(new ExternalSystemNodeDescriptor<String>("", "", "", null)));
        this.myExternalSystemId = externalSystemId2;
        this.myUiAware = ExternalSystemUiUtil.getUiAware(externalSystemId2);
    }

    private static String getTaskName(@NotNull ExternalTaskExecutionInfo taskInfo) {
        if (taskInfo == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(1);
        }
        return (String)taskInfo.getSettings().getTaskNames().get(0);
    }

    @NotNull
    public ExternalSystemNode<ExternalProjectPojo> ensureProjectNodeExists(@NotNull ExternalProjectPojo project) {
        if (project == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(2);
        }
        Object root = this.getRoot();
        for (int i2 = ((DefaultMutableTreeNode)root).getChildCount() - 1; i2 >= 0; --i2) {
            ExternalProjectPojo pojo;
            TreeNode child2 = ((ExternalSystemNode)root).getChildAt(i2);
            ExternalSystemNodeDescriptor descriptor2 = ((ExternalSystemNode)child2).getDescriptor();
            Object element2 = descriptor2.getElement();
            if (!(element2 instanceof ExternalProjectPojo) || !(pojo = (ExternalProjectPojo)element2).getPath().equals(project.getPath())) continue;
            if (!pojo.getName().equals(project.getName())) {
                pojo.setName(project.getName());
                descriptor2.setName(project.getName());
                this.nodeChanged(child2);
            }
            TreeNode treeNode = child2;
            if (treeNode == null) {
                ExternalSystemTasksTreeModel.$$$reportNull$$$0(3);
            }
            return treeNode;
        }
        ExternalProjectPojo element3 = new ExternalProjectPojo(project.getName(), project.getPath());
        ExternalSystemNodeDescriptor<ExternalProjectPojo> descriptor3 = ExternalSystemTasksTreeModel.descriptor(element3, this.myUiAware.getProjectIcon());
        ExternalSystemNode<ExternalProjectPojo> result2 = new ExternalSystemNode<ExternalProjectPojo>(descriptor3);
        this.insertNodeInto(result2, (MutableTreeNode)root);
        ExternalSystemNode<ExternalProjectPojo> externalSystemNode = result2;
        if (externalSystemNode == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(4);
        }
        return externalSystemNode;
    }

    public void pruneNodes(@NotNull Object payload) {
        if (payload == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(5);
        }
        ArrayDeque<Object> toProcess = new ArrayDeque<Object>();
        toProcess.addFirst(this.getRoot());
        while (!toProcess.isEmpty()) {
            ExternalSystemNode node2 = (ExternalSystemNode)toProcess.removeLast();
            if (payload.equals(node2.getDescriptor().getElement())) {
                this.removeNodeFromParent(node2);
                continue;
            }
            for (int i2 = 0; i2 < node2.getChildCount(); ++i2) {
                toProcess.addFirst(node2.getChildAt(i2));
            }
        }
    }

    public void ensureSubProjectsStructure(@NotNull ExternalProjectPojo topLevelProject, @NotNull Collection<? extends ExternalProjectPojo> subProjects) {
        if (topLevelProject == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(6);
        }
        if (subProjects == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(7);
        }
        ExternalSystemNode<ExternalProjectPojo> topLevelProjectNode = this.ensureProjectNodeExists(topLevelProject);
        HashMap<String, ExternalProjectPojo> toAdd = new HashMap<String, ExternalProjectPojo>();
        for (ExternalProjectPojo externalProjectPojo : subProjects) {
            toAdd.put(externalProjectPojo.getPath(), externalProjectPojo);
        }
        toAdd.remove(topLevelProject.getPath());
        for (int i2 = 0; i2 < topLevelProjectNode.getChildCount(); ++i2) {
            TreeNode treeNode = topLevelProjectNode.getChildAt(i2);
            Object childElement = ((ExternalSystemNode)treeNode).getDescriptor().getElement();
            if (childElement instanceof ExternalTaskExecutionInfo || toAdd.remove(((ExternalProjectPojo)childElement).getPath()) != null) continue;
            this.removeNodeFromParent((MutableTreeNode)treeNode);
            --i2;
        }
        if (!toAdd.isEmpty()) {
            for (Map.Entry entry2 : toAdd.entrySet()) {
                ExternalProjectPojo element2 = new ExternalProjectPojo(((ExternalProjectPojo)entry2.getValue()).getName(), ((ExternalProjectPojo)entry2.getValue()).getPath());
                this.insertNodeInto(new ExternalSystemNode<ExternalProjectPojo>(ExternalSystemTasksTreeModel.descriptor(element2, this.myUiAware.getProjectIcon())), topLevelProjectNode);
            }
        }
    }

    public void ensureTasks(@NotNull String externalProjectConfigPath, @NotNull Collection<? extends ExternalTaskPojo> tasks) {
        if (externalProjectConfigPath == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(8);
        }
        if (tasks == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(9);
        }
        if (tasks.isEmpty()) {
            return;
        }
        ExternalSystemNode<ExternalProjectPojo> moduleNode = this.findProjectNode(externalProjectConfigPath);
        if (moduleNode == null) {
            return;
        }
        HashSet<ExternalTaskExecutionInfo> toAdd = new HashSet<ExternalTaskExecutionInfo>();
        for (ExternalTaskPojo externalTaskPojo : tasks) {
            toAdd.add(this.buildTaskInfo(externalTaskPojo));
        }
        for (int i2 = 0; i2 < moduleNode.getChildCount(); ++i2) {
            TreeNode treeNode = moduleNode.getChildAt(i2);
            Object element2 = ((ExternalSystemNode)treeNode).getDescriptor().getElement();
            if (!(element2 instanceof ExternalTaskExecutionInfo) || toAdd.remove(element2)) continue;
            this.removeNodeFromParent((MutableTreeNode)treeNode);
            --i2;
        }
        if (!toAdd.isEmpty()) {
            for (ExternalTaskExecutionInfo externalTaskExecutionInfo : toAdd) {
                this.insertNodeInto(new ExternalSystemNode<ExternalTaskExecutionInfo>(ExternalSystemTasksTreeModel.descriptor(externalTaskExecutionInfo, externalTaskExecutionInfo.getDescription(), this.myUiAware.getTaskIcon())), moduleNode);
            }
        }
    }

    @NotNull
    private ExternalTaskExecutionInfo buildTaskInfo(@NotNull ExternalTaskPojo task2) {
        if (task2 == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(10);
        }
        ExternalSystemTaskExecutionSettings settings2 = new ExternalSystemTaskExecutionSettings();
        settings2.setExternalProjectPath(task2.getLinkedExternalProjectPath());
        settings2.setTaskNames(Collections.singletonList(task2.getName()));
        settings2.setTaskDescriptions(Collections.singletonList(task2.getDescription()));
        settings2.setExternalSystemIdString(this.myExternalSystemId.toString());
        return new ExternalTaskExecutionInfo(settings2, "Run");
    }

    @Nullable
    private ExternalSystemNode<ExternalProjectPojo> findProjectNode(@NotNull String configPath) {
        if (configPath == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(11);
        }
        for (int i2 = ((DefaultMutableTreeNode)this.getRoot()).getChildCount() - 1; i2 >= 0; --i2) {
            TreeNode child2 = ((ExternalSystemNode)this.getRoot()).getChildAt(i2);
            Object childElement = ((ExternalSystemNode)child2).getDescriptor().getElement();
            if (childElement instanceof ExternalProjectPojo && ((ExternalProjectPojo)childElement).getPath().equals(configPath)) {
                return child2;
            }
            for (int j = ((DefaultMutableTreeNode)child2).getChildCount() - 1; j >= 0; --j) {
                TreeNode grandChild = ((ExternalSystemNode)child2).getChildAt(j);
                Object grandChildElement = ((ExternalSystemNode)grandChild).getDescriptor().getElement();
                if (!(grandChildElement instanceof ExternalProjectPojo) || !((ExternalProjectPojo)grandChildElement).getPath().equals(configPath)) continue;
                return grandChild;
            }
        }
        return null;
    }

    @NotNull
    private static <T> ExternalSystemNodeDescriptor<T> descriptor(@NotNull T element2, @Nullable Icon icon2) {
        if (element2 == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(12);
        }
        return ExternalSystemTasksTreeModel.descriptor(element2, "", icon2);
    }

    @NotNull
    private static <T> ExternalSystemNodeDescriptor<T> descriptor(@NotNull T element2, @NotNull @Nls String description2, @Nullable Icon icon2) {
        if (element2 == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(13);
        }
        if (description2 == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(14);
        }
        return new ExternalSystemNodeDescriptor<T>(element2, element2.toString(), description2, icon2);
    }

    @Override
    @NotNull
    public ExternalSystemNode<?> getRoot() {
        ExternalSystemNode externalSystemNode = (ExternalSystemNode)super.getRoot();
        if (externalSystemNode == null) {
            ExternalSystemTasksTreeModel.$$$reportNull$$$0(15);
        }
        return externalSystemNode;
    }

    public void insertNodeInto(MutableTreeNode child2, MutableTreeNode parent) {
        int index2 = ExternalSystemTasksTreeModel.findIndexFor(child2, parent);
        super.insertNodeInto(child2, parent, index2);
    }

    @Override
    public void insertNodeInto(MutableTreeNode child2, MutableTreeNode parent, int i2) {
        this.insertNodeInto(child2, parent);
    }

    private static int findIndexFor(MutableTreeNode child2, MutableTreeNode parent) {
        int childCount = parent.getChildCount();
        if (childCount == 0) {
            return 0;
        }
        if (childCount == 1) {
            return NODE_COMPARATOR.compare(child2, parent.getChildAt(0)) <= 0 ? 0 : 1;
        }
        return ExternalSystemTasksTreeModel.findIndexFor(child2, parent, 0, childCount - 1);
    }

    private static int findIndexFor(MutableTreeNode child2, MutableTreeNode parent, int i1, int i2) {
        if (i1 == i2) {
            return NODE_COMPARATOR.compare(child2, parent.getChildAt(i1)) <= 0 ? i1 : i1 + 1;
        }
        int half = (i1 + i2) / 2;
        if (NODE_COMPARATOR.compare(child2, parent.getChildAt(half)) <= 0) {
            return ExternalSystemTasksTreeModel.findIndexFor(child2, parent, i1, half);
        }
        return ExternalSystemTasksTreeModel.findIndexFor(child2, parent, half + 1, i2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "payload";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelProject";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subProjects";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectConfigPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPath";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureProjectNodeExists";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTaskName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "ensureProjectNodeExists";
                break;
            }
            case 3: 
            case 4: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "pruneNodes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "ensureSubProjectsStructure";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "ensureTasks";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildTaskInfo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findProjectNode";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "descriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

