/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class GotoDesktopDirAction
extends FileChooserAction
implements LightEditCompatible {
    private final NullableLazyValue<VirtualFile> myDesktopDirectory = new NullableLazyValue<VirtualFile>(){

        @Nullable
        protected VirtualFile compute() {
            return GotoDesktopDirAction.getDesktopDirectory();
        }
    };

    @Override
    protected void actionPerformed(FileSystemTree tree, AnActionEvent e) {
        VirtualFile dir = (VirtualFile)this.myDesktopDirectory.getValue();
        if (dir != null) {
            tree.select(dir, () -> tree.expand(dir, null));
        }
    }

    @Override
    protected void update(FileSystemTree tree, AnActionEvent e) {
        VirtualFile dir = (VirtualFile)this.myDesktopDirectory.getValue();
        e.getPresentation().setEnabled(dir != null && tree.isUnderRoots(dir));
    }

    @Nullable
    private static VirtualFile getDesktopDirectory() {
        String path2;
        File desktop = new File(SystemProperties.getUserHome(), "Desktop");
        if (!desktop.isDirectory() && SystemInfo.hasXdgOpen() && (path2 = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"xdg-user-dir", "DESKTOP"}))) != null) {
            desktop = new File(path2);
        }
        return desktop.isDirectory() ? LocalFileSystem.getInstance().refreshAndFindFileByIoFile(desktop) : null;
    }
}

