/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl.associate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.associate.OSFileAssociationException;
import com.intellij.openapi.fileTypes.impl.associate.OSFileAssociationFeatureUsagesUtil;
import com.intellij.openapi.fileTypes.impl.associate.OSFileAssociationPreferences;
import com.intellij.openapi.fileTypes.impl.associate.SystemAssociatorFactory;
import com.intellij.openapi.fileTypes.impl.associate.SystemFileTypeAssociator;
import com.intellij.openapi.fileTypes.impl.associate.ui.FileTypeAssociationDialog;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OSAssociateFileTypesUtil {
    public static final String ENABLE_REG_KEY = "system.file.type.associations.enabled";
    private static final Logger LOG = Logger.getInstance(OSAssociateFileTypesUtil.class);
    public static final String EXTENSION_SEPARATOR = "-x-";

    private OSAssociateFileTypesUtil() {
    }

    public static void chooseAndAssociate(@NotNull Callback callback2) {
        FileTypeAssociationDialog dialog2;
        SystemFileTypeAssociator associator;
        if (callback2 == null) {
            OSAssociateFileTypesUtil.$$$reportNull$$$0(0);
        }
        if ((associator = SystemAssociatorFactory.getAssociator()) != null && (dialog2 = new FileTypeAssociationDialog()).showAndGet()) {
            List<FileType> fileTypes = dialog2.getSelectedFileTypes();
            OSAssociateFileTypesUtil.doAssociate(callback2, associator, fileTypes);
            OSFileAssociationPreferences.getInstance().updateFileTypes(fileTypes);
        }
    }

    public static void restoreAssociations(@NotNull Callback callback2) {
        List<FileType> savedFileTypes;
        SystemFileTypeAssociator associator;
        if (callback2 == null) {
            OSAssociateFileTypesUtil.$$$reportNull$$$0(1);
        }
        if ((associator = SystemAssociatorFactory.getAssociator()) != null && !(savedFileTypes = OSAssociateFileTypesUtil.restoreFileTypes()).isEmpty()) {
            OSAssociateFileTypesUtil.doAssociate(callback2, associator, savedFileTypes);
        }
    }

    public static List<FileType> restoreFileTypes() {
        ArrayList<FileType> fileTypes = new ArrayList<FileType>();
        OSFileAssociationPreferences.getInstance().fileTypeNames.forEach(name -> {
            if (name.contains(EXTENSION_SEPARATOR)) {
                int extPos = name.indexOf(EXTENSION_SEPARATOR);
                String originalName = name.substring(0, extPos);
                String extension2 = name.substring(extPos + EXTENSION_SEPARATOR.length());
                FileType originalType = OSAssociateFileTypesUtil.getFileTypeByName(originalName);
                if (originalType != null) {
                    for (FileNameMatcher matcher : FileTypeManager.getInstance().getAssociations(originalType)) {
                        if (!(matcher instanceof ExtensionFileNameMatcher) || !extension2.equals(((ExtensionFileNameMatcher)matcher).getExtension())) continue;
                        fileTypes.add(new MyFileSubtype(originalType, matcher, (String)name, matcher.getPresentableString()));
                    }
                }
            } else {
                ObjectUtils.consumeIfNotNull((Object)OSAssociateFileTypesUtil.getFileTypeByName(name), fileType -> fileTypes.add((FileType)fileType));
            }
        });
        return fileTypes;
    }

    @Nullable
    private static FileType getFileTypeByName(@NotNull String name) {
        if (name == null) {
            OSAssociateFileTypesUtil.$$$reportNull$$$0(2);
        }
        for (FileType fileType : FileTypeManager.getInstance().getRegisteredFileTypes()) {
            if (!name.equals(fileType.getName())) continue;
            return fileType;
        }
        LOG.warn(name + " file type not found.");
        return null;
    }

    private static void doAssociate(@NotNull Callback callback2, @NotNull SystemFileTypeAssociator associator, List<FileType> fileTypes) {
        if (callback2 == null) {
            OSAssociateFileTypesUtil.$$$reportNull$$$0(3);
        }
        if (associator == null) {
            OSAssociateFileTypesUtil.$$$reportNull$$$0(4);
        }
        if (fileTypes.size() > 0) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    callback2.beforeStart();
                    associator.associateFileTypes(fileTypes);
                    OSFileAssociationFeatureUsagesUtil.logFilesAssociated(fileTypes);
                    callback2.onSuccess(associator.isOsRestartRequired());
                }
                catch (OSFileAssociationException exception) {
                    callback2.onFailure(exception.getMessage());
                    LOG.info((Throwable)exception);
                }
            });
        }
    }

    public static boolean isAvailable() {
        return Registry.get((String)ENABLE_REG_KEY).asBoolean() && SystemAssociatorFactory.getAssociator() != null;
    }

    @NotNull
    public static List<String> getExtensions(@NotNull FileType fileType) {
        if (fileType == null) {
            OSAssociateFileTypesUtil.$$$reportNull$$$0(5);
        }
        List list2 = ContainerUtil.map(OSAssociateFileTypesUtil.getExtensionMatchers(fileType), matcher -> matcher.getExtension());
        if (list2 == null) {
            OSAssociateFileTypesUtil.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public static List<ExtensionFileNameMatcher> getExtensionMatchers(@NotNull FileType fileType) {
        if (fileType == null) {
            OSAssociateFileTypesUtil.$$$reportNull$$$0(7);
        }
        List<ExtensionFileNameMatcher> list2 = OSAssociateFileTypesUtil.getMatchers(fileType).stream().filter(matcher -> matcher instanceof ExtensionFileNameMatcher).map(matcher -> (ExtensionFileNameMatcher)matcher).collect(Collectors.toList());
        if (list2 == null) {
            OSAssociateFileTypesUtil.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    public static List<FileNameMatcher> getMatchers(@NotNull FileType fileType) {
        if (fileType == null) {
            OSAssociateFileTypesUtil.$$$reportNull$$$0(9);
        }
        if (fileType instanceof MyFileSubtype) {
            List<FileNameMatcher> list2 = Collections.singletonList(((MyFileSubtype)fileType).getMatcher());
            if (list2 == null) {
                OSAssociateFileTypesUtil.$$$reportNull$$$0(10);
            }
            return list2;
        }
        List matchers = FileTypeManager.getInstance().getAssociations(fileType);
        if (matchers.size() > 0) {
            List list3 = matchers;
            if (list3 == null) {
                OSAssociateFileTypesUtil.$$$reportNull$$$0(11);
            }
            return list3;
        }
        String defaultExt = fileType.getDefaultExtension();
        if (!StringUtil.isEmptyOrSpaces((String)defaultExt)) {
            List<ExtensionFileNameMatcher> list4 = Collections.singletonList(new ExtensionFileNameMatcher(defaultExt));
            if (list4 == null) {
                OSAssociateFileTypesUtil.$$$reportNull$$$0(12);
            }
            return list4;
        }
        List<FileNameMatcher> list5 = Collections.emptyList();
        if (list5 == null) {
            OSAssociateFileTypesUtil.$$$reportNull$$$0(13);
        }
        return list5;
    }

    @NotNull
    public static List<FileType> createSubtypes(@NotNull FileType originalType) {
        if (originalType == null) {
            OSAssociateFileTypesUtil.$$$reportNull$$$0(14);
        }
        ArrayList<FileType> subtypes = new ArrayList<FileType>();
        for (FileNameMatcher matcher : FileTypeManager.getInstance().getAssociations(originalType)) {
            if (!(matcher instanceof ExtensionFileNameMatcher)) continue;
            String name = ((ExtensionFileNameMatcher)matcher).getExtension().equals(originalType.getDefaultExtension()) ? originalType.getName() : OSAssociateFileTypesUtil.getSubtypeName(originalType.getName(), (ExtensionFileNameMatcher)matcher);
            subtypes.add(new MyFileSubtype(originalType, matcher, name, matcher.getPresentableString()));
        }
        ArrayList<FileType> arrayList = subtypes;
        if (arrayList == null) {
            OSAssociateFileTypesUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static String getSubtypeName(@NotNull String baseName, @NotNull ExtensionFileNameMatcher matcher) {
        if (baseName == null) {
            OSAssociateFileTypesUtil.$$$reportNull$$$0(16);
        }
        if (matcher == null) {
            OSAssociateFileTypesUtil.$$$reportNull$$$0(17);
        }
        String ext = StringUtils.removeStart((String)matcher.getExtension(), (String)".");
        return baseName + EXTENSION_SEPARATOR + ext;
    }

    @Nullable
    public static FileNameMatcher getSubtypeMatcher(@NotNull FileType fileType) {
        if (fileType == null) {
            OSAssociateFileTypesUtil.$$$reportNull$$$0(18);
        }
        return fileType instanceof MyFileSubtype ? ((MyFileSubtype)fileType).getMatcher() : null;
    }

    @NotNull
    static FileType getOriginalType(@NotNull FileType fileType) {
        if (fileType == null) {
            OSAssociateFileTypesUtil.$$$reportNull$$$0(19);
        }
        FileType fileType2 = fileType instanceof MyFileSubtype ? ((MyFileSubtype)fileType).myOriginalType : fileType;
        if (fileType2 == null) {
            OSAssociateFileTypesUtil.$$$reportNull$$$0(20);
        }
        return fileType2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "associator";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/associate/OSAssociateFileTypesUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/associate/OSAssociateFileTypesUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionMatchers";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchers";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubtypes";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndAssociate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "restoreAssociations";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileTypeByName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doAssociate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 20: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionMatchers";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMatchers";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createSubtypes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSubtypeName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSubtypeMatcher";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyFileSubtype
    implements FileType {
        private final FileType myOriginalType;
        private final FileNameMatcher myMatcher;
        private final String myName;
        @NlsSafe
        private final String myDescription;

        private MyFileSubtype(@NotNull FileType originalType, @NotNull FileNameMatcher matcher, @NotNull @NonNls String name, @NotNull @NonNls String description2) {
            if (originalType == null) {
                MyFileSubtype.$$$reportNull$$$0(0);
            }
            if (matcher == null) {
                MyFileSubtype.$$$reportNull$$$0(1);
            }
            if (name == null) {
                MyFileSubtype.$$$reportNull$$$0(2);
            }
            if (description2 == null) {
                MyFileSubtype.$$$reportNull$$$0(3);
            }
            this.myOriginalType = originalType;
            this.myMatcher = matcher;
            this.myName = name;
            this.myDescription = description2;
        }

        @NonNls
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                MyFileSubtype.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NlsContexts.Label
        @NotNull
        public String getDescription() {
            String string = this.myDescription;
            if (string == null) {
                MyFileSubtype.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NlsSafe
        @NotNull
        public String getDefaultExtension() {
            String string = this.myMatcher instanceof ExtensionFileNameMatcher ? ((ExtensionFileNameMatcher)this.myMatcher).getExtension() : this.myOriginalType.getDefaultExtension();
            if (string == null) {
                MyFileSubtype.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Nullable
        public Icon getIcon() {
            return this.myOriginalType.getIcon();
        }

        public boolean isBinary() {
            return this.myOriginalType.isBinary();
        }

        public boolean isReadOnly() {
            return this.myOriginalType.isReadOnly();
        }

        @NonNls
        @Nullable
        public String getCharset(@NotNull VirtualFile file2, byte @NotNull [] content2) {
            if (file2 == null) {
                MyFileSubtype.$$$reportNull$$$0(7);
            }
            if (content2 == null) {
                MyFileSubtype.$$$reportNull$$$0(8);
            }
            return this.myOriginalType.getCharset(file2, content2);
        }

        @NotNull
        private FileNameMatcher getMatcher() {
            FileNameMatcher fileNameMatcher = this.myMatcher;
            if (fileNameMatcher == null) {
                MyFileSubtype.$$$reportNull$$$0(9);
            }
            return fileNameMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileTypes/impl/associate/OSAssociateFileTypesUtil$MyFileSubtype";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileTypes/impl/associate/OSAssociateFileTypesUtil$MyFileSubtype";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultExtension";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getCharset";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Callback {
        public void beforeStart();

        public void onSuccess(boolean var1);

        public void onFailure(@NotNull @Nls String var1);
    }
}

