/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl.associate;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.associate.OSAssociateFileTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class OSFileAssociationFeatureUsagesUtil {
    private static final String GROUP_ID = "os.file.type.association";
    private static final String ASSOCIATION_CREATED = "os.association.created";
    private static final String OTHER_FILE_TYPE = "Other";

    private OSFileAssociationFeatureUsagesUtil() {
    }

    static void logFilesAssociated(@NotNull List<? extends FileType> fileTypes) {
        if (fileTypes == null) {
            OSFileAssociationFeatureUsagesUtil.$$$reportNull$$$0(0);
        }
        ContainerUtil.map(fileTypes, fileType -> OSFileAssociationFeatureUsagesUtil.getAllowedTypeName(fileType)).forEach(fileType -> FUCounterUsageLogger.getInstance().logEvent(GROUP_ID, ASSOCIATION_CREATED, new FeatureUsageData().addData("file_type", fileType)));
    }

    public static String getAllowedTypeName(@NotNull FileType fileType) {
        FileType originalType;
        PluginInfo info2;
        if (fileType == null) {
            OSFileAssociationFeatureUsagesUtil.$$$reportNull$$$0(1);
        }
        return (info2 = PluginInfoDetectorKt.getPluginInfo((originalType = OSAssociateFileTypesUtil.getOriginalType(fileType)).getClass())).isDevelopedByJetBrains() ? originalType.getName() : OTHER_FILE_TYPE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileTypes/impl/associate/OSFileAssociationFeatureUsagesUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "logFilesAssociated";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllowedTypeName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

