/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl.associate;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.fileTypes.impl.associate.OSAssociateFileTypesUtil;
import com.intellij.openapi.fileTypes.impl.associate.OSFileAssociationPreferences;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.util.messages.SimpleMessageBusConnection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OSFileAssociationStartupConfigurator
implements ApplicationInitializedListener {
    private static final Logger LOG = Logger.getInstance(OSFileAssociationStartupConfigurator.class);

    OSFileAssociationStartupConfigurator() {
    }

    public void componentsInitialized() {
        OSFileAssociationPreferences preferences = OSFileAssociationPreferences.getInstance();
        if (!preferences.fileTypeNames.isEmpty() && preferences.ideLocationChanged()) {
            LOG.info("Restoring file type associations on IDE location change");
            SimpleMessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().simpleConnect();
            MyResultHandler resultHandler = new MyResultHandler(connection);
            connection.subscribe(AppLifecycleListener.TOPIC, (Object)resultHandler);
            connection.subscribe(ProjectManager.TOPIC, (Object)resultHandler);
            OSAssociateFileTypesUtil.restoreAssociations(resultHandler);
            preferences.updateIdeLocationHash();
        }
    }

    private static class MyResultHandler
    implements OSAssociateFileTypesUtil.Callback,
    AppLifecycleListener,
    ProjectManagerListener {
        private static final String NOTIF_GROUP_ID = "os.file.ide.association";
        private Notification myNotification;
        private SimpleMessageBusConnection myConnection;

        private MyResultHandler(@NotNull SimpleMessageBusConnection connection) {
            if (connection == null) {
                MyResultHandler.$$$reportNull$$$0(0);
            }
            this.myConnection = connection;
        }

        @Override
        public void beforeStart() {
        }

        @Override
        public void onSuccess(boolean isOsRestartRequired) {
            LOG.info("File-IDE associations successfully restored.");
            this.myNotification = new Notification(NOTIF_GROUP_ID, MyResultHandler.getNotifTitle(), FileTypesBundle.message("filetype.associate.notif.success", ApplicationInfo.getInstance().getFullApplicationName()) + (String)(isOsRestartRequired ? "\n" + FileTypesBundle.message("filetype.associate.message.os.restart", new Object[0]) : ""), isOsRestartRequired ? NotificationType.WARNING : NotificationType.INFORMATION);
        }

        @Override
        public void onFailure(@NotNull @Nls String errorMessage) {
            if (errorMessage == null) {
                MyResultHandler.$$$reportNull$$$0(1);
            }
            LOG.warn("File-IDE associations can't be restored: " + errorMessage);
            this.myNotification = new Notification(NOTIF_GROUP_ID, MyResultHandler.getNotifTitle(), FileTypesBundle.message("filetype.associate.notif.error", new Object[0]), NotificationType.ERROR);
        }

        @Nls
        private static String getNotifTitle() {
            return FileTypesBundle.message("filetype.associate.notif.title", new Object[0]);
        }

        @Override
        public void welcomeScreenDisplayed() {
            this.doNotify(null);
        }

        public void projectOpened(@NotNull Project project) {
            if (project == null) {
                MyResultHandler.$$$reportNull$$$0(2);
            }
            this.doNotify(project);
        }

        private void doNotify(@Nullable Project project) {
            if (this.myNotification != null) {
                Notifications.Bus.notify((Notification)this.myNotification, (Project)project);
                this.myConnection.disconnect();
                this.myConnection = null;
                this.myNotification = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileTypes/impl/associate/OSFileAssociationStartupConfigurator$MyResultHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onFailure";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectOpened";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

