/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.keymap.impl.ui.KeyboardShortcutPanel;
import com.intellij.openapi.keymap.impl.ui.ShortcutDialog;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class KeyboardShortcutDialog
extends ShortcutDialog<KeyboardShortcut> {
    private final JComponent myPreferredFocusedComponent;
    @Nullable
    private final Map<KeyStroke, String> mySystemShortcuts;

    KeyboardShortcutDialog(Component parent, boolean allowSecondStroke, @Nullable Map<KeyStroke, String> systemShortcuts) {
        super(parent, "keyboard.shortcut.dialog.title", new KeyboardShortcutPanel(true, new BorderLayout()));
        KeyboardShortcutPanel panel2 = (KeyboardShortcutPanel)this.myShortcutPanel;
        this.myPreferredFocusedComponent = panel2.myFirstStroke;
        this.mySystemShortcuts = systemShortcuts;
        JPanel inner = new JPanel(new BorderLayout());
        inner.add("Center", (Component)((Object)panel2.mySecondStroke));
        inner.add("West", panel2.mySecondStrokeEnable);
        inner.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        inner.setVisible(allowSecondStroke);
        panel2.add("North", (Component)((Object)panel2.myFirstStroke));
        panel2.add("South", inner);
        panel2.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        panel2.mySecondStrokeEnable.setText(KeyMapBundle.message((String)"dialog.enable.second.stroke.checkbox", (Object[])new Object[0]));
        this.init();
    }

    protected String getHelpId() {
        return "preferences.keymap.shortcut";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPreferredFocusedComponent;
    }

    @Override
    KeyboardShortcut toShortcut(Object value2) {
        return value2 instanceof KeyboardShortcut ? (KeyboardShortcut)value2 : null;
    }

    @Override
    @NotNull
    Collection<String> getConflicts(KeyboardShortcut shortcut, String actionId, Keymap keymap2) {
        String sysAct = this.getSystemShortcutAction(shortcut.getFirstKeyStroke());
        Set<String> keymapConflicts = keymap2.getConflicts(actionId, shortcut).keySet();
        if (sysAct == null) {
            Set<String> set2 = keymapConflicts;
            if (set2 == null) {
                KeyboardShortcutDialog.$$$reportNull$$$0(0);
            }
            return set2;
        }
        if (keymapConflicts.isEmpty()) {
            List<String> list2 = Collections.singletonList(sysAct);
            if (list2 == null) {
                KeyboardShortcutDialog.$$$reportNull$$$0(1);
            }
            return list2;
        }
        ArrayList<String> result2 = new ArrayList<String>(keymapConflicts);
        result2.add(sysAct);
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            KeyboardShortcutDialog.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    protected void addSystemActionsIfPresented(Group group2) {
        if (this.mySystemShortcuts != null) {
            Group macOsSysGroup = new Group(IdeBundle.message((String)"action.group.macos.shortcuts.text", (Object[])new Object[0]), AllIcons.Nodes.KeymapOther);
            this.mySystemShortcuts.forEach((ks, id2) -> macOsSysGroup.addActionId((String)id2));
            group2.addGroup(macOsSysGroup);
        }
    }

    @Nullable
    private String getSystemShortcutAction(@NotNull KeyStroke keyStroke) {
        if (keyStroke == null) {
            KeyboardShortcutDialog.$$$reportNull$$$0(3);
        }
        return this.mySystemShortcuts == null ? null : this.mySystemShortcuts.get(keyStroke);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/KeyboardShortcutDialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStroke";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflicts";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeyboardShortcutDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSystemShortcutAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

