/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.Function;
import com.intellij.util.io.URLUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalPathReferenceProvider
implements PathReferenceProvider {
    @NonNls
    private static final String[] PREFIXES = new String[]{"tel:", "sms:", "skype:", "data:", "xmpp:"};

    public static boolean startsWithAllowedPrefix(String s) {
        for (String prefix2 : PREFIXES) {
            if (!s.startsWith(prefix2)) continue;
            return true;
        }
        return false;
    }

    public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> references, boolean soft) {
        ElementManipulator manipulator;
        if (psiElement == null) {
            GlobalPathReferenceProvider.$$$reportNull$$$0(0);
        }
        if (references == null) {
            GlobalPathReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((manipulator = ElementManipulators.getManipulator((PsiElement)psiElement)) == null) {
            return false;
        }
        return this.createUrlReference(psiElement, manipulator.getRangeInElement(psiElement).substring(psiElement.getText()), manipulator.getRangeInElement(psiElement), references);
    }

    public boolean createUrlReference(@NotNull PsiElement psiElement, String url, TextRange rangeInElement, @NotNull List<? super PsiReference> references) {
        if (psiElement == null) {
            GlobalPathReferenceProvider.$$$reportNull$$$0(2);
        }
        if (references == null) {
            GlobalPathReferenceProvider.$$$reportNull$$$0(3);
        }
        if (GlobalPathReferenceProvider.isWebReferenceUrl(url)) {
            references.add((PsiReference)new WebReference(psiElement, rangeInElement, url));
            return true;
        }
        if (url.contains("://") || url.startsWith("//") || GlobalPathReferenceProvider.startsWithAllowedPrefix(url)) {
            references.add((PsiReference)PsiReferenceBase.createSelfReference((PsiElement)psiElement, (TextRange)rangeInElement, (PsiElement)psiElement));
            return true;
        }
        return false;
    }

    public static boolean isWebReferenceUrl(String url) {
        return url.startsWith("http://") || url.startsWith("https://") || url.startsWith("about:") || url.startsWith("mailto:");
    }

    @Nullable
    public PathReference getPathReference(@NotNull String path2, @NotNull PsiElement element2) {
        if (path2 == null) {
            GlobalPathReferenceProvider.$$$reportNull$$$0(4);
        }
        if (element2 == null) {
            GlobalPathReferenceProvider.$$$reportNull$$$0(5);
        }
        return URLUtil.containsScheme((String)path2) ? new PathReference(path2, (Function)PathReference.NULL_ICON) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/paths/GlobalPathReferenceProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferences";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createUrlReference";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getPathReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

