/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.vfs.JarCopyingFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtilRt;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class RootsAsVirtualFilePointers
implements RootProvider {
    private static final Logger LOG = Logger.getInstance(RootsAsVirtualFilePointers.class);
    private final Map<OrderRootType, VirtualFilePointerContainer> myRoots;
    private final boolean myNoCopyJars;
    private final VirtualFilePointerListener myListener;
    @NotNull
    private final Disposable myParent;

    RootsAsVirtualFilePointers(boolean noCopyJars, VirtualFilePointerListener listener2, @NotNull Disposable parent) {
        if (parent == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(0);
        }
        this.myRoots = new ConcurrentHashMap<OrderRootType, VirtualFilePointerContainer>();
        this.myNoCopyJars = noCopyJars;
        this.myListener = listener2;
        this.myParent = parent;
    }

    public VirtualFile @NotNull [] getFiles(@NotNull OrderRootType type) {
        VirtualFilePointerContainer container;
        if (type == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(1);
        }
        VirtualFile[] virtualFileArray = (container = this.myRoots.get(type)) == null ? VirtualFile.EMPTY_ARRAY : container.getFiles();
        if (virtualFileArray == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(2);
        }
        return virtualFileArray;
    }

    public String @NotNull [] getUrls(@NotNull OrderRootType type) {
        VirtualFilePointerContainer container;
        if (type == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(3);
        }
        String[] stringArray = (container = this.myRoots.get(type)) == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : container.getUrls();
        if (stringArray == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    public void addRoot(@NotNull VirtualFile virtualFile2, @NotNull OrderRootType type) {
        if (virtualFile2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(5);
        }
        if (type == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(6);
        }
        this.getOrCreateContainer(type).add(virtualFile2);
    }

    public void addRoot(@NotNull String url, @NotNull OrderRootType type) {
        if (url == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(7);
        }
        if (type == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(8);
        }
        this.getOrCreateContainer(type).add(url);
    }

    public void removeAllRoots(@NotNull OrderRootType type) {
        VirtualFilePointerContainer container;
        if (type == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(9);
        }
        if ((container = this.myRoots.get(type)) != null) {
            container.clear();
        }
    }

    public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType type) {
        if (root == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(10);
        }
        if (type == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(11);
        }
        this.removeRoot(root.getUrl(), type);
    }

    public void removeRoot(@NotNull String url, @NotNull OrderRootType type) {
        VirtualFilePointerContainer container;
        VirtualFilePointer pointer;
        if (url == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(12);
        }
        if (type == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(13);
        }
        VirtualFilePointer virtualFilePointer = pointer = (container = this.myRoots.get(type)) == null ? null : container.findByUrl(url);
        if (pointer != null) {
            container.remove(pointer);
        }
    }

    public void removeAllRoots() {
        for (VirtualFilePointerContainer myRoot : this.myRoots.values()) {
            myRoot.clear();
        }
    }

    public void readExternal(@NotNull Element element2) {
        if (element2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(14);
        }
        for (PersistentOrderRootType type : OrderRootType.getAllPersistentTypes()) {
            this.read(element2, type);
        }
        if (this.myNoCopyJars) {
            this.myRoots.values().forEach(container -> {
                for (String root : container.getUrls()) {
                    RootsAsVirtualFilePointers.setNoCopyJars(root);
                }
            });
        }
    }

    public void writeExternal(@NotNull Element element2) {
        if (element2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(15);
        }
        for (PersistentOrderRootType type : OrderRootType.getSortedRootTypes()) {
            this.write(element2, type);
        }
    }

    void copyRootsFrom(@NotNull RootProvider rootContainer) {
        if (rootContainer == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(16);
        }
        this.removeAllRoots();
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            String[] newRoots;
            for (String newRoot : newRoots = rootContainer.getUrls(rootType)) {
                this.addRoot(newRoot, rootType);
            }
        }
    }

    private static void setNoCopyJars(@NotNull String url) {
        if (url == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(17);
        }
        if ("jar".equals(VirtualFileManager.extractProtocol((String)url))) {
            String path2 = VirtualFileManager.extractPath((String)url);
            VirtualFileSystem fileSystem = StandardFileSystems.jar();
            if (fileSystem instanceof JarCopyingFileSystem) {
                ((JarCopyingFileSystem)fileSystem).setNoCopyJarForPath(path2);
            }
        }
    }

    private void read(@NotNull Element roots, @NotNull PersistentOrderRootType type) {
        Element composite2;
        String sdkRootName;
        Element child2;
        if (roots == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(18);
        }
        if (type == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(19);
        }
        Element element2 = child2 = (sdkRootName = type.getSdkRootName()) == null ? null : roots.getChild(sdkRootName);
        if (child2 == null) {
            return;
        }
        List composites = child2.getChildren();
        if (composites.size() != 1) {
            LOG.error((Object)composites);
        }
        if (!(composite2 = (Element)composites.get(0)).getChildren("root").isEmpty()) {
            VirtualFilePointerContainer container = this.getOrCreateContainer((OrderRootType)type);
            container.readExternal(composite2, "root", false);
        }
    }

    private void write(@NotNull Element roots, @NotNull PersistentOrderRootType type) {
        String sdkRootName;
        if (roots == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(20);
        }
        if (type == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(21);
        }
        if ((sdkRootName = type.getSdkRootName()) == null) {
            return;
        }
        Element e = new Element(sdkRootName);
        roots.addContent(e);
        Element composite2 = new Element("root");
        composite2.setAttribute("type", "composite");
        e.addContent(composite2);
        VirtualFilePointerContainer container = this.myRoots.get(type);
        if (container != null) {
            container.writeExternal(composite2, "root", false);
        }
        for (Element root : composite2.getChildren()) {
            root.setAttribute("type", "simple");
        }
    }

    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
        if (listener2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(22);
        }
        throw new RuntimeException();
    }

    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(23);
        }
        if (parentDisposable == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(24);
        }
        throw new RuntimeException();
    }

    public void removeRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
        if (listener2 == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(25);
        }
        throw new RuntimeException();
    }

    @NotNull
    private VirtualFilePointerContainer getOrCreateContainer(@NotNull OrderRootType rootType) {
        VirtualFilePointerContainer roots;
        if (rootType == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(26);
        }
        if ((roots = this.myRoots.get(rootType)) == null) {
            roots = VirtualFilePointerManager.getInstance().createContainer(this.myParent, this.myListener);
            this.myRoots.put(rootType, roots);
        }
        VirtualFilePointerContainer virtualFilePointerContainer = roots;
        if (virtualFilePointerContainer == null) {
            RootsAsVirtualFilePointers.$$$reportNull$$$0(27);
        }
        return virtualFilePointerContainer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 4: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/RootsAsVirtualFilePointers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 7: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootContainer";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/RootsAsVirtualFilePointers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 2: 
            case 4: 
            case 27: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeAllRoots";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "copyRootsFrom";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setNoCopyJars";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addRootSetChangedListener";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeRootSetChangedListener";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateContainer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

