/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SdkListItem {
    private SdkListItem() {
    }

    public static final class GroupItem
    extends SdkListItem {
        @NotNull
        public final Icon icon;
        @Nls
        @NotNull
        public final String caption;
        @NotNull
        public final List<? extends SdkListItem> subItems;

        GroupItem(@NotNull Icon icon2, @Nls @NotNull String caption, @NotNull List<ActionItem> subItems) {
            if (icon2 == null) {
                GroupItem.$$$reportNull$$$0(0);
            }
            if (caption == null) {
                GroupItem.$$$reportNull$$$0(1);
            }
            if (subItems == null) {
                GroupItem.$$$reportNull$$$0(2);
            }
            this.icon = icon2;
            this.caption = caption;
            this.subItems = ImmutableList.copyOf((Collection)ContainerUtil.map(subItems, it -> it.withGroup(this)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "caption";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "subItems";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/roots/ui/configuration/SdkListItem$GroupItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ActionItem
    extends SdkListItem {
        @NotNull
        public final ActionRole role;
        @NotNull
        public final ProjectSdksModel.NewSdkAction action;
        @Nullable
        public final GroupItem group;

        ActionItem(@NotNull ActionRole role, @NotNull ProjectSdksModel.NewSdkAction action2, @Nullable GroupItem group2) {
            if (role == null) {
                ActionItem.$$$reportNull$$$0(0);
            }
            if (action2 == null) {
                ActionItem.$$$reportNull$$$0(1);
            }
            this.role = role;
            this.action = action2;
            this.group = group2;
        }

        @Contract(pure=true)
        @NotNull
        ActionItem withGroup(@NotNull GroupItem group2) {
            if (group2 == null) {
                ActionItem.$$$reportNull$$$0(2);
            }
            return new ActionItem(this.role, this.action, group2);
        }

        public String toString() {
            return this.action.getListItemText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "role";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/SdkListItem$ActionItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withGroup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum ActionRole {
        DOWNLOAD,
        ADD;

    }

    public static final class SuggestedItem
    extends SdkListItem {
        @NotNull
        public final SdkType sdkType;
        @NlsSafe
        public final String version;
        @NotNull
        public final String homePath;

        SuggestedItem(@NotNull SdkType sdkType, @NlsSafe @NotNull String version2, @NotNull String homePath) {
            if (sdkType == null) {
                SuggestedItem.$$$reportNull$$$0(0);
            }
            if (version2 == null) {
                SuggestedItem.$$$reportNull$$$0(1);
            }
            if (homePath == null) {
                SuggestedItem.$$$reportNull$$$0(2);
            }
            this.sdkType = sdkType;
            this.version = version2;
            this.homePath = homePath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sdkType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "version";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "homePath";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/roots/ui/configuration/SdkListItem$SuggestedItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class InvalidSdkItem
    extends SdkListItem {
        @NotNull
        public final String sdkName;

        InvalidSdkItem(@NotNull String name) {
            if (name == null) {
                InvalidSdkItem.$$$reportNull$$$0(0);
            }
            this.sdkName = name;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof InvalidSdkItem && this.sdkName.equals(((InvalidSdkItem)o).sdkName);
        }

        public int hashCode() {
            return this.sdkName.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/roots/ui/configuration/SdkListItem$InvalidSdkItem", "<init>"));
        }
    }

    public static final class NoneSdkItem
    extends SdkListItem {
        public int hashCode() {
            return 42;
        }

        public boolean equals(Object obj2) {
            return obj2 instanceof NoneSdkItem;
        }
    }

    public static final class ProjectSdkItem
    extends SdkListItem {
        public int hashCode() {
            return 42;
        }

        public boolean equals(Object obj2) {
            return obj2 instanceof ProjectSdkItem;
        }
    }

    public static abstract class SdkItem
    extends SdkListItem {
        @NotNull
        public final Sdk sdk;

        SdkItem(@NotNull Sdk sdk2) {
            if (sdk2 == null) {
                SdkItem.$$$reportNull$$$0(0);
            }
            this.sdk = sdk2;
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="20201.1")
        @NotNull
        public Sdk getSdk() {
            Sdk sdk2 = this.sdk;
            if (sdk2 == null) {
                SdkItem.$$$reportNull$$$0(1);
            }
            return sdk2;
        }

        public final boolean equals(Object o) {
            return this == o || o instanceof SdkItem && this.sdk.equals(((SdkItem)o).sdk);
        }

        public final int hashCode() {
            return this.sdk.hashCode();
        }

        abstract boolean hasSameSdk(@NotNull Sdk var1);

        public String toString() {
            return this.sdk.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/SdkListItem$SdkItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/SdkListItem$SdkItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSdk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class SdkReferenceItem
    extends SdkListItem {
        @NotNull
        public final SdkType sdkType;
        @NotNull
        public final String name;
        @NlsSafe
        @Nullable
        public final String versionString;
        public final boolean hasValidPath;

        SdkReferenceItem(@NotNull SdkType sdkType, @NotNull String name, @Nullable String versionString, boolean hasValidPath) {
            if (sdkType == null) {
                SdkReferenceItem.$$$reportNull$$$0(0);
            }
            if (name == null) {
                SdkReferenceItem.$$$reportNull$$$0(1);
            }
            this.sdkType = sdkType;
            this.name = name;
            this.versionString = versionString;
            this.hasValidPath = hasValidPath;
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="20201.1")
        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                SdkReferenceItem.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SdkReferenceItem)) {
                return false;
            }
            SdkReferenceItem item = (SdkReferenceItem)o;
            return this.sdkType.equals((Object)item.sdkType) && this.name.equals(item.name);
        }

        public int hashCode() {
            return Objects.hash(this.sdkType, this.name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/SdkListItem$SdkReferenceItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/SdkListItem$SdkReferenceItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

