/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsConfigurable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JEditorPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractUpdateDialog
extends DialogWrapper {
    protected final boolean myEnableLink;

    protected AbstractUpdateDialog(boolean enableLink) {
        this(null, enableLink);
    }

    protected AbstractUpdateDialog(@Nullable Project project, boolean enableLink) {
        super(project, true);
        this.myEnableLink = enableLink;
        this.setTitle(IdeBundle.message((String)"updates.dialog.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
    }

    protected void init() {
        this.setOKButtonText(this.getOkButtonText());
        this.setCancelButtonText(this.getCancelButtonText());
        super.init();
    }

    @NlsContexts.Button
    protected String getOkButtonText() {
        return CommonBundle.getOkButtonText();
    }

    @NlsContexts.Button
    protected String getCancelButtonText() {
        return CommonBundle.getCancelButtonText();
    }

    protected void configureMessageArea(@NotNull JEditorPane area) {
        if (area == null) {
            AbstractUpdateDialog.$$$reportNull$$$0(0);
        }
        String messageBody = this.myEnableLink ? IdeBundle.message((String)"updates.configure.label", (Object[])new Object[0]) : "";
        HtmlChunk.Element html = new HtmlBuilder().append((HtmlChunk)HtmlChunk.head().addRaw(UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont())).child((HtmlChunk)HtmlChunk.styleTag((String)("body {background: #" + ColorUtil.toHex((Color)UIUtil.getPanelBackground()) + ";}")))).append((HtmlChunk)HtmlChunk.body().addRaw(messageBody)).wrapWith("html");
        area.setBackground(UIUtil.getPanelBackground());
        area.setBorder((Border)JBUI.Borders.empty());
        area.setText(html.toString());
        area.setCaretPosition(0);
        area.setEditable(false);
        if (this.myEnableLink) {
            area.addHyperlinkListener(e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    ShowSettingsUtil.getInstance().editConfigurable((Component)area, (Configurable)new UpdateSettingsConfigurable(false));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "area", "com/intellij/openapi/updateSettings/impl/AbstractUpdateDialog", "configureMessageArea"));
    }
}

