/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginHeaderPanel;
import com.intellij.ide.plugins.PluginInfoProvider;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.OrderPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class DetectedPluginsPanel
extends OrderPanel<PluginDownloader> {
    private final JEditorPane myDescriptionPanel = new JEditorPane();
    private final PluginHeaderPanel myHeader = new PluginHeaderPanel();
    private final HashSet<PluginId> mySkippedPlugins = new HashSet();

    public DetectedPluginsPanel() {
        super(PluginDownloader.class);
        final JTable entryTable = this.getEntryTable();
        entryTable.setTableHeader(null);
        entryTable.setDefaultRenderer(PluginDownloader.class, (TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, Object value2, boolean selected2, boolean hasFocus, int row2, int column2) {
                String version2;
                String oldPluginName;
                if (table == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.setBorder(null);
                if (!(value2 instanceof PluginDownloader)) {
                    return;
                }
                PluginDownloader downloader = (PluginDownloader)value2;
                String pluginName = downloader.getPluginName();
                this.append(pluginName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                IdeaPluginDescriptor installedPlugin = PluginManagerCore.getPlugin(downloader.getId());
                String string = oldPluginName = installedPlugin != null ? installedPlugin.getName() : null;
                if (oldPluginName != null && !Comparing.strEqual((String)pluginName, (String)oldPluginName)) {
                    this.append(" - " + oldPluginName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
                String installedVersion = installedPlugin != null ? installedPlugin.getVersion() : null;
                String availableVersion = downloader.getPluginVersion();
                String string2 = version2 = installedVersion != null && availableVersion != null ? StringUtil.join((String[])new String[]{installedVersion, UIUtil.rightArrow(), availableVersion}, (String)"") : StringUtil.defaultIfEmpty((String)installedVersion, (String)availableVersion);
                if (StringUtil.isNotEmpty((String)version2)) {
                    this.append(" " + version2, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/openapi/updateSettings/impl/DetectedPluginsPanel$1", "customizeCellRenderer"));
            }
        });
        entryTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = entryTable.getSelectedRow();
                if (selectedRow != -1) {
                    IdeaPluginDescriptor plugin2 = ((PluginDownloader)DetectedPluginsPanel.this.getValueAt(selectedRow)).getDescriptor();
                    DetectedPluginsPanel.this.myHeader.setPlugin(plugin2);
                    DetectedPluginsPanel.this.myDescriptionPanel.setText(DetectedPluginsPanel.pluginInfoUpdate(plugin2));
                    DetectedPluginsPanel.this.myDescriptionPanel.setCaretPosition(0);
                }
            }
        });
        this.myDescriptionPanel.setPreferredSize((Dimension)new JBDimension(600, 400));
        this.myDescriptionPanel.setEditable(false);
        this.myDescriptionPanel.setEditorKit(UIUtil.getHTMLEditorKit());
        this.myDescriptionPanel.addHyperlinkListener(new PluginManagerMain.MyHyperlinkListener());
        this.removeAll();
        OnePixelSplitter splitter = new OnePixelSplitter(false);
        splitter.setFirstComponent((JComponent)DetectedPluginsPanel.wrapWithPane(entryTable, 1, 0));
        splitter.setSecondComponent((JComponent)DetectedPluginsPanel.wrapWithPane(this.myDescriptionPanel, 0, 1));
        this.add((Component)splitter, "Center");
    }

    @NotNull
    private static JScrollPane wrapWithPane(@NotNull JComponent c, int left, int right) {
        if (c == null) {
            DetectedPluginsPanel.$$$reportNull$$$0(0);
        }
        JScrollPane pane2 = ScrollPaneFactory.createScrollPane((Component)c);
        pane2.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)1, (int)left, (int)1, (int)right));
        JScrollPane jScrollPane = pane2;
        if (jScrollPane == null) {
            DetectedPluginsPanel.$$$reportNull$$$0(1);
        }
        return jScrollPane;
    }

    public void addAll(@NotNull Collection<? extends PluginDownloader> orderEntries) {
        if (orderEntries == null) {
            DetectedPluginsPanel.$$$reportNull$$$0(2);
        }
        super.addAll(orderEntries);
        TableUtil.ensureSelectionExists((JTable)this.getEntryTable());
    }

    public boolean isChecked(@NotNull PluginDownloader downloader) {
        if (downloader == null) {
            DetectedPluginsPanel.$$$reportNull$$$0(3);
        }
        return !this.mySkippedPlugins.contains(downloader.getId());
    }

    public void setChecked(@NotNull PluginDownloader downloader, boolean checked) {
        if (downloader == null) {
            DetectedPluginsPanel.$$$reportNull$$$0(4);
        }
        PluginId pluginId = downloader.getId();
        if (checked) {
            this.mySkippedPlugins.remove(pluginId);
        } else {
            this.mySkippedPlugins.add(pluginId);
        }
    }

    @NotNull
    @Nls
    private static String pluginInfoUpdate(@NotNull IdeaPluginDescriptor descriptor2) {
        String changeNotes;
        if (descriptor2 == null) {
            DetectedPluginsPanel.$$$reportNull$$$0(5);
        }
        StringBuilder builder2 = new StringBuilder(DetectedPluginsPanel.getTextPrefix());
        String description2 = descriptor2.getDescription();
        if (!Strings.isEmptyOrSpaces((CharSequence)description2)) {
            builder2.append(description2);
        }
        if (!Strings.isEmptyOrSpaces((CharSequence)(changeNotes = descriptor2.getChangeNotes()))) {
            builder2.append("<h4>Change Notes</h4>").append(changeNotes);
        }
        if (!descriptor2.isBundled()) {
            boolean isVendorUrlDefined;
            String vendor = descriptor2.getVendor();
            boolean isVendorDefined = !Strings.isEmptyOrSpaces((CharSequence)vendor);
            String vendorEmail = descriptor2.getVendorEmail();
            boolean isVendorEmailDefined = !Strings.isEmptyOrSpaces((CharSequence)vendorEmail);
            String vendorUrl = descriptor2.getVendorUrl();
            boolean bl = isVendorUrlDefined = !Strings.isEmptyOrSpaces((CharSequence)vendorUrl);
            if (isVendorDefined || isVendorEmailDefined || isVendorUrlDefined) {
                builder2.append("<h4>Vendor</h4>");
                if (isVendorDefined) {
                    builder2.append(vendor);
                }
                if (isVendorUrlDefined) {
                    DetectedPluginsPanel.appendLink(builder2, "<br>", vendorUrl, vendorUrl);
                }
                if (isVendorEmailDefined) {
                    DetectedPluginsPanel.appendLink(builder2, "<br>", "mailto:" + vendorUrl, vendorEmail);
                }
            }
            String pluginDescriptorUrl = descriptor2.getUrl();
            PluginInfoProvider provider2 = PluginInfoProvider.getInstance();
            Set marketplacePlugins = provider2.loadCachedPlugins();
            if (marketplacePlugins == null || marketplacePlugins.contains(descriptor2.getPluginId())) {
                if (!Strings.isEmptyOrSpaces((CharSequence)pluginDescriptorUrl)) {
                    DetectedPluginsPanel.appendLink(builder2, "<h4>Plugin homepage</h4>", pluginDescriptorUrl, pluginDescriptorUrl);
                }
                if (marketplacePlugins == null) {
                    provider2.loadPlugins();
                }
            }
            if (descriptor2 instanceof PluginNode) {
                String size2 = StringUtil.defaultIfEmpty((String)((PluginNode)descriptor2).getPresentableSize(), (String)IdeBundle.message((String)"plugin.info.unknown", (Object[])new Object[0]));
                builder2.append("<h4>Size</h4>").append(size2);
            }
        }
        String result2 = builder2.append("</body></html>").toString();
        String string = result2.trim();
        if (string == null) {
            DetectedPluginsPanel.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private static String getTextPrefix() {
        int fontSize = JBUIScale.scale((int)12);
        int m1 = JBUIScale.scale((int)2);
        int m2 = JBUIScale.scale((int)5);
        String string = String.format("<html><head>    <style type=\"text/css\">        p {            font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx        }    </style></head><body style=\"font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx;\">", fontSize, m1, m1, fontSize, m2, m2);
        if (string == null) {
            DetectedPluginsPanel.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static void appendLink(@NotNull StringBuilder builder2, @NotNull @NonNls String htmlPrefix, @NotNull @NonNls String url, @NotNull @NonNls String text2) {
        if (builder2 == null) {
            DetectedPluginsPanel.$$$reportNull$$$0(8);
        }
        if (htmlPrefix == null) {
            DetectedPluginsPanel.$$$reportNull$$$0(9);
        }
        if (url == null) {
            DetectedPluginsPanel.$$$reportNull$$$0(10);
        }
        if (text2 == null) {
            DetectedPluginsPanel.$$$reportNull$$$0(11);
        }
        builder2.append(htmlPrefix).append("<a href=\"").append(url).append("\">").append(text2).append("</a>");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/DetectedPluginsPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntries";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlPrefix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/DetectedPluginsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithPane";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "pluginInfoUpdate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithPane";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isChecked";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setChecked";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "pluginInfoUpdate";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendLink";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

