/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.DiffPreviewUpdateProcessor;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.UnversionedDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.PresentableChange;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeViewDiffRequestProcessor
extends CacheDiffRequestProcessor.Simple
implements DiffPreviewUpdateProcessor {
    private static final int MANY_CHANGES_THRESHOLD = 10000;
    @Nullable
    private Wrapper myCurrentChange;

    public ChangeViewDiffRequestProcessor(@NotNull Project project, @NotNull String place) {
        if (project == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(0);
        }
        if (place == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(1);
        }
        super(project, place);
    }

    @NotNull
    public abstract Stream<Wrapper> getSelectedChanges();

    @NotNull
    public abstract Stream<Wrapper> getAllChanges();

    protected abstract void selectChange(@NotNull Wrapper var1);

    @Override
    protected DiffRequestProducer getCurrentRequestProvider() {
        return this.myCurrentChange != null ? this.myCurrentChange.createProducer(this.getProject()) : null;
    }

    @Override
    @Nullable
    protected DiffRequest loadRequestFast(@NotNull DiffRequestProducer provider2) {
        DiffRequest request;
        if (provider2 == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(2);
        }
        return ChangeViewDiffRequestProcessor.isRequestValid(request = super.loadRequestFast(provider2)) ? request : null;
    }

    private static boolean isRequestValid(@Nullable DiffRequest request) {
        if (request instanceof ContentDiffRequest) {
            for (DiffContent content2 : ((ContentDiffRequest)request).getContents()) {
                if (!(content2 instanceof FileContent) || ((FileContent)content2).getFile().isValid()) continue;
                return false;
            }
        }
        return true;
    }

    public void updatePreview(boolean state, boolean fromModelRefresh) {
        if (state) {
            this.refresh(fromModelRefresh);
        } else {
            this.clear();
        }
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = super.getProject();
        if (project == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(3);
        }
        return project;
    }

    @Override
    public boolean isWindowFocused() {
        return DiffUtil.isFocusedComponent(this.getProject(), this.getComponent());
    }

    @Override
    @RequiresEdt
    public void clear() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myCurrentChange != null) {
            this.myCurrentChange = null;
            this.updateRequest();
        }
        this.dropCaches();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresEdt
    public void refresh(boolean bl) {
        void fromModelRefresh;
        Wrapper selectedChange;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        List selectedChanges = this.getSelectedChanges().collect(Collectors.toList());
        Wrapper wrapper2 = selectedChange = this.myCurrentChange != null ? (Wrapper)ContainerUtil.find(selectedChanges, (Object)this.myCurrentChange) : null;
        if (fromModelRefresh != false && selectedChange == null && this.myCurrentChange != null && this.getContext().isWindowFocused() && this.getContext().isFocusedInWindow()) {
            if (selectedChanges.size() == 1 && this.getAllChanges().anyMatch(it -> this.myCurrentChange.equals(it))) {
                this.selectChange(this.myCurrentChange);
            }
            return;
        }
        if (selectedChanges.isEmpty()) {
            this.setCurrentChange(null);
            return;
        }
        if (selectedChange == null) {
            this.setCurrentChange((Wrapper)selectedChanges.get(0));
            return;
        }
        this.setCurrentChange(selectedChange);
    }

    @Nullable
    @RequiresEdt
    public String getCurrentChangeName() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myCurrentChange == null) {
            return null;
        }
        return this.myCurrentChange.getPresentableName();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setCurrentChange(@Nullable Wrapper wrapper2) {
        void change;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myCurrentChange = change;
        this.updateRequest();
    }

    @Nullable
    public Wrapper getCurrentChange() {
        return this.myCurrentChange;
    }

    @Deprecated
    protected void selectFilePath(@NotNull FilePath filePath) {
        Wrapper changeToSelect;
        if (filePath == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(4);
        }
        if ((changeToSelect = (Wrapper)ContainerUtil.find(this.getAllChanges().iterator(), change -> change.getFilePath().equals(filePath))) != null) {
            this.myCurrentChange = changeToSelect;
            this.selectChange(changeToSelect);
        }
    }

    @Override
    protected boolean hasNextChange(boolean fromUpdate) {
        PrevNextDifferenceIterable strategy = this.getSelectionStrategy(fromUpdate);
        return strategy != null && strategy.canGoNext();
    }

    @Override
    protected boolean hasPrevChange(boolean fromUpdate) {
        PrevNextDifferenceIterable strategy = this.getSelectionStrategy(fromUpdate);
        return strategy != null && strategy.canGoPrev();
    }

    @Override
    protected void goToNextChange(boolean fromDifferences) {
        Objects.requireNonNull(this.getSelectionStrategy(false)).goNext();
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE : null);
    }

    @Override
    protected void goToPrevChange(boolean fromDifferences) {
        Objects.requireNonNull(this.getSelectionStrategy(false)).goPrev();
        this.updateRequest(false, fromDifferences ? DiffUserDataKeysEx.ScrollToPolicy.LAST_CHANGE : null);
    }

    @Override
    protected boolean isNavigationEnabled() {
        return true;
    }

    @Nullable
    private PrevNextDifferenceIterable getSelectionStrategy(boolean fromUpdate) {
        if (this.myCurrentChange == null) {
            return null;
        }
        List<Wrapper> selectedChanges = ChangeViewDiffRequestProcessor.toListIfNotMany(this.getSelectedChanges(), fromUpdate);
        if (selectedChanges == null) {
            return DumbPrevNextDifferenceIterable.INSTANCE;
        }
        if (selectedChanges.isEmpty()) {
            return null;
        }
        if (selectedChanges.size() == 1) {
            List<Wrapper> allChanges = ChangeViewDiffRequestProcessor.toListIfNotMany(this.getAllChanges(), fromUpdate);
            if (allChanges == null) {
                return DumbPrevNextDifferenceIterable.INSTANCE;
            }
            return new ChangesNavigatable(allChanges, selectedChanges.get(0), true);
        }
        return new ChangesNavigatable(selectedChanges, selectedChanges.get(0), false);
    }

    @Nullable
    private static <T> List<T> toListIfNotMany(@NotNull Stream<T> stream, boolean fromUpdate) {
        if (stream == null) {
            ChangeViewDiffRequestProcessor.$$$reportNull$$$0(5);
        }
        if (!fromUpdate) {
            return stream.collect(Collectors.toList());
        }
        List result2 = stream.limit(10001L).collect(Collectors.toList());
        if (result2.size() > 10000) {
            return null;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadRequestFast";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectFilePath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toListIfNotMany";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ErrorChangeRequestProducer
    implements DiffRequestProducer {
        @NotNull
        private final Change myChange;
        @NotNull
        private final DiffRequest myRequest;

        ErrorChangeRequestProducer(@NotNull Change change, @NotNull DiffRequest request) {
            if (change == null) {
                ErrorChangeRequestProducer.$$$reportNull$$$0(0);
            }
            if (request == null) {
                ErrorChangeRequestProducer.$$$reportNull$$$0(1);
            }
            this.myChange = change;
            this.myRequest = request;
        }

        @NotNull
        public String getName() {
            String string = ChangeDiffRequestProducer.getRequestTitle(this.myChange);
            if (string == null) {
                ErrorChangeRequestProducer.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator2) throws ProcessCanceledException {
            if (context2 == null) {
                ErrorChangeRequestProducer.$$$reportNull$$$0(3);
            }
            if (indicator2 == null) {
                ErrorChangeRequestProducer.$$$reportNull$$$0(4);
            }
            DiffRequest diffRequest = this.myRequest;
            if (diffRequest == null) {
                ErrorChangeRequestProducer.$$$reportNull$$$0(5);
            }
            return diffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$ErrorChangeRequestProducer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$ErrorChangeRequestProducer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class UnversionedFileWrapper
    extends Wrapper {
        @NotNull
        protected final FilePath path;

        public UnversionedFileWrapper(@NotNull FilePath path2) {
            if (path2 == null) {
                UnversionedFileWrapper.$$$reportNull$$$0(0);
            }
            this.path = path2;
        }

        @Override
        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.path;
            if (filePath == null) {
                UnversionedFileWrapper.$$$reportNull$$$0(1);
            }
            return filePath;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            FileStatus fileStatus = FileStatus.UNKNOWN;
            if (fileStatus == null) {
                UnversionedFileWrapper.$$$reportNull$$$0(2);
            }
            return fileStatus;
        }

        @Override
        @Nullable
        public ChangesBrowserNode.Tag getTag() {
            return ChangesBrowserNode.UNVERSIONED_FILES_TAG;
        }

        @Override
        @NotNull
        public Object getUserObject() {
            FilePath filePath = this.path;
            if (filePath == null) {
                UnversionedFileWrapper.$$$reportNull$$$0(3);
            }
            return filePath;
        }

        @Override
        @Nullable
        public String getPresentableName() {
            return this.path.getName();
        }

        @Override
        @Nullable
        public DiffRequestProducer createProducer(@Nullable Project project) {
            return UnversionedDiffRequestProducer.create(project, this.path);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$UnversionedFileWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$UnversionedFileWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileStatus";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUserObject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class ChangeWrapper
    extends Wrapper {
        @NotNull
        protected final Change change;

        public ChangeWrapper(@NotNull Change change) {
            if (change == null) {
                ChangeWrapper.$$$reportNull$$$0(0);
            }
            this.change = change;
        }

        @Override
        @NotNull
        public Object getUserObject() {
            Change change = this.change;
            if (change == null) {
                ChangeWrapper.$$$reportNull$$$0(1);
            }
            return change;
        }

        @Override
        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = ChangesUtil.getFilePath((Change)this.change);
            if (filePath == null) {
                ChangeWrapper.$$$reportNull$$$0(2);
            }
            return filePath;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            FileStatus fileStatus = this.change.getFileStatus();
            if (fileStatus == null) {
                ChangeWrapper.$$$reportNull$$$0(3);
            }
            return fileStatus;
        }

        @Override
        @Nullable
        public String getPresentableName() {
            return this.getFilePath().getName();
        }

        @Override
        @Nullable
        public DiffRequestProducer createProducer(@Nullable Project project) {
            if (this.change.getBeforeRevision() instanceof FakeRevision || this.change.getAfterRevision() instanceof FakeRevision) {
                LoadingDiffRequest request = new LoadingDiffRequest(ChangeDiffRequestProducer.getRequestTitle(this.change));
                return new ErrorChangeRequestProducer(this.change, (DiffRequest)request);
            }
            ChangeDiffRequestProducer producer = ChangeDiffRequestProducer.create(project, this.change);
            if (producer == null) {
                ErrorDiffRequest request = new ErrorDiffRequest(DiffBundle.message((String)"error.cant.show.diff.message", (Object[])new Object[0]));
                return new ErrorChangeRequestProducer(this.change, (DiffRequest)request);
            }
            return producer;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            ChangeWrapper wrapper2 = (ChangeWrapper)o;
            return ChangeListChange.HASHING_STRATEGY.equals((Object)wrapper2.change, (Object)this.change);
        }

        @Override
        public int hashCode() {
            return this.change.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$ChangeWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$ChangeWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUserObject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class Wrapper
    implements PresentableChange {
        @NotNull
        public abstract Object getUserObject();

        @Nullable
        public abstract String getPresentableName();

        @Nullable
        public abstract DiffRequestProducer createProducer(@Nullable Project var1);

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            Wrapper wrapper2 = (Wrapper)o;
            return Comparing.equal((Object)this.getUserObject(), (Object)wrapper2.getUserObject());
        }

        public int hashCode() {
            return this.getUserObject().hashCode();
        }
    }

    private static class DumbPrevNextDifferenceIterable
    implements PrevNextDifferenceIterable {
        public static final DumbPrevNextDifferenceIterable INSTANCE = new DumbPrevNextDifferenceIterable();

        private DumbPrevNextDifferenceIterable() {
        }

        @Override
        public boolean canGoPrev() {
            return true;
        }

        @Override
        public boolean canGoNext() {
            return true;
        }

        @Override
        public void goPrev() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void goNext() {
            throw new UnsupportedOperationException();
        }
    }

    private class ChangesNavigatable
    implements PrevNextDifferenceIterable {
        @NotNull
        private final List<? extends Wrapper> myChanges;
        @NotNull
        private final Wrapper myFallback;
        private final boolean myUpdateSelection;

        ChangesNavigatable(@NotNull List<? extends Wrapper> allChanges, Wrapper fallback, boolean updateSelection) {
            if (allChanges == null) {
                ChangesNavigatable.$$$reportNull$$$0(0);
            }
            if (fallback == null) {
                ChangesNavigatable.$$$reportNull$$$0(1);
            }
            this.myChanges = allChanges;
            this.myFallback = fallback;
            this.myUpdateSelection = updateSelection;
        }

        @Override
        public boolean canGoNext() {
            if (ChangeViewDiffRequestProcessor.this.myCurrentChange == null) {
                return false;
            }
            int index2 = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            return index2 == -1 || index2 < this.myChanges.size() - 1;
        }

        @Override
        public boolean canGoPrev() {
            if (ChangeViewDiffRequestProcessor.this.myCurrentChange == null) {
                return false;
            }
            int index2 = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            return index2 == -1 || index2 > 0;
        }

        @Override
        public void goNext() {
            int index2 = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            if (index2 != -1) {
                this.select(this.myChanges.get(index2 + 1));
            } else {
                this.select(this.myFallback);
            }
        }

        @Override
        public void goPrev() {
            int index2 = this.myChanges.indexOf(ChangeViewDiffRequestProcessor.this.myCurrentChange);
            if (index2 != -1) {
                this.select(this.myChanges.get(index2 - 1));
            } else {
                this.select(this.myFallback);
            }
        }

        private void select(@NotNull Wrapper change) {
            if (change == null) {
                ChangesNavigatable.$$$reportNull$$$0(2);
            }
            ChangeViewDiffRequestProcessor.this.myCurrentChange = change;
            if (this.myUpdateSelection) {
                ChangeViewDiffRequestProcessor.this.selectChange(change);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allChanges";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fallback";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$ChangesNavigatable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "select";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

