/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.CommitDialogChangesBrowser;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IconUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.collections.CollectionsKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScheduleForAdditionAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(0);
        }
        boolean enabled = this.isEnabled(e);
        e.getPresentation().setEnabled(enabled);
        if ("ActionPlace.VcsQuickListPopupAction".equals(e.getPlace()) || "ChangesViewPopup".equals(e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        }
        if (e.isFromActionToolbar() && e.getPresentation().getIcon() == null) {
            e.getPresentation().setIcon(IconUtil.getAddIcon());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        List unversionedFiles = ScheduleForAdditionAction.getUnversionedFiles(e, project).collect(Collectors.toList());
        ScheduleForAdditionAction.addUnversioned(project, unversionedFiles, (ChangesBrowserBase)e.getData(ChangesBrowserBase.DATA_KEY));
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(2);
        }
        return e.getProject() != null && !UtilKt.isEmpty(ScheduleForAdditionAction.getUnversionedFiles(e, e.getProject()));
    }

    public static boolean addUnversioned(@NotNull Project project, @NotNull List<? extends VirtualFile> files2, @Nullable ChangesBrowserBase browser2) {
        if (project == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(3);
        }
        if (files2 == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(4);
        }
        return ScheduleForAdditionAction.addUnversioned(project, files2, browser2, null);
    }

    protected static boolean addUnversioned(@NotNull Project project, @NotNull List<? extends VirtualFile> files2, @Nullable ChangesBrowserBase browser2, @Nullable PairConsumer<? super ProgressIndicator, ? super List<VcsException>> additionalTask) {
        if (project == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(5);
        }
        if (files2 == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(6);
        }
        if (files2.isEmpty() && additionalTask == null) {
            return true;
        }
        LocalChangeList targetChangeList = browser2 instanceof CommitDialogChangesBrowser ? ((CommitDialogChangesBrowser)browser2).getSelectedChangeList() : ChangeListManager.getInstance((Project)project).getDefaultChangeList();
        Consumer changeConsumer = browser2 != null ? changes -> browser2.getViewer().includeChanges((Collection<?>)changes) : null;
        FileDocumentManager.getInstance().saveAllDocuments();
        return ScheduleForAdditionAction.addUnversionedFilesToVcs(project, targetChangeList, files2, (Consumer<? super List<Change>>)changeConsumer, additionalTask);
    }

    @NotNull
    public static Stream<VirtualFile> getUnversionedFiles(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(7);
        }
        if (project == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(8);
        }
        return ScheduleForAdditionAction.getUnversionedFiles(e.getDataContext(), project);
    }

    @NotNull
    public static Stream<VirtualFile> getUnversionedFiles(@NotNull DataContext context2, @NotNull Project project) {
        JBIterable filePaths;
        if (context2 == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(9);
        }
        if (project == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(10);
        }
        if ((filePaths = JBIterable.from(context2.getData(ChangesListView.UNVERSIONED_FILE_PATHS_DATA_KEY))).isNotEmpty()) {
            StreamEx streamEx = StreamEx.of((Iterator)filePaths.map(FilePath::getVirtualFile).filter(Objects::nonNull).iterator());
            if (streamEx == null) {
                ScheduleForAdditionAction.$$$reportNull$$$0(11);
            }
            return streamEx;
        }
        if (!ArrayUtil.isEmpty((Object[])((Change[])context2.getData(VcsDataKeys.CHANGES)))) {
            Stream<VirtualFile> stream = Stream.empty();
            if (stream == null) {
                ScheduleForAdditionAction.$$$reportNull$$$0(12);
            }
            return stream;
        }
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        StreamEx streamEx = StreamEx.of((Iterator)JBIterable.from((Iterable)((Iterable)context2.getData(VcsDataKeys.VIRTUAL_FILES))).filter(file2 -> ScheduleForAdditionAction.isFileUnversioned(file2, vcsManager2, changeListManager)).iterator());
        if (streamEx == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(13);
        }
        return streamEx;
    }

    private static boolean isFileUnversioned(@NotNull VirtualFile file2, @NotNull ProjectLevelVcsManager vcsManager2, @NotNull ChangeListManager changeListManager) {
        AbstractVcs vcs;
        if (file2 == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(14);
        }
        if (vcsManager2 == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(15);
        }
        if (changeListManager == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(16);
        }
        return (vcs = vcsManager2.getVcsFor(file2)) != null && !vcs.areDirectoriesVersionedItems() && file2.isDirectory() && changeListManager.getStatus(file2) != FileStatus.IGNORED || changeListManager.getStatus(file2) == FileStatus.UNKNOWN;
    }

    public static boolean addUnversionedFilesToVcs(@NotNull Project project, @Nullable LocalChangeList list2, @NotNull List<? extends VirtualFile> files2) {
        if (project == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(17);
        }
        if (files2 == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(18);
        }
        return ScheduleForAdditionAction.addUnversionedFilesToVcs(project, list2, files2, null, null);
    }

    public static boolean addUnversionedFilesToVcs(final @NotNull Project project, @Nullable LocalChangeList list2, final @NotNull List<? extends VirtualFile> files2, @Nullable Consumer<? super List<Change>> changesConsumer, final @Nullable PairConsumer<? super ProgressIndicator, ? super List<VcsException>> additionalTask) {
        boolean syncUpdateRequired;
        if (project == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(19);
        }
        if (files2 == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(20);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        final ArrayList exceptions = new ArrayList();
        final HashSet allProcessedFiles = new HashSet();
        ProgressManager.getInstance().run((Task)new Task.Modal(project, VcsBundle.message((String)"progress.title.adding.files.to.vcs", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ChangesUtil.processVirtualFilesByVcs((Project)project, (Collection)files2, (vcs, files2) -> ScheduleForAdditionAction.addUnversionedFilesToVcs(project, vcs, (List<? extends VirtualFile>)files2, allProcessedFiles, exceptions));
                if (additionalTask != null) {
                    additionalTask.consume((Object)indicator2, (Object)exceptions);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction$1", "run"));
            }
        });
        if (!exceptions.isEmpty()) {
            @Nls StringBuilder message2 = new StringBuilder(VcsBundle.message((String)"error.adding.files.prompt", (Object[])new Object[0]));
            for (VcsException ex : exceptions) {
                message2.append("\n").append(ex.getMessage());
            }
            Messages.showErrorDialog((Project)project, (String)message2.toString(), (String)VcsBundle.message((String)"error.adding.files.title", (Object[])new Object[0]));
        }
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project);
        for (VirtualFile file2 : allProcessedFiles) {
            fileStatusManager.fileStatusChanged(file2);
        }
        VcsDirtyScopeManager.getInstance((Project)project).filesDirty(allProcessedFiles, null);
        boolean moveRequired = list2 != null && !list2.isDefault() && !allProcessedFiles.isEmpty() && changeListManager.areChangeListsEnabled();
        boolean bl = syncUpdateRequired = changesConsumer != null;
        if (moveRequired || syncUpdateRequired) {
            InvokeAfterUpdateMode updateMode = syncUpdateRequired ? InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE : InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE;
            changeListManager.invokeAfterUpdate(() -> {
                ArrayList newChanges = ContainerUtil.filter((Collection)changeListManager.getDefaultChangeList().getChanges(), change -> {
                    FilePath path2 = ChangesUtil.getAfterPath((Change)change);
                    return path2 != null && allProcessedFiles.contains(path2.getVirtualFile());
                });
                if (moveRequired && !newChanges.isEmpty()) {
                    changeListManager.moveChangesTo(list2, newChanges.toArray(new Change[0]));
                }
                if (changesConsumer != null) {
                    LocalChangeList newList;
                    if (moveRequired && !newChanges.isEmpty() && (newList = changeListManager.getChangeList(list2.getId())) != null) {
                        newChanges = new ArrayList(CollectionsKt.intersect((Iterable)newList.getChanges(), (Iterable)newChanges));
                    }
                    changesConsumer.consume((Object)newChanges);
                }
            }, updateMode, VcsBundle.message((String)"change.lists.manager.add.unversioned", (Object[])new Object[0]), null);
        }
        return exceptions.isEmpty();
    }

    private static void addUnversionedFilesToVcs(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull List<? extends VirtualFile> items, @NotNull Set<? super VirtualFile> allProcessedFiles, @NotNull List<? super VcsException> exceptions) {
        CheckinEnvironment environment2;
        if (project == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(21);
        }
        if (vcs == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(22);
        }
        if (items == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(23);
        }
        if (allProcessedFiles == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(24);
        }
        if (exceptions == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(25);
        }
        if ((environment2 = vcs.getCheckinEnvironment()) == null) {
            return;
        }
        Set descendants = (Set)ReadAction.compute(() -> ScheduleForAdditionAction.getUnversionedDescendantsRecursively(project, items));
        Set parents2 = (Set)ReadAction.compute(() -> ScheduleForAdditionAction.getUnversionedParents(project, vcs, items));
        List exs = environment2.scheduleUnversionedFilesForAddition(new ArrayList(descendants));
        if (exs != null) {
            exceptions.addAll(exs);
        }
        allProcessedFiles.addAll(descendants);
        allProcessedFiles.addAll(parents2);
    }

    @NotNull
    private static Set<VirtualFile> getUnversionedDescendantsRecursively(@NotNull Project project, @NotNull List<? extends VirtualFile> items) {
        if (project == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(26);
        }
        if (items == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(27);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        Processor addToResultProcessor = file2 -> {
            if (changeListManager.getStatus(file2) == FileStatus.UNKNOWN) {
                result2.add((VirtualFile)file2);
            }
            return true;
        };
        for (VirtualFile virtualFile2 : items) {
            VcsRootIterator.iterateVfUnderVcsRoot(project, virtualFile2, (Processor<? super VirtualFile>)addToResultProcessor);
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(28);
        }
        return hashSet;
    }

    @NotNull
    private static Set<VirtualFile> getUnversionedParents(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull Collection<? extends VirtualFile> items) {
        if (project == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(29);
        }
        if (vcs == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(30);
        }
        if (items == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(31);
        }
        if (!vcs.areDirectoriesVersionedItems()) {
            Set<VirtualFile> set2 = Collections.emptySet();
            if (set2 == null) {
                ScheduleForAdditionAction.$$$reportNull$$$0(32);
            }
            return set2;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        for (VirtualFile virtualFile2 : items) {
            for (VirtualFile parent = virtualFile2.getParent(); parent != null && changeListManager.getStatus(parent) == FileStatus.UNKNOWN; parent = parent.getParent()) {
                result2.add(parent);
            }
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            ScheduleForAdditionAction.$$$reportNull$$$0(33);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 28: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 28: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 17: 
            case 19: 
            case 21: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 28: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsManager";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 23: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allProcessedFiles";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedFiles";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedDescendantsRecursively";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addUnversioned";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUnversionedFiles";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 28: 
            case 32: 
            case 33: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isFileUnversioned";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addUnversionedFilesToVcs";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getUnversionedDescendantsRecursively";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getUnversionedParents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 28: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

