/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.VcsBundle;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RelativePathCalculator {
    private static final int ourNumOfAllowedStepsAbove = 1;
    private static final int ourAllowedStepsDown = 2;
    private final String myShifted;
    private final String myBase;
    private boolean myRename;

    public RelativePathCalculator(@NotNull String base, @NotNull String shifted) {
        if (base == null) {
            RelativePathCalculator.$$$reportNull$$$0(0);
        }
        if (shifted == null) {
            RelativePathCalculator.$$$reportNull$$$0(1);
        }
        this.myShifted = shifted;
        this.myBase = base;
    }

    private static boolean stringEqual(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            RelativePathCalculator.$$$reportNull$$$0(2);
        }
        if (s2 == null) {
            RelativePathCalculator.$$$reportNull$$$0(3);
        }
        if (!SystemInfo.isFileSystemCaseSensitive) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }

    @NlsSafe
    @NotNull
    public String execute() {
        int i2;
        if (RelativePathCalculator.stringEqual(this.myShifted, this.myBase)) {
            return ".";
        }
        String[] baseParts = RelativePathCalculator.split(this.myBase);
        String[] shiftedParts = RelativePathCalculator.split(this.myShifted);
        this.myRename = RelativePathCalculator.checkRename(baseParts, shiftedParts);
        int cnt = 0;
        while (true) {
            if (baseParts.length <= cnt || shiftedParts.length <= cnt) {
                --cnt;
                break;
            }
            if (!RelativePathCalculator.stringEqual(baseParts[cnt], shiftedParts[cnt])) break;
            ++cnt;
        }
        int stepsUp = baseParts.length - cnt - 1;
        if (!this.myRename && stepsUp > 1 && shiftedParts.length - cnt <= 2) {
            String string = this.myShifted;
            if (string == null) {
                RelativePathCalculator.$$$reportNull$$$0(4);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        for (i2 = 0; i2 < stepsUp; ++i2) {
            sb.append("../");
        }
        for (i2 = cnt; i2 < shiftedParts.length - 1; ++i2) {
            String shiftedPart = shiftedParts[i2];
            sb.append(shiftedPart);
            sb.append('/');
        }
        String oldName = baseParts[baseParts.length - 1];
        String newName2 = shiftedParts[shiftedParts.length - 1];
        boolean skipFileName = oldName.equals(newName2);
        if (!skipFileName) {
            sb.append(newName2);
        }
        String string = sb.toString();
        if (string == null) {
            RelativePathCalculator.$$$reportNull$$$0(5);
        }
        return string;
    }

    private boolean isRename() {
        return this.myRename;
    }

    private static boolean checkRename(String[] baseParts, String[] shiftedParts) {
        if (baseParts.length == shiftedParts.length) {
            for (int i2 = 0; i2 < baseParts.length; ++i2) {
                if (RelativePathCalculator.stringEqual(baseParts[i2], shiftedParts[i2])) continue;
                return i2 == baseParts.length - 1;
            }
        }
        return false;
    }

    @NlsContexts.Label
    @Nullable
    public static String getMovedString(String beforeName, String afterName) {
        if (beforeName != null && afterName != null && !RelativePathCalculator.stringEqual(beforeName, afterName)) {
            RelativePathCalculator calculator = new RelativePathCalculator(beforeName, afterName);
            String result2 = calculator.execute();
            return calculator.isRename() ? VcsBundle.message((String)"change.file.renamed.to.text", (Object[])new Object[]{result2}) : VcsBundle.message((String)"change.file.moved.to.text", (Object[])new Object[]{result2});
        }
        return null;
    }

    public static String[] split(@NotNull String s) {
        if (s == null) {
            RelativePathCalculator.$$$reportNull$$$0(6);
        }
        return s.replace(File.separatorChar, '/').split("/");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shifted";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/RelativePathCalculator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/RelativePathCalculator";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "stringEqual";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

