/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.CommonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CleanUnshelvedFilterDialog
extends DialogWrapper {
    private final JRadioButton myUnshelvedWithFilterButton;
    private final JRadioButton myAllUnshelvedButton;
    private final ComboBox<TimePeriod> myTimePeriodComboBox;

    public CleanUnshelvedFilterDialog(@Nullable Project project) {
        super(project);
        this.setTitle(VcsBundle.message((String)"shelve.clean.unshelved.changelists.title", (Object[])new Object[0]));
        this.myUnshelvedWithFilterButton = new JRadioButton(VcsBundle.message((String)"shelve.clean.changelists.older.than.one.button", (Object[])new Object[0]), true);
        this.myAllUnshelvedButton = new JRadioButton(VcsBundle.message((String)"shelve.clean.changelists.all.button", (Object[])new Object[0]), false);
        this.myTimePeriodComboBox = new ComboBox((ComboBoxModel)new EnumComboBoxModel(TimePeriod.class));
        this.myTimePeriodComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", value2 -> {
            switch (value2) {
                case Week: {
                    return VcsBundle.message((String)"shelve.clean.timeperiod.week", (Object[])new Object[0]);
                }
                case Month: {
                    return VcsBundle.message((String)"shelve.clean.timeperiod.month", (Object[])new Object[0]);
                }
                case Year: {
                    return VcsBundle.message((String)"shelve.clean.timeperiod.year", (Object[])new Object[0]);
                }
            }
            throw new IllegalArgumentException(value2.name());
        }));
        this.myTimePeriodComboBox.setEnabled(this.myUnshelvedWithFilterButton.isSelected());
        this.myUnshelvedWithFilterButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CleanUnshelvedFilterDialog.this.myTimePeriodComboBox.setEnabled(CleanUnshelvedFilterDialog.this.myUnshelvedWithFilterButton.isSelected());
            }
        });
        this.setOKButtonText(CommonBundle.message((String)"button.delete", (Object[])new Object[0]));
        this.init();
        this.setResizable(false);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        JLabel questLabel = new JLabel(VcsBundle.message((String)"shelve.delete.already.unshelved.label", (Object[])new Object[0]));
        String panelConstraints = "flowx, ins 0";
        MigLayout migLayout = new MigLayout(panelConstraints);
        JPanel buttonsPanel = new JPanel((LayoutManager)migLayout);
        ButtonGroup gr = new ButtonGroup();
        gr.add(this.myUnshelvedWithFilterButton);
        gr.add(this.myAllUnshelvedButton);
        this.myUnshelvedWithFilterButton.setBorder(BorderFactory.createEmptyBorder());
        this.myAllUnshelvedButton.setBorder(BorderFactory.createEmptyBorder());
        JPanel filterPanel = new JPanel((LayoutManager)new MigLayout(panelConstraints));
        filterPanel.add(this.myUnshelvedWithFilterButton);
        filterPanel.add((Component)this.myTimePeriodComboBox);
        buttonsPanel.add((Component)filterPanel, "wrap");
        buttonsPanel.add(this.myAllUnshelvedButton);
        panel2.add((Component)questLabel, "North");
        panel2.add((Component)buttonsPanel, "Center");
        return panel2;
    }

    public boolean isAllUnshelvedSelected() {
        return this.myAllUnshelvedButton.isSelected();
    }

    public boolean isUnshelvedWithFilterSelected() {
        return this.myUnshelvedWithFilterButton.isSelected();
    }

    public long getTimeLimitInMillis() {
        return ((TimePeriod)((Object)this.myTimePeriodComboBox.getSelectedItem())).getTimeLimitInMillis();
    }

    private static enum TimePeriod {
        Week{

            @Override
            protected void updateCalendar(@NotNull Calendar cal) {
                if (cal == null) {
                    1.$$$reportNull$$$0(0);
                }
                cal.add(5, -7);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cal", "com/intellij/openapi/vcs/changes/shelf/CleanUnshelvedFilterDialog$TimePeriod$1", "updateCalendar"));
            }
        }
        ,
        Month{

            @Override
            protected void updateCalendar(@NotNull Calendar cal) {
                if (cal == null) {
                    2.$$$reportNull$$$0(0);
                }
                cal.add(2, -1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cal", "com/intellij/openapi/vcs/changes/shelf/CleanUnshelvedFilterDialog$TimePeriod$2", "updateCalendar"));
            }
        }
        ,
        Year{

            @Override
            protected void updateCalendar(@NotNull Calendar cal) {
                if (cal == null) {
                    3.$$$reportNull$$$0(0);
                }
                cal.add(1, -1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cal", "com/intellij/openapi/vcs/changes/shelf/CleanUnshelvedFilterDialog$TimePeriod$3", "updateCalendar"));
            }
        };


        public long getTimeLimitInMillis() {
            Calendar cal = Calendar.getInstance();
            this.updateCalendar(cal);
            return cal.getTimeInMillis();
        }

        protected abstract void updateCalendar(@NotNull Calendar var1);
    }
}

