/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.requests.UnknownFileTypeDiffRequest;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.SoftHardCacheMap;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.PatchDiffRequestFactory;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequest;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedWrapper;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiffShelvedChangesActionProvider
implements AnActionExtensionProvider {
    private static final Logger LOG = Logger.getInstance(DiffShelvedChangesActionProvider.class);

    @Override
    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(0);
        }
        return e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY) != null || e.getData(ShelvedChangesViewManager.SHELVED_RECYCLED_CHANGELIST_KEY) != null;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(1);
        }
        DiffShelvedChangesActionProvider.updateAvailability(e);
    }

    public static void updateAvailability(@NotNull AnActionEvent e) {
        if (e == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabled(DiffShelvedChangesActionProvider.isEnabled(e.getDataContext()));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(3);
        }
        DiffShelvedChangesActionProvider.showShelvedChangesDiff(e.getDataContext());
    }

    public static boolean isEnabled(DataContext dc) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project == null) {
            return false;
        }
        List<ShelvedChangeList> changeLists = ShelvedChangesViewManager.getShelvedLists(dc);
        return changeLists.size() == 1;
    }

    public static void showShelvedChangesDiff(DataContext dc) {
        DiffShelvedChangesActionProvider.showShelvedChangesDiff(dc, false);
    }

    @Nullable
    public static ListSelection<? extends ChangeDiffRequestChain.Producer> createDiffProducers(@NotNull DataContext dc, boolean withLocal) {
        Project project;
        if (dc == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(4);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dc)) == null) {
            return null;
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return null;
        }
        String base = project.getBasePath();
        if (base == null) {
            LOG.error("No base path for project " + project);
            return null;
        }
        ListSelection<ShelvedWrapper> wrappers = ShelvedChangesViewManager.getSelectedChangesOrAll(dc);
        ApplyPatchContext patchContext = new ApplyPatchContext(project.getBaseDir(), 0, false, false);
        PatchesPreloader preloader = new PatchesPreloader(project);
        return wrappers.map(s -> {
            ShelvedChange textChange = s.getShelvedChange();
            if (textChange != null) {
                return DiffShelvedChangesActionProvider.processTextChange(project, base, patchContext, preloader, textChange, withLocal);
            }
            ShelvedBinaryFile binaryChange = s.getBinaryFile();
            if (binaryChange != null) {
                return DiffShelvedChangesActionProvider.processBinaryChange(project, base, binaryChange);
            }
            return null;
        });
    }

    public static void showShelvedChangesDiff(@NotNull DataContext dc, boolean withLocal) {
        Project project;
        if (dc == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(5);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dc)) == null) {
            return;
        }
        ListSelection<? extends ChangeDiffRequestChain.Producer> diffRequestProducers = DiffShelvedChangesActionProvider.createDiffProducers(dc, withLocal);
        if (diffRequestProducers == null || diffRequestProducers.isEmpty()) {
            return;
        }
        ChangeDiffRequestChain chain = new ChangeDiffRequestChain(diffRequestProducers.getList(), diffRequestProducers.getSelectedIndex());
        DiffManager.getInstance().showDiff(project, (DiffRequestChain)chain, DiffDialogHints.FRAME);
    }

    private static ShelveDiffRequestProducer processBinaryChange(@NotNull Project project, @NotNull String base, @NotNull ShelvedBinaryFile shelvedChange) {
        if (project == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(6);
        }
        if (base == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(7);
        }
        if (shelvedChange == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(8);
        }
        File file2 = new File(base, shelvedChange.AFTER_PATH == null ? shelvedChange.BEFORE_PATH : shelvedChange.AFTER_PATH);
        FilePath filePath = VcsUtil.getFilePath((File)file2);
        return new BinaryShelveDiffRequestProducer(project, shelvedChange, filePath);
    }

    private static ShelveDiffRequestProducer processTextChange(@NotNull Project project, @NotNull String base, @NotNull ApplyPatchContext patchContext, @NotNull PatchesPreloader preloader, @NotNull ShelvedChange shelvedChange, boolean withLocal) {
        if (project == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(9);
        }
        if (base == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(10);
        }
        if (patchContext == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(11);
        }
        if (preloader == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(12);
        }
        if (shelvedChange == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(13);
        }
        String beforePath = shelvedChange.getBeforePath();
        String afterPath = shelvedChange.getAfterPath();
        FilePath filePath = VcsUtil.getFilePath((File)new File(base, afterPath == null ? beforePath : afterPath));
        try {
            if (FileStatus.ADDED.equals(shelvedChange.getFileStatus())) {
                return new NewFileTextShelveDiffRequestProducer(project, shelvedChange, filePath, preloader, withLocal);
            }
            VirtualFile file2 = ApplyFilePatchBase.findPatchTarget(patchContext, beforePath, afterPath);
            if (file2 == null || !file2.exists()) {
                throw new FileNotFoundException(beforePath);
            }
            return new TextShelveDiffRequestProducer(project, shelvedChange, filePath, file2, patchContext, preloader, withLocal);
        }
        catch (IOException e) {
            return new PatchShelveDiffRequestProducer(project, shelvedChange, filePath, preloader);
        }
    }

    @NotNull
    static AppliedTextPatch createAppliedTextPatch(@NotNull TextFilePatch patch2) {
        if (patch2 == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(14);
        }
        GenericPatchApplier applier = new GenericPatchApplier("", patch2.getHunks());
        applier.execute();
        AppliedTextPatch appliedTextPatch = AppliedTextPatch.create(applier.getAppliedInfo());
        if (appliedTextPatch == null) {
            DiffShelvedChangesActionProvider.$$$reportNull$$$0(15);
        }
        return appliedTextPatch;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dc";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChange";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchContext";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preloader";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createAppliedTextPatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateAvailability";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDiffProducers";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showShelvedChangesDiff";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processBinaryChange";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processTextChange";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createAppliedTextPatch";
                break;
            }
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class BaseTextShelveDiffRequestProducer
    extends ShelveDiffRequestProducer {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final ShelvedChange myChange;

        BaseTextShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath) {
            if (project == null) {
                BaseTextShelveDiffRequestProducer.$$$reportNull$$$0(0);
            }
            if (change == null) {
                BaseTextShelveDiffRequestProducer.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                BaseTextShelveDiffRequestProducer.$$$reportNull$$$0(2);
            }
            super(filePath);
            this.myChange = change;
            this.myProject = project;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            FileStatus fileStatus = this.myChange.getFileStatus();
            if (fileStatus == null) {
                BaseTextShelveDiffRequestProducer.$$$reportNull$$$0(3);
            }
            return fileStatus;
        }

        @Override
        @NotNull
        public ShelvedChange getTextChange() {
            ShelvedChange shelvedChange = this.myChange;
            if (shelvedChange == null) {
                BaseTextShelveDiffRequestProducer.$$$reportNull$$$0(4);
            }
            return shelvedChange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$BaseTextShelveDiffRequestProducer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$BaseTextShelveDiffRequestProducer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileStatus";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TextShelveDiffRequestProducer
    extends BaseTextShelveDiffRequestProducer {
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final ApplyPatchContext myPatchContext;
        @NotNull
        private final PatchesPreloader myPreloader;
        private final boolean myWithLocal;

        TextShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath, @NotNull VirtualFile file2, @NotNull ApplyPatchContext patchContext, @NotNull PatchesPreloader preloader, boolean withLocal) {
            if (project == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(0);
            }
            if (change == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(3);
            }
            if (patchContext == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(4);
            }
            if (preloader == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(5);
            }
            super(project, change, filePath);
            this.myFile = file2;
            this.myPatchContext = patchContext;
            this.myPreloader = preloader;
            this.myWithLocal = withLocal;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator2) throws DiffRequestProducerException, ProcessCanceledException {
            DiffRequest diffRequest;
            if (context2 == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(6);
            }
            if (indicator2 == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(7);
            }
            if (FileTypeRegistry.getInstance().isFileOfType(this.myFile, UnknownFileType.INSTANCE)) {
                return new UnknownFileTypeDiffRequest(this.myFile, this.getName());
            }
            try {
                Pair<TextFilePatch, CommitContext> pair = this.myPreloader.getPatchWithContext(this.myChange);
                TextFilePatch patch2 = (TextFilePatch)pair.first;
                CommitContext commitContext = (CommitContext)pair.second;
                if (patch2.isDeletedFile()) {
                    return this.createDiffRequestForDeleted(patch2);
                }
                String path2 = (String)ObjectUtils.chooseNotNull((Object)patch2.getAfterName(), (Object)patch2.getBeforeName());
                CharSequence baseContents = ((BaseRevisionTextPatchEP)PatchEP.EP_NAME.findExtensionOrFail(BaseRevisionTextPatchEP.class)).provideContent(this.myProject, path2, commitContext);
                ApplyPatchForBaseRevisionTexts texts = ApplyPatchForBaseRevisionTexts.create(this.myProject, this.myFile, this.myPatchContext.getPathBeforeRename(this.myFile), patch2, baseContents);
                if (texts.isBaseRevisionLoaded()) {
                    assert (!texts.isAppliedSomehow());
                    return this.createDiffRequestUsingBase(texts);
                }
                diffRequest = this.createDiffRequestUsingLocal(texts, patch2, context2, indicator2);
            }
            catch (VcsException e) {
                throw new DiffRequestProducerException(VcsBundle.message((String)"changes.error.can.t.show.diff.for", (Object[])new Object[]{this.getFilePath()}), (Throwable)e);
            }
            if (diffRequest == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(8);
            }
            return diffRequest;
        }

        @NotNull
        private DiffRequest createDiffRequestForDeleted(@NotNull TextFilePatch patch2) {
            String leftTitle;
            DiffContent leftContent;
            if (patch2 == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(9);
            }
            DiffContentFactory contentFactory = DiffContentFactory.getInstance();
            if (this.myWithLocal) {
                leftContent = contentFactory.create(this.myProject, this.myFile);
                leftTitle = DiffBundle.message((String)"merge.version.title.current", (Object[])new Object[0]);
            } else {
                leftContent = contentFactory.create(this.myProject, patch2.getSingleHunkPatchText(), this.myFile);
                leftTitle = VcsBundle.message((String)"shelve.shelved.version", (Object[])new Object[0]);
            }
            EmptyContent rightContent = contentFactory.createEmpty();
            String rightTitle = null;
            return new SimpleDiffRequest(this.getName(), leftContent, (DiffContent)rightContent, leftTitle, rightTitle);
        }

        @NotNull
        private DiffRequest createDiffRequestUsingBase(@NotNull ApplyPatchForBaseRevisionTexts texts) {
            String leftTitle;
            DiffContent leftContent;
            if (texts == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(10);
            }
            DiffContentFactory contentFactory = DiffContentFactory.getInstance();
            if (this.myWithLocal) {
                leftContent = contentFactory.create(this.myProject, this.myFile);
                leftTitle = DiffBundle.message((String)"merge.version.title.current", (Object[])new Object[0]);
            } else {
                leftContent = contentFactory.create(this.myProject, Objects.requireNonNull(texts.getBase()), this.myFile);
                leftTitle = DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]);
            }
            DocumentContent rightContent = contentFactory.create(this.myProject, texts.getPatched(), this.myFile);
            return new SimpleDiffRequest(this.getName(), leftContent, (DiffContent)rightContent, leftTitle, VcsBundle.message((String)"shelve.shelved.version", (Object[])new Object[0]));
        }

        private DiffRequest createDiffRequestUsingLocal(@NotNull ApplyPatchForBaseRevisionTexts texts, @NotNull TextFilePatch patch2, @NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator2) throws DiffRequestProducerException {
            DiffRequest diffRequest;
            if (texts == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(11);
            }
            if (patch2 == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(12);
            }
            if (context2 == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(13);
            }
            if (indicator2 == null) {
                TextShelveDiffRequestProducer.$$$reportNull$$$0(14);
            }
            DiffRequest diffRequest2 = diffRequest = this.myChange.isConflictingChange() ? PatchDiffRequestFactory.createConflictDiffRequest(this.myProject, this.myFile, patch2, VcsBundle.message((String)"shelve.shelved.version", (Object[])new Object[0]), texts, this.getName()) : PatchDiffRequestFactory.createDiffRequest(this.myProject, this.myChange.getChange(), this.getName(), context2, indicator2);
            if (!this.myWithLocal) {
                DiffUtil.addNotification(DiffNotifications.createNotificationProvider(VcsBundle.message((String)"shelve.base.content.not.found.or.not.applicable.error", (Object[])new Object[0])), (UserDataHolder)diffRequest);
            }
            return diffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patchContext";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preloader";
                    break;
                }
                case 6: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 7: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$TextShelveDiffRequestProducer";
                    break;
                }
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patch";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "texts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$TextShelveDiffRequestProducer";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createDiffRequestForDeleted";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createDiffRequestUsingBase";
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "createDiffRequestUsingLocal";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NewFileTextShelveDiffRequestProducer
    extends BaseTextShelveDiffRequestProducer {
        @NotNull
        private final PatchesPreloader myPreloader;
        private final boolean myWithLocal;

        NewFileTextShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath, @NotNull PatchesPreloader preloader, boolean withLocal) {
            if (project == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(0);
            }
            if (change == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(2);
            }
            if (preloader == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(3);
            }
            super(project, change, filePath);
            this.myPreloader = preloader;
            this.myWithLocal = withLocal;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator2) throws DiffRequestProducerException, ProcessCanceledException {
            if (context2 == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(4);
            }
            if (indicator2 == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(5);
            }
            VirtualFile file2 = this.myFilePath.getVirtualFile();
            if (this.myWithLocal && file2 != null) {
                try {
                    TextFilePatch patch2 = this.myPreloader.getPatch(this.myChange);
                    DiffContentFactory contentFactory = DiffContentFactory.getInstance();
                    DiffContent leftContent = contentFactory.create(this.myProject, file2);
                    DocumentContent rightContent = contentFactory.create(this.myProject, patch2.getSingleHunkPatchText(), file2);
                    return new SimpleDiffRequest(this.getName(), leftContent, (DiffContent)rightContent, DiffBundle.message((String)"merge.version.title.current", (Object[])new Object[0]), VcsBundle.message((String)"shelve.shelved.version", (Object[])new Object[0]));
                }
                catch (VcsException e) {
                    throw new DiffRequestProducerException(VcsBundle.message((String)"changes.error.can.t.show.diff.for", (Object[])new Object[]{this.getFilePath()}), (Throwable)e);
                }
            }
            DiffRequest diffRequest = PatchDiffRequestFactory.createDiffRequest(this.myProject, this.myChange.getChange(), this.getName(), context2, indicator2);
            if (diffRequest == null) {
                NewFileTextShelveDiffRequestProducer.$$$reportNull$$$0(6);
            }
            return diffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preloader";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$NewFileTextShelveDiffRequestProducer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$NewFileTextShelveDiffRequestProducer";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PatchShelveDiffRequestProducer
    extends BaseTextShelveDiffRequestProducer {
        private final PatchesPreloader myPreloader;

        PatchShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedChange change, @NotNull FilePath filePath, @NotNull PatchesPreloader preloader) {
            if (project == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(0);
            }
            if (change == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(2);
            }
            if (preloader == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(3);
            }
            super(project, change, filePath);
            this.myPreloader = preloader;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator2) throws DiffRequestProducerException {
            PatchDiffRequest patchDiffRequest;
            if (context2 == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(4);
            }
            if (indicator2 == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(5);
            }
            try {
                TextFilePatch patch2 = this.myPreloader.getPatch(this.myChange);
                AppliedTextPatch appliedTextPatch = DiffShelvedChangesActionProvider.createAppliedTextPatch(patch2);
                PatchDiffRequest request = new PatchDiffRequest(appliedTextPatch, this.getName(), VcsBundle.message((String)"patch.apply.conflict.patch", (Object[])new Object[0]));
                DiffUtil.addNotification(DiffNotifications.createNotificationProvider(DiffBundle.message((String)"cannot.find.file.error", (Object[])new Object[]{this.getFilePath()})), (UserDataHolder)request);
                patchDiffRequest = request;
            }
            catch (VcsException e) {
                throw new DiffRequestProducerException(VcsBundle.message((String)"changes.error.can.t.show.diff.for", (Object[])new Object[]{this.getFilePath()}), (Throwable)e);
            }
            if (patchDiffRequest == null) {
                PatchShelveDiffRequestProducer.$$$reportNull$$$0(6);
            }
            return patchDiffRequest;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preloader";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchShelveDiffRequestProducer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchShelveDiffRequestProducer";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class BinaryShelveDiffRequestProducer
    extends ShelveDiffRequestProducer {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ShelvedBinaryFile myBinaryChange;

        BinaryShelveDiffRequestProducer(@NotNull Project project, @NotNull ShelvedBinaryFile change, @NotNull FilePath filePath) {
            if (project == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(0);
            }
            if (change == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(1);
            }
            if (filePath == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(2);
            }
            super(filePath);
            this.myBinaryChange = change;
            this.myProject = project;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator2) throws DiffRequestProducerException, ProcessCanceledException {
            if (context2 == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(3);
            }
            if (indicator2 == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(4);
            }
            Change change = this.myBinaryChange.createChange(this.myProject);
            DiffRequest diffRequest = PatchDiffRequestFactory.createDiffRequest(this.myProject, change, this.getName(), context2, indicator2);
            if (diffRequest == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(5);
            }
            return diffRequest;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            FileStatus fileStatus = this.myBinaryChange.getFileStatus();
            if (fileStatus == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(6);
            }
            return fileStatus;
        }

        @Override
        @NotNull
        public ShelvedBinaryFile getBinaryChange() {
            ShelvedBinaryFile shelvedBinaryFile = this.myBinaryChange;
            if (shelvedBinaryFile == null) {
                BinaryShelveDiffRequestProducer.$$$reportNull$$$0(7);
            }
            return shelvedBinaryFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$BinaryShelveDiffRequestProducer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$BinaryShelveDiffRequestProducer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileStatus";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBinaryChange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class ShelveDiffRequestProducer
    implements ChangeDiffRequestChain.Producer {
        @NotNull
        protected final FilePath myFilePath;

        ShelveDiffRequestProducer(@NotNull FilePath filePath) {
            if (filePath == null) {
                ShelveDiffRequestProducer.$$$reportNull$$$0(0);
            }
            this.myFilePath = filePath;
        }

        @Nullable
        public ShelvedChange getTextChange() {
            return null;
        }

        @Nullable
        public ShelvedBinaryFile getBinaryChange() {
            return null;
        }

        @NotNull
        public String getName() {
            String string = FileUtil.toSystemDependentName((String)this.getFilePath().getPath());
            if (string == null) {
                ShelveDiffRequestProducer.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = this.myFilePath;
            if (filePath == null) {
                ShelveDiffRequestProducer.$$$reportNull$$$0(2);
            }
            return filePath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$ShelveDiffRequestProducer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$ShelveDiffRequestProducer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class PatchesPreloader {
        private final Project myProject;
        private final SoftHardCacheMap<Path, PatchInfo> myFilePatchesMap = new SoftHardCacheMap(5, 5);
        private final ReadWriteLock myLock = new ReentrantReadWriteLock(true);

        PatchesPreloader(Project project) {
            this.myProject = project;
        }

        /*
         * WARNING - void declaration
         */
        @RequiresBackgroundThread
        @NotNull
        public TextFilePatch getPatch(@NotNull ShelvedChange shelvedChange) throws VcsException {
            void shelvedChange2;
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            if (shelvedChange2 == null) {
                PatchesPreloader.$$$reportNull$$$0(0);
            }
            TextFilePatch textFilePatch = (TextFilePatch)this.getPatchWithContext((ShelvedChange)shelvedChange2).first;
            if (textFilePatch == null) {
                PatchesPreloader.$$$reportNull$$$0(1);
            }
            return textFilePatch;
        }

        /*
         * WARNING - void declaration
         */
        @RequiresBackgroundThread
        @NotNull
        public Pair<TextFilePatch, CommitContext> getPatchWithContext(@NotNull ShelvedChange shelvedChange) throws VcsException {
            PatchInfo patchInfo;
            Path patchPath;
            void shelvedChange2;
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            if (shelvedChange2 == null) {
                PatchesPreloader.$$$reportNull$$$0(2);
            }
            if (this.getInfoFromCache(patchPath = shelvedChange2.getPatchPath()) == null || this.isPatchFileChanged(patchPath)) {
                this.readFilePatchAndUpdateCaches(patchPath);
            }
            if ((patchInfo = this.getInfoFromCache(patchPath)) != null) {
                for (TextFilePatch textFilePatch : patchInfo.myTextFilePatches) {
                    if (!shelvedChange2.getBeforePath().equals(textFilePatch.getBeforeName())) continue;
                    Pair pair = Pair.create((Object)textFilePatch, (Object)patchInfo.myCommitContext);
                    if (pair == null) {
                        PatchesPreloader.$$$reportNull$$$0(3);
                    }
                    return pair;
                }
            }
            throw new VcsException(VcsBundle.message((String)"changes.can.not.find.patch.for.path.in.patch.file", (Object[])new Object[]{shelvedChange2.getBeforePath()}));
        }

        private PatchInfo getInfoFromCache(@NotNull Path patchPath) {
            if (patchPath == null) {
                PatchesPreloader.$$$reportNull$$$0(4);
            }
            try {
                this.myLock.readLock().lock();
                PatchInfo patchInfo = this.myFilePatchesMap.get(patchPath);
                return patchInfo;
            }
            finally {
                this.myLock.readLock().unlock();
            }
        }

        private void readFilePatchAndUpdateCaches(@NotNull Path patchPath) throws VcsException {
            if (patchPath == null) {
                PatchesPreloader.$$$reportNull$$$0(5);
            }
            try {
                this.myLock.writeLock().lock();
                CommitContext commitContext = new CommitContext();
                List<TextFilePatch> patches2 = ShelveChangesManager.loadPatches(this.myProject, patchPath, commitContext);
                long timestamp = Files.getLastModifiedTime(patchPath, new LinkOption[0]).toMillis();
                this.myFilePatchesMap.put(patchPath, new PatchInfo(patches2, commitContext, timestamp));
            }
            catch (PatchSyntaxException | IOException e) {
                throw new VcsException((Throwable)e);
            }
            finally {
                this.myLock.writeLock().unlock();
            }
        }

        public boolean isPatchFileChanged(@NotNull Path patchPath) {
            PatchInfo patchInfo;
            if (patchPath == null) {
                PatchesPreloader.$$$reportNull$$$0(6);
            }
            if ((patchInfo = this.getInfoFromCache(patchPath)) == null) {
                return false;
            }
            try {
                return Files.getLastModifiedTime(patchPath, new LinkOption[0]).toMillis() != patchInfo.myLoadedTimeStamp;
            }
            catch (IOException e) {
                return false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shelvedChange";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchesPreloader";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patchPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchesPreloader";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPatch";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPatchWithContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPatch";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPatchWithContext";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getInfoFromCache";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "readFilePatchAndUpdateCaches";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isPatchFileChanged";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static final class PatchInfo {
            private final long myLoadedTimeStamp;
            @NotNull
            private final List<TextFilePatch> myTextFilePatches;
            @NotNull
            private final CommitContext myCommitContext;

            PatchInfo(@NotNull List<TextFilePatch> patches2, @NotNull CommitContext commitContext, long loadedTimeStamp) {
                if (patches2 == null) {
                    PatchInfo.$$$reportNull$$$0(0);
                }
                if (commitContext == null) {
                    PatchInfo.$$$reportNull$$$0(1);
                }
                this.myTextFilePatches = patches2;
                this.myCommitContext = commitContext;
                this.myLoadedTimeStamp = loadedTimeStamp;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "patches";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "commitContext";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesActionProvider$PatchesPreloader$PatchInfo";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

