/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchException;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShelvedChange {
    private static final Logger LOG = Logger.getInstance(ShelvedChange.class);
    private final Path myPatchPath;
    private final String myBeforePath;
    private final String myAfterPath;
    private final FileStatus myFileStatus;
    @NotNull
    private final Change myChange;

    public ShelvedChange(@NotNull Project project, @NotNull Path patchPath, String beforePath, String afterPath, FileStatus fileStatus) {
        if (project == null) {
            ShelvedChange.$$$reportNull$$$0(0);
        }
        if (patchPath == null) {
            ShelvedChange.$$$reportNull$$$0(1);
        }
        this.myPatchPath = patchPath;
        this.myBeforePath = beforePath;
        this.myAfterPath = Objects.equals(beforePath, afterPath) ? beforePath : afterPath;
        this.myFileStatus = fileStatus;
        this.myChange = this.createChange(project);
    }

    public boolean isConflictingChange() {
        block3: {
            ContentRevision afterRevision = this.getChange().getAfterRevision();
            if (afterRevision == null) {
                return false;
            }
            try {
                afterRevision.getContent();
            }
            catch (VcsException e) {
                if (!(e.getCause() instanceof ApplyPatchException)) break block3;
                return true;
            }
        }
        return false;
    }

    public String getBeforePath() {
        return this.myBeforePath;
    }

    public String getAfterPath() {
        return this.myAfterPath;
    }

    public FileStatus getFileStatus() {
        return this.myFileStatus;
    }

    @NotNull
    public Change getChange() {
        Change change = this.myChange;
        if (change == null) {
            ShelvedChange.$$$reportNull$$$0(2);
        }
        return change;
    }

    @Deprecated
    @NotNull
    public Change getChange(@NotNull Project project) {
        if (project == null) {
            ShelvedChange.$$$reportNull$$$0(3);
        }
        Change change = this.myChange;
        if (change == null) {
            ShelvedChange.$$$reportNull$$$0(4);
        }
        return change;
    }

    private Change createChange(@NotNull Project project) {
        if (project == null) {
            ShelvedChange.$$$reportNull$$$0(5);
        }
        File baseDir = new File(Objects.requireNonNull(project.getBasePath()));
        File file2 = ShelvedChange.getAbsolutePath(baseDir, this.myBeforePath);
        FilePath beforePath = VcsUtil.getFilePath((File)file2, (boolean)false);
        CurrentContentRevision beforeRevision = null;
        if (this.myFileStatus != FileStatus.ADDED) {
            beforeRevision = new CurrentContentRevision(beforePath){

                @NotNull
                public VcsRevisionNumber getRevisionNumber() {
                    return new TextRevisionNumber(VcsBundle.message((String)"local.version.title", (Object[])new Object[0]));
                }
            };
        }
        PatchedContentRevision afterRevision = null;
        if (this.myFileStatus != FileStatus.DELETED) {
            FilePath afterPath = VcsUtil.getFilePath((File)ShelvedChange.getAbsolutePath(baseDir, this.myAfterPath), (boolean)false);
            afterRevision = new PatchedContentRevision(project, beforePath, afterPath);
        }
        return new Change((ContentRevision)beforeRevision, afterRevision, this.myFileStatus);
    }

    private static File getAbsolutePath(File baseDir, String relativePath) {
        File file2;
        try {
            file2 = new File(baseDir, relativePath).getCanonicalFile();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            file2 = new File(baseDir, relativePath);
        }
        return file2;
    }

    @Nullable
    public TextFilePatch loadFilePatch(Project project, CommitContext commitContext) throws IOException, PatchSyntaxException {
        List<TextFilePatch> filePatches = ShelveChangesManager.loadPatches(project, this.myPatchPath, commitContext);
        return (TextFilePatch)ContainerUtil.find(filePatches, patch2 -> this.myBeforePath.equals(patch2.getBeforeName()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShelvedChange)) {
            return false;
        }
        ShelvedChange that = (ShelvedChange)o;
        if (!Objects.equals(this.myAfterPath, that.myAfterPath)) {
            return false;
        }
        if (!Objects.equals(this.myBeforePath, that.myBeforePath)) {
            return false;
        }
        if (!Objects.equals(this.myFileStatus, that.myFileStatus)) {
            return false;
        }
        return Objects.equals(this.myPatchPath, that.myPatchPath);
    }

    public int hashCode() {
        return Objects.hash(this.myPatchPath, this.myBeforePath, this.myAfterPath, this.myFileStatus);
    }

    @NotNull
    public Path getPatchPath() {
        Path path2 = this.myPatchPath;
        if (path2 == null) {
            ShelvedChange.$$$reportNull$$$0(6);
        }
        return path2;
    }

    public String toString() {
        return FileUtil.toSystemDependentName((String)(this.myBeforePath == null ? this.myAfterPath : this.myBeforePath));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchPath";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChange";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChange";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PatchedContentRevision
    implements ContentRevision {
        private final Project myProject;
        private final FilePath myBeforeFilePath;
        private final FilePath myAfterFilePath;

        PatchedContentRevision(Project project, FilePath beforeFilePath, FilePath afterFilePath) {
            this.myProject = project;
            this.myBeforeFilePath = beforeFilePath;
            this.myAfterFilePath = afterFilePath;
        }

        @Nullable
        public String getContent() throws VcsException {
            try {
                return this.loadContent();
            }
            catch (Exception e) {
                throw new VcsException((Throwable)e);
            }
        }

        @Nullable
        private String loadContent() throws IOException, PatchSyntaxException, ApplyPatchException {
            TextFilePatch patch2 = ShelvedChange.this.loadFilePatch(this.myProject, null);
            if (patch2 != null) {
                return this.loadContent(patch2);
            }
            return null;
        }

        private String loadContent(TextFilePatch patch2) throws ApplyPatchException {
            if (patch2.isNewFile()) {
                return patch2.getSingleHunkPatchText();
            }
            if (patch2.isDeletedFile()) {
                return null;
            }
            GenericPatchApplier.AppliedPatch appliedPatch = GenericPatchApplier.apply(this.getBaseContent(), patch2.getHunks());
            if (appliedPatch != null) {
                return appliedPatch.patchedText;
            }
            throw new ApplyPatchException("Apply patch conflict");
        }

        private String getBaseContent() {
            return (String)ReadAction.compute(() -> {
                Document doc = FileDocumentManager.getInstance().getDocument(this.myBeforeFilePath.getVirtualFile());
                return doc.getText();
            });
        }

        @NotNull
        public FilePath getFile() {
            FilePath filePath = this.myAfterFilePath;
            if (filePath == null) {
                PatchedContentRevision.$$$reportNull$$$0(0);
            }
            return filePath;
        }

        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            return new TextRevisionNumber(VcsBundle.message((String)"shelved.version.name", (Object[])new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedChange$PatchedContentRevision", "getFile"));
        }
    }
}

