/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.PlainSimplePatchApplier;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.DiffPreviewUpdateProcessor;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreviewManager;
import com.intellij.openapi.vcs.changes.EditorTabPreview;
import com.intellij.openapi.vcs.changes.PreviewDiffSplitterComponent;
import com.intellij.openapi.vcs.changes.VcsToolwindowDnDTarget;
import com.intellij.openapi.vcs.changes.actions.ShowDiffPreviewAction;
import com.intellij.openapi.vcs.changes.actions.diff.SelectionAwareGoToChangePopupActionProvider;
import com.intellij.openapi.vcs.changes.patch.PatchFileType;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequest;
import com.intellij.openapi.vcs.changes.shelf.DiffShelvedChangesActionProvider;
import com.intellij.openapi.vcs.changes.shelf.ShelfDeleteNotification;
import com.intellij.openapi.vcs.changes.shelf.ShelfNotification;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedWrapper;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentI;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.openapi.vcs.changes.ui.PresentableChange;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.FontUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedChangesViewManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ShelvedChangesViewManager.class);
    @NonNls
    static final String SHELF_CONTEXT_MENU = "Vcs.Shelf.ContextMenu";
    private static final String SHELVE_PREVIEW_SPLITTER_PROPORTION = "ShelvedChangesViewManager.DETAILS_SPLITTER_PROPORTION";
    private final ShelveChangesManager myShelveChangesManager;
    private final Project myProject;
    private ShelfToolWindowPanel myPanel = null;
    private ContentImpl myContent = null;
    private final MergingUpdateQueue myUpdateQueue;
    private final List<Runnable> myPostUpdateEdtActivity = new ArrayList<Runnable>();
    public static final DataKey<ChangesTree> SHELVED_CHANGES_TREE = DataKey.create("ShelveChangesManager.ShelvedChangesTree");
    public static final DataKey<List<ShelvedChangeList>> SHELVED_CHANGELIST_KEY = DataKey.create("ShelveChangesManager.ShelvedChangeListData");
    public static final DataKey<List<ShelvedChangeList>> SHELVED_RECYCLED_CHANGELIST_KEY = DataKey.create("ShelveChangesManager.ShelvedRecycledChangeListData");
    public static final DataKey<List<ShelvedChangeList>> SHELVED_DELETED_CHANGELIST_KEY = DataKey.create("ShelveChangesManager.ShelvedDeletedChangeListData");
    public static final DataKey<List<ShelvedChange>> SHELVED_CHANGE_KEY = DataKey.create("ShelveChangesManager.ShelvedChange");
    public static final DataKey<List<ShelvedBinaryFile>> SHELVED_BINARY_FILE_KEY = DataKey.create("ShelveChangesManager.ShelvedBinaryFile");

    public static ShelvedChangesViewManager getInstance(Project project) {
        return (ShelvedChangesViewManager)project.getService(ShelvedChangesViewManager.class);
    }

    public ShelvedChangesViewManager(Project project) {
        this.myProject = project;
        this.myShelveChangesManager = ShelveChangesManager.getInstance(project);
        this.myUpdateQueue = new MergingUpdateQueue("Update Shelf Content", 200, true, null, (Disposable)this.myProject, null, true);
        project.getMessageBus().connect().subscribe(ShelveChangesManager.SHELF_TOPIC, e -> this.scheduleContentUpdate());
    }

    private void scheduleContentUpdate() {
        this.myUpdateQueue.queue((Update)new MyContentUpdater());
    }

    private void updateTreeIfShown(@NotNull Consumer<? super ShelfTree> treeConsumer) {
        if (treeConsumer == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(0);
        }
        if (this.myContent == null) {
            return;
        }
        treeConsumer.consume((Object)this.myPanel.myTree);
    }

    @RequiresEdt
    void updateViewContent() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myShelveChangesManager.getAllLists().isEmpty()) {
            if (this.myContent != null) {
                this.removeContent(this.myContent);
                VcsNotifier.getInstance(this.myProject).hideAllNotificationsByType(ShelfNotification.class);
            }
            this.myContent = null;
        } else {
            if (this.myContent == null) {
                this.myPanel = new ShelfToolWindowPanel(this.myProject);
                this.myContent = new ContentImpl(this.myPanel.myRootPanel, VcsBundle.message((String)"shelf.tab", (Object[])new Object[0]), false);
                this.myContent.setTabName("Shelf");
                MyDnDTarget dnDTarget = new MyDnDTarget(this.myPanel.myProject, this.myContent);
                this.myContent.putUserData(Content.TAB_DND_TARGET_KEY, dnDTarget);
                this.myContent.putUserData(ChangesViewContentManager.IS_IN_COMMIT_TOOLWINDOW_KEY, true);
                this.myContent.setCloseable(false);
                this.myContent.setDisposer(this.myPanel);
                DnDSupport.createBuilder((JComponent)((Object)this.myPanel.myTree)).setImageProvider(x$0 -> this.myPanel.createDraggedImage((DnDActionInfo)x$0)).setBeanProvider(x$0 -> this.myPanel.createDragStartBean((DnDActionInfo)x$0)).setTargetChecker((DnDTargetChecker)dnDTarget).setDropHandler((DnDDropHandler)dnDTarget).setDisposableParent((Disposable)this.myContent).install();
                this.addContent(this.myContent);
            }
            this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree -> tree.rebuildTree()));
        }
    }

    protected void removeContent(Content content2) {
        ChangesViewContentI contentManager2 = ChangesViewContentManager.getInstance(this.myProject);
        contentManager2.removeContent(content2);
        contentManager2.selectContent("Local Changes");
    }

    protected void addContent(Content content2) {
        ChangesViewContentI contentManager2 = ChangesViewContentManager.getInstance(this.myProject);
        contentManager2.addContent(content2);
    }

    protected void activateContent() {
        ChangesViewContentI contentManager2 = ChangesViewContentManager.getInstance(this.myProject);
        contentManager2.setSelectedContent(this.myContent);
        ToolWindow window = ChangesViewContentManager.getToolWindowFor(this.myProject, "Shelf");
        if (window != null && !window.isVisible()) {
            window.activate(null);
        }
    }

    @RequiresEdt
    private void updateTreeModel() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree -> tree.setPaintBusy(true)));
        BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myProject, () -> {
            List<ShelvedChangeList> lists = this.myShelveChangesManager.getAllLists();
            lists.forEach(l -> l.loadChangesIfNeeded(this.myProject));
            List sortedLists = ContainerUtil.sorted(lists, (Comparator)ChangelistComparator.getInstance());
            ApplicationManager.getApplication().invokeLater(() -> {
                this.updateViewContent();
                this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree -> {
                    tree.setLoadedLists(sortedLists);
                    tree.setPaintBusy(false);
                    tree.rebuildTree();
                }));
                this.myPostUpdateEdtActivity.forEach(Runnable::run);
                this.myPostUpdateEdtActivity.clear();
            }, ModalityState.NON_MODAL, this.myProject.getDisposed());
        });
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void startEditing(@NotNull ShelvedChangeList shelvedChangeList) {
        void shelvedChangeList2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (shelvedChangeList2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(1);
        }
        this.runAfterUpdate(() -> this.lambda$startEditing$10((ShelvedChangeList)shelvedChangeList2));
    }

    public void activateView(@Nullable ShelvedChangeList list2) {
        this.runAfterUpdate(() -> {
            if (this.myContent == null) {
                return;
            }
            if (list2 != null) {
                this.selectShelvedList(list2);
            }
            this.activateContent();
        });
    }

    private void runAfterUpdate(@NotNull Runnable postUpdateRunnable) {
        if (postUpdateRunnable == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(2);
        }
        ModalityUiUtil.invokeLaterIfNeeded(() -> {
            this.myUpdateQueue.cancelAllUpdates();
            this.myPostUpdateEdtActivity.add(postUpdateRunnable);
            this.updateTreeModel();
        }, (ModalityState)ModalityState.NON_MODAL, (Condition)this.myProject.getDisposed());
    }

    public void dispose() {
        this.myUpdateQueue.cancelAllUpdates();
    }

    public void closeEditorPreview() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myContent == null) {
            return;
        }
        EditorTabPreview diffPreview = this.myPanel.myEditorDiffPreview;
        if (diffPreview != null) {
            diffPreview.closePreview();
        }
    }

    public void openEditorPreview() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myContent == null) {
            return;
        }
        this.myPanel.openEditorPreview(false);
    }

    public void updateOnVcsMappingsChanged() {
        ApplicationManager.getApplication().invokeLater(() -> this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree -> {
            ChangesGroupingSupport treeGroupingSupport = tree.getGroupingSupport();
            if (treeGroupingSupport.isAvailable("repository") && treeGroupingSupport.get("repository")) {
                tree.rebuildTree();
            }
        })), this.myProject.getDisposed());
    }

    public void selectShelvedList(@NotNull ShelvedChangeList list2) {
        if (list2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(3);
        }
        this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree -> {
            DefaultMutableTreeNode treeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)tree.getModel().getRoot()), (Object)list2);
            if (treeNode == null) {
                LOG.warn(VcsBundle.message((String)"shelve.changelist.not.found", (Object[])new Object[]{list2.DESCRIPTION}));
                return;
            }
            TreeUtil.selectNode((JTree)((Object)tree), (TreeNode)treeNode);
        }));
    }

    @NotNull
    private static Set<ShelvedChangeList> getSelectedLists(@NotNull ChangesTree tree, @NotNull Predicate<? super ShelvedChangeList> condition2) {
        Object[] selectionPaths;
        if (tree == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(4);
        }
        if (condition2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(5);
        }
        if ((selectionPaths = tree.getSelectionPaths()) == null) {
            Set<ShelvedChangeList> set2 = Collections.emptySet();
            if (set2 == null) {
                ShelvedChangesViewManager.$$$reportNull$$$0(6);
            }
            return set2;
        }
        Set set3 = (Set)((StreamEx)((StreamEx)StreamEx.of((Object[])selectionPaths).map(path2 -> (ShelvedChangeList)TreeUtil.findObjectInPath((TreePath)path2, ShelvedChangeList.class)).filter(Objects::nonNull)).filter(condition2)).collect(Collectors.toSet());
        if (set3 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(7);
        }
        return set3;
    }

    @NotNull
    static ListSelection<ShelvedWrapper> getSelectedChangesOrAll(@NotNull DataContext dataContext) {
        List<ShelvedWrapper> allWrappers;
        ChangesBrowserNode changeListNode;
        ShelvedChangeList changeList;
        ChangesTree tree;
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(8);
        }
        if ((tree = dataContext.getData(SHELVED_CHANGES_TREE)) == null) {
            ListSelection listSelection = ListSelection.createAt(Collections.emptyList(), (int)0);
            if (listSelection == null) {
                ShelvedChangesViewManager.$$$reportNull$$$0(9);
            }
            return listSelection;
        }
        ListSelection wrappers = ListSelection.createAt(VcsTreeModelData.selected((JTree)((Object)tree)).userObjects(ShelvedWrapper.class), (int)0);
        if (wrappers.getList().size() == 1 && (changeList = (ShelvedChangeList)ContainerUtil.getFirstItem(ShelvedChangesViewManager.getSelectedLists(tree, it -> true))) != null && (changeListNode = (ChangesBrowserNode)TreeUtil.findNodeWithObject(tree.getRoot(), (Object)changeList)) != null && (allWrappers = changeListNode.getAllObjectsUnder(ShelvedWrapper.class)).size() > 1) {
            ShelvedWrapper toSelect2 = (ShelvedWrapper)ContainerUtil.getFirstItem((List)wrappers.getList());
            ListSelection listSelection = ListSelection.create(allWrappers, (Object)toSelect2);
            if (listSelection == null) {
                ShelvedChangesViewManager.$$$reportNull$$$0(10);
            }
            return listSelection;
        }
        ListSelection listSelection = wrappers;
        if (listSelection == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(11);
        }
        return listSelection;
    }

    @NotNull
    public static List<ShelvedChangeList> getShelvedLists(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(12);
        }
        ArrayList<ShelvedChangeList> shelvedChangeLists = new ArrayList<ShelvedChangeList>();
        shelvedChangeLists.addAll(ContainerUtil.notNullize(SHELVED_CHANGELIST_KEY.getData(dataContext)));
        shelvedChangeLists.addAll(ContainerUtil.notNullize(SHELVED_RECYCLED_CHANGELIST_KEY.getData(dataContext)));
        shelvedChangeLists.addAll(ContainerUtil.notNullize(SHELVED_DELETED_CHANGELIST_KEY.getData(dataContext)));
        ArrayList<ShelvedChangeList> arrayList = shelvedChangeLists;
        if (arrayList == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public static List<ShelvedChangeList> getExactlySelectedLists(@NotNull DataContext dataContext) {
        ChangesTree shelvedChangeTree;
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(14);
        }
        if ((shelvedChangeTree = dataContext.getData(SHELVED_CHANGES_TREE)) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                ShelvedChangesViewManager.$$$reportNull$$$0(15);
            }
            return list2;
        }
        List list3 = StreamEx.of(VcsTreeModelData.exactlySelected((JTree)((Object)shelvedChangeTree)).userObjectsStream(ShelvedChangeList.class)).toList();
        if (list3 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(16);
        }
        return list3;
    }

    @NotNull
    public static List<ShelvedChange> getShelveChanges(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(17);
        }
        List list2 = ContainerUtil.notNullize(dataContext.getData(SHELVED_CHANGE_KEY));
        if (list2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(18);
        }
        return list2;
    }

    @NotNull
    public static List<ShelvedBinaryFile> getBinaryShelveChanges(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(19);
        }
        List list2 = ContainerUtil.notNullize(dataContext.getData(SHELVED_BINARY_FILE_KEY));
        if (list2 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(20);
        }
        return list2;
    }

    @NotNull
    public static List<String> getSelectedShelvedChangeNames(@NotNull DataContext dataContext) {
        ChangesTree shelvedChangeTree;
        if (dataContext == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(21);
        }
        if ((shelvedChangeTree = dataContext.getData(SHELVED_CHANGES_TREE)) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                ShelvedChangesViewManager.$$$reportNull$$$0(22);
            }
            return list2;
        }
        List list3 = StreamEx.of(VcsTreeModelData.selected((JTree)((Object)shelvedChangeTree)).userObjectsStream(ShelvedWrapper.class)).map(ShelvedWrapper::getPath).toList();
        if (list3 == null) {
            ShelvedChangesViewManager.$$$reportNull$$$0(23);
        }
        return list3;
    }

    private /* synthetic */ void lambda$startEditing$10(ShelvedChangeList shelvedChangeList) {
        this.selectShelvedList(shelvedChangeList);
        this.updateTreeIfShown((Consumer<? super ShelfTree>)((Consumer)tree -> tree.startEditingAtPath(tree.getLeadSelectionPath())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeConsumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChangeList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postUpdateRunnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLists";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChangesOrAll";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getShelvedLists";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExactlySelectedLists";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getShelveChanges";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryShelveChanges";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedShelvedChangeNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateTreeIfShown";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startEditing";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runAfterUpdate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "selectShelvedList";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedLists";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedChangesOrAll";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getShelvedLists";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExactlySelectedLists";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getShelveChanges";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryShelveChanges";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedShelvedChangeNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PostStartupActivity
    implements StartupActivity.Background {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                PostStartupActivity.$$$reportNull$$$0(0);
            }
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                return;
            }
            ShelvedChangesViewManager.getInstance(project).scheduleContentUpdate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$PostStartupActivity", "runActivity"));
        }
    }

    private class MyContentUpdater
    extends Update {
        MyContentUpdater() {
            super((Object)"ShelfContentUpdate");
        }

        public void run() {
            ShelvedChangesViewManager.this.updateTreeModel();
        }

        public boolean canEat(Update update2) {
            return true;
        }
    }

    private static class ShelvedChangeNode
    extends ChangesBrowserNode<ShelvedWrapper>
    implements Comparable<ShelvedChangeNode> {
        @NotNull
        private final ShelvedWrapper myShelvedChange;
        @NotNull
        private final FilePath myFilePath;
        @Nullable
        @Nls
        private final String myAdditionalText;

        protected ShelvedChangeNode(@NotNull ShelvedWrapper shelvedChange, @NotNull FilePath filePath, @Nullable @Nls String additionalText) {
            if (shelvedChange == null) {
                ShelvedChangeNode.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                ShelvedChangeNode.$$$reportNull$$$0(1);
            }
            super(shelvedChange);
            this.myShelvedChange = shelvedChange;
            this.myFilePath = filePath;
            this.myAdditionalText = additionalText;
        }

        @Override
        public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected2, boolean expanded, boolean hasFocus) {
            if (renderer2 == null) {
                ShelvedChangeNode.$$$reportNull$$$0(2);
            }
            String path2 = this.myShelvedChange.getRequestName();
            String directory = StringUtil.defaultIfEmpty((String)PathUtil.getParentPath((String)path2), (String)VcsBundle.message((String)"shelve.default.path.rendering", (Object[])new Object[0]));
            String fileName = StringUtil.defaultIfEmpty((String)PathUtil.getFileName((String)path2), (String)path2);
            renderer2.append(fileName, new SimpleTextAttributes(0, this.myShelvedChange.getFileStatus().getColor()));
            if (this.myAdditionalText != null) {
                renderer2.append(FontUtil.spaceAndThinSpace() + this.myAdditionalText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            if (renderer2.isShowFlatten()) {
                renderer2.append(FontUtil.spaceAndThinSpace() + FileUtil.toSystemDependentName((String)directory), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            renderer2.setIcon(FileTypeManager.getInstance().getFileTypeByFileName(fileName).getIcon());
        }

        @Override
        public String getTextPresentation() {
            return PathUtil.getFileName((String)this.myShelvedChange.getRequestName());
        }

        @Override
        protected boolean isFile() {
            return true;
        }

        @Override
        public int compareTo(@NotNull ShelvedChangeNode o) {
            if (o == null) {
                ShelvedChangeNode.$$$reportNull$$$0(3);
            }
            return ShelvedChangeNode.compareFilePaths(this.myFilePath, o.myFilePath);
        }

        @Override
        @Nullable
        public Color getBackgroundColor(@NotNull Project project) {
            if (project == null) {
                ShelvedChangeNode.$$$reportNull$$$0(4);
            }
            return ShelvedChangeNode.getBackgroundColorFor(project, this.myFilePath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shelvedChange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelvedChangeNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "render";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBackgroundColor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ShelvedListNode
    extends ChangesBrowserNode<ShelvedChangeList> {
        private static final Icon PatchIcon = PatchFileType.INSTANCE.getIcon();
        private static final Icon AppliedPatchIcon = new IconUtil.IconSizeWrapper(AllIcons.Vcs.Patch_applied, AllIcons.Vcs.Patch_applied.getIconWidth(), AllIcons.Vcs.Patch_applied.getIconHeight()){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                GraphicsUtil.paintWithAlpha((Graphics)g, (float)0.6f);
                super.paintIcon(c, g, x, y);
            }
        };
        private static final Icon DisabledToDeleteIcon = IconUtil.desaturate(AllIcons.Actions.GC);
        @NotNull
        private final ShelvedChangeList myList;

        ShelvedListNode(@NotNull ShelvedChangeList list2) {
            if (list2 == null) {
                ShelvedListNode.$$$reportNull$$$0(0);
            }
            super(list2);
            this.myList = list2;
        }

        @NotNull
        public ShelvedChangeList getList() {
            ShelvedChangeList shelvedChangeList = this.myList;
            if (shelvedChangeList == null) {
                ShelvedListNode.$$$reportNull$$$0(1);
            }
            return shelvedChangeList;
        }

        @Override
        public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected2, boolean expanded, boolean hasFocus) {
            String listName;
            if (renderer2 == null) {
                ShelvedListNode.$$$reportNull$$$0(2);
            }
            if (StringUtil.isEmptyOrSpaces((String)(listName = this.myList.DESCRIPTION))) {
                listName = VcsBundle.message((String)"changes.nodetitle.empty.changelist.name", (Object[])new Object[0]);
            }
            if (this.myList.isRecycled() || this.myList.isDeleted()) {
                renderer2.appendTextWithIssueLinks(listName, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                renderer2.setIcon(this.myList.isMarkedToDelete() || this.myList.isDeleted() ? DisabledToDeleteIcon : AppliedPatchIcon);
            } else {
                renderer2.appendTextWithIssueLinks(listName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                renderer2.setIcon(PatchIcon);
            }
            this.appendCount(renderer2);
            String date = DateFormatUtil.formatPrettyDateTime((Date)this.myList.DATE);
            renderer2.append(", " + date, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }

        @Override
        @Nls
        public String getTextPresentation() {
            return ((ShelvedChangeList)this.getUserObject()).toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelvedListNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelvedListNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "render";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyShelvedPreviewProcessor
    extends CacheDiffRequestProcessor<ShelvedWrapper>
    implements DiffPreviewUpdateProcessor {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ShelfTree myTree;
        @NotNull
        private final DiffShelvedChangesActionProvider.PatchesPreloader myPreloader;
        @Nullable
        private ShelvedWrapper myCurrentShelvedElement;

        MyShelvedPreviewProcessor(@NotNull Project project, @NotNull ShelfTree tree) {
            if (project == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(1);
            }
            super(project);
            this.myProject = project;
            this.myTree = tree;
            this.myPreloader = new DiffShelvedChangesActionProvider.PatchesPreloader(project);
        }

        @Override
        @NotNull
        protected String getRequestName(@NotNull ShelvedWrapper provider2) {
            if (provider2 == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(2);
            }
            String string = provider2.getRequestName();
            if (string == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        protected ShelvedWrapper getCurrentRequestProvider() {
            return this.myCurrentShelvedElement;
        }

        @Override
        @RequiresEdt
        public void clear() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (this.myCurrentShelvedElement != null) {
                this.myCurrentShelvedElement = null;
                this.updateRequest();
            }
            this.dropCaches();
        }

        @Override
        @RequiresEdt
        public void refresh(boolean bl) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            DataContext dc = DataManager.getInstance().getDataContext((Component)((Object)this.myTree));
            List<ShelvedChange> selectedChanges = ShelvedChangesViewManager.getShelveChanges(dc);
            List<ShelvedBinaryFile> selectedBinaryChanges = ShelvedChangesViewManager.getBinaryShelveChanges(dc);
            if (selectedChanges.isEmpty() && selectedBinaryChanges.isEmpty()) {
                this.clear();
                return;
            }
            if (this.myCurrentShelvedElement != null && (this.keepBinarySelection(selectedBinaryChanges, this.myCurrentShelvedElement.getBinaryFile()) || this.keepShelvedSelection(selectedChanges, this.myCurrentShelvedElement.getShelvedChange()))) {
                this.dropCachesIfNeededAndUpdate(this.myCurrentShelvedElement);
                return;
            }
            this.myCurrentShelvedElement = !selectedChanges.isEmpty() ? new ShelvedWrapper(selectedChanges.get(0)) : new ShelvedWrapper(selectedBinaryChanges.get(0));
            this.dropCachesIfNeededAndUpdate(this.myCurrentShelvedElement);
        }

        private void dropCachesIfNeededAndUpdate(@NotNull ShelvedWrapper currentShelvedElement) {
            ShelvedChange shelvedChange;
            boolean dropCaches;
            if (currentShelvedElement == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(4);
            }
            boolean bl = dropCaches = (shelvedChange = currentShelvedElement.getShelvedChange()) != null && this.myPreloader.isPatchFileChanged(shelvedChange.getPatchPath());
            if (dropCaches) {
                this.dropCaches();
            }
            this.updateRequest(dropCaches);
        }

        boolean keepShelvedSelection(@NotNull List<ShelvedChange> selectedChanges, @Nullable ShelvedChange currentShelvedChange) {
            if (selectedChanges == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(5);
            }
            return currentShelvedChange != null && selectedChanges.contains(currentShelvedChange);
        }

        boolean keepBinarySelection(@NotNull List<ShelvedBinaryFile> selectedBinaryChanges, @Nullable ShelvedBinaryFile currentBinary) {
            if (selectedBinaryChanges == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(6);
            }
            return currentBinary != null && selectedBinaryChanges.contains(currentBinary);
        }

        @Override
        @NotNull
        protected DiffRequest loadRequest(@NotNull ShelvedWrapper provider2, @NotNull ProgressIndicator indicator2) throws ProcessCanceledException, DiffRequestProducerException {
            if (provider2 == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(7);
            }
            if (indicator2 == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(8);
            }
            String title2 = this.getRequestName(provider2);
            try {
                ShelvedChange shelvedChange = provider2.getShelvedChange();
                if (shelvedChange != null) {
                    return this.createTextShelveRequest(shelvedChange, title2);
                }
                ShelvedBinaryFile binaryFile = provider2.getBinaryFile();
                if (binaryFile != null) {
                    return this.createBinaryShelveRequest(binaryFile, title2);
                }
                throw new IllegalStateException("Empty shelved wrapper: " + provider2);
            }
            catch (VcsException | IOException e) {
                throw new DiffRequestProducerException(VcsBundle.message((String)"changes.error.can.t.show.diff.for", (Object[])new Object[]{title2}), e);
            }
        }

        @NotNull
        private DiffRequest createTextShelveRequest(@NotNull ShelvedChange shelvedChange, @Nullable @Nls String title2) throws VcsException {
            String patchedContent;
            if (shelvedChange == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(9);
            }
            DiffContentFactoryEx factory2 = DiffContentFactoryEx.getInstanceEx();
            Pair<TextFilePatch, CommitContext> pair = this.myPreloader.getPatchWithContext(shelvedChange);
            TextFilePatch patch2 = (TextFilePatch)pair.first;
            CommitContext commitContext = (CommitContext)pair.second;
            FilePath contextFilePath = MyShelvedPreviewProcessor.getContextFilePath(shelvedChange);
            if (patch2.isDeletedFile() || patch2.isNewFile()) {
                DocumentContent shelfContent = factory2.create(this.myProject, patch2.getSingleHunkPatchText(), contextFilePath);
                EmptyContent emptyContent = factory2.createEmpty();
                DocumentContent leftContent = patch2.isDeletedFile() ? shelfContent : emptyContent;
                DocumentContent rightContent = !patch2.isDeletedFile() ? shelfContent : emptyContent;
                String leftTitle = DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]);
                String rightTitle = VcsBundle.message((String)"shelve.shelved.version", (Object[])new Object[0]);
                return new SimpleDiffRequest(title2, (DiffContent)leftContent, (DiffContent)rightContent, leftTitle, rightTitle);
            }
            String path2 = (String)ObjectUtils.chooseNotNull((Object)patch2.getAfterName(), (Object)patch2.getBeforeName());
            CharSequence baseContents = ((BaseRevisionTextPatchEP)PatchEP.EP_NAME.findExtensionOrFail(BaseRevisionTextPatchEP.class)).provideContent(this.myProject, path2, commitContext);
            if (baseContents != null && (patchedContent = PlainSimplePatchApplier.apply(baseContents, patch2.getHunks())) != null) {
                DocumentContent leftContent = factory2.create(this.myProject, baseContents.toString(), contextFilePath);
                DocumentContent rightContent = factory2.create(this.myProject, patchedContent, contextFilePath);
                String leftTitle = DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]);
                String rightTitle = VcsBundle.message((String)"shelve.shelved.version", (Object[])new Object[0]);
                return new SimpleDiffRequest(title2, (DiffContent)leftContent, (DiffContent)rightContent, leftTitle, rightTitle);
            }
            return new PatchDiffRequest(DiffShelvedChangesActionProvider.createAppliedTextPatch(patch2), title2, null);
        }

        @Override
        @Nullable
        protected AnAction createGoToChangeAction() {
            return new MyGoToChangePopupProvider().createGoToChangeAction();
        }

        @NotNull
        private static FilePath getContextFilePath(@NotNull ShelvedChange shelvedChange) {
            Change change;
            if (shelvedChange == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(10);
            }
            if ((change = shelvedChange.getChange()).getType() == Change.Type.MOVED) {
                FilePath bPath = Objects.requireNonNull(ChangesUtil.getBeforePath((Change)change));
                FilePath aPath = Objects.requireNonNull(ChangesUtil.getAfterPath((Change)change));
                if (bPath.getVirtualFile() != null) {
                    FilePath filePath = bPath;
                    if (filePath == null) {
                        MyShelvedPreviewProcessor.$$$reportNull$$$0(11);
                    }
                    return filePath;
                }
                if (aPath.getVirtualFile() != null) {
                    FilePath filePath = aPath;
                    if (filePath == null) {
                        MyShelvedPreviewProcessor.$$$reportNull$$$0(12);
                    }
                    return filePath;
                }
                FilePath filePath = bPath;
                if (filePath == null) {
                    MyShelvedPreviewProcessor.$$$reportNull$$$0(13);
                }
                return filePath;
            }
            FilePath filePath = ChangesUtil.getFilePath((Change)change);
            if (filePath == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(14);
            }
            return filePath;
        }

        @NotNull
        private SimpleDiffRequest createBinaryShelveRequest(@NotNull ShelvedBinaryFile binaryFile, @Nullable @Nls String title2) throws DiffRequestProducerException, VcsException, IOException {
            if (binaryFile == null) {
                MyShelvedPreviewProcessor.$$$reportNull$$$0(15);
            }
            DiffContentFactory factory2 = DiffContentFactory.getInstance();
            if (binaryFile.AFTER_PATH == null) {
                throw new DiffRequestProducerException(VcsBundle.message((String)"changes.error.content.for.0.was.removed", (Object[])new Object[]{title2}));
            }
            byte[] binaryContent = binaryFile.createBinaryContentRevision(this.myProject).getBinaryContent();
            FileType fileType = VcsUtil.getFilePath((String)binaryFile.SHELVED_PATH).getFileType();
            DiffContent shelfContent = factory2.createBinary(this.myProject, binaryContent, fileType, title2);
            return new SimpleDiffRequest(title2, (DiffContent)factory2.createEmpty(), shelfContent, null, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 3: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelvedPreviewProcessor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentShelvedElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedChanges";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedBinaryChanges";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shelvedChange";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "binaryFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelvedPreviewProcessor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequestName";
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContextFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getRequestName";
                    break;
                }
                case 3: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "dropCachesIfNeededAndUpdate";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "keepShelvedSelection";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "keepBinarySelection";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "loadRequest";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createTextShelveRequest";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getContextFilePath";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "createBinaryShelveRequest";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class MyGoToChangePopupProvider
        extends SelectionAwareGoToChangePopupActionProvider {
            private MyGoToChangePopupProvider() {
            }

            @Override
            @NotNull
            public List<? extends PresentableChange> getChanges() {
                DataContext dc = DataManager.getInstance().getDataContext((Component)((Object)MyShelvedPreviewProcessor.this.myTree));
                ListSelection<? extends ChangeDiffRequestChain.Producer> diffProducers = DiffShelvedChangesActionProvider.createDiffProducers(dc, false);
                if (diffProducers == null) {
                    List list2 = ContainerUtil.emptyList();
                    if (list2 == null) {
                        MyGoToChangePopupProvider.$$$reportNull$$$0(0);
                    }
                    return list2;
                }
                List list3 = diffProducers.getList();
                if (list3 == null) {
                    MyGoToChangePopupProvider.$$$reportNull$$$0(1);
                }
                return list3;
            }

            @Override
            public void select(@NotNull PresentableChange presentableChange) {
                ShelvedChangeList selectedList;
                if (presentableChange == null) {
                    MyGoToChangePopupProvider.$$$reportNull$$$0(2);
                }
                if ((selectedList = (ShelvedChangeList)ContainerUtil.getOnlyItem(ShelvedChangesViewManager.getSelectedLists(MyShelvedPreviewProcessor.this.myTree, it -> true))) == null) {
                    return;
                }
                FilePath filePath = presentableChange.getFilePath();
                ChangesBrowserNode changeListNode = (ChangesBrowserNode)TreeUtil.findNodeWithObject(MyShelvedPreviewProcessor.this.myTree.getRoot(), (Object)selectedList);
                TreeNode targetNode = (TreeNode)TreeUtil.treeNodeTraverser((TreeNode)changeListNode).traverse(TreeTraversal.POST_ORDER_DFS).find(node2 -> {
                    Object userObject;
                    if (node2 instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)node2).getUserObject()) instanceof ShelvedWrapper) {
                        ShelvedWrapper shelvedWrapper = (ShelvedWrapper)userObject;
                        Change change = shelvedWrapper.getChange(MyShelvedPreviewProcessor.this.myProject);
                        return ChangesUtil.getFilePath((Change)change).equals(filePath);
                    }
                    return false;
                });
                if (targetNode != null) {
                    TreeUtil.selectNode((JTree)((Object)MyShelvedPreviewProcessor.this.myTree), (TreeNode)targetNode);
                    MyShelvedPreviewProcessor.this.refresh(false);
                }
            }

            @Override
            @Nullable
            public PresentableChange getSelectedChange() {
                return MyShelvedPreviewProcessor.this.myCurrentShelvedElement != null ? MyShelvedPreviewProcessor.this.myCurrentShelvedElement : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelvedPreviewProcessor$MyGoToChangePopupProvider";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "presentableChange";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChanges";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelvedPreviewProcessor$MyGoToChangePopupProvider";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "select";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static final class ShelfToolWindowPanel
    implements ChangesViewContentManagerListener,
    DataProvider,
    Disposable {
        @NotNull
        private static final RegistryValue isOpenEditorDiffPreviewWithSingleClick = Registry.get((String)"show.diff.preview.as.editor.tab.with.single.click");
        private final Project myProject;
        private final ShelveChangesManager myShelveChangesManager;
        private final VcsConfiguration myVcsConfiguration;
        @NotNull
        private final JScrollPane myTreeScrollPane;
        private final ShelfTree myTree;
        private final ActionToolbar myToolbar;
        @NotNull
        private final JPanel myRootPanel;
        private MyShelvedPreviewProcessor myEditorChangeProcessor;
        private MyShelvedPreviewProcessor mySplitterChangeProcessor;
        private EditorTabPreview myEditorDiffPreview;
        private PreviewDiffSplitterComponent mySplitterDiffPreview;

        private ShelfToolWindowPanel(@NotNull Project project) {
            if (project == null) {
                ShelfToolWindowPanel.$$$reportNull$$$0(0);
            }
            this.myRootPanel = new JPanel(new BorderLayout());
            this.myProject = project;
            this.myShelveChangesManager = ShelveChangesManager.getInstance(this.myProject);
            this.myVcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
            this.myTree = new ShelfTree(this.myProject);
            this.myTree.setEditable(true);
            this.myTree.setDragEnabled(!ApplicationManager.getApplication().isHeadlessEnvironment());
            this.myTree.getGroupingSupport().setGroupingKeysOrSkip(this.myShelveChangesManager.getGrouping());
            this.myTree.addGroupingChangeListener(e -> {
                this.myShelveChangesManager.setGrouping(this.myTree.getGroupingSupport().getGroupingKeys());
                this.myTree.rebuildTree();
            });
            DefaultTreeCellEditor treeCellEditor = new DefaultTreeCellEditor((JTree)((Object)this.myTree), null){

                @Override
                public boolean isCellEditable(EventObject event) {
                    return !(event instanceof MouseEvent) && super.isCellEditable(event);
                }
            };
            this.myTree.setCellEditor(treeCellEditor);
            treeCellEditor.addCellEditorListener(new CellEditorListener(){

                @Override
                public void editingStopped(ChangeEvent e) {
                    DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)myTree.getLastSelectedPathComponent();
                    if (node2 instanceof ShelvedListNode && e.getSource() instanceof TreeCellEditor) {
                        String editorValue = ((TreeCellEditor)e.getSource()).getCellEditorValue().toString();
                        ShelvedChangeList shelvedChangeList = ((ShelvedListNode)node2).getList();
                        myShelveChangesManager.renameChangeList(shelvedChangeList, editorValue);
                    }
                }

                @Override
                public void editingCanceled(ChangeEvent e) {
                }
            });
            AnAction showDiffAction = ActionManager.getInstance().getAction("Diff.ShowDiff");
            showDiffAction.registerCustomShortcutSet(showDiffAction.getShortcutSet(), (JComponent)((Object)this.myTree));
            EditSourceAction editSourceAction = new EditSourceAction();
            editSourceAction.registerCustomShortcutSet(editSourceAction.getShortcutSet(), (JComponent)((Object)this.myTree));
            DefaultActionGroup actionGroup2 = new DefaultActionGroup();
            actionGroup2.addAll((ActionGroup)ActionManager.getInstance().getAction("ShelvedChangesToolbar"));
            actionGroup2.add((AnAction)Separator.getInstance());
            actionGroup2.add((AnAction)new MyToggleDetailsAction());
            this.myToolbar = ActionManager.getInstance().createActionToolbar("ShelvedChanges", (ActionGroup)actionGroup2, false);
            this.myToolbar.setTargetComponent((JComponent)((Object)this.myTree));
            this.myTreeScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree), (int)1);
            this.myRootPanel.add((Component)this.myTreeScrollPane, "Center");
            this.addToolbar(ChangesViewContentManagerKt.isCommitToolWindowShown(this.myProject));
            this.setDiffPreview();
            EditorTabDiffPreviewManager.getInstance(project).subscribeToPreviewVisibilityChange(this, this::setDiffPreview);
            isOpenEditorDiffPreviewWithSingleClick.addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue value2) {
                    if (value2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (myEditorDiffPreview != null) {
                        this.setDiffPreview();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfToolWindowPanel$3", "afterValueChanged"));
                }
            }, (Disposable)this);
            this.myProject.getMessageBus().connect((Disposable)this).subscribe(ChangesViewContentManagerListener.TOPIC, (Object)this);
            DataManager.registerDataProvider((JComponent)this.myRootPanel, (DataProvider)this);
            PopupHandler.installPopupMenu((JComponent)((Object)this.myTree), (String)"ShelvedChangesPopupMenu", (String)ShelvedChangesViewManager.SHELF_CONTEXT_MENU);
        }

        public void dispose() {
        }

        @Override
        public void toolWindowMappingChanged() {
            this.addToolbar(ChangesViewContentManagerKt.isCommitToolWindowShown(this.myProject));
        }

        private void addToolbar(boolean isHorizontal) {
            if (isHorizontal) {
                this.myToolbar.setOrientation(0);
                this.myRootPanel.add((Component)this.myToolbar.getComponent(), "North");
            } else {
                this.myToolbar.setOrientation(1);
                this.myRootPanel.add((Component)this.myToolbar.getComponent(), "West");
            }
        }

        private void setDiffPreview() {
            boolean hasSplitterPreview;
            boolean isEditorPreview = ChangesViewManager.isEditorPreview(this.myProject);
            boolean bl = hasSplitterPreview = !ChangesViewContentManagerKt.isCommitToolWindowShown(this.myProject);
            if (this.myEditorChangeProcessor != null) {
                Disposer.dispose((Disposable)this.myEditorChangeProcessor);
            }
            if (this.mySplitterChangeProcessor != null) {
                Disposer.dispose((Disposable)this.mySplitterChangeProcessor);
            }
            if (isEditorPreview) {
                this.myEditorChangeProcessor = new MyShelvedPreviewProcessor(this.myProject, this.myTree);
                Disposer.register((Disposable)this, (Disposable)this.myEditorChangeProcessor);
                this.myEditorDiffPreview = this.installEditorPreview(this.myEditorChangeProcessor);
            } else {
                this.myEditorDiffPreview = null;
            }
            if (hasSplitterPreview) {
                this.mySplitterChangeProcessor = new MyShelvedPreviewProcessor(this.myProject, this.myTree);
                Disposer.register((Disposable)this, (Disposable)this.mySplitterChangeProcessor);
                this.mySplitterDiffPreview = this.installSplitterPreview(this.mySplitterChangeProcessor);
            } else {
                this.mySplitterDiffPreview = null;
            }
        }

        @NotNull
        private EditorTabPreview installEditorPreview(final @NotNull MyShelvedPreviewProcessor changeProcessor) {
            if (changeProcessor == null) {
                ShelfToolWindowPanel.$$$reportNull$$$0(1);
            }
            EditorTabPreview editorPreview = new EditorTabPreview(changeProcessor){

                @Override
                public void updateAvailability(@NotNull AnActionEvent event) {
                    if (event == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    DiffShelvedChangesActionProvider.updateAvailability(event);
                }

                @Override
                protected String getCurrentName() {
                    ShelvedWrapper myCurrentShelvedElement = changeProcessor.myCurrentShelvedElement;
                    return myCurrentShelvedElement != null ? VcsBundle.message((String)"shelve.editor.diff.preview.title", (Object[])new Object[]{myCurrentShelvedElement.getPresentableName()}) : VcsBundle.message((String)"shelved.version.name", (Object[])new Object[0]);
                }

                @Override
                protected boolean hasContent() {
                    return changeProcessor.myCurrentShelvedElement != null;
                }

                @Override
                protected boolean skipPreviewUpdate() {
                    if (super.skipPreviewUpdate()) {
                        return true;
                    }
                    if (!myTree.equals(IdeFocusManager.getInstance((Project)myProject).getFocusOwner())) {
                        return true;
                    }
                    return !this.isPreviewOpen() && !this.isEditorPreviewAllowed();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfToolWindowPanel$4", "updateAvailability"));
                }
            };
            editorPreview.setEscapeHandler(() -> {
                editorPreview.closePreview();
                ToolWindow toolWindow = ChangesViewContentManager.getToolWindowFor(this.myProject, "Shelf");
                if (toolWindow != null) {
                    toolWindow.activate(null);
                }
            });
            editorPreview.installListeners(this.myTree, isOpenEditorDiffPreviewWithSingleClick.asBoolean());
            editorPreview.installNextDiffActionOn(this.myTreeScrollPane);
            EditorTabPreview editorTabPreview = editorPreview;
            if (editorTabPreview == null) {
                ShelfToolWindowPanel.$$$reportNull$$$0(2);
            }
            return editorTabPreview;
        }

        @NotNull
        private PreviewDiffSplitterComponent installSplitterPreview(@NotNull MyShelvedPreviewProcessor changeProcessor) {
            if (changeProcessor == null) {
                ShelfToolWindowPanel.$$$reportNull$$$0(3);
            }
            PreviewDiffSplitterComponent previewSplitter = new PreviewDiffSplitterComponent(changeProcessor, ShelvedChangesViewManager.SHELVE_PREVIEW_SPLITTER_PROPORTION);
            previewSplitter.setFirstComponent(this.myTreeScrollPane);
            previewSplitter.setPreviewVisible(this.myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN, false);
            this.myTree.addSelectionListener(() -> previewSplitter.updatePreview(false), changeProcessor);
            this.myRootPanel.add((Component)((Object)previewSplitter), "Center");
            Disposer.register((Disposable)changeProcessor, () -> {
                this.myRootPanel.remove((Component)((Object)previewSplitter));
                this.myRootPanel.add((Component)this.myTreeScrollPane, "Center");
                this.myRootPanel.revalidate();
                this.myRootPanel.repaint();
            });
            PreviewDiffSplitterComponent previewDiffSplitterComponent = previewSplitter;
            if (previewDiffSplitterComponent == null) {
                ShelfToolWindowPanel.$$$reportNull$$$0(4);
            }
            return previewDiffSplitterComponent;
        }

        private boolean isEditorPreviewAllowed() {
            return !isOpenEditorDiffPreviewWithSingleClick.asBoolean() || this.myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN;
        }

        private void openEditorPreview(boolean focusEditor) {
            if (this.myEditorDiffPreview == null) {
                return;
            }
            if (!this.isEditorPreviewAllowed()) {
                return;
            }
            this.myEditorDiffPreview.openPreview(focusEditor);
        }

        @Nullable
        private DnDDragStartBean createDragStartBean(@NotNull DnDActionInfo info2) {
            if (info2 == null) {
                ShelfToolWindowPanel.$$$reportNull$$$0(5);
            }
            if (info2.isMove()) {
                DataContext dc = DataManager.getInstance().getDataContext((Component)((Object)this.myTree));
                return new DnDDragStartBean((Object)new ShelvedChangeListDragBean(ShelvedChangesViewManager.getShelveChanges(dc), ShelvedChangesViewManager.getBinaryShelveChanges(dc), ShelvedChangesViewManager.getShelvedLists(dc)));
            }
            return null;
        }

        @NotNull
        private DnDImage createDraggedImage(@NotNull DnDActionInfo info2) {
            if (info2 == null) {
                ShelfToolWindowPanel.$$$reportNull$$$0(6);
            }
            String imageText = VcsBundle.message((String)"unshelve.changes.action", (Object[])new Object[0]);
            Image image = (Image)DnDAwareTree.getDragImage((Tree)this.myTree, imageText, null).getFirst();
            return new DnDImage(image, new Point(-image.getWidth(null), -image.getHeight(null)));
        }

        @Override
        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                ShelfToolWindowPanel.$$$reportNull$$$0(7);
            }
            if (EditorTabDiffPreviewManager.EDITOR_TAB_DIFF_PREVIEW.is(dataId)) {
                return this.myEditorDiffPreview;
            }
            return this.myTree.getData(dataId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeProcessor";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfToolWindowPanel";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfToolWindowPanel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "installEditorPreview";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "installSplitterPreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "installEditorPreview";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "installSplitterPreview";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createDragStartBean";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createDraggedImage";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class MyToggleDetailsAction
        extends ShowDiffPreviewAction {
            private MyToggleDetailsAction() {
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyToggleDetailsAction.$$$reportNull$$$0(0);
                }
                super.update(e);
                e.getPresentation().setEnabledAndVisible(ShelfToolWindowPanel.this.mySplitterDiffPreview != null || isOpenEditorDiffPreviewWithSingleClick.asBoolean());
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    MyToggleDetailsAction.$$$reportNull$$$0(1);
                }
                ((DiffPreview)ObjectUtils.chooseNotNull((Object)ShelfToolWindowPanel.this.mySplitterDiffPreview, (Object)ShelfToolWindowPanel.this.myEditorDiffPreview)).setPreviewVisible(state, false);
                ShelfToolWindowPanel.this.myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN = state;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyToggleDetailsAction.$$$reportNull$$$0(2);
                }
                return ShelfToolWindowPanel.this.myVcsConfiguration.SHELVE_DETAILS_PREVIEW_SHOWN;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfToolWindowPanel$MyToggleDetailsAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static final class MyDnDTarget
    extends VcsToolwindowDnDTarget {
        private MyDnDTarget(@NotNull Project project, @NotNull Content content2) {
            if (project == null) {
                MyDnDTarget.$$$reportNull$$$0(0);
            }
            if (content2 == null) {
                MyDnDTarget.$$$reportNull$$$0(1);
            }
            super(project, content2);
        }

        @Override
        public void drop(DnDEvent event) {
            super.drop(event);
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ChangeListDragBean) {
                FileDocumentManager.getInstance().saveAllDocuments();
                List<Change> changes = Arrays.asList(((ChangeListDragBean)attachedObject).getChanges());
                ShelveChangesManager.getInstance(this.myProject).shelveSilentlyUnderProgress(changes, true);
            }
        }

        @Override
        public boolean isDropPossible(@NotNull DnDEvent event) {
            Object attachedObject;
            if (event == null) {
                MyDnDTarget.$$$reportNull$$$0(2);
            }
            return (attachedObject = event.getAttachedObject()) instanceof ChangeListDragBean && ((ChangeListDragBean)attachedObject).getChanges().length > 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyDnDTarget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDropPossible";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyShelveDeleteProvider
    implements DeleteProvider {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ShelfTree myTree;

        private MyShelveDeleteProvider(@NotNull Project project, @NotNull ShelfTree tree) {
            if (project == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myTree = tree;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(2);
            }
            List shelvedListsToDelete = TreeUtil.collectSelectedObjectsOfType((JTree)((Object)this.myTree), ShelvedChangeList.class);
            List<ShelvedChange> changesToDelete = MyShelveDeleteProvider.getChangesNotInLists(shelvedListsToDelete, ShelvedChangesViewManager.getShelveChanges(dataContext));
            List<ShelvedBinaryFile> binariesToDelete = MyShelveDeleteProvider.getBinariesNotInLists(shelvedListsToDelete, ShelvedChangesViewManager.getBinaryShelveChanges(dataContext));
            ShelveChangesManager manager2 = ShelveChangesManager.getInstance(this.myProject);
            int fileListSize = binariesToDelete.size() + changesToDelete.size();
            Map<ShelvedChangeList, Date> createdDeletedListsWithOriginalDates = manager2.deleteShelves(shelvedListsToDelete, ShelvedChangesViewManager.getShelvedLists(dataContext), changesToDelete, binariesToDelete);
            if (!createdDeletedListsWithOriginalDates.isEmpty()) {
                this.showUndoDeleteNotification(shelvedListsToDelete, fileListSize, createdDeletedListsWithOriginalDates);
            }
        }

        private void showUndoDeleteNotification(@NotNull List<ShelvedChangeList> shelvedListsToDelete, int fileListSize, @NotNull Map<ShelvedChangeList, Date> createdDeletedListsWithOriginalDate) {
            if (shelvedListsToDelete == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(3);
            }
            if (createdDeletedListsWithOriginalDate == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(4);
            }
            String message2 = MyShelveDeleteProvider.constructDeleteSuccessfullyMessage(fileListSize, shelvedListsToDelete.size(), (ShelvedChangeList)ContainerUtil.getFirstItem(shelvedListsToDelete));
            ShelfDeleteNotification shelfDeletionNotification = new ShelfDeleteNotification(message2);
            shelfDeletionNotification.addAction((AnAction)new UndoShelfDeletionAction(this.myProject, createdDeletedListsWithOriginalDate));
            shelfDeletionNotification.addAction(ActionManager.getInstance().getAction("ShelvedChanges.ShowRecentlyDeleted"));
            VcsNotifier.getInstance(this.myProject).showNotificationAndHideExisting(shelfDeletionNotification, ShelfDeleteNotification.class);
        }

        private static List<ShelvedBinaryFile> getBinariesNotInLists(@NotNull List<ShelvedChangeList> listsToDelete, @NotNull List<ShelvedBinaryFile> binaryFiles) {
            if (listsToDelete == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(5);
            }
            if (binaryFiles == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(6);
            }
            ArrayList<ShelvedBinaryFile> result2 = new ArrayList<ShelvedBinaryFile>(binaryFiles);
            for (ShelvedChangeList list2 : listsToDelete) {
                result2.removeAll(list2.getBinaryFiles());
            }
            return result2;
        }

        @NotNull
        private static List<ShelvedChange> getChangesNotInLists(@NotNull List<ShelvedChangeList> listsToDelete, @NotNull List<ShelvedChange> shelvedChanges) {
            if (listsToDelete == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(7);
            }
            if (shelvedChanges == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(8);
            }
            ArrayList<ShelvedChange> result2 = new ArrayList<ShelvedChange>(shelvedChanges);
            listsToDelete.stream().map(list2 -> Objects.requireNonNull(list2.getChanges())).forEach(result2::removeAll);
            ArrayList<ShelvedChange> arrayList = result2;
            if (arrayList == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(9);
            }
            return arrayList;
        }

        @NotNull
        private static String constructDeleteSuccessfullyMessage(int fileNum, int listNum, @Nullable ShelvedChangeList first) {
            String filesMessage;
            String string = filesMessage = fileNum != 0 ? VcsBundle.message((String)"shelve.delete.files.successful.message", (Object[])new Object[]{fileNum}) : "";
            String changelistsMessage = listNum != 0 ? VcsBundle.message((String)"shelve.delete.changelists.message", (Object[])new Object[]{listNum, listNum == 1 && first != null ? first.DESCRIPTION : ""}) : "";
            String string2 = StringUtil.capitalize((String)VcsBundle.message((String)"shelve.delete.successful.message", (Object[])new Object[]{filesMessage, fileNum > 0 && listNum > 0 ? 1 : 0, changelistsMessage}));
            if (string2 == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(10);
            }
            return string2;
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyShelveDeleteProvider.$$$reportNull$$$0(11);
            }
            return !ShelvedChangesViewManager.getShelvedLists(dataContext).isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 2: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shelvedListsToDelete";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "createdDeletedListsWithOriginalDate";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listsToDelete";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "binaryFiles";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shelvedChanges";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangesNotInLists";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "constructDeleteSuccessfullyMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteElement";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "showUndoDeleteNotification";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getBinariesNotInLists";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getChangesNotInLists";
                    break;
                }
                case 9: 
                case 10: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static final class UndoShelfDeletionAction
        extends NotificationAction {
            @NotNull
            private final Project myProject;
            @NotNull
            private final Map<ShelvedChangeList, Date> myListDateMap;

            private UndoShelfDeletionAction(@NotNull Project project, @NotNull Map<ShelvedChangeList, Date> listDateMap) {
                if (project == null) {
                    UndoShelfDeletionAction.$$$reportNull$$$0(0);
                }
                if (listDateMap == null) {
                    UndoShelfDeletionAction.$$$reportNull$$$0(1);
                }
                super(IdeBundle.messagePointer((String)"undo.dialog.title", (Object[])new Object[0]));
                this.myProject = project;
                this.myListDateMap = listDateMap;
            }

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    UndoShelfDeletionAction.$$$reportNull$$$0(2);
                }
                if (notification == null) {
                    UndoShelfDeletionAction.$$$reportNull$$$0(3);
                }
                ShelveChangesManager manager2 = ShelveChangesManager.getInstance(this.myProject);
                List cantRestoreList = ContainerUtil.findAll(this.myListDateMap.keySet(), l -> !manager2.getDeletedLists().contains(l));
                this.myListDateMap.forEach((l, d) -> manager2.restoreList((ShelvedChangeList)l, (Date)d));
                notification.expire();
                if (!cantRestoreList.isEmpty()) {
                    VcsNotifier.getInstance(this.myProject).notifyMinorWarning("vcs.shelve.deletion.undo", VcsBundle.message((String)"shelve.undo.deletion", (Object[])new Object[0]), VcsBundle.message((String)"shelve.changes.restore.error", (Object[])new Object[]{cantRestoreList.size()}));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "listDateMap";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "notification";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelveDeleteProvider$UndoShelfDeletionAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static final class ShelfTree
    extends ChangesTree {
        private List<ShelvedChangeList> myLoadedLists;
        private final DeleteProvider myDeleteProvider;

        private ShelfTree(@NotNull Project project) {
            if (project == null) {
                ShelfTree.$$$reportNull$$$0(0);
            }
            super(project, false, false, true);
            this.myLoadedLists = ContainerUtil.emptyList();
            this.myDeleteProvider = new MyShelveDeleteProvider(this.myProject, this);
            this.setKeepTreeState(true);
            this.setDoubleClickHandler((Processor<? super MouseEvent>)((Processor)e -> this.showShelvedChangesDiff()));
            this.setEnterKeyHandler((Processor<? super KeyEvent>)((Processor)e -> this.showShelvedChangesDiff()));
        }

        public void setLoadedLists(@NotNull List<ShelvedChangeList> lists) {
            if (lists == null) {
                ShelfTree.$$$reportNull$$$0(1);
            }
            this.myLoadedLists = new ArrayList<ShelvedChangeList>(lists);
        }

        public boolean isPathEditable(TreePath path2) {
            return this.isEditable() && this.getSelectionCount() == 1 && path2.getLastPathComponent() instanceof ShelvedListNode;
        }

        @Override
        @NotNull
        protected ChangesGroupingSupport installGroupingSupport() {
            return new ChangesGroupingSupport(this.myProject, this, false);
        }

        @Override
        public int getToggleClickCount() {
            return 2;
        }

        private boolean showShelvedChangesDiff() {
            if (!this.hasExactlySelectedChanges()) {
                return false;
            }
            DiffShelvedChangesActionProvider.showShelvedChangesDiff(DataManager.getInstance().getDataContext((Component)((Object)this)));
            return true;
        }

        private boolean hasExactlySelectedChanges() {
            return !UtilKt.isEmpty(VcsTreeModelData.exactlySelected((JTree)((Object)this)).userObjectsStream(ShelvedWrapper.class));
        }

        @Override
        public void rebuildTree() {
            boolean showRecycled = ShelveChangesManager.getInstance(this.myProject).isShowRecycled();
            MyShelvedTreeModelBuilder modelBuilder2 = new MyShelvedTreeModelBuilder(this.myProject, this.getGrouping());
            modelBuilder2.setShelvedLists(ContainerUtil.filter(this.myLoadedLists, l -> !l.isDeleted() && (showRecycled || !l.isRecycled())));
            modelBuilder2.setDeletedShelvedLists(ContainerUtil.filter(this.myLoadedLists, ShelvedChangeList::isDeleted));
            this.updateTreeModel(modelBuilder2.build());
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                ShelfTree.$$$reportNull$$$0(2);
            }
            if (SHELVED_CHANGES_TREE.is(dataId)) {
                return this;
            }
            if (SHELVED_CHANGELIST_KEY.is(dataId)) {
                return new ArrayList<ShelvedChangeList>(ShelvedChangesViewManager.getSelectedLists(this, l -> !l.isRecycled() && !l.isDeleted()));
            }
            if (SHELVED_RECYCLED_CHANGELIST_KEY.is(dataId)) {
                return new ArrayList<ShelvedChangeList>(ShelvedChangesViewManager.getSelectedLists(this, l -> l.isRecycled() && !l.isDeleted()));
            }
            if (SHELVED_DELETED_CHANGELIST_KEY.is(dataId)) {
                return new ArrayList<ShelvedChangeList>(ShelvedChangesViewManager.getSelectedLists(this, l -> l.isDeleted()));
            }
            if (SHELVED_CHANGE_KEY.is(dataId)) {
                return StreamEx.of(VcsTreeModelData.selected((JTree)((Object)this)).userObjectsStream(ShelvedWrapper.class)).map(s -> s.getShelvedChange()).nonNull().toList();
            }
            if (SHELVED_BINARY_FILE_KEY.is(dataId)) {
                return StreamEx.of(VcsTreeModelData.selected((JTree)((Object)this)).userObjectsStream(ShelvedWrapper.class)).map(s -> s.getBinaryFile()).nonNull().toList();
            }
            if (VcsDataKeys.HAVE_SELECTED_CHANGES.is(dataId)) {
                return this.getSelectionCount() > 0;
            }
            if (VcsDataKeys.CHANGES.is(dataId)) {
                List<ShelvedWrapper> shelvedChanges = VcsTreeModelData.selected((JTree)((Object)this)).userObjects(ShelvedWrapper.class);
                if (!shelvedChanges.isEmpty()) {
                    return ContainerUtil.map2Array(shelvedChanges, Change.class, s -> s.getChange(this.myProject));
                }
            } else {
                if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
                    return this.myDeleteProvider;
                }
                if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                    List<ShelvedWrapper> shelvedChanges = VcsTreeModelData.selected((JTree)((Object)this)).userObjects(ShelvedWrapper.class);
                    ArrayDeque<1> navigatables = new ArrayDeque<1>();
                    for (final ShelvedWrapper shelvedChange : shelvedChanges) {
                        if (shelvedChange.getBeforePath() == null || FileStatus.ADDED.equals(shelvedChange.getFileStatus())) continue;
                        NavigatableAdapter navigatable = new NavigatableAdapter(){

                            public void navigate(boolean requestFocus) {
                                VirtualFile vf = shelvedChange.getBeforeVFUnderProject(myProject);
                                if (vf != null) {
                                    1.navigate((Project)myProject, (VirtualFile)vf, (boolean)true);
                                }
                            }
                        };
                        navigatables.add(navigatable);
                    }
                    return navigatables.toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY);
                }
            }
            return super.getData(dataId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lists";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$ShelfTree";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setLoadedLists";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ChangelistComparator
    implements Comparator<ShelvedChangeList> {
        private static final ChangelistComparator ourInstance = new ChangelistComparator();

        ChangelistComparator() {
        }

        public static ChangelistComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(ShelvedChangeList o1, ShelvedChangeList o2) {
            return o2.DATE.compareTo(o1.DATE);
        }
    }

    private static final class MyShelvedTreeModelBuilder
    extends TreeModelBuilder {
        private MyShelvedTreeModelBuilder(Project project, @NotNull ChangesGroupingPolicyFactory grouping2) {
            if (grouping2 == null) {
                MyShelvedTreeModelBuilder.$$$reportNull$$$0(0);
            }
            super(project, grouping2);
        }

        public void setShelvedLists(@NotNull List<ShelvedChangeList> shelvedLists) {
            if (shelvedLists == null) {
                MyShelvedTreeModelBuilder.$$$reportNull$$$0(1);
            }
            this.createShelvedListsWithChangesNode(shelvedLists, this.myRoot);
        }

        public void setDeletedShelvedLists(@NotNull List<ShelvedChangeList> shelvedLists) {
            if (shelvedLists == null) {
                MyShelvedTreeModelBuilder.$$$reportNull$$$0(2);
            }
            this.createShelvedListsWithChangesNode(shelvedLists, this.createTagNode(VcsBundle.message((String)"shelve.recently.deleted.node", (Object[])new Object[0])));
        }

        private void createShelvedListsWithChangesNode(@NotNull List<ShelvedChangeList> shelvedLists, @NotNull ChangesBrowserNode<?> parentNode) {
            if (shelvedLists == null) {
                MyShelvedTreeModelBuilder.$$$reportNull$$$0(3);
            }
            if (parentNode == null) {
                MyShelvedTreeModelBuilder.$$$reportNull$$$0(4);
            }
            shelvedLists.forEach(changeList -> {
                ArrayList<ShelvedWrapper> shelvedChanges = new ArrayList<ShelvedWrapper>();
                Objects.requireNonNull(changeList.getChanges()).stream().map(ShelvedWrapper::new).forEach(shelvedChanges::add);
                changeList.getBinaryFiles().stream().map(ShelvedWrapper::new).forEach(shelvedChanges::add);
                shelvedChanges.sort(Comparator.comparing(s -> s.getChange(this.myProject), CHANGE_COMPARATOR));
                ShelvedListNode shelvedListNode = new ShelvedListNode((ShelvedChangeList)changeList);
                this.insertSubtreeRoot(shelvedListNode, parentNode);
                for (ShelvedWrapper shelved : shelvedChanges) {
                    Change change = shelved.getChange(this.myProject);
                    FilePath filePath = ChangesUtil.getFilePath((Change)change);
                    this.insertChangeNode(change, shelvedListNode, new ShelvedChangeNode(shelved, filePath, change.getOriginText(this.myProject)));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grouping";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shelvedLists";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentNode";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedChangesViewManager$MyShelvedTreeModelBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setShelvedLists";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setDeletedShelvedLists";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createShelvedListsWithChangesNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

