/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.CompareWithLocalDialog;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsDiffUtil {
    @Nls
    @NotNull
    public static String getRevisionTitle(@NotNull @NlsSafe String revision, boolean localMark) {
        if (revision == null) {
            VcsDiffUtil.$$$reportNull$$$0(0);
        }
        String string = revision + (String)(localMark ? " (" + VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]) + ")" : "");
        if (string == null) {
            VcsDiffUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public static String getRevisionTitle(@NotNull @NlsSafe String revision, @Nullable FilePath file2, @Nullable FilePath baseFile) {
        if (revision == null) {
            VcsDiffUtil.$$$reportNull$$$0(2);
        }
        String string = revision + (String)(file2 == null || VcsFileUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals((Object)baseFile, (Object)file2) ? "" : " (" + VcsDiffUtil.getRelativeFileName(baseFile, file2) + ")");
        if (string == null) {
            VcsDiffUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static void putFilePathsIntoChangeContext(@NotNull Change change, @NotNull Map<Key<?>, Object> context2) {
        if (change == null) {
            VcsDiffUtil.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            VcsDiffUtil.$$$reportNull$$$0(5);
        }
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        FilePath aFile = afterRevision == null ? null : afterRevision.getFile();
        FilePath bFile = beforeRevision == null ? null : beforeRevision.getFile();
        context2.put(DiffUserDataKeysEx.VCS_DIFF_RIGHT_CONTENT_TITLE, VcsDiffUtil.getRevisionTitle(afterRevision, aFile, null));
        context2.put(DiffUserDataKeysEx.VCS_DIFF_LEFT_CONTENT_TITLE, VcsDiffUtil.getRevisionTitle(beforeRevision, bFile, aFile));
    }

    @Nls
    @NotNull
    public static String getRevisionTitle(@Nullable ContentRevision revision, @Nullable FilePath file2, @Nullable FilePath baseFile) {
        return VcsDiffUtil.getRevisionTitle(VcsDiffUtil.getShortHash(revision), file2, baseFile);
    }

    @NlsSafe
    @NotNull
    private static String getShortHash(@Nullable ContentRevision revision) {
        if (revision == null) {
            return "";
        }
        VcsRevisionNumber revisionNumber = revision.getRevisionNumber();
        if (revisionNumber instanceof ShortVcsRevisionNumber) {
            String string = ((ShortVcsRevisionNumber)revisionNumber).toShortString();
            if (string == null) {
                VcsDiffUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = revisionNumber.asString();
        if (string == null) {
            VcsDiffUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    private static String getRelativeFileName(@Nullable FilePath baseFile, @NotNull FilePath file2) {
        if (file2 == null) {
            VcsDiffUtil.$$$reportNull$$$0(8);
        }
        if (baseFile == null || !baseFile.getName().equals(file2.getName())) {
            String string = file2.getName();
            if (string == null) {
                VcsDiffUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        FilePath aParentPath = baseFile.getParentPath();
        if (aParentPath == null) {
            String string = file2.getName();
            if (string == null) {
                VcsDiffUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = VcsFileUtil.relativePath(aParentPath.getIOFile(), file2.getIOFile());
        if (string == null) {
            VcsDiffUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static void showChangesDialog(@NotNull Project project, @NotNull @NlsContexts.DialogTitle String string, @NotNull List<? extends Change> list2) {
        void changes;
        void title2;
        Project project2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project2 == null) {
            VcsDiffUtil.$$$reportNull$$$0(12);
        }
        if (title2 == null) {
            VcsDiffUtil.$$$reportNull$$$0(13);
        }
        if (changes == null) {
            VcsDiffUtil.$$$reportNull$$$0(14);
        }
        DialogBuilder dialogBuilder = new DialogBuilder(project2);
        dialogBuilder.setTitle((String)title2);
        dialogBuilder.setActionDescriptors(new DialogBuilder.ActionDescriptor[]{new DialogBuilder.CloseDialogAction()});
        SimpleChangesBrowser changesBrowser2 = new SimpleChangesBrowser(project2, false, true);
        changesBrowser2.setChangesToDisplay((Collection<? extends Change>)changes);
        dialogBuilder.setCenterPanel((JComponent)changesBrowser2);
        dialogBuilder.setPreferredFocusComponent(changesBrowser2.getPreferredFocusedComponent());
        dialogBuilder.setDimensionServiceKey("VcsDiffUtil.ChangesDialog");
        dialogBuilder.showNotModal();
    }

    @NotNull
    public static List<Change> createChangesWithCurrentContentForFile(@NotNull FilePath filePath, @Nullable ContentRevision beforeContentRevision) {
        if (filePath == null) {
            VcsDiffUtil.$$$reportNull$$$0(15);
        }
        List<Change> list2 = Collections.singletonList(new Change(beforeContentRevision, CurrentContentRevision.create((FilePath)filePath)));
        if (list2 == null) {
            VcsDiffUtil.$$$reportNull$$$0(16);
        }
        return list2;
    }

    public static void showChangesWithWorkingDirLater(@NotNull Project project, @NotNull VirtualFile file2, @NotNull VcsRevisionNumber targetRevNumber, @NotNull DiffProvider provider2) {
        if (project == null) {
            VcsDiffUtil.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            VcsDiffUtil.$$$reportNull$$$0(18);
        }
        if (targetRevNumber == null) {
            VcsDiffUtil.$$$reportNull$$$0(19);
        }
        if (provider2 == null) {
            VcsDiffUtil.$$$reportNull$$$0(20);
        }
        String revNumTitle1 = VcsDiffUtil.getRevisionTitle(VcsUtil.getShortRevisionString((VcsRevisionNumber)targetRevNumber), false);
        String revNumTitle2 = VcsBundle.message((String)"diff.title.local", (Object[])new Object[0]);
        String dialogTitle = VcsBundle.message((String)"history.dialog.title.difference.between.versions.in", (Object[])new Object[]{revNumTitle1, revNumTitle2, VcsUtil.getFilePath((VirtualFile)file2)});
        CompareWithLocalDialog.showDialog(project, dialogTitle, CompareWithLocalDialog.LocalContent.AFTER, (ThrowableComputable<? extends Collection<Change>, ? extends VcsException>)((ThrowableComputable)() -> provider2.compareWithWorkingDir(file2, targetRevNumber)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/VcsDiffUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRevNumber";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/VcsDiffUtil";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionTitle";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortHash";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeFileName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createChangesWithCurrentContentForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionTitle";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putFilePathsIntoChangeContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeFileName";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showChangesDialog";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createChangesWithCurrentContentForFile";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showChangesWithWorkingDirLater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

