/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vcs.ex.ExclusionState;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PartialChangesUtil {
    private static final Logger LOG = Logger.getInstance(PartialChangesUtil.class);

    @Nullable
    public static PartialLocalLineStatusTracker getPartialTracker(@NotNull Project project, @NotNull Change change) {
        VirtualFile file2;
        if (project == null) {
            PartialChangesUtil.$$$reportNull$$$0(0);
        }
        if (change == null) {
            PartialChangesUtil.$$$reportNull$$$0(1);
        }
        if ((file2 = PartialChangesUtil.getVirtualFile(change)) == null) {
            return null;
        }
        return PartialChangesUtil.getPartialTracker(project, file2);
    }

    @Nullable
    public static PartialLocalLineStatusTracker getPartialTracker(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            PartialChangesUtil.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            PartialChangesUtil.$$$reportNull$$$0(3);
        }
        LineStatusTracker<?> tracker2 = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(file2);
        return (PartialLocalLineStatusTracker)ObjectUtils.tryCast(tracker2, PartialLocalLineStatusTracker.class);
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull Change change) {
        ContentRevision revision;
        if (change == null) {
            PartialChangesUtil.$$$reportNull$$$0(4);
        }
        if (!((revision = change.getAfterRevision()) instanceof CurrentContentRevision)) {
            return null;
        }
        return ((CurrentContentRevision)revision).getVirtualFile();
    }

    @NotNull
    public static List<Change> processPartialChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes, boolean executeOnEDT, @NotNull PairFunction<? super List<ChangeListChange>, ? super PartialLocalLineStatusTracker, Boolean> partialProcessor) {
        if (project == null) {
            PartialChangesUtil.$$$reportNull$$$0(5);
        }
        if (changes == null) {
            PartialChangesUtil.$$$reportNull$$$0(6);
        }
        if (partialProcessor == null) {
            PartialChangesUtil.$$$reportNull$$$0(7);
        }
        if (!LineStatusTrackerManager.getInstance(project).arePartialChangelistsEnabled() || !ContainerUtil.exists(changes, it -> it instanceof ChangeListChange)) {
            return new ArrayList<Change>(changes);
        }
        ArrayList<Change> otherChanges = new ArrayList<Change>();
        Runnable task2 = () -> {
            VirtualFile virtualFile2;
            MultiMap partialChangesMap = new MultiMap();
            for (Change change : changes) {
                if (change instanceof ChangeListChange) {
                    ChangeListChange changelistChange = (ChangeListChange)change;
                    virtualFile2 = PartialChangesUtil.getVirtualFile(change);
                    if (virtualFile2 != null) {
                        partialChangesMap.putValue((Object)virtualFile2, (Object)changelistChange);
                        continue;
                    }
                    otherChanges.add(changelistChange.getChange());
                    continue;
                }
                otherChanges.add(change);
            }
            LineStatusTrackerManagerI lstManager = LineStatusTrackerManager.getInstance(project);
            for (Map.Entry entry2 : partialChangesMap.entrySet()) {
                virtualFile2 = (VirtualFile)entry2.getKey();
                List partialChanges = (List)entry2.getValue();
                Change actualChange = ((ChangeListChange)partialChanges.get(0)).getChange();
                PartialLocalLineStatusTracker tracker2 = (PartialLocalLineStatusTracker)ObjectUtils.tryCast(lstManager.getLineStatusTracker(virtualFile2), PartialLocalLineStatusTracker.class);
                if (tracker2 == null) {
                    otherChanges.add(actualChange);
                    continue;
                }
                boolean success2 = (Boolean)partialProcessor.fun((Object)partialChanges, (Object)tracker2);
                if (success2) continue;
                otherChanges.add(actualChange);
            }
        };
        if (executeOnEDT && !ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeAndWait(task2);
        } else {
            task2.run();
        }
        ArrayList<Change> arrayList = otherChanges;
        if (arrayList == null) {
            PartialChangesUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public static void runUnderChangeList(@NotNull Project project, @Nullable LocalChangeList targetChangeList, @NotNull Runnable task2) {
        if (project == null) {
            PartialChangesUtil.$$$reportNull$$$0(9);
        }
        if (task2 == null) {
            PartialChangesUtil.$$$reportNull$$$0(10);
        }
        PartialChangesUtil.computeUnderChangeList(project, targetChangeList, () -> {
            task2.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T computeUnderChangeList(@NotNull Project project, @Nullable LocalChangeList targetChangeList, @NotNull Computable<T> task2) {
        if (project == null) {
            PartialChangesUtil.$$$reportNull$$$0(11);
        }
        if (task2 == null) {
            PartialChangesUtil.$$$reportNull$$$0(12);
        }
        ChangeListManagerEx changeListManager = ChangeListManagerEx.getInstanceEx(project);
        LocalChangeList oldDefaultList = changeListManager.getDefaultChangeList();
        if (targetChangeList == null || targetChangeList.equals(oldDefaultList) || !changeListManager.areChangeListsEnabled()) {
            return (T)task2.compute();
        }
        PartialChangesUtil.switchChangeList(changeListManager, targetChangeList, oldDefaultList);
        ChangelistConflictTracker clmConflictTracker = ChangelistConflictTracker.getInstance(project);
        try {
            clmConflictTracker.setIgnoreModifications(true);
            Object object = task2.compute();
            return (T)object;
        }
        finally {
            clmConflictTracker.setIgnoreModifications(false);
            PartialChangesUtil.restoreChangeList(changeListManager, targetChangeList, oldDefaultList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T computeUnderChangeListSync(@NotNull Project project, @Nullable LocalChangeList targetChangeList, @NotNull Computable<T> task2) {
        if (project == null) {
            PartialChangesUtil.$$$reportNull$$$0(13);
        }
        if (task2 == null) {
            PartialChangesUtil.$$$reportNull$$$0(14);
        }
        ChangeListManagerEx changeListManager = ChangeListManagerEx.getInstanceEx(project);
        LocalChangeList oldDefaultList = changeListManager.getDefaultChangeList();
        if (targetChangeList == null || !changeListManager.areChangeListsEnabled()) {
            return (T)task2.compute();
        }
        PartialChangesUtil.switchChangeList(changeListManager, targetChangeList, oldDefaultList);
        ChangelistConflictTracker clmConflictTracker = ChangelistConflictTracker.getInstance(project);
        try {
            clmConflictTracker.setIgnoreModifications(true);
            Object object = task2.compute();
            return (T)object;
        }
        finally {
            clmConflictTracker.setIgnoreModifications(false);
            if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                LOG.warn("Can't wait till changes are applied while holding read lock", new Throwable());
            } else {
                ChangeListManagerEx.getInstanceEx(project).waitForUpdate();
            }
            PartialChangesUtil.restoreChangeList(changeListManager, targetChangeList, oldDefaultList);
        }
    }

    private static void switchChangeList(@NotNull ChangeListManagerEx clm, @NotNull LocalChangeList targetChangeList, @NotNull LocalChangeList oldDefaultList) {
        if (clm == null) {
            PartialChangesUtil.$$$reportNull$$$0(15);
        }
        if (targetChangeList == null) {
            PartialChangesUtil.$$$reportNull$$$0(16);
        }
        if (oldDefaultList == null) {
            PartialChangesUtil.$$$reportNull$$$0(17);
        }
        clm.setDefaultChangeList(targetChangeList, true);
        LOG.debug(String.format("Active changelist changed: %s -> %s", oldDefaultList.getName(), targetChangeList.getName()));
    }

    private static void restoreChangeList(@NotNull ChangeListManagerEx clm, @NotNull LocalChangeList targetChangeList, @NotNull LocalChangeList oldDefaultList) {
        LocalChangeList defaultChangeList;
        if (clm == null) {
            PartialChangesUtil.$$$reportNull$$$0(18);
        }
        if (targetChangeList == null) {
            PartialChangesUtil.$$$reportNull$$$0(19);
        }
        if (oldDefaultList == null) {
            PartialChangesUtil.$$$reportNull$$$0(20);
        }
        if (Objects.equals((defaultChangeList = clm.getDefaultChangeList()).getId(), targetChangeList.getId())) {
            clm.setDefaultChangeList(oldDefaultList, true);
            LOG.debug(String.format("Active changelist restored: %s -> %s", targetChangeList.getName(), oldDefaultList.getName()));
        } else {
            LOG.warn(new Throwable(String.format("Active changelist was changed during the operation. Expected: %s -> %s, actual default: %s", targetChangeList.getName(), oldDefaultList.getName(), defaultChangeList.getName())));
        }
    }

    @NotNull
    public static ThreeStateCheckBox.State convertExclusionState(@NotNull ExclusionState exclusionState) {
        if (exclusionState == null) {
            PartialChangesUtil.$$$reportNull$$$0(21);
        }
        if (exclusionState == ExclusionState.ALL_INCLUDED) {
            ThreeStateCheckBox.State state = ThreeStateCheckBox.State.SELECTED;
            if (state == null) {
                PartialChangesUtil.$$$reportNull$$$0(22);
            }
            return state;
        }
        if (exclusionState == ExclusionState.ALL_EXCLUDED) {
            ThreeStateCheckBox.State state = ThreeStateCheckBox.State.NOT_SELECTED;
            if (state == null) {
                PartialChangesUtil.$$$reportNull$$$0(23);
            }
            return state;
        }
        ThreeStateCheckBox.State state = ThreeStateCheckBox.State.DONT_CARE;
        if (state == null) {
            PartialChangesUtil.$$$reportNull$$$0(24);
        }
        return state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialProcessor";
                break;
            }
            case 8: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/PartialChangesUtil";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clm";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetChangeList";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldDefaultList";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exclusionState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/PartialChangesUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "processPartialChanges";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "convertExclusionState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPartialTracker";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processPartialChanges";
                break;
            }
            case 8: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runUnderChangeList";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "computeUnderChangeList";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeUnderChangeListSync";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "switchChangeList";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "restoreChangeList";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "convertExclusionState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

