/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.util.CompressionUtil;
import com.intellij.util.hash.ContentHashEnumerator;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.util.io.storage.RefCountingContentStorage;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PersistentFSContentAccessor {
    private static final Logger LOG = Logger.getInstance(PersistentFSContentAccessor.class);
    private final boolean myUseContentHashes;
    private final PersistentFSConnection myFSConnection;
    private long totalContents;
    private long totalReuses;
    private long time;
    private int contents;
    private int reuses;

    PersistentFSContentAccessor(boolean useContentHashes, @NotNull PersistentFSConnection connection) {
        if (connection == null) {
            PersistentFSContentAccessor.$$$reportNull$$$0(0);
        }
        this.myUseContentHashes = useContentHashes;
        this.myFSConnection = connection;
    }

    @Nullable
    ThrowableComputable<DataInputStream, IOException> readContent(int fileId) throws IOException {
        PersistentFSConnection.ensureIdIsValid(fileId);
        int page = this.myFSConnection.getRecords().getContentRecordId(fileId);
        if (page == 0) {
            return null;
        }
        return () -> this.readContentDirectly(page);
    }

    DataInputStream readContentDirectly(int contentId) throws IOException {
        DataInputStream stream = this.myFSConnection.getContents().readStream(contentId);
        if (FSRecords.useCompressionUtil) {
            byte[] bytes = CompressionUtil.readCompressed((DataInput)stream);
            stream = new DataInputStream((InputStream)new UnsyncByteArrayInputStream(bytes));
        }
        return stream;
    }

    void deleteContent(int fileId) throws IOException {
        int contentPage = this.myFSConnection.getRecords().getContentRecordId(fileId);
        if (contentPage != 0) {
            this.releaseContentRecord(contentPage);
        }
    }

    void releaseContentRecord(int contentId) throws IOException {
        this.myFSConnection.getContents().releaseRecord(contentId);
    }

    boolean writeContent(int fileId, @NotNull ByteArraySequence bytes, boolean fixedSize) throws IOException {
        ByteArraySequence newBytes;
        int page;
        if (bytes == null) {
            PersistentFSContentAccessor.$$$reportNull$$$0(1);
        }
        PersistentFSConnection connection = this.myFSConnection;
        PersistentFSConnection.ensureIdIsValid(fileId);
        boolean modified = false;
        RefCountingContentStorage contentStorage = connection.getContents();
        if (this.myUseContentHashes) {
            int value2;
            page = this.findOrCreateContentRecord(bytes.getInternalBuffer(), bytes.getOffset(), bytes.getLength());
            if (page < 0 || connection.getRecords().getContentRecordId(fileId) != page) {
                modified = true;
                value2 = page > 0 ? page : -page;
                connection.getRecords().setContentRecordId(fileId, value2);
            }
            value2 = page > 0 ? page : -page;
            connection.getRecords().setContentRecordId(fileId, value2);
            if (page > 0) {
                return modified;
            }
            page = -page;
            fixedSize = true;
        } else {
            page = connection.getRecords().getContentRecordId(fileId);
            if (page == 0 || contentStorage.getRefCount(page) > 1) {
                page = contentStorage.acquireNewRecord();
                connection.getRecords().setContentRecordId(fileId, page);
            }
        }
        if (FSRecords.useCompressionUtil) {
            BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)out);){
                CompressionUtil.writeCompressed((DataOutput)outputStream, (byte[])bytes.getInternalBuffer(), (int)bytes.getOffset(), (int)bytes.getLength());
            }
            newBytes = out.toByteArraySequence();
        } else {
            newBytes = bytes;
        }
        contentStorage.writeBytes(page, newBytes, fixedSize);
        return true;
    }

    int allocateContentRecordAndStore(byte @NotNull [] bytes) throws IOException {
        int recordId;
        if (bytes == null) {
            PersistentFSContentAccessor.$$$reportNull$$$0(2);
        }
        if (this.myUseContentHashes) {
            recordId = this.findOrCreateContentRecord(bytes, 0, bytes.length);
            if (recordId > 0) {
                return recordId;
            }
            recordId = -recordId;
        } else {
            recordId = this.myFSConnection.getContents().acquireNewRecord();
        }
        try (AbstractStorage.StorageDataOutput output2 = this.myFSConnection.getContents().writeStream(recordId, true);){
            output2.write(bytes);
        }
        return recordId;
    }

    byte @Nullable [] getContentHash(int fileId) throws IOException {
        if (!this.myUseContentHashes) {
            return null;
        }
        int contentId = this.myFSConnection.getRecords().getContentRecordId(fileId);
        return contentId <= 0 ? null : this.myFSConnection.getContentHashesEnumerator().valueOf(contentId);
    }

    private int findOrCreateContentRecord(byte[] bytes, int offset, int length) throws IOException {
        assert (this.myUseContentHashes);
        long started = System.nanoTime();
        byte[] contentHash = PersistentFSContentAccessor.calculateHash(bytes, offset, length);
        long done = System.nanoTime() - started;
        this.time += done;
        ++this.contents;
        this.totalContents += (long)length;
        if ((this.contents & 0x3FFF) == 0) {
            LOG.info("Contents:" + this.contents + " of " + this.totalContents + ", reuses:" + this.reuses + " of " + this.totalReuses + " for " + this.time / 1000000L);
        }
        ContentHashEnumerator hashesEnumerator = this.myFSConnection.getContentHashesEnumerator();
        int largestId = hashesEnumerator.getLargestId();
        int page = hashesEnumerator.enumerate(contentHash);
        if (page <= largestId) {
            ++this.reuses;
            this.myFSConnection.getContents().acquireRecord(page);
            this.totalReuses += (long)length;
            return page;
        }
        int newRecord = this.myFSConnection.getContents().acquireNewRecord();
        assert (page == newRecord) : "Unexpected content storage modification: page=" + page + "; newRecord=" + newRecord;
        return -page;
    }

    int acquireContentRecord(int fileId) throws IOException {
        int record = this.myFSConnection.getRecords().getContentRecordId(fileId);
        if (record > 0) {
            this.myFSConnection.getContents().acquireRecord(record);
        }
        return record;
    }

    void checkContentsStorageSanity(int id2) throws IOException {
        int recordId = this.myFSConnection.getRecords().getContentRecordId(id2);
        assert (recordId >= 0);
        if (recordId > 0) {
            this.myFSConnection.getContents().checkSanity(recordId);
        }
    }

    @NotNull
    private static MessageDigest getContentHashDigest() {
        MessageDigest messageDigest = DigestUtil.sha1();
        if (messageDigest == null) {
            PersistentFSContentAccessor.$$$reportNull$$$0(3);
        }
        return messageDigest;
    }

    private static byte @NotNull [] calculateHash(byte[] bytes, int offset, int length) {
        MessageDigest digest = PersistentFSContentAccessor.getContentHashDigest();
        digest.update(String.valueOf(length).getBytes(StandardCharsets.UTF_8));
        digest.update("\u0000".getBytes(StandardCharsets.UTF_8));
        digest.update(bytes, offset, length);
        byte[] byArray = digest.digest();
        if (byArray == null) {
            PersistentFSContentAccessor.$$$reportNull$$$0(4);
        }
        return byArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSContentAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSContentAccessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentHashDigest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeContent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "allocateContentRecordAndStore";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    final class ContentOutputStream
    extends DataOutputStream {
        private final int myFileId;
        private final boolean myFixedSize;
        boolean myModified;

        ContentOutputStream(int fileId, boolean readOnly) {
            super((OutputStream)new BufferExposingByteArrayOutputStream());
            PersistentFSConnection.ensureIdIsValid(fileId);
            this.myFileId = fileId;
            this.myFixedSize = readOnly;
        }

        public void close() throws IOException {
            super.close();
            BufferExposingByteArrayOutputStream _out = (BufferExposingByteArrayOutputStream)this.out;
            if (PersistentFSContentAccessor.this.writeContent(this.myFileId, _out.toByteArraySequence(), this.myFixedSize)) {
                this.myModified = true;
            }
        }

        boolean isModified() {
            return this.myModified;
        }
    }
}

