/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.DesktopLayoutKt;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.util.xmlb.BeanBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!B\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u000fJ\u0006\u0010\u0010\u001a\u00020\u0000J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u0004J\u0015\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00192\u0006\u0010 \u001a\u00020\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/wm/impl/DesktopLayout;", "", "idToInfo", "", "", "Lcom/intellij/openapi/wm/impl/WindowInfoImpl;", "(Ljava/util/Map;)V", "stateModificationCount", "", "getStateModificationCount", "()J", "addInfo", "", "id", "info", "addInfo$intellij_platform_ide_impl", "copy", "createDefaultInfo", "getInfo", "getOrCreate", "task", "Lcom/intellij/openapi/wm/RegisterToolWindowTask;", "getOrCreate$intellij_platform_ide_impl", "readExternal", "layoutElement", "Lorg/jdom/Element;", "setAnchor", "newAnchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "suppliedNewOrder", "", "writeExternal", "tagName", "Companion", "intellij.platform.ide.impl"})
public final class DesktopLayout {
    private final Map<String, WindowInfoImpl> idToInfo;
    @NonNls
    @NotNull
    public static final String TAG = "layout";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final DesktopLayout copy() {
        HashMap<String, WindowInfoImpl> map2 = new HashMap<String, WindowInfoImpl>(this.idToInfo.size());
        Map<String, WindowInfoImpl> map3 = this.idToInfo;
        boolean bl = false;
        for (Map.Entry<String, WindowInfoImpl> entry2 : map3.entrySet()) {
            map2.put(entry2.getKey(), entry2.getValue().copy());
        }
        return new DesktopLayout((Map<String, WindowInfoImpl>)map2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final WindowInfoImpl getOrCreate$intellij_platform_ide_impl(@NotNull RegisterToolWindowTask task2) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Map<String, WindowInfoImpl> map2 = this.idToInfo;
        String key$iv = task2.getId();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            WindowInfoImpl info2 = this.createDefaultInfo(task2.getId());
            info2.setAnchor(task2.getAnchor());
            info2.setSplit(task2.getSideTool());
            WindowInfoImpl answer$iv = info2;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (WindowInfoImpl)object;
    }

    private final WindowInfoImpl createDefaultInfo(String id2) {
        WindowInfoImpl info2 = new WindowInfoImpl();
        info2.setId(id2);
        info2.setFromPersistentSettings$intellij_platform_ide_impl(false);
        Collection<WindowInfoImpl> collection = this.idToInfo.values();
        ToolWindowAnchor toolWindowAnchor = info2.getAnchor();
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"info.anchor");
        info2.setOrder(DesktopLayoutKt.access$getMaxOrder(collection, toolWindowAnchor) + 1);
        return info2;
    }

    @Nullable
    public final WindowInfoImpl getInfo(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return this.idToInfo.get(id2);
    }

    public final void addInfo$intellij_platform_ide_impl(@NotNull String id2, @NotNull WindowInfoImpl info2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        WindowInfoImpl old = this.idToInfo.put(id2, info2);
        DesktopLayoutKt.access$getLOG$p().assertTrue(old == null);
    }

    /*
     * WARNING - void declaration
     */
    public final void setAnchor(@NotNull WindowInfoImpl info2, @NotNull ToolWindowAnchor newAnchor, int suppliedNewOrder) {
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        Intrinsics.checkNotNullParameter((Object)newAnchor, (String)"newAnchor");
        int newOrder = suppliedNewOrder;
        if (newOrder == -1) {
            newOrder = DesktopLayoutKt.access$getMaxOrder(this.idToInfo.values(), newAnchor) + 1;
        }
        ToolWindowAnchor toolWindowAnchor = info2.getAnchor();
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"info.anchor");
        ToolWindowAnchor oldAnchor = toolWindowAnchor;
        List infos = DesktopLayoutKt.access$getAllInfos(this.idToInfo.values(), newAnchor);
        int n = infos.size() - 1;
        boolean bl = false;
        while (n >= 0) {
            void i2;
            WindowInfoImpl info22 = (WindowInfoImpl)infos.get((int)i2);
            if (newOrder <= info22.getOrder()) {
                info22.setOrder(info22.getOrder() + 1);
            }
            --i2;
        }
        info2.setAnchor(newAnchor);
        info2.setOrder(newOrder);
        DesktopLayoutKt.access$normalizeOrder(DesktopLayoutKt.access$getAllInfos(this.idToInfo.values(), oldAnchor));
        if (Intrinsics.areEqual((Object)oldAnchor, (Object)newAnchor) ^ true) {
            DesktopLayoutKt.access$normalizeOrder(DesktopLayoutKt.access$getAllInfos(this.idToInfo.values(), newAnchor));
        }
    }

    public final void readExternal(@NotNull Element layoutElement) {
        Intrinsics.checkNotNullParameter((Object)layoutElement, (String)"layoutElement");
        BeanBinding beanBinding = com.intellij.util.xmlb.XmlSerializer.getBeanBinding(WindowInfoImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)beanBinding, (String)"XmlSerializer.getBeanBin\u2026ndowInfoImpl::class.java)");
        BeanBinding infoBinding = beanBinding;
        boolean bl = false;
        List list2 = new ArrayList();
        for (Element element2 : layoutElement.getChildren("window_info")) {
            WindowInfoImpl info2 = new WindowInfoImpl();
            infoBinding.deserializeInto((Object)info2, element2);
            info2.normalizeAfterRead$intellij_platform_ide_impl();
            String id2 = info2.getId();
            if (id2 == null) {
                DesktopLayoutKt.access$getLOG$p().warn("Skip invalid window info (no id): " + JDOMUtil.writeElement((Element)element2));
                continue;
            }
            if (info2.getOrder() == -1) {
                Collection collection = list2;
                ToolWindowAnchor toolWindowAnchor = info2.getAnchor();
                Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"info.anchor");
                info2.setOrder(DesktopLayoutKt.access$getMaxOrder(collection, toolWindowAnchor) + 1);
            }
            this.idToInfo.put(id2, info2);
            list2.add(info2);
        }
        Collection collection = list2;
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.TOP;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"ToolWindowAnchor.TOP");
        DesktopLayoutKt.access$normalizeOrder(DesktopLayoutKt.access$getAllInfos(collection, toolWindowAnchor));
        Collection collection2 = list2;
        ToolWindowAnchor toolWindowAnchor2 = ToolWindowAnchor.LEFT;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor2, (String)"ToolWindowAnchor.LEFT");
        DesktopLayoutKt.access$normalizeOrder(DesktopLayoutKt.access$getAllInfos(collection2, toolWindowAnchor2));
        Collection collection3 = list2;
        ToolWindowAnchor toolWindowAnchor3 = ToolWindowAnchor.BOTTOM;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor3, (String)"ToolWindowAnchor.BOTTOM");
        DesktopLayoutKt.access$normalizeOrder(DesktopLayoutKt.access$getAllInfos(collection3, toolWindowAnchor3));
        Collection collection4 = list2;
        ToolWindowAnchor toolWindowAnchor4 = ToolWindowAnchor.RIGHT;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor4, (String)"ToolWindowAnchor.RIGHT");
        DesktopLayoutKt.access$normalizeOrder(DesktopLayoutKt.access$getAllInfos(collection4, toolWindowAnchor4));
        for (WindowInfoImpl info3 : list2) {
            info3.resetModificationCount();
        }
    }

    public final long getStateModificationCount() {
        if (this.idToInfo.isEmpty()) {
            return 0L;
        }
        long result2 = 0L;
        for (WindowInfoImpl info2 : this.idToInfo.values()) {
            result2 += info2.getModificationCount();
        }
        return result2;
    }

    @Nullable
    public final Element writeExternal(@NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        if (this.idToInfo.isEmpty()) {
            return null;
        }
        Element state = new Element(tagName);
        for (WindowInfoImpl info2 : CollectionsKt.sortedWith((Iterable)this.idToInfo.values(), DesktopLayoutKt.getWindowInfoComparator())) {
            Element element2;
            if (XmlSerializer.serialize$default((Object)info2, null, (boolean)false, (int)6, null) == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            Element it = element2;
            boolean bl3 = false;
            state.addContent(it);
        }
        return state;
    }

    public DesktopLayout(@NotNull Map<String, WindowInfoImpl> idToInfo) {
        Intrinsics.checkNotNullParameter(idToInfo, (String)"idToInfo");
        this.idToInfo = idToInfo;
    }

    public /* synthetic */ DesktopLayout(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = new HashMap();
        }
        this(map2);
    }

    public DesktopLayout() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/wm/impl/DesktopLayout$Companion;", "", "()V", "TAG", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

