/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.BundleBase;
import com.intellij.DynamicBundle;
import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.impl.Stripe;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImplKt;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u001c\u0010\u0015\u001a\u00020\r2\b\b\u0001\u0010\u0016\u001a\u00020\t2\b\b\u0001\u0010\u0017\u001a\u00020\tH\u0002\u001a \u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002\u001a\u001e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010%2\u0006\u0010&\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u001a\u0010'\u001a\u00020\r2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0002\u001a\u0010\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\tH\u0003\u001a\u0010\u0010.\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\u00020\t8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\u00a8\u0006/"}, d2={"ACTIVE_ATTR_VALUE", "", "EDITOR_ELEMENT", "LAYOUT_TO_RESTORE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "RECENT_TW_TAG", "activateToolWindowVKsMask", "", "getActivateToolWindowVKsMask", "()I", "isStackEnabled", "", "()Z", "addStripeButton", "", "button", "Lcom/intellij/openapi/wm/impl/StripeButton;", "stripe", "Lcom/intellij/openapi/wm/impl/Stripe;", "areAllModifiersPressed", "modifiers", "mask", "findIconFromBean", "Ljavax/swing/Icon;", "bean", "Lcom/intellij/openapi/wm/ToolWindowEP;", "factory", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "getRootBounds", "Ljava/awt/Rectangle;", "frame", "Ljavax/swing/JFrame;", "getStripeTitleSupplier", "Ljava/util/function/Supplier;", "id", "isInActiveToolWindow", "component", "", "activeToolWindow", "Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "keyCodeToInputMask", "code", "removeStripeButton", "intellij.platform.ide.impl"})
public final class ToolWindowManagerImplKt {
    private static final Logger LOG;
    private static final String EDITOR_ELEMENT = "editor";
    private static final String ACTIVE_ATTR_VALUE = "active";
    private static final String LAYOUT_TO_RESTORE = "layout-to-restore";
    private static final String RECENT_TW_TAG = "recentWindows";

    private static final boolean areAllModifiersPressed(@JdkConstants.InputEventMask int modifiers, @JdkConstants.InputEventMask int mask) {
        return (modifiers ^ mask) == 0;
    }

    @JdkConstants.InputEventMask
    private static final int keyCodeToInputMask(int code) {
        int n;
        switch (code) {
            case 16: {
                n = 1;
                break;
            }
            case 17: {
                n = 2;
                break;
            }
            case 157: {
                n = 4;
                break;
            }
            case 18: {
                n = 8;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @JdkConstants.InputEventMask
    private static final int getActivateToolWindowVKsMask() {
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            return 0;
        }
        if (Registry.is((String)"toolwindow.disable.overlay.by.double.key")) {
            return 0;
        }
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)keymapManager2, (String)"KeymapManager.getInstance()");
        Keymap keymap2 = keymapManager2.getActiveKeymap();
        Intrinsics.checkNotNullExpressionValue((Object)keymap2, (String)"KeymapManager.getInstance().activeKeymap");
        Keymap keymap3 = keymap2;
        Shortcut[] baseShortcut = keymap3.getShortcuts("ActivateProjectToolWindow");
        int baseModifiers = SystemInfo.isMac ? 4 : 8;
        for (Shortcut each : baseShortcut) {
            KeyStroke keyStroke;
            if (!(each instanceof KeyboardShortcut)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((KeyboardShortcut)each).getFirstKeyStroke(), (String)"each.firstKeyStroke");
            baseModifiers = keyStroke.getModifiers();
            if (baseModifiers > 0) break;
        }
        return baseModifiers & 0xF;
    }

    private static final boolean isStackEnabled() {
        return Registry.is((String)"ide.enable.toolwindow.stack");
    }

    private static final Rectangle getRootBounds(JFrame frame) {
        JRootPane rootPane;
        JRootPane jRootPane = rootPane = frame.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"rootPane");
        Rectangle bounds2 = jRootPane.getBounds();
        bounds2.setLocation(frame.getX() + rootPane.getX(), frame.getY() + rootPane.getY());
        Rectangle rectangle = bounds2;
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"bounds");
        return rectangle;
    }

    private static final boolean isInActiveToolWindow(Object component2, ToolWindowImpl activeToolWindow) {
        JComponent source = component2 instanceof JComponent ? (JComponent)component2 : null;
        JComponent activeToolWindowComponent = activeToolWindow.getComponentIfInitialized();
        if (activeToolWindowComponent != null) {
            while (source != null && source != activeToolWindowComponent) {
                JComponent jComponent = (JComponent)ComponentUtil.getClientProperty((JComponent)source, ToolWindowManagerImpl.PARENT_COMPONENT);
                if (jComponent == null) {
                    Container container = source.getParent();
                    if (!(container instanceof JComponent)) {
                        container = null;
                    }
                    jComponent = (JComponent)container;
                }
                source = jComponent;
            }
        }
        return source != null;
    }

    @Nullable
    public static final Icon findIconFromBean(@NotNull ToolWindowEP bean, @NotNull ToolWindowFactory factory2, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        try {
            String string = bean.icon;
            if (string == null) {
                return null;
            }
            return IconLoader.findIcon((String)string, factory2.getClass(), (ClassLoader)pluginDescriptor.getPluginClassLoader(), null, (boolean)true);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return EmptyIcon.ICON_13;
        }
    }

    @Nullable
    public static final Supplier<String> getStripeTitleSupplier(@NotNull String id2, @NotNull PluginDescriptor pluginDescriptor) {
        String string;
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        ClassLoader classLoader = pluginDescriptor.getPluginClassLoader();
        PluginId pluginId = pluginDescriptor.getPluginId();
        if (Intrinsics.areEqual((Object)pluginId, (Object)PluginManagerCore.CORE_ID)) {
            string = "messages.IdeBundle";
        } else {
            String string2 = pluginDescriptor.getResourceBundleBaseName();
            if (string2 == null) {
                return null;
            }
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pluginDescriptor.resourc\u2026leBaseName ?: return null");
        }
        String bundleName = string;
        try {
            ResourceBundle resourceBundle = DynamicBundle.INSTANCE.getResourceBundle(bundleName, classLoader);
            Intrinsics.checkNotNullExpressionValue((Object)resourceBundle, (String)"DynamicBundle.INSTANCE.g\u2026(bundleName, classLoader)");
            ResourceBundle bundle = resourceBundle;
            String key = StringsKt.replace$default((String)("toolwindow.stripe." + id2), (String)" ", (String)"_", (boolean)false, (int)4, null);
            String fallback = id2;
            String label2 = BundleBase.messageOrDefault((ResourceBundle)bundle, (String)key, (String)fallback, (Object[])new Object[0]);
            return new Supplier(label2){
                final /* synthetic */ String $label;

                @NotNull
                public final String get() {
                    return this.$label;
                }
                {
                    this.$label = string;
                }
            };
        }
        catch (MissingResourceException e) {
            LOG.warn("Missing bundle " + bundleName + " at " + classLoader, (Throwable)e);
            return null;
        }
    }

    private static final void addStripeButton(StripeButton button4, Stripe stripe) {
        stripe.addButton(button4, addStripeButton.1.INSTANCE);
    }

    private static final void removeStripeButton(StripeButton button4) {
        block1: {
            Container container = button4.getParent();
            if (!(container instanceof Stripe)) {
                container = null;
            }
            Stripe stripe = (Stripe)container;
            if (stripe == null) break block1;
            stripe.removeButton(button4);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ToolWindowManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ boolean access$isInActiveToolWindow(Object component2, ToolWindowImpl activeToolWindow) {
        return ToolWindowManagerImplKt.isInActiveToolWindow(component2, activeToolWindow);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ int access$getActivateToolWindowVKsMask$p() {
        return ToolWindowManagerImplKt.getActivateToolWindowVKsMask();
    }

    public static final /* synthetic */ int access$keyCodeToInputMask(int code) {
        return ToolWindowManagerImplKt.keyCodeToInputMask(code);
    }

    public static final /* synthetic */ boolean access$areAllModifiersPressed(int modifiers, int mask) {
        return ToolWindowManagerImplKt.areAllModifiersPressed(modifiers, mask);
    }

    public static final /* synthetic */ boolean access$isStackEnabled$p() {
        return ToolWindowManagerImplKt.isStackEnabled();
    }

    public static final /* synthetic */ void access$addStripeButton(StripeButton button4, Stripe stripe) {
        ToolWindowManagerImplKt.addStripeButton(button4, stripe);
    }

    public static final /* synthetic */ void access$removeStripeButton(StripeButton button4) {
        ToolWindowManagerImplKt.removeStripeButton(button4);
    }

    public static final /* synthetic */ Rectangle access$getRootBounds(JFrame frame) {
        return ToolWindowManagerImplKt.getRootBounds(frame);
    }
}

