/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.util.ui.JBUI;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

abstract class ContentLayout {
    ToolWindowContentUi myUi;
    BaseLabel myIdLabel;

    ContentLayout(@NotNull ToolWindowContentUi ui2) {
        if (ui2 == null) {
            ContentLayout.$$$reportNull$$$0(0);
        }
        this.myUi = ui2;
    }

    public abstract void init(@NotNull ContentManager var1);

    public abstract void reset();

    public abstract void layout();

    public abstract void paintComponent(Graphics var1);

    public abstract void update();

    public abstract void rebuild();

    public abstract int getMinimumWidth();

    public abstract void contentAdded(ContentManagerEvent var1);

    public abstract void contentRemoved(ContentManagerEvent var1);

    protected void updateIdLabel(BaseLabel label2) {
        Object title2 = this.myUi.window.getStripeTitle();
        String suffix = this.getTitleSuffix();
        if (suffix != null) {
            title2 = (String)title2 + suffix;
        }
        label2.setText((String)title2);
        label2.setBorder((Border)JBUI.Borders.empty((int)0, (int)2, (int)0, (int)7));
        label2.setVisible(this.shouldShowId());
    }

    private String getTitleSuffix() {
        ContentManager manager2 = this.myUi.getContentManager();
        switch (manager2.getContentCount()) {
            case 0: {
                return null;
            }
            case 1: {
                Content content2 = manager2.getContent(0);
                if (content2 == null) {
                    return null;
                }
                String text2 = content2.getDisplayName();
                if (text2 != null && text2.trim().length() > 0 && manager2.canCloseContents()) {
                    return ":";
                }
                return null;
            }
        }
        return ":";
    }

    public abstract void showContentPopup(ListPopup var1);

    @NlsActions.ActionText
    public abstract String getCloseActionName();

    @NlsActions.ActionText
    public abstract String getCloseAllButThisActionName();

    @NlsActions.ActionText
    public abstract String getPreviousContentActionName();

    @NlsActions.ActionText
    public abstract String getNextContentActionName();

    protected boolean shouldShowId() {
        JComponent component2 = this.myUi.window.getComponentIfInitialized();
        return component2 != null && !"true".equals(component2.getClientProperty("HideIdLabel"));
    }

    boolean isIdVisible() {
        return this.myIdLabel.isVisible();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/openapi/wm/impl/content/ContentLayout", "<init>"));
    }
}

