/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.impl.content.ContentLabel;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.openapi.wm.impl.content.tabActions.ContentTabAction;
import com.intellij.ui.EngravedTextGraphics;
import com.intellij.ui.Gray;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

class ContentTabLabel
extends ContentLabel {
    private static final int MAX_WIDTH = JBUIScale.scale((int)400);
    private final LayeredIcon myActiveCloseIcon;
    private final LayeredIcon myRegularCloseIcon;
    @NotNull
    protected final Content myContent;
    private final TabContentLayout myLayout;
    private @NlsContexts.Label String myText;

    @Override
    protected void handleMouseClick(@NotNull MouseEvent e) {
        if (e == null) {
            ContentTabLabel.$$$reportNull$$$0(0);
        }
        if (e.getID() == 502) {
            if (this.handleActionsClick(e)) {
                return;
            }
            this.selectContent();
            this.handleDoubleClick(e);
        }
    }

    private void handleDoubleClick(@NotNull MouseEvent e) {
        if (e == null) {
            ContentTabLabel.$$$reportNull$$$0(1);
        }
        if (e.getClickCount() == 2 && e.getButton() == 1 && !this.myLayout.myDoubleClickActions.isEmpty()) {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
            for (AnAction action2 : this.myLayout.myDoubleClickActions) {
                AnActionEvent event;
                if (!ActionUtil.lastUpdateAndCheckDumb((AnAction)action2, (AnActionEvent)(event = AnActionEvent.createFromInputEvent((InputEvent)e, (String)"unknown", null, (DataContext)dataContext)), (boolean)false)) continue;
                ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action2, (AnActionEvent)event);
            }
        }
    }

    @Override
    public void setText(@NlsContexts.Label String text2) {
        this.myText = text2;
        this.updateText();
    }

    private void updateText() {
        int maxWidth;
        if (this.myText != null && this.myText.startsWith("<html>")) {
            super.setText(this.myText);
            return;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int textWidth = UIUtilities.stringWidth((JComponent)this, (FontMetrics)fm, (String)this.myText);
        int prefWidth = this.myIconWithInsetsWidth + textWidth;
        if (prefWidth > (maxWidth = this.getMaximumSize().width)) {
            int offset = maxWidth - this.myIconWithInsetsWidth;
            String s = UIUtilities.clipString((JComponent)this, (FontMetrics)fm, (String)this.myText, (int)offset);
            super.setText(s);
            return;
        }
        super.setText(this.myText);
    }

    ContentTabLabel(@NotNull Content content2, @NotNull TabContentLayout layout) {
        if (content2 == null) {
            ContentTabLabel.$$$reportNull$$$0(2);
        }
        if (layout == null) {
            ContentTabLabel.$$$reportNull$$$0(3);
        }
        super(layout.myUi, false);
        this.myActiveCloseIcon = new LayeredIcon(JBUI.CurrentTheme.ToolWindow.closeTabIcon((boolean)true));
        this.myRegularCloseIcon = new LayeredIcon(JBUI.CurrentTheme.ToolWindow.closeTabIcon((boolean)false));
        this.myLayout = layout;
        this.myContent = content2;
        this.updateAdditionalActions();
        this.myContent.addPropertyChangeListener(event -> {
            String property2 = event.getPropertyName();
            if ("isClosable".equals(property2)) {
                this.repaint();
            }
            if ("pinned".equals(property2)) {
                this.updateCloseIcon();
            }
        });
        if (this.myContent.isPinned()) {
            SwingUtilities.invokeLater(this::updateCloseIcon);
        }
        this.setMaximumSize(new Dimension(MAX_WIDTH, this.getMaximumSize().height));
    }

    @Override
    protected String getOriginalText() {
        return this.myText;
    }

    private void updateCloseIcon() {
        boolean pinned = this.getContent().isPinned();
        this.myActiveCloseIcon.setIcon(pinned ? AllIcons.Actions.PinTab : JBUI.CurrentTheme.ToolWindow.closeTabIcon((boolean)true), 0);
        this.myRegularCloseIcon.setIcon(pinned ? AllIcons.Actions.PinTab : JBUI.CurrentTheme.ToolWindow.closeTabIcon((boolean)false), 0);
        this.repaint();
    }

    @Override
    protected void fillActions(@NotNull List<? super ContentTabAction> actions2) {
        if (actions2 == null) {
            ContentTabLabel.$$$reportNull$$$0(4);
        }
        super.fillActions(actions2);
        actions2.add(new CloseContentTabAction());
    }

    public final boolean canBeClosed() {
        return this.myContent.isCloseable() && this.myUi.window.canCloseContents();
    }

    protected void selectContent() {
        ContentManager manager2 = this.getContentManager();
        if (manager2.getIndexOfContent(this.myContent) >= 0) {
            manager2.setSelectedContent(this.myContent, true);
        }
    }

    public void update() {
        this.setHorizontalAlignment(2);
        if (this.myLayout.isToDrawTabs() == TabContentLayout.TabsDrawMode.HIDE) {
            this.setBorder(null);
        }
        this.updateTextAndIcon(this.myContent, this.isSelected());
    }

    @Override
    protected boolean allowEngravement() {
        return this.isSelected() || this.myUi != null && this.myUi.window.isActive();
    }

    @Override
    protected Color getActiveFg(boolean selected2) {
        ContentManager contentManager2 = this.myUi.window.getContentManagerIfCreated();
        if (contentManager2 != null && contentManager2.getContentCount() > 1) {
            return selected2 ? JBUI.CurrentTheme.ToolWindow.underlinedTabForeground() : JBUI.CurrentTheme.Label.foreground((boolean)false);
        }
        return super.getActiveFg(selected2);
    }

    @Override
    protected Color getPassiveFg(boolean selected2) {
        ContentManager contentManager2 = this.myUi.window.getContentManagerIfCreated();
        if (contentManager2 != null && contentManager2.getContentCount() > 1) {
            return selected2 ? JBUI.CurrentTheme.ToolWindow.underlinedTabInactiveForeground() : JBUI.CurrentTheme.Label.foreground((boolean)false);
        }
        return super.getPassiveFg(selected2);
    }

    public boolean isSelected() {
        ContentManager contentManager2 = this.myUi.window.getContentManagerIfCreated();
        return contentManager2 != null && contentManager2.isSelected(this.myContent);
    }

    @Override
    protected Graphics _getGraphics(Graphics2D g) {
        if (this.isSelected() && this.getContentManager().getContentCount() > 1) {
            return new EngravedTextGraphics(g, 1, 1, Gray._0.withAlpha(this.myUi.window.isActive() ? 120 : 130));
        }
        return super._getGraphics(g);
    }

    @NotNull
    private ContentManager getContentManager() {
        ContentManager contentManager2 = this.myUi.getContentManager();
        if (contentManager2 == null) {
            ContentTabLabel.$$$reportNull$$$0(5);
        }
        return contentManager2;
    }

    @Override
    @NotNull
    public Content getContent() {
        Content content2 = this.myContent;
        if (content2 == null) {
            ContentTabLabel.$$$reportNull$$$0(6);
        }
        return content2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/content/ContentTabLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/content/ContentTabLabel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleMouseClick";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleDoubleClick";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fillActions";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CloseContentTabAction
    extends ContentTabAction {
        private CloseContentTabAction() {
            super(new ActiveIcon((Icon)ContentTabLabel.this.myActiveCloseIcon, (Icon)ContentTabLabel.this.myRegularCloseIcon));
        }

        @Override
        public boolean getAvailable() {
            return ContentTabLabel.this.canBeClosed();
        }

        @Override
        public void runAction() {
            Content content2 = ContentTabLabel.this.getContent();
            if (content2.isPinned()) {
                content2.setPinned(false);
                return;
            }
            ContentManager contentManager2 = ContentTabLabel.this.myUi.window.getContentManagerIfCreated();
            if (contentManager2 != null) {
                contentManager2.removeContent(content2, true);
            }
        }

        @Override
        public boolean getAfterText() {
            return UISettings.getShadowInstance().getCloseTabButtonOnTheRight() || !UISettings.getShadowInstance().getShowCloseButton();
        }

        @Override
        @NotNull
        public String getTooltip() {
            if (ContentTabLabel.this.getContent().isPinned()) {
                String string = IdeBundle.message((String)"action.unpin.tab.tooltip", (Object[])new Object[0]);
                if (string == null) {
                    CloseContentTabAction.$$$reportNull$$$0(0);
                }
                return string;
            }
            Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts("CloseActiveTab");
            String text2 = KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
            Object object = text2.isEmpty() || !ContentTabLabel.this.isSelected() ? IdeBundle.message((String)"tooltip.close.tab", (Object[])new Object[0]) : IdeBundle.message((String)"tooltip.close.tab", (Object[])new Object[0]) + " (" + text2 + ")";
            if (object == null) {
                CloseContentTabAction.$$$reportNull$$$0(1);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/content/ContentTabLabel$CloseContentTabAction", "getTooltip"));
        }
    }
}

