/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.wm.impl.content.AdditionalIcon;
import com.intellij.openapi.wm.impl.content.ContentLabel;
import com.intellij.openapi.wm.impl.content.ContentTabLabel;
import com.intellij.openapi.wm.impl.content.SelectContentTabStep;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.openapi.wm.impl.content.tabActions.ContentTabAction;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.popup.PopupState;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class TabbedContentTabLabel
extends ContentTabLabel {
    private final PopupState<JBPopup> myPopupState;

    public TabbedContentTabLabel(@NotNull TabbedContent content2, @NotNull TabContentLayout layout) {
        if (content2 == null) {
            TabbedContentTabLabel.$$$reportNull$$$0(0);
        }
        if (layout == null) {
            TabbedContentTabLabel.$$$reportNull$$$0(1);
        }
        super((Content)content2, layout);
        this.myPopupState = PopupState.forPopup();
    }

    private boolean isPopupShown() {
        return this.myPopupState.isShowing();
    }

    @Override
    protected void selectContent() {
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups();
        super.selectContent();
        if (this.hasMultipleTabs()) {
            if (this.myPopupState.isRecentlyHidden()) {
                return;
            }
            SelectContentTabStep step2 = new SelectContentTabStep(this.getContent());
            ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2);
            this.myPopupState.prepareToShow((Object)popup2);
            popup2.showUnderneathOf((Component)this);
            popup2.addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    TabbedContentTabLabel.this.repaint();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/content/TabbedContentTabLabel$1", "onClosed"));
                }
            });
        }
    }

    @Override
    public void update() {
        super.update();
        this.setText(this.myContent.getDisplayName());
    }

    @Override
    protected void fillActions(@NotNull List<? super ContentTabAction> actions2) {
        if (actions2 == null) {
            TabbedContentTabLabel.$$$reportNull$$$0(2);
        }
        actions2.add(new SelectContentTabAction());
        super.fillActions(actions2);
    }

    @Override
    @NotNull
    protected AdditionalIcon createIcon(@NotNull ContentTabAction action2) {
        if (action2 == null) {
            TabbedContentTabLabel.$$$reportNull$$$0(3);
        }
        return new TabbedContentTabAdditionalIcon(action2);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.myPopupState.hidePopup();
    }

    @NotNull
    public TabbedContent getContent() {
        TabbedContent tabbedContent = (TabbedContent)super.getContent();
        if (tabbedContent == null) {
            TabbedContentTabLabel.$$$reportNull$$$0(4);
        }
        return tabbedContent;
    }

    private boolean hasMultipleTabs() {
        return this.getContent().hasMultipleTabs();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/content/TabbedContentTabLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/content/TabbedContentTabLabel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fillActions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createIcon";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class TabbedContentTabAdditionalIcon
    extends ContentLabel.ContentAdditionalIcon {
        public TabbedContentTabAdditionalIcon(ContentTabAction action2) {
            if (action2 == null) {
                TabbedContentTabAdditionalIcon.$$$reportNull$$$0(0);
            }
            super(action2);
        }

        @Override
        public boolean getActive() {
            return super.getActive() || TabbedContentTabLabel.this.isPopupShown();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/wm/impl/content/TabbedContentTabLabel$TabbedContentTabAdditionalIcon", "<init>"));
        }
    }

    private class SelectContentTabAction
    extends ContentTabAction {
        private SelectContentTabAction() {
            super(new ActiveIcon(JBUI.CurrentTheme.ToolWindow.comboTabIcon((boolean)true), JBUI.CurrentTheme.ToolWindow.comboTabIcon((boolean)false)));
        }

        @Override
        public boolean getAvailable() {
            return TabbedContentTabLabel.this.hasMultipleTabs();
        }

        @Override
        public void runAction() {
            TabbedContentTabLabel.this.selectContent();
        }
    }
}

