/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StatusBarUtil {
    private static final Logger LOG = Logger.getInstance(StatusBar.class);

    private StatusBarUtil() {
    }

    @Nullable
    public static Editor getCurrentTextEditor(@Nullable StatusBar statusBar2) {
        if (statusBar2 == null) {
            return null;
        }
        FileEditor fileEditor = StatusBarUtil.getCurrentFileEditor(statusBar2);
        if (fileEditor instanceof TextEditor) {
            Editor editor = ((TextEditor)fileEditor).getEditor();
            return StatusBarUtil.ensureValidEditorFile(editor, fileEditor) ? editor : null;
        }
        return null;
    }

    @Nullable
    public static FileEditor getCurrentFileEditor(@Nullable StatusBar statusBar2) {
        EditorWithProviderComposite editor;
        if (statusBar2 == null) {
            return null;
        }
        Project project = statusBar2.getProject();
        if (project == null) {
            return null;
        }
        if (LightEdit.owns((Project)project)) {
            return LightEditService.getInstance().getSelectedFileEditor();
        }
        DockContainer c = DockManager.getInstance((Project)project).getContainerFor((Component)statusBar2.getComponent());
        EditorsSplitters splitters = null;
        if (c instanceof DockableEditorTabbedContainer) {
            splitters = ((DockableEditorTabbedContainer)c).getSplitters();
        }
        if (splitters != null && splitters.getCurrentWindow() != null && (editor = splitters.getCurrentWindow().getSelectedEditor()) != null) {
            return editor.getSelectedWithProvider().getFileEditor();
        }
        return null;
    }

    public static void setStatusBarInfo(@NotNull Project project, @NotNull @NlsContexts.StatusBarText String message2) {
        StatusBar statusBar2;
        if (project == null) {
            StatusBarUtil.$$$reportNull$$$0(0);
        }
        if (message2 == null) {
            StatusBarUtil.$$$reportNull$$$0(1);
        }
        if ((statusBar2 = WindowManager.getInstance().getStatusBar(project)) != null) {
            statusBar2.setInfo(message2);
        }
    }

    private static boolean ensureValidEditorFile(@NotNull Editor editor, @Nullable FileEditor fileEditor) {
        if (editor == null) {
            StatusBarUtil.$$$reportNull$$$0(2);
        }
        Document document = editor.getDocument();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null && !file2.isValid()) {
            Document cachedDocument = FileDocumentManager.getInstance().getCachedDocument(file2);
            Project project = editor.getProject();
            Boolean fileIsOpen = project == null ? null : Boolean.valueOf(ArrayUtil.contains((Object)file2, (Object[])FileEditorManager.getInstance((Project)project).getOpenFiles()));
            LOG.error("Returned editor for invalid file: " + editor + "; disposed=" + editor.isDisposed() + (String)(fileEditor == null ? "" : "; fileEditor=" + fileEditor + "; fileEditor.valid=" + fileEditor.isValid()) + "; file " + file2.getClass() + "; cached document exists: " + (cachedDocument != null) + "; same as document: " + (cachedDocument == document) + "; file is open: " + fileIsOpen);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/status/StatusBarUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setStatusBarInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureValidEditorFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

