/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.util.Consumer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \t2\u00020\u00012\u00020\u0002:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/AttachProjectAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "intellij.platform.ide.impl"})
public class AttachProjectAction
extends AnAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * Unable to fully structure code
     */
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        v0 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"e.presentation");
        if (!ProjectAttachProcessor.canAttachToProject()) ** GOTO lbl-1000
        v1 = GeneralSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"GeneralSettings.getInstance()");
        if (v1.getConfirmOpenNewProject() != -1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        v0.setEnabledAndVisible(v2);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.getData(CommonDataKeys.PROJECT) ?: return");
        Project project2 = project;
        Companion.chooseAndAttachToProject(project2);
    }

    public AttachProjectAction() {
        super(ActionsBundle.message((String)"action.AttachProject.text", (Object[])new Object[0]));
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/AttachProjectAction$Companion;", "", "()V", "attachProject", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "chooseAndAttachToProject", "intellij.platform.ide.impl"})
    public static final class Companion {
        public final void chooseAndAttachToProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            OpenProjectFileChooserDescriptor descriptor2 = new OpenProjectFileChooserDescriptor(true);
            FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)project, null, (Consumer)new Consumer(project){
                final /* synthetic */ Project $project;

                public final void consume(List<VirtualFile> it) {
                    VirtualFile virtualFile2 = it.get(0);
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"it[0]");
                    AttachProjectAction.Companion.attachProject(virtualFile2, this.$project);
                }
                {
                    this.$project = project;
                }
            });
        }

        public final void attachProject(@NotNull VirtualFile virtualFile2, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            VirtualFile baseDir = virtualFile2;
            if (!virtualFile2.isDirectory()) {
                for (baseDir = virtualFile2.getParent(); baseDir != null && !ProjectUtil.isProjectDirectoryExistsUsingIo((VirtualFile)baseDir); baseDir = baseDir.getParent()) {
                }
            }
            if (baseDir == null) {
                Messages.showErrorDialog((String)IdeBundle.message((String)"dialog.message.attach.project.not.found", (Object[])new Object[]{virtualFile2.getPath()}), (String)IdeBundle.message((String)"dialog.title.attach.project.error", (Object[])new Object[0]));
            } else {
                Path path2 = Paths.get(FileUtil.toSystemDependentName((String)baseDir.getPath()), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(FileUtil.toSys\u2026endentName(baseDir.path))");
                PlatformProjectOpenProcessor.Companion.attachToProject(project, path2, null);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

