/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.profiler.AbstractProfilerToolWindowPanel;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.ProfilerDumpPanel;
import com.intellij.profiler.ProfilerProcessPanel;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.ProfilerToolWindowManagerKt;
import com.intellij.profiler.TabNameFormatToggleAction;
import com.intellij.profiler.api.DataReady;
import com.intellij.profiler.api.ProfilerError;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ContentsUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 +2\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u00020\u00062\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\b\b\u0002\u0010\u000e\u001a\u00020\nJ\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00102\b\b\u0002\u0010\t\u001a\u00020\nJ\u0018\u0010\u000f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u00182\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\u000e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0018J.\u0010\u001c\u001a\u00020\u00062\b\b\u0001\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0014\b\u0002\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00060!J\u0010\u0010#\u001a\u00020\u00062\b\b\u0001\u0010\u001d\u001a\u00020\u0015J\u0010\u0010$\u001a\u00020\u00062\b\b\u0001\u0010\u001d\u001a\u00020\u0015J&\u0010%\u001a\u00020\u00062\b\b\u0001\u0010&\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020'2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0002J\u0010\u0010(\u001a\u00020\u00062\b\b\u0001\u0010\u001d\u001a\u00020\u0015J\u0014\u0010)\u001a\u00020\u00152\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0003J\u0014\u0010\u0014\u001a\u00020\u00152\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0003J\u001c\u0010*\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/profiler/ProfilerToolWindowManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "addProfilerDumpTab", "", "panel", "Lcom/intellij/profiler/ProfilerDumpPanel;", "activate", "", "addProfilerProcessTab", "profilerProcess", "Lcom/intellij/profiler/api/ProfilerProcess;", "activateToolWindow", "addTab", "Lcom/intellij/profiler/AbstractProfilerToolWindowPanel;", "Lcom/intellij/ui/content/Content;", "component", "Ljavax/swing/JComponent;", "tabName", "", "findToolWindowContent", "tw", "Lcom/intellij/openapi/wm/ToolWindow;", "getToolWindow", "initToolWindow", "toolWindow", "showBalloon", "message", "type", "Lcom/intellij/openapi/ui/MessageType;", "beforeNotify", "Lkotlin/Function1;", "Lcom/intellij/notification/Notification;", "showErrorBalloon", "showInfoBalloon", "showOpenProfilerTabBalloon", "content", "Lcom/intellij/notification/NotificationType;", "showWarningBalloon", "tabDescription", "twIsVisibleAndThisProcessTabSelected", "Companion", "intellij.profiler.common"})
public final class ProfilerToolWindowManager {
    private final Project project;
    @NotNull
    public static final String TOOLWINDOW_ID = "Profiler";
    private static final NotificationGroup TOOLWINDOW_BALLOON_GROUP;
    @NotNull
    public static final Companion Companion;

    private final ToolWindow getToolWindow() {
        ToolWindowManager manager2 = ToolWindowManager.Companion.getInstance(this.project);
        ToolWindow toolWindow = manager2.getToolWindow(TOOLWINDOW_ID);
        if (toolWindow == null) {
            ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"ToolWindowAnchor.BOTTOM");
            ToolWindow toolWindow2 = manager2.registerToolWindow(new RegisterToolWindowTask(TOOLWINDOW_ID, toolWindowAnchor, null, false, false, false, false, null, null, CommonProfilerBundleKt.profilerMessagePointer("profiler.configurable.name", new Object[0]), 508, null));
            boolean bl = false;
            boolean bl2 = false;
            ToolWindow it = toolWindow2;
            boolean bl3 = false;
            this.initToolWindow(it);
            ContentManagerWatcher.watchContentManager(it, it.getContentManager());
            toolWindow = toolWindow2;
        }
        return toolWindow;
    }

    /*
     * WARNING - void declaration
     */
    public final void initToolWindow(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowProfiler);
        toolWindow.setToHideOnEmptyContent(false);
        if (toolWindow instanceof ToolWindowEx) {
            Collection<TabNameFormatToggleAction> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup(CommonProfilerBundleKt.profilerMessage("ui.tabs.format.name", new Object[0]), true);
            boolean bl = false;
            boolean bl2 = false;
            DefaultActionGroup $this$apply = defaultActionGroup;
            boolean bl3 = false;
            CommonProfilerUiOptions.TabNameFormat[] tabNameFormatArray = CommonProfilerUiOptions.TabNameFormat.values();
            DefaultActionGroup defaultActionGroup2 = $this$apply;
            boolean $i$f$map = false;
            void var11_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var14_13 = $this$mapTo$iv$iv;
            int n = ((void)var14_13).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var18_17 = item$iv$iv = var14_13[j];
                collection = destination$iv$iv;
                boolean bl4 = false;
                ContentManager contentManager2 = ((ToolWindowEx)toolWindow).getContentManager();
                Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"toolWindow.contentManager");
                TabNameFormatToggleAction tabNameFormatToggleAction = new TabNameFormatToggleAction((CommonProfilerUiOptions.TabNameFormat)it, contentManager2);
                collection.add(tabNameFormatToggleAction);
            }
            collection = (List)destination$iv$iv;
            defaultActionGroup2.addAll((Collection)collection);
            DefaultActionGroup tabFormatGroup = defaultActionGroup;
            ((ToolWindowEx)toolWindow).setAdditionalGearActions((ActionGroup)tabFormatGroup);
        }
    }

    public final void addProfilerDumpTab(@NotNull ProfilerDumpPanel panel2, boolean activate2) {
        Intrinsics.checkNotNullParameter((Object)((Object)panel2), (String)"panel");
        this.addTab(panel2, activate2);
    }

    public static /* synthetic */ void addProfilerDumpTab$default(ProfilerToolWindowManager profilerToolWindowManager, ProfilerDumpPanel profilerDumpPanel, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        profilerToolWindowManager.addProfilerDumpTab(profilerDumpPanel, bl);
    }

    public final void addProfilerProcessTab(@NotNull ProfilerProcess<?> profilerProcess, boolean activateToolWindow2) {
        Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
        profilerProcess.addStateChangedListener((Function2<ProfilerState, ProfilerState, Unit>)((Function2)new Function2<ProfilerState, ProfilerState, Unit>(this, profilerProcess){
            final /* synthetic */ ProfilerToolWindowManager this$0;
            final /* synthetic */ ProfilerProcess $profilerProcess;

            public final void invoke(@NotNull ProfilerState $noName_0, @NotNull ProfilerState newState2) {
                block1: {
                    ProfilerState profilerState;
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter((Object)newState2, (String)"newState");
                        profilerState = newState2;
                        if (!(profilerState instanceof ProfilerError)) break block0;
                        StringBuilder stringBuilder = new StringBuilder();
                        Object[] objectArray = new Object[1];
                        String string = StringUtil.escapeXmlEntities((String)((ProfilerError)newState2).getReason());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.escapeXmlEntities(newState.reason)");
                        objectArray[0] = string;
                        ProfilerToolWindowManager.access$showOpenProfilerTabBalloon(this.this$0, stringBuilder.append(CommonProfilerBundleKt.profilerMessage("run.profiler.data.error", objectArray)).append("<br>").toString(), NotificationType.ERROR, this.$profilerProcess);
                        break block1;
                    }
                    if (!(profilerState instanceof DataReady)) break block1;
                    ProfilerToolWindowManager.access$showOpenProfilerTabBalloon(this.this$0, CommonProfilerBundleKt.profilerMessage("run.profiler.data.ready", new Object[0]), NotificationType.INFORMATION, this.$profilerProcess);
                }
            }
            {
                this.this$0 = profilerToolWindowManager;
                this.$profilerProcess = profilerProcess;
                super(2);
            }
        }));
        String tabName = this.tabName(profilerProcess);
        String tabDescription = this.tabDescription(profilerProcess);
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, profilerProcess, tabName, tabDescription, activateToolWindow2){
            final /* synthetic */ ProfilerToolWindowManager this$0;
            final /* synthetic */ ProfilerProcess $profilerProcess;
            final /* synthetic */ String $tabName;
            final /* synthetic */ String $tabDescription;
            final /* synthetic */ boolean $activateToolWindow;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                void it;
                ProfilerProcessPanel profilerProcessPanel = new ProfilerProcessPanel(this.$profilerProcess, this.$tabName);
                boolean bl = false;
                boolean bl2 = false;
                ProfilerProcessPanel profilerProcessPanel2 = profilerProcessPanel;
                ProfilerToolWindowManager profilerToolWindowManager = this.this$0;
                boolean bl3 = false;
                it.getContent().setDescription(this.$tabDescription);
                Unit unit = Unit.INSTANCE;
                profilerToolWindowManager.addTab(profilerProcessPanel, this.$activateToolWindow);
                ProfilerToolWindowManager.access$showOpenProfilerTabBalloon(this.this$0, CommonProfilerBundleKt.profilerMessage("run.profiler.attached", new Object[0]), NotificationType.INFORMATION, this.$profilerProcess);
            }
            {
                this.this$0 = profilerToolWindowManager;
                this.$profilerProcess = profilerProcess;
                this.$tabName = string;
                this.$tabDescription = string2;
                this.$activateToolWindow = bl;
            }
        });
        profilerProcess.startNotify();
    }

    public static /* synthetic */ void addProfilerProcessTab$default(ProfilerToolWindowManager profilerToolWindowManager, ProfilerProcess profilerProcess, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        profilerToolWindowManager.addProfilerProcessTab(profilerProcess, bl);
    }

    @NlsSafe
    private final String tabName(ProfilerProcess<?> profilerProcess) {
        String string = DateFormatUtil.formatDateTime((long)profilerProcess.getAttachedTimestamp());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DateFormatUtil.formatDat\u2026rocess.attachedTimestamp)");
        String suffix = string;
        return profilerProcess.getTargetProcess().getShortName() + ' ' + suffix;
    }

    @Nls
    private final String tabDescription(ProfilerProcess<?> profilerProcess) {
        String profilerConfigurationName = profilerProcess.getProfilerConfiguration().getDisplayName();
        String target2 = profilerProcess.getTargetProcess().getFullName();
        CharSequence charSequence = profilerConfigurationName;
        boolean bl = false;
        boolean bl2 = false;
        String oldTabNameFormat = charSequence == null || charSequence.length() == 0 ? target2 : CommonProfilerBundleKt.profilerMessage("profiler.with.configuration.tab.title", target2, profilerConfigurationName);
        String string = new HtmlBuilder().append((HtmlChunk)HtmlChunk.div((String)"white-space: nowrap").addText(oldTabNameFormat)).wrapWithHtmlBody().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HtmlBuilder().append(Htm\u2026WithHtmlBody().toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void addTab(@NotNull AbstractProfilerToolWindowPanel panel2, boolean activate2) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)panel2), (String)"panel");
        ContentManager contentManager2 = this.getToolWindow().getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"getToolWindow().contentManager");
        Object[] objectArray = contentManager2.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getToolWindow().contentManager.contents");
        Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)addTab.existingNames.1.INSTANCE);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Content content2 = (Content)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            String string = v2.getDisplayName();
            collection.add(string);
        }
        HashSet existingNames2 = (HashSet)destination$iv;
        ToolWindow toolWindow = this.getToolWindow();
        ContentManager contentManager3 = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager3, (String)"toolWindow.contentManager");
        ContentManager contentManager4 = contentManager3;
        ContentsUtil.addContent((ContentManager)contentManager4, (Content)panel2.getContent(), (boolean)true);
        panel2.onPanelAdd();
        if (activate2) {
            toolWindow.activate(null);
        }
        panel2.getContent().setDisplayName(ProfilerToolWindowManagerKt.access$formatTabName(((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getTabNameFormat(), panel2.getTabName(), panel2.getTime(), existingNames2));
    }

    public static /* synthetic */ void addTab$default(ProfilerToolWindowManager profilerToolWindowManager, AbstractProfilerToolWindowPanel abstractProfilerToolWindowPanel, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        profilerToolWindowManager.addTab(abstractProfilerToolWindowPanel, bl);
    }

    @NotNull
    public final Content addTab(@NotNull JComponent component2, @NlsContexts.TabTitle @NotNull String tabName) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        ContentManager contentManager2 = this.getToolWindow().getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"getToolWindow().contentManager");
        ContentManager cm = contentManager2;
        Content content2 = ContentFactory.SERVICE.getInstance().createContent(component2, tabName, true);
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"ContentFactory.SERVICE.g\u2026component, tabName, true)");
        Content content3 = content2;
        ContentsUtil.addContent((ContentManager)cm, (Content)content3, (boolean)true);
        return content3;
    }

    public final void showWarningBalloon(@NlsContexts.NotificationContent @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        MessageType messageType = MessageType.WARNING;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.WARNING");
        TOOLWINDOW_BALLOON_GROUP.createNotification(message2, messageType).notify(this.project);
    }

    public final void showInfoBalloon(@NlsContexts.NotificationContent @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        MessageType messageType = MessageType.INFO;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.INFO");
        TOOLWINDOW_BALLOON_GROUP.createNotification(message2, messageType).notify(this.project);
    }

    public final void showErrorBalloon(@NlsContexts.NotificationContent @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        MessageType messageType = MessageType.ERROR;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.ERROR");
        TOOLWINDOW_BALLOON_GROUP.createNotification(message2, messageType).notify(this.project);
    }

    public final void showBalloon(@NlsContexts.NotificationContent @NotNull String message2, @NotNull MessageType type, @NotNull Function1<? super Notification, Unit> beforeNotify) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(beforeNotify, (String)"beforeNotify");
        Notification notification = TOOLWINDOW_BALLOON_GROUP.createNotification(message2, type);
        boolean bl = false;
        boolean bl2 = false;
        beforeNotify.invoke((Object)notification);
        notification.notify(this.project);
    }

    public static /* synthetic */ void showBalloon$default(ProfilerToolWindowManager profilerToolWindowManager, String string, MessageType messageType, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = showBalloon.1.INSTANCE;
        }
        profilerToolWindowManager.showBalloon(string, messageType, (Function1<? super Notification, Unit>)function1);
    }

    private final void showOpenProfilerTabBalloon(@NlsContexts.NotificationContent String content2, NotificationType type, ProfilerProcess<?> profilerProcess) {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.project).getToolWindow(TOOLWINDOW_ID);
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        if (this.twIsVisibleAndThisProcessTabSelected(toolWindow2, profilerProcess)) {
            return;
        }
        TOOLWINDOW_BALLOON_GROUP.createNotification(CommonProfilerBundleKt.profilerMessage("run.profiler.open", content2), type).setListener((NotificationListener)new NotificationListener.Adapter(this, toolWindow2, profilerProcess){
            final /* synthetic */ ProfilerToolWindowManager this$0;
            final /* synthetic */ ToolWindow $toolWindow;
            final /* synthetic */ ProfilerProcess $profilerProcess;

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Content content2 = ProfilerToolWindowManager.access$findToolWindowContent(this.this$0, this.$toolWindow, this.$profilerProcess);
                if (content2 != null) {
                    Content content3 = content2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Content it = content3;
                    boolean bl3 = false;
                    this.$toolWindow.getContentManager().setSelectedContent(it);
                }
                this.$toolWindow.activate(null);
                notification.expire();
            }
            {
                this.this$0 = this$0;
                this.$toolWindow = $captured_local_variable$1;
                this.$profilerProcess = $captured_local_variable$2;
            }
        }).notify(this.project);
    }

    private final boolean twIsVisibleAndThisProcessTabSelected(ToolWindow tw, ProfilerProcess<?> profilerProcess) {
        if (!tw.isVisible()) {
            return false;
        }
        Content content2 = this.findToolWindowContent(tw, profilerProcess);
        if (content2 == null) {
            return false;
        }
        Content tab = content2;
        ContentManager contentManager2 = tw.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"tw.contentManager");
        return Intrinsics.areEqual((Object)contentManager2.getSelectedContent(), (Object)tab);
    }

    private final Content findToolWindowContent(ToolWindow tw, ProfilerProcess<?> profilerProcess) {
        Content content2;
        block1: {
            ContentManager contentManager2 = tw.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"tw.contentManager");
            Content[] contentArray = contentManager2.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"tw.contentManager.contents");
            Content[] contentArray2 = contentArray;
            boolean bl = false;
            Content[] contentArray3 = contentArray2;
            boolean bl2 = false;
            Content[] contentArray4 = contentArray3;
            int n = contentArray4.length;
            for (int j = 0; j < n; ++j) {
                JComponent comp;
                Content content3;
                Content it = content3 = contentArray4[j];
                boolean bl3 = false;
                Content content4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)content4, (String)"it");
                Intrinsics.checkNotNullExpressionValue((Object)content4.getComponent(), (String)"it.component");
                if (!(comp instanceof ProfilerProcessPanel && Intrinsics.areEqual(((ProfilerProcessPanel)((Object)comp)).getProfilerProcess(), profilerProcess))) continue;
                content2 = content3;
                break block1;
            }
            content2 = null;
        }
        return content2;
    }

    public ProfilerToolWindowManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    static {
        Companion = new Companion(null);
        TOOLWINDOW_BALLOON_GROUP = NotificationGroup.Companion.toolWindowGroup$default((NotificationGroup.Companion)NotificationGroup.Companion, (String)"ProfilerBalloon", (String)TOOLWINDOW_ID, (boolean)false, (int)4, null);
    }

    public static final /* synthetic */ void access$showOpenProfilerTabBalloon(ProfilerToolWindowManager $this, String content2, NotificationType type, ProfilerProcess profilerProcess) {
        $this.showOpenProfilerTabBalloon(content2, type, profilerProcess);
    }

    public static final /* synthetic */ Content access$findToolWindowContent(ProfilerToolWindowManager $this, ToolWindow tw, ProfilerProcess profilerProcess) {
        return $this.findToolWindowContent(tw, profilerProcess);
    }

    @JvmStatic
    @NotNull
    public static final ProfilerToolWindowManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ProfilerToolWindowManager$Companion;", "", "()V", "TOOLWINDOW_BALLOON_GROUP", "Lcom/intellij/notification/NotificationGroup;", "TOOLWINDOW_ID", "", "getInstance", "Lcom/intellij/profiler/ProfilerToolWindowManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.profiler.common"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ProfilerToolWindowManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(ProfilerToolWindowManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (ProfilerToolWindowManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

