/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.ProfilerDumpPanel;
import com.intellij.profiler.ProfilerManager;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.actions.ImportProfilerResultAction;
import com.intellij.profiler.api.Failure;
import com.intellij.profiler.api.ProfileHistoryConfiguration;
import com.intellij.profiler.api.ProfilerData;
import com.intellij.profiler.api.ProfilerDumpDescriptor;
import com.intellij.profiler.api.ProfilerDumpFileParser;
import com.intellij.profiler.api.ProfilerDumpFileParsingResult;
import com.intellij.profiler.api.ProfilerDumpParserProvider;
import com.intellij.profiler.api.ProfilerDumpParserProviderKt;
import com.intellij.profiler.api.Success;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBRadioButton;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/actions/ImportProfilerResultAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "dump", "Lcom/intellij/profiler/api/ProfilerDumpDescriptor;", "(Lcom/intellij/profiler/api/ProfilerDumpDescriptor;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "intellij.profiler.common"})
public final class ImportProfilerResultAction
extends DumbAwareAction {
    private final ProfilerDumpDescriptor dump;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        Collection collection = ProfilerDumpParserProviderKt.getProfilerDumpParserProviders();
        boolean bl = false;
        presentation2.setEnabledAndVisible(!collection.isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        if (this.dump == null) {
            VirtualFile virtualFile2 = Companion.chooseProfilerSnapshot(project2);
            if (virtualFile2 == null) {
                return;
            }
            VirtualFile vFile = virtualFile2;
            com.intellij.profiler.actions.ImportProfilerResultAction$Companion.importProfilerDump$default(Companion, project2, new File(vFile.getPath()), null, null, null, 28, null);
        } else {
            com.intellij.profiler.actions.ImportProfilerResultAction$Companion.importProfilerDump$default(Companion, project2, this.dump, null, 4, null);
        }
    }

    public ImportProfilerResultAction(@Nullable ProfilerDumpDescriptor dump) {
        super(ImportProfilerResultAction.Companion.textFor(dump), null, ImportProfilerResultAction.Companion.iconFor(dump));
        this.dump = dump;
    }

    public /* synthetic */ ImportProfilerResultAction(ProfilerDumpDescriptor profilerDumpDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            profilerDumpDescriptor = null;
        }
        this(profilerDumpDescriptor);
    }

    public ImportProfilerResultAction() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ImportProfilerResultAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0017\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018J:\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0003J\f\u0010\u001c\u001a\u00020\u001b*\u00020\u001dH\u0003R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/profiler/actions/ImportProfilerResultAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "chooseOtherProvider", "Lcom/intellij/profiler/api/ProfilerDumpParserProvider;", "providers", "", "project", "Lcom/intellij/openapi/project/Project;", "chooseProfilerSnapshot", "Lcom/intellij/openapi/vfs/VirtualFile;", "findParserProvider", "file", "Ljava/io/File;", "iconFor", "Ljavax/swing/Icon;", "dump", "Lcom/intellij/profiler/api/ProfilerDumpDescriptor;", "importProfilerDump", "", "onComplete", "Ljava/lang/Runnable;", "parserProvider", "textFor", "", "getReasonString", "Lcom/intellij/profiler/api/Failure;", "intellij.profiler.common"})
    public static final class Companion {
        @NlsSafe
        private final String textFor(ProfilerDumpDescriptor dump) {
            Object object;
            block3: {
                block2: {
                    object = dump;
                    if (object == null) break block2;
                    ProfilerDumpDescriptor profilerDumpDescriptor = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    ProfilerDumpDescriptor it = profilerDumpDescriptor;
                    boolean bl3 = false;
                    object = it.getName() + " (" + new SimpleDateFormat("yyyy.MM.dd HH:mm:ss").format(it.getTime()) + ')';
                    if (object != null) break block3;
                }
                object = CommonProfilerBundleKt.profilerMessage("ui.action.open", new Object[0]);
            }
            return object;
        }

        private final Icon iconFor(ProfilerDumpDescriptor dump) {
            Icon icon2 = dump != null ? AllIcons.Actions.Profile : AllIcons.Actions.MenuOpen;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"if (dump != null) AllIco\u2026AllIcons.Actions.MenuOpen");
            return icon2;
        }

        public final void importProfilerDump(@NotNull Project project, @NotNull ProfilerDumpDescriptor dump, @Nullable Runnable onComplete) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
            this.importProfilerDump(project, dump.getFile(), dump.getParserProvider(), dump, onComplete);
        }

        public static /* synthetic */ void importProfilerDump$default(Companion companion, Project project, ProfilerDumpDescriptor profilerDumpDescriptor, Runnable runnable2, int n, Object object) {
            if ((n & 4) != 0) {
                runnable2 = null;
            }
            companion.importProfilerDump(project, profilerDumpDescriptor, runnable2);
        }

        public final void importProfilerDump(@NotNull Project project, @NotNull File file2, @Nullable ProfilerDumpParserProvider parserProvider, @Nullable ProfilerDumpDescriptor dump, @Nullable Runnable onComplete) {
            ProfilerDumpParserProvider provider2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            ProfilerDumpParserProvider profilerDumpParserProvider = parserProvider;
            if (profilerDumpParserProvider == null) {
                profilerDumpParserProvider = provider2 = this.findParserProvider(project, file2);
            }
            if (provider2 == null) {
                ProfilerManager.showStickyError$default(ProfilerManager.INSTANCE, CommonProfilerBundleKt.profilerMessage("profiler.action.import.cant.find.parser", new Object[0]), project, null, 4, null);
                return;
            }
            long start2 = System.currentTimeMillis();
            new Task.Backgroundable(file2, project, dump, provider2, start2, onComplete, project, CommonProfilerBundleKt.profilerMessage("profiler.action.import.reading", provider2.getName()), true, PerformInBackgroundOption.ALWAYS_BACKGROUND){
                private final ProfilerDumpFileParser parser;
                final /* synthetic */ File $file;
                final /* synthetic */ Project $project;
                final /* synthetic */ ProfilerDumpDescriptor $dump;
                final /* synthetic */ ProfilerDumpParserProvider $provider;
                final /* synthetic */ long $start;
                final /* synthetic */ Runnable $onComplete;

                public void run(@NotNull ProgressIndicator indicator2) {
                    Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
                    ProfilerDumpFileParsingResult result2 = this.parser.parse(this.$file, indicator2);
                    if (result2 instanceof Success) {
                        ProfileHistoryConfiguration profileHistoryConfiguration = ProfileHistoryConfiguration.Companion.getInstance(this.$project);
                        Object object = this.$dump;
                        if (object == null || (object = ((ProfilerDumpDescriptor)object).getName()) == null) {
                            object = this.$file.getName();
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dump?.name ?: file.name");
                        profileHistoryConfiguration.register(this.$file, (String)object);
                        AppUIUtil.invokeLaterIfProjectAlive(this.$project, new Runnable(this, result2){
                            final /* synthetic */ importProfilerDump.1 this$0;
                            final /* synthetic */ ProfilerDumpFileParsingResult $result;

                            public final void run() {
                                ProfilerUsageTriggerCollector.Companion.reportSnapshotOpen(this.this$0.$project, this.this$0.$provider.getId(), this.this$0.$file.length(), System.currentTimeMillis() - this.this$0.$start);
                                Object object = this.this$0.$dump;
                                if (object == null || (object = ((ProfilerDumpDescriptor)object).getName()) == null) {
                                    object = this.this$0.$file.getName();
                                }
                                Object name = object;
                                ProfilerToolWindowManager profilerToolWindowManager = ProfilerToolWindowManager.Companion.getInstance(this.this$0.$project);
                                Project project = this.this$0.$project;
                                ProfilerData profilerData = ((Success)this.$result).getData();
                                Object object2 = name;
                                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"name");
                                ProfilerToolWindowManager.addProfilerDumpTab$default(profilerToolWindowManager, new ProfilerDumpPanel(project, profilerData, (String)object2, importProfilerDump.1.access$getParser$p(this.this$0).getHelpId(), this.this$0.$dump), false, 2, null);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$result = profilerDumpFileParsingResult;
                            }
                        });
                    } else if (result2 instanceof Failure) {
                        ProfilerManager.showStickyError$default(ProfilerManager.INSTANCE, com.intellij.profiler.actions.ImportProfilerResultAction$Companion.access$getReasonString(ImportProfilerResultAction.Companion, (Failure)result2), this.$project, null, 4, null);
                    }
                }

                public void onFinished() {
                    block0: {
                        Runnable runnable2 = this.$onComplete;
                        if (runnable2 == null) break block0;
                        runnable2.run();
                    }
                }

                public void onThrowable(@NotNull Throwable error2) {
                    Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
                    ImportProfilerResultAction.access$getLOG$cp().error(error2);
                    ProfilerManager.showStickyError$default(ProfilerManager.INSTANCE, UtilsKt.explain(error2, CommonProfilerBundleKt.profilerMessage("profiler.action.import.error", new Object[0])), this.$project, null, 4, null);
                }
                {
                    this.$file = $captured_local_variable$0;
                    this.$project = $captured_local_variable$1;
                    this.$dump = $captured_local_variable$2;
                    this.$provider = $captured_local_variable$3;
                    this.$start = $captured_local_variable$4;
                    this.$onComplete = $captured_local_variable$5;
                    super($super_call_param$6, $super_call_param$7, $super_call_param$8, $super_call_param$9);
                    this.parser = $captured_local_variable$3.createParser($captured_local_variable$1);
                }

                public static final /* synthetic */ ProfilerDumpFileParser access$getParser$p(importProfilerDump.1 $this) {
                    return $this.parser;
                }
            }.queue();
        }

        public static /* synthetic */ void importProfilerDump$default(Companion companion, Project project, File file2, ProfilerDumpParserProvider profilerDumpParserProvider, ProfilerDumpDescriptor profilerDumpDescriptor, Runnable runnable2, int n, Object object) {
            if ((n & 4) != 0) {
                profilerDumpParserProvider = null;
            }
            if ((n & 8) != 0) {
                profilerDumpDescriptor = null;
            }
            if ((n & 0x10) != 0) {
                runnable2 = null;
            }
            companion.importProfilerDump(project, file2, profilerDumpParserProvider, profilerDumpDescriptor, runnable2);
        }

        @NlsSafe
        private final String getReasonString(Failure $this$getReasonString) {
            return $this$getReasonString.getReason();
        }

        /*
         * WARNING - void declaration
         */
        private final ProfilerDumpParserProvider findParserProvider(Project project, File file2) {
            ProfilerDumpParserProvider profilerDumpParserProvider;
            Object v1;
            List noExtension;
            block3: {
                void $this$filterTo$iv$iv;
                List<ProfilerDumpParserProvider> parserProviders = ProfilerDumpParserProviderKt.getProfilerDumpParserProviders();
                Iterable $this$filter$iv = parserProviders;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ProfilerDumpParserProvider it = (ProfilerDumpParserProvider)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getRequiredFileExtension() != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List withExtension = (List)destination$iv$iv;
                noExtension = CollectionsKt.minus((Iterable)parserProviders, (Iterable)withExtension);
                String string = FileUtilRt.getExtension((String)file2.getName());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtilRt.getExtension(file.name)");
                String extension2 = string;
                iterable = withExtension;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    ProfilerDumpParserProvider it = (ProfilerDumpParserProvider)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getRequiredFileExtension(), (Object)extension2)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            if ((profilerDumpParserProvider = (ProfilerDumpParserProvider)v1) == null) {
                profilerDumpParserProvider = this.chooseOtherProvider(noExtension, project);
            }
            return profilerDumpParserProvider;
        }

        /*
         * WARNING - void declaration
         */
        private final ProfilerDumpParserProvider chooseOtherProvider(List<? extends ProfilerDumpParserProvider> providers, Project project) {
            void $this$mapTo$iv$iv2;
            if (providers.size() == 1) {
                return (ProfilerDumpParserProvider)CollectionsKt.first(providers);
            }
            Object $this$map$iv = providers;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Iterator it;
                ProfilerDumpParserProvider profilerDumpParserProvider = (ProfilerDumpParserProvider)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                JBRadioButton jBRadioButton = new JBRadioButton(it.getName());
                collection.add(jBRadioButton);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map22 = false;
            boolean $this$mapTo$iv$iv2 = false;
            Object $this$apply = $this$map$iv;
            boolean bl = false;
            ((JBRadioButton)CollectionsKt.first((List)$this$apply)).setSelected(true);
            Iterable buttons = $this$map$iv;
            $this$map$iv = new ButtonGroup();
            $i$f$map22 = false;
            $this$mapTo$iv$iv2 = false;
            $this$apply = $this$map$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv = buttons;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JBRadioButton it = (JBRadioButton)element$iv;
                boolean bl3 = false;
                ((ButtonGroup)$this$apply).add((AbstractButton)it);
            }
            JPanel $i$f$map22 = new JPanel((LayoutManager)new VerticalFlowLayout());
            $this$mapTo$iv$iv2 = false;
            boolean bl4 = false;
            JPanel $this$apply2 = $i$f$map22;
            boolean bl5 = false;
            Iterable $this$forEach$iv2 = buttons;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                JBRadioButton it = (JBRadioButton)element$iv;
                boolean bl6 = false;
                $this$apply2.add((Component)it);
            }
            JPanel panel2 = $i$f$map22;
            DialogWrapper dialog2 = ComponentsKt.dialog$default(CommonProfilerBundleKt.profilerMessage("import.profiler.dump.dialog.title", new Object[0]), panel2, false, null, false, project, null, null, null, null, null, 2012, null);
            AtomicReference<Object> ref = new AtomicReference<Object>(null);
            ApplicationManager.getApplication().invokeAndWait(new Runnable(dialog2, (List)buttons, ref, providers){
                final /* synthetic */ DialogWrapper $dialog;
                final /* synthetic */ List $buttons;
                final /* synthetic */ AtomicReference $ref;
                final /* synthetic */ List $providers;

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    if (this.$dialog.showAndGet()) {
                        ProfilerDumpParserProvider profilerDumpParserProvider;
                        Object v0;
                        int n;
                        boolean bl;
                        Object object;
                        block5: {
                            object = CollectionsKt.withIndex((Iterable)this.$buttons);
                            bl = false;
                            Iterable iterable = object;
                            n = 0;
                            for (T t : iterable) {
                                IndexedValue $dstr$_u24__u24$b = (IndexedValue)t;
                                boolean bl2 = false;
                                JBRadioButton b = (JBRadioButton)$dstr$_u24__u24$b.component2();
                                if (!b.isSelected()) continue;
                                v0 = t;
                                break block5;
                            }
                            v0 = null;
                        }
                        IndexedValue indexedValue = v0;
                        Integer selected2 = indexedValue != null ? Integer.valueOf(indexedValue.getIndex()) : null;
                        AtomicReference atomicReference = this.$ref;
                        Integer n2 = selected2;
                        if (n2 != null) {
                            void it;
                            object = n2;
                            bl = false;
                            boolean bl3 = false;
                            n = ((Number)object).intValue();
                            AtomicReference atomicReference2 = atomicReference;
                            boolean bl4 = false;
                            ProfilerDumpParserProvider profilerDumpParserProvider2 = (ProfilerDumpParserProvider)CollectionsKt.getOrNull((List)this.$providers, (int)it);
                            atomicReference = atomicReference2;
                            profilerDumpParserProvider = profilerDumpParserProvider2;
                        } else {
                            profilerDumpParserProvider = null;
                        }
                        atomicReference.set(profilerDumpParserProvider);
                    } else {
                        this.$ref.set(null);
                    }
                }
                {
                    this.$dialog = dialogWrapper2;
                    this.$buttons = list2;
                    this.$ref = atomicReference;
                    this.$providers = list3;
                }
            });
            return ref.get();
        }

        @Nullable
        public final VirtualFile chooseProfilerSnapshot(@Nullable Project project) {
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileDescriptor().withTitle(CommonProfilerBundleKt.profilerMessage("profiler.action.import.openFile", new Object[0])).withHideIgnored(false);
            return FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)project, null);
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$getReasonString(Companion $this, Failure $this$access_u24getReasonString) {
            return $this.getReasonString($this$access_u24getReasonString);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

