/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api.monitor;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.api.monitor.CpuAndMemoryError;
import com.intellij.profiler.api.monitor.CpuAndMemoryInfo;
import com.intellij.profiler.api.monitor.CpuAndMemoryPanel;
import com.intellij.profiler.api.monitor.CpuAndMemoryPanel$WhenMappings;
import com.intellij.profiler.api.monitor.JavaProcessMonitor;
import com.intellij.profiler.api.monitor.ValueDisplay;
import com.intellij.profiler.charts.ChartUtils;
import com.intellij.profiler.charts.ChartWrapperKt;
import com.intellij.profiler.charts.Coordinates;
import com.intellij.profiler.charts.Dataset;
import com.intellij.profiler.charts.Grid;
import com.intellij.profiler.charts.GridChartWrapper;
import com.intellij.profiler.charts.GridLine;
import com.intellij.profiler.charts.LineChart;
import com.intellij.profiler.charts.LineDataset;
import com.intellij.profiler.charts.MinMax;
import com.intellij.profiler.charts.Overlay;
import com.intellij.profiler.charts.XYChartComponent;
import com.intellij.profiler.charts.XYDataHolder;
import com.intellij.profiler.charts.XYLineChart;
import com.intellij.profiler.charts.XYLineDataset;
import com.intellij.profiler.ui.concurrency.EdtWorker;
import com.intellij.profiler.ui.concurrency.SupplierUnderProgressIndicator;
import com.intellij.ui.DarculaColors;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.sun.management.OperatingSystemMXBean;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.math.MathKt;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001MB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u00102\u001a\u00020\u0017J\u0006\u00103\u001a\u00020\u0017J\b\u00104\u001a\u00020\u0017H\u0016J&\u00105\u001a\u00020\u00172\u001c\u00106\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\f\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\u001707H\u0002J6\u00108\u001a\u00020\u00172,\u00106\u001a(\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\f\u0012\u0002\b\u00030\u000b\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\f\u0012\u0002\b\u00030\u001e\u0012\u0004\u0012\u00020\u00170\u0014H\u0002J$\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020&2\b\b\u0002\u0010<\u001a\u00020\u00042\b\b\u0002\u0010=\u001a\u00020\u0004H\u0007J\u0006\u0010>\u001a\u00020\u0017J\u0010\u0010?\u001a\u00020\u00172\u0006\u0010@\u001a\u00020AH\u0016J\u0006\u0010B\u001a\u00020\u0017J\u0010\u0010C\u001a\u00020:2\u0006\u0010D\u001a\u00020\fH\u0002J\b\u0010E\u001a\u00020\u0017H\u0002J\u0010\u0010E\u001a\u00020\u00172\u0006\u0010F\u001a\u00020GH\u0002J\"\u0010H\u001a\u00020\u00172\u0010\u0010I\u001a\f\u0012\u0004\u0012\u00020\f\u0012\u0002\b\u00030\u000b2\u0006\u0010J\u001a\u00020\fH\u0002J(\u0010K\u001a\u00020\u0017*\f\u0012\u0004\u0012\u00020\f\u0012\u0002\b\u00030L2\u0010\u0010I\u001a\f\u0012\u0004\u0012\u00020\f\u0012\u0002\b\u00030\u000bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0010R\u00020\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u00020\u00170\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001c\u001a\u0018\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\"\u001a\u0018\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u0003\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b(\u0010)\"\u0004\b*\u0010\u0005R$\u0010.\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010)\"\u0004\b0\u0010\u0005R\u001a\u00101\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/intellij/profiler/api/monitor/CpuAndMemoryPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/Disposable;", "processId", "", "(I)V", "alarm", "Lcom/intellij/util/SingleAlarm;", "chartInsets", "Ljava/awt/Insets;", "cpu", "Lcom/intellij/profiler/charts/XYLineChart;", "", "", "dotPainters", "", "Lcom/intellij/profiler/api/monitor/CpuAndMemoryPanel$ValueDotPainter;", "edtWorker", "Lcom/intellij/profiler/ui/concurrency/EdtWorker;", "errorHandler", "Lkotlin/Function2;", "Lcom/intellij/profiler/api/monitor/CpuAndMemoryError;", "", "", "getErrorHandler", "()Lkotlin/jvm/functions/Function2;", "setErrorHandler", "(Lkotlin/jvm/functions/Function2;)V", "fillColors", "", "Lcom/intellij/profiler/charts/LineDataset;", "Ljava/awt/Paint;", "javaProcessMonitor", "Lcom/intellij/profiler/api/monitor/JavaProcessMonitor;", "lineColors", "mem", "nonheap", "processDescriptor", "Lcom/sun/tools/attach/VirtualMachineDescriptor;", "<set-?>", "getProcessId", "()I", "setProcessId", "processId$delegate", "Lkotlin/properties/ReadWriteProperty;", "value", "seconds", "getSeconds", "setSeconds", "thread", "cancel", "clear", "dispose", "forEachChart", "action", "Lkotlin/Function1;", "forEachDataset", "getDisplayName", "", "vmd", "maxLength", "suffixLength", "restart", "setEnabled", "enabled", "", "start", "time", "v", "updateChart", "info", "Lcom/intellij/profiler/api/monitor/CpuAndMemoryInfo;", "updateChartAxis", "chart", "currentTime", "xLines", "Lcom/intellij/profiler/charts/Grid;", "ValueDotPainter", "intellij.profiler.common"})
public final class CpuAndMemoryPanel
extends BorderLayoutPanel
implements Disposable {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private Function2<? super CpuAndMemoryError, ? super Throwable, Unit> errorHandler = (Function2)new Function2<CpuAndMemoryError, Throwable, Unit>(this){
        final /* synthetic */ CpuAndMemoryPanel this$0;

        public final void invoke(@NotNull CpuAndMemoryError type, @Nullable Throwable exc) {
            String string;
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            switch (CpuAndMemoryPanel$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    string = CommonProfilerBundleKt.profilerMessage("cpumemory.cannotFindVM", new Object[0]);
                    break;
                }
                case 2: {
                    string = CommonProfilerBundleKt.profilerMessage("cpumemory.cannotConnect", new Object[0]);
                    break;
                }
                case 3: {
                    string = CommonProfilerBundleKt.profilerMessage("cpumemory.unknownError", new Object[0]);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String message2 = string;
            ApplicationManager.getApplication().invokeLater(new Runnable(this, message2){
                final /* synthetic */ errorHandler.1 this$0;
                final /* synthetic */ String $message;

                public final void run() {
                    Messages.showErrorDialog((Component)((Component)((Object)this.this$0.this$0)), (String)this.$message, (String)CommonProfilerBundleKt.profilerMessage("cpumemory.errorOccurred", new Object[0]));
                }
                {
                    this.this$0 = var1_1;
                    this.$message = string;
                }
            });
            Throwable throwable = exc;
            if (throwable != null) {
                Throwable throwable2 = throwable;
                boolean bl = false;
                boolean bl2 = false;
                Throwable it = throwable2;
                boolean bl3 = false;
                it.printStackTrace();
                throw it;
            }
        }
        {
            this.this$0 = cpuAndMemoryPanel;
            super(2);
        }
    };
    @NotNull
    private final ReadWriteProperty processId$delegate;
    private int seconds;
    private VirtualMachineDescriptor processDescriptor;
    private final List<ValueDotPainter<?>> dotPainters;
    private JavaProcessMonitor javaProcessMonitor;
    private final EdtWorker edtWorker;
    private final SingleAlarm alarm;
    private final Insets chartInsets;
    private final Map<LineDataset<?, ?>, Paint> lineColors;
    private final Map<LineDataset<?, ?>, Paint> fillColors;
    private final XYLineChart<Long, Double> cpu;
    private final XYLineChart<Long, Long> mem;
    private final XYLineChart<Long, Long> nonheap;
    private final XYLineChart<Long, Integer> thread;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(CpuAndMemoryPanel.class, "processId", "getProcessId()I", 0))};
    }

    @NotNull
    public final Function2<CpuAndMemoryError, Throwable, Unit> getErrorHandler() {
        return this.errorHandler;
    }

    public final void setErrorHandler(@NotNull Function2<? super CpuAndMemoryError, ? super Throwable, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.errorHandler = function2;
    }

    public final int getProcessId() {
        return ((Number)this.processId$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    public final void setProcessId(int n) {
        this.processId$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
    }

    public final int getSeconds() {
        return this.seconds;
    }

    public final void setSeconds(int value2) {
        if (this.seconds != value2) {
            this.seconds = value2 < 1 ? -1 : value2;
            long currentTime = System.currentTimeMillis();
            this.forEachChart((Function1)new Function1<XYLineChart<Long, ?>, Unit>(this, currentTime){
                final /* synthetic */ CpuAndMemoryPanel this$0;
                final /* synthetic */ long $currentTime;

                public final void invoke(@NotNull XYLineChart<Long, ?> chart2) {
                    Intrinsics.checkNotNullParameter(chart2, (String)"chart");
                    CpuAndMemoryPanel.access$updateChartAxis(this.this$0, chart2, chart2.getRanges().getXMaxInitialized() ? ((Number)chart2.getRanges().getXMax()).longValue() : this.$currentTime);
                }
                {
                    this.this$0 = cpuAndMemoryPanel;
                    this.$currentTime = l;
                    super(1);
                }
            });
            this.repaint();
        }
    }

    private final void xLines(Grid<Long, ?> $this$xLines, XYLineChart<Long, ?> chart2) {
        $this$xLines.setXLines(ChartUtils.generator(1000L));
        ChartUtils.xPainter($this$xLines, (Function1)new Function1<GridLine<Long, ? extends Number, Long>, Unit>(this, chart2){
            final /* synthetic */ CpuAndMemoryPanel this$0;
            final /* synthetic */ XYLineChart $chart;

            public final void invoke(@NotNull GridLine<Long, ? extends Number, Long> $this$xPainter) {
                Intrinsics.checkNotNullParameter($this$xPainter, (String)"$receiver");
                int scale = ChartUtils.findScale(this.$chart, $this$xPainter.getXY().getXMin(), $this$xPainter.getXY().getXMax(), 120);
                $this$xPainter.setPaintLine((this.this$0.getSeconds() == -1 ? $this$xPainter.getValue() - $this$xPainter.getXY().getXMin() : $this$xPainter.getValue() / (long)1000 * (long)1000) % (long)scale == 0L);
                $this$xPainter.setHorizontalAlignment(4);
                if ($this$xPainter.getPaintLine()) {
                    Object v0;
                    block3: {
                        Iterable iterable = CpuAndMemoryPanel.access$getDotPainters$p(this.this$0);
                        boolean bl = false;
                        Iterable iterable2 = iterable;
                        boolean bl2 = false;
                        for (T t : iterable2) {
                            ValueDotPainter it = (ValueDotPainter)t;
                            boolean bl3 = false;
                            if (!(it.getMouseLocation() != null)) continue;
                            v0 = t;
                            break block3;
                        }
                        v0 = null;
                    }
                    if (v0 == null) {
                        $this$xPainter.setLabel(CpuAndMemoryPanel.access$time(this.this$0, $this$xPainter.getValue()));
                    }
                }
            }
            {
                this.this$0 = cpuAndMemoryPanel;
                this.$chart = xYLineChart;
                super(1);
            }
        });
    }

    public final void clear() {
        this.cpu.clear();
        this.mem.clear();
        this.nonheap.clear();
        this.nonheap.getRanges().setYMax(1L);
        this.thread.clear();
        this.thread.getRanges().setYMax(1);
    }

    public final void start() {
        this.edtWorker.updateAsync(start.1.INSTANCE).onSuccess(new Consumer(this){
            final /* synthetic */ CpuAndMemoryPanel this$0;

            public final void accept(List<VirtualMachineDescriptor> vms) {
                Object v1;
                CpuAndMemoryPanel cpuAndMemoryPanel;
                block1: {
                    List<VirtualMachineDescriptor> list2 = vms;
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"vms");
                    Iterable iterable = list2;
                    cpuAndMemoryPanel = this.this$0;
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (T t : iterable2) {
                        String string;
                        VirtualMachineDescriptor it = (VirtualMachineDescriptor)t;
                        boolean bl3 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it.id(), (String)"it.id()");
                        boolean bl4 = false;
                        if (!(Integer.parseInt(string) == this.this$0.getProcessId())) continue;
                        v1 = t;
                        break block1;
                    }
                    v1 = null;
                }
                Object var13_13 = v1;
                CpuAndMemoryPanel.access$setProcessDescriptor$p(cpuAndMemoryPanel, var13_13);
                CpuAndMemoryPanel.access$updateChart(this.this$0);
            }
            {
                this.this$0 = cpuAndMemoryPanel;
            }
        });
    }

    public final void cancel() {
        this.alarm.cancelAllRequests();
        this.clear();
    }

    public final void restart() {
        this.cancel();
        this.start();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.forEachDataset((Function2)new Function2<XYLineChart<Long, ?>, LineDataset<Long, ?>, Unit>(this){
                final /* synthetic */ CpuAndMemoryPanel this$0;

                public final void invoke(@NotNull XYLineChart<Long, ?> $noName_0, @NotNull LineDataset<Long, ?> dataset2) {
                    Intrinsics.checkNotNullParameter($noName_0, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter(dataset2, (String)"dataset");
                    Paint paint2 = (Paint)CpuAndMemoryPanel.access$getLineColors$p(this.this$0).get(dataset2);
                    if (paint2 == null) {
                        paint2 = (Paint)JBColor.GRAY;
                    }
                    dataset2.setLineColor(paint2);
                    Paint paint3 = (Paint)CpuAndMemoryPanel.access$getFillColors$p(this.this$0).get(dataset2);
                    if (paint3 == null) {
                        paint3 = (Paint)JBColor.GRAY;
                    }
                    dataset2.setFillColor(paint3);
                }
                {
                    this.this$0 = cpuAndMemoryPanel;
                    super(2);
                }
            });
        } else {
            this.forEachDataset(setEnabled.2.INSTANCE);
        }
    }

    private final void forEachDataset(Function2<? super XYLineChart<Long, ?>, ? super LineDataset<Long, ?>, Unit> action2) {
        this.forEachChart((Function1)new Function1<XYLineChart<Long, ?>, Unit>(action2){
            final /* synthetic */ Function2 $action;

            public final void invoke(@NotNull XYLineChart<Long, ?> chart2) {
                Intrinsics.checkNotNullParameter(chart2, (String)"chart");
                Iterable $this$forEach$iv = chart2.getDatasets();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    XYLineDataset dataset2 = (XYLineDataset)element$iv;
                    boolean bl = false;
                    this.$action.invoke(chart2, (Object)dataset2);
                }
            }
            {
                this.$action = function2;
                super(1);
            }
        });
    }

    private final void forEachChart(Function1<? super XYLineChart<Long, ?>, Unit> action2) {
        XYLineChart[] $this$forEach$iv = new XYLineChart[]{this.cpu, this.mem, this.nonheap, this.thread};
        boolean $i$f$forEach = false;
        for (XYLineChart element$iv : $this$forEach$iv) {
            action2.invoke((Object)element$iv);
        }
    }

    private final void updateChart() {
        VirtualMachineDescriptor data2 = this.processDescriptor;
        if (data2 == null) {
            this.edtWorker.updateAsync(updateChart.1.INSTANCE).onSuccess(new Consumer(this){
                final /* synthetic */ CpuAndMemoryPanel this$0;

                public final void accept(List<VirtualMachineDescriptor> vms) {
                    String pid2 = OSProcessUtil.getApplicationPid();
                    for (VirtualMachineDescriptor descriptor2 : vms) {
                        if (!Intrinsics.areEqual((Object)pid2, (Object)descriptor2.id())) continue;
                        CpuAndMemoryPanel.access$updateChart(this.this$0);
                        return;
                    }
                    this.this$0.getErrorHandler().invoke((Object)((Object)CpuAndMemoryError.CANNOT_FIND_CURRENT_VM), null);
                }
                {
                    this.this$0 = cpuAndMemoryPanel;
                }
            });
            return;
        }
        this.edtWorker.updateAsync(new SupplierUnderProgressIndicator(this, data2){
            final /* synthetic */ CpuAndMemoryPanel this$0;
            final /* synthetic */ VirtualMachineDescriptor $data;

            @Nullable
            public final CpuAndMemoryInfo run(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Integer pid2 = Integer.valueOf(this.$data.id());
                JavaProcessMonitor javaProcessMonitor = CpuAndMemoryPanel.access$getJavaProcessMonitor$p(this.this$0);
                if (Intrinsics.areEqual((Object)(javaProcessMonitor != null ? Integer.valueOf(javaProcessMonitor.getPid()) : null), (Object)pid2) ^ true) {
                    JavaProcessMonitor javaProcessMonitor2 = CpuAndMemoryPanel.access$getJavaProcessMonitor$p(this.this$0);
                    if (javaProcessMonitor2 != null) {
                        javaProcessMonitor2.close();
                    }
                    Integer n = pid2;
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"pid");
                    CpuAndMemoryPanel.access$setJavaProcessMonitor$p(this.this$0, JavaProcessMonitor.Companion.connect(n));
                }
                JavaProcessMonitor javaProcessMonitor3 = CpuAndMemoryPanel.access$getJavaProcessMonitor$p(this.this$0);
                Intrinsics.checkNotNull((Object)javaProcessMonitor3);
                OperatingSystemMXBean os = javaProcessMonitor3.getOsBean();
                double processCpuLoad2 = os.getProcessCpuLoad();
                JavaProcessMonitor javaProcessMonitor4 = CpuAndMemoryPanel.access$getJavaProcessMonitor$p(this.this$0);
                Intrinsics.checkNotNull((Object)javaProcessMonitor4);
                MemoryMXBean memory = javaProcessMonitor4.getMemoryBean();
                MemoryUsage memoryUsage = memory.getHeapMemoryUsage();
                Intrinsics.checkNotNullExpressionValue((Object)memoryUsage, (String)"memory.heapMemoryUsage");
                long usedHeapMemory = memoryUsage.getUsed() >> 20;
                MemoryUsage memoryUsage2 = memory.getHeapMemoryUsage();
                Intrinsics.checkNotNullExpressionValue((Object)memoryUsage2, (String)"memory.heapMemoryUsage");
                long heapMemoryMax = memoryUsage2.getMax() >> 20;
                MemoryUsage memoryUsage3 = memory.getNonHeapMemoryUsage();
                Intrinsics.checkNotNullExpressionValue((Object)memoryUsage3, (String)"memory.nonHeapMemoryUsage");
                long nonHeapMemory = memoryUsage3.getUsed() >> 20;
                JavaProcessMonitor javaProcessMonitor5 = CpuAndMemoryPanel.access$getJavaProcessMonitor$p(this.this$0);
                Intrinsics.checkNotNull((Object)javaProcessMonitor5);
                ThreadMXBean threads = javaProcessMonitor5.getThreadBean();
                int threadCount = threads.getThreadCount();
                int peakThreadCount = threads.getPeakThreadCount();
                int daemonThreadCount = threads.getDaemonThreadCount();
                long msecond = System.currentTimeMillis();
                it.checkCanceled();
                return new CpuAndMemoryInfo(processCpuLoad2, usedHeapMemory, heapMemoryMax, nonHeapMemory, threadCount, daemonThreadCount, peakThreadCount, msecond);
            }
            {
                this.this$0 = cpuAndMemoryPanel;
                this.$data = virtualMachineDescriptor;
            }
        }).onSuccess(new Consumer(this){
            final /* synthetic */ CpuAndMemoryPanel this$0;

            public final void accept(CpuAndMemoryInfo info2) {
                CpuAndMemoryInfo cpuAndMemoryInfo = info2;
                Intrinsics.checkNotNullExpressionValue((Object)cpuAndMemoryInfo, (String)"info");
                CpuAndMemoryPanel.access$updateChart(this.this$0, cpuAndMemoryInfo);
                Function0 function0 = (Function0)new Function0<Unit>(this.this$0){

                    public final void invoke() {
                        CpuAndMemoryPanel.access$updateChart((CpuAndMemoryPanel)((Object)this.receiver));
                    }
                };
                CpuAndMemoryPanel.access$getAlarm$p(this.this$0).addRequest(new Runnable(function0){
                    private final /* synthetic */ Function0 function;
                    {
                        this.function = function0;
                    }

                    public final /* synthetic */ void run() {
                        Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                    }
                }, 1000);
                this.this$0.repaint();
            }
            {
                this.this$0 = cpuAndMemoryPanel;
            }
        }).onError(new Consumer(this){
            final /* synthetic */ CpuAndMemoryPanel this$0;

            public final void accept(Throwable exp) {
                this.this$0.getErrorHandler().invoke((Object)((Object)CpuAndMemoryError.CANNOT_CONNECT_TO_CURRENT_VM), (Object)exp);
            }
            {
                this.this$0 = cpuAndMemoryPanel;
            }
        });
    }

    private final void updateChart(CpuAndMemoryInfo info2) {
        long currentTime = info2.getMsecond();
        this.cpu.add((Long)((Number)info2.getMsecond()), (Double)((Number)(info2.getProcessCpuLoad() * (double)100)));
        this.updateChartAxis(this.cpu, currentTime);
        long l = info2.getMsecond();
        long l2 = ((Number)this.cpu.getRanges().getXMin()).longValue() + 1L;
        boolean bl = false;
        this.cpu.getRanges().setXMax(Math.max(l, l2));
        this.mem.getDataset("Used").add(ChartWrapperKt.to(info2.getMsecond(), info2.getUsedHeapMemory()));
        this.updateChartAxis(this.mem, currentTime);
        this.mem.getRanges().setYMax(info2.getHeapMemoryMax());
        l = info2.getMsecond();
        l2 = ((Number)this.mem.getRanges().getXMin()).longValue() + 1L;
        bl = false;
        this.mem.getRanges().setXMax(Math.max(l, l2));
        this.nonheap.add((Long)((Number)info2.getMsecond()), (Long)((Number)info2.getNonHeapMemory()));
        this.updateChartAxis(this.nonheap, currentTime);
        l = info2.getNonHeapMemory();
        l2 = ((Number)this.nonheap.getRanges().getYMax()).longValue();
        bl = false;
        this.nonheap.getRanges().setYMax(Math.max(l, l2));
        l = info2.getMsecond();
        l2 = ((Number)this.nonheap.getRanges().getXMin()).longValue() + 1L;
        bl = false;
        this.nonheap.getRanges().setXMax(Math.max(l, l2));
        this.thread.getDataset("Total").add(ChartWrapperKt.to(info2.getMsecond(), info2.getThreadCount()));
        this.thread.getDataset("Daemon").add(ChartWrapperKt.to(info2.getMsecond(), info2.getDaemonThreadCount()));
        this.thread.getRanges().setYMax(info2.getPeakThreadCount());
        this.updateChartAxis(this.thread, currentTime);
        l = info2.getMsecond();
        l2 = ((Number)this.thread.getRanges().getXMin()).longValue() + 1L;
        bl = false;
        this.thread.getRanges().setXMax(Math.max(l, l2));
    }

    private final void updateChartAxis(XYLineChart<Long, ?> chart2, long currentTime) {
        block1: {
            block0: {
                if (this.seconds <= -1) break block0;
                chart2.getRanges().setXMin(currentTime - (long)(this.seconds * 1000));
                break block1;
            }
            Object object = (XYLineDataset)CollectionsKt.firstOrNull(chart2.getDatasets());
            if (object == null || (object = ((Dataset)object).getData()) == null || (object = (Coordinates)CollectionsKt.firstOrNull((Iterable)object)) == null || (object = (Long)((Coordinates)object).getX()) == null) break block1;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            long it = ((Number)object2).longValue();
            boolean bl3 = false;
            chart2.getRanges().setXMin(it);
        }
    }

    public void dispose() {
        this.cancel();
        Disposer.dispose((Disposable)this.edtWorker);
        JavaProcessMonitor javaProcessMonitor = this.javaProcessMonitor;
        if (javaProcessMonitor != null) {
            javaProcessMonitor.close();
        }
        this.javaProcessMonitor = null;
    }

    @NlsSafe
    @NotNull
    public final String getDisplayName(@NotNull VirtualMachineDescriptor vmd, int maxLength, int suffixLength) {
        Intrinsics.checkNotNullParameter((Object)vmd, (String)"vmd");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s %s";
        Object[] objectArray = new Object[]{vmd.id(), vmd.displayName()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String string3 = StringUtil.shortenTextWithEllipsis((String)string2, (int)maxLength, (int)suffixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringUtil.shortenTextWi\u2026 maxLength, suffixLength)");
        return string3;
    }

    public static /* synthetic */ String getDisplayName$default(CpuAndMemoryPanel cpuAndMemoryPanel, VirtualMachineDescriptor virtualMachineDescriptor, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 90;
        }
        if ((n3 & 4) != 0) {
            n2 = 30;
        }
        return cpuAndMemoryPanel.getDisplayName(virtualMachineDescriptor, n, n2);
    }

    private final String time(long v) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%1$tH:%1$tM:%1$tS";
        Object[] objectArray = new Object[]{v};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public CpuAndMemoryPanel(int processId) {
        void $this$mapTo$iv$iv;
        Object $this$apply;
        Delegates delegates = Delegates.INSTANCE;
        Integer initialValue$iv = processId;
        boolean $i$f$observable = false;
        this.processId$delegate = (ReadWriteProperty)new ObservableProperty<Integer>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ CpuAndMemoryPanel this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = cpuAndMemoryPanel;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property2, Object oldValue, Object newValue2) {
                void newValue3;
                void oldValue2;
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                int n = ((Number)newValue2).intValue();
                int n2 = ((Number)oldValue).intValue();
                KProperty $noName_0 = property2;
                boolean bl = false;
                if (oldValue2 != newValue3) {
                    this.this$0.cancel();
                    this.this$0.start();
                }
            }
        };
        this.seconds = 60;
        boolean this_$iv = false;
        this.dotPainters = new ArrayList();
        this.edtWorker = new EdtWorker(AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Cpu and Memory Worker", (int)1));
        this.alarm = new SingleAlarm(new Runnable(this){
            final /* synthetic */ CpuAndMemoryPanel this$0;

            public final void run() {
                CpuAndMemoryPanel.access$updateChart(this.this$0);
            }
            {
                this.this$0 = cpuAndMemoryPanel;
            }
        }, 1000, this, Alarm.ThreadToUse.POOLED_THREAD, null, 16, null);
        this.chartInsets = new Insets(30, 10, 30, 10);
        this_$iv = false;
        this.lineColors = new LinkedHashMap();
        this_$iv = false;
        this.fillColors = new LinkedHashMap();
        this.cpu = ChartUtils.lineChart((Function1)new Function1<XYLineChart<Long, Double>, Unit>(this){
            final /* synthetic */ CpuAndMemoryPanel this$0;

            public final void invoke(@NotNull XYLineChart<Long, Double> $this$lineChart) {
                Intrinsics.checkNotNullParameter($this$lineChart, (String)"$receiver");
                ChartUtils.ranges((XYChartComponent)$this$lineChart, cpu.1.INSTANCE);
                ChartUtils.grid((GridChartWrapper)$this$lineChart, (Function1)new Function1<Grid<Long, Double>, Unit>(this, $this$lineChart){
                    final /* synthetic */ cpu.1 this$0;
                    final /* synthetic */ XYLineChart $this_lineChart;

                    public final void invoke(@NotNull Grid<Long, Double> $this$grid) {
                        Intrinsics.checkNotNullParameter($this$grid, (String)"$receiver");
                        CpuAndMemoryPanel.access$xLines(this.this$0.this$0, $this$grid, this.$this_lineChart);
                        $this$grid.setYLines(ChartUtils.enumerator((Number[])new Double[]{0.0, 25.0, 50.0, 75.0, 100.0}));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$this_lineChart = xYLineChart;
                        super(1);
                    }
                });
                $this$lineChart.setMargins(CpuAndMemoryPanel.access$getChartInsets$p(this.this$0));
                ChartUtils.dataset($this$lineChart, (Function1)new Function1<XYLineDataset<Long, Double>, Unit>(this, $this$lineChart){
                    final /* synthetic */ cpu.1 this$0;
                    final /* synthetic */ XYLineChart $this_lineChart;

                    public final void invoke(@NotNull XYLineDataset<Long, Double> $this$dataset) {
                        Intrinsics.checkNotNullParameter($this$dataset, (String)"$receiver");
                        $this$dataset.setLineColor(new Color(98, 150, 85));
                        $this$dataset.setFillColor(new Color(98, 150, 85, 128));
                        $this$dataset.setModificationFirst(true);
                        this.$this_lineChart.setOverlays(CollectionsKt.listOf((Object[])new Overlay[]{new ValueDotPainter<T>(this.this$0.this$0, (Dataset)$this$dataset, "%%", 0), new ValueDisplay<T>((Dataset)$this$dataset, CommonProfilerBundleKt.profilerMessage("cpumemory.chart.cpu", new Object[0]), "%%", 0, true)}));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$this_lineChart = xYLineChart;
                        super(1);
                    }
                });
                $this$lineChart.setBorderPainted(true);
            }
            {
                this.this$0 = cpuAndMemoryPanel;
                super(1);
            }
        });
        this.mem = ChartUtils.lineChart((Function1)new Function1<XYLineChart<Long, Long>, Unit>(this){
            final /* synthetic */ CpuAndMemoryPanel this$0;

            public final void invoke(@NotNull XYLineChart<Long, Long> $this$lineChart) {
                Intrinsics.checkNotNullParameter($this$lineChart, (String)"$receiver");
                $this$lineChart.getRanges().setYMin(0L);
                ChartUtils.grid((GridChartWrapper)$this$lineChart, (Function1)new Function1<Grid<Long, Long>, Unit>(this, $this$lineChart){
                    final /* synthetic */ mem.1 this$0;
                    final /* synthetic */ XYLineChart $this_lineChart;

                    public final void invoke(@NotNull Grid<Long, Long> $this$grid) {
                        Intrinsics.checkNotNullParameter($this$grid, (String)"$receiver");
                        CpuAndMemoryPanel.access$xLines(this.this$0.this$0, $this$grid, this.$this_lineChart);
                        $this$grid.setYLines(ChartUtils.generator(512L));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$this_lineChart = xYLineChart;
                        super(1);
                    }
                });
                $this$lineChart.setMargins(CpuAndMemoryPanel.access$getChartInsets$p(this.this$0));
                ChartUtils.datasets($this$lineChart, (Function1)new Function1<XYDataHolder<Long, Long>, Unit>(this, $this$lineChart){
                    final /* synthetic */ mem.1 this$0;
                    final /* synthetic */ XYLineChart $this_lineChart;

                    public final void invoke(@NotNull XYDataHolder<Long, Long> $this$datasets) {
                        Intrinsics.checkNotNullParameter($this$datasets, (String)"$receiver");
                        ChartUtils.dataset($this$datasets, (Function1)new Function1<XYLineDataset<Long, Long>, Unit>(this){
                            final /* synthetic */ mem.2 this$0;

                            public final void invoke(@NotNull XYLineDataset<Long, Long> $this$dataset) {
                                Intrinsics.checkNotNullParameter($this$dataset, (String)"$receiver");
                                $this$dataset.setLabel("Used");
                                $this$dataset.setLineColor(DarculaColors.BLUE);
                                Color color = DarculaColors.BLUE;
                                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"DarculaColors.BLUE");
                                $this$dataset.setFillColor($this$dataset.transparent(color, 0.5));
                                $this$dataset.setModificationFirst(true);
                                this.this$0.$this_lineChart.setOverlays(CollectionsKt.listOf((Object[])new Overlay[]{new ValueDotPainter<T>(this.this$0.this$0.this$0, (Dataset)$this$dataset, " MB", 0), new ValueDisplay<T>($this$dataset, CommonProfilerBundleKt.profilerMessage("cpumemory.chart.heap.memory", new Object[0]), " MB", 0, false, 16, null)}));
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$this_lineChart = xYLineChart;
                        super(1);
                    }
                });
                $this$lineChart.setBorderPainted(true);
            }
            {
                this.this$0 = cpuAndMemoryPanel;
                super(1);
            }
        });
        this.nonheap = ChartUtils.lineChart((Function1)new Function1<XYLineChart<Long, Long>, Unit>(this){
            final /* synthetic */ CpuAndMemoryPanel this$0;

            public final void invoke(@NotNull XYLineChart<Long, Long> $this$lineChart) {
                Intrinsics.checkNotNullParameter($this$lineChart, (String)"$receiver");
                $this$lineChart.getRanges().setYMin(0L);
                $this$lineChart.getRanges().setYMax(0L);
                ChartUtils.grid((GridChartWrapper)$this$lineChart, (Function1)new Function1<Grid<Long, Long>, Unit>(this, $this$lineChart){
                    final /* synthetic */ nonheap.1 this$0;
                    final /* synthetic */ XYLineChart $this_lineChart;

                    public final void invoke(@NotNull Grid<Long, Long> $this$grid) {
                        Intrinsics.checkNotNullParameter($this$grid, (String)"$receiver");
                        CpuAndMemoryPanel.access$xLines(this.this$0.this$0, $this$grid, this.$this_lineChart);
                        $this$grid.setYLines(ChartUtils.generator(512L));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$this_lineChart = xYLineChart;
                        super(1);
                    }
                });
                $this$lineChart.setMargins(CpuAndMemoryPanel.access$getChartInsets$p(this.this$0));
                ChartUtils.datasets($this$lineChart, (Function1)new Function1<XYDataHolder<Long, Long>, Unit>(this, $this$lineChart){
                    final /* synthetic */ nonheap.1 this$0;
                    final /* synthetic */ XYLineChart $this_lineChart;

                    public final void invoke(@NotNull XYDataHolder<Long, Long> $this$datasets) {
                        Intrinsics.checkNotNullParameter($this$datasets, (String)"$receiver");
                        ChartUtils.dataset($this$datasets, (Function1)new Function1<XYLineDataset<Long, Long>, Unit>(this){
                            final /* synthetic */ nonheap.2 this$0;

                            public final void invoke(@NotNull XYLineDataset<Long, Long> $this$dataset) {
                                Intrinsics.checkNotNullParameter($this$dataset, (String)"$receiver");
                                $this$dataset.setLabel("Used");
                                $this$dataset.setLineColor(new Color(151, 118, 169));
                                $this$dataset.setFillColor($this$dataset.transparent(new Color(151, 118, 169), 0.5));
                                $this$dataset.setModificationFirst(true);
                                this.this$0.$this_lineChart.setOverlays(CollectionsKt.listOf((Object[])new Overlay[]{new ValueDotPainter<T>(this.this$0.this$0.this$0, (Dataset)$this$dataset, " MB", 0), new ValueDisplay<T>($this$dataset, CommonProfilerBundleKt.profilerMessage("cpumemory.chart.non.heap", new Object[0]), " MB", 0, false, 16, null)}));
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$this_lineChart = xYLineChart;
                        super(1);
                    }
                });
                $this$lineChart.setBorderPainted(true);
            }
            {
                this.this$0 = cpuAndMemoryPanel;
                super(1);
            }
        });
        this.thread = ChartUtils.lineChart((Function1)new Function1<XYLineChart<Long, Integer>, Unit>(this){
            final /* synthetic */ CpuAndMemoryPanel this$0;

            public final void invoke(@NotNull XYLineChart<Long, Integer> $this$lineChart) {
                Intrinsics.checkNotNullParameter($this$lineChart, (String)"$receiver");
                $this$lineChart.getRanges().setYMin(0);
                ChartUtils.grid((GridChartWrapper)$this$lineChart, (Function1)new Function1<Grid<Long, Integer>, Unit>(this, $this$lineChart){
                    final /* synthetic */ thread.1 this$0;
                    final /* synthetic */ XYLineChart $this_lineChart;

                    public final void invoke(@NotNull Grid<Long, Integer> $this$grid) {
                        Intrinsics.checkNotNullParameter($this$grid, (String)"$receiver");
                        CpuAndMemoryPanel.access$xLines(this.this$0.this$0, $this$grid, this.$this_lineChart);
                        $this$grid.setYLines(ChartUtils.generator(50));
                    }
                    {
                        this.this$0 = var1_1;
                        this.$this_lineChart = xYLineChart;
                        super(1);
                    }
                });
                $this$lineChart.setMargins(CpuAndMemoryPanel.access$getChartInsets$p(this.this$0));
                ChartUtils.datasets($this$lineChart, (Function1)new Function1<XYDataHolder<Long, Integer>, Unit>(this, $this$lineChart){
                    final /* synthetic */ thread.1 this$0;
                    final /* synthetic */ XYLineChart $this_lineChart;

                    public final void invoke(@NotNull XYDataHolder<Long, Integer> $this$datasets) {
                        Intrinsics.checkNotNullParameter($this$datasets, (String)"$receiver");
                        ChartUtils.dataset($this$datasets, (Function1)new Function1<XYLineDataset<Long, Integer>, Unit>(this){
                            final /* synthetic */ thread.2 this$0;

                            public final void invoke(@NotNull XYLineDataset<Long, Integer> $this$dataset) {
                                Intrinsics.checkNotNullParameter($this$dataset, (String)"$receiver");
                                $this$dataset.setLabel("Daemon");
                                $this$dataset.setStacked(true);
                                $this$dataset.setLineColor((Paint)JBColor.RED);
                                JBColor jBColor = JBColor.RED;
                                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"JBColor.RED");
                                $this$dataset.setFillColor($this$dataset.transparent((Color)jBColor, 0.5));
                                $this$dataset.setModificationFirst(true);
                                this.this$0.$this_lineChart.setOverlays(CollectionsKt.listOf(new ValueDotPainter<T>(this.this$0.this$0.this$0, (Dataset)$this$dataset, "", -1)));
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                        ChartUtils.dataset($this$datasets, (Function1)new Function1<XYLineDataset<Long, Integer>, Unit>(this){
                            final /* synthetic */ thread.2 this$0;

                            public final void invoke(@NotNull XYLineDataset<Long, Integer> $this$dataset) {
                                Intrinsics.checkNotNullParameter($this$dataset, (String)"$receiver");
                                $this$dataset.setLabel("Total");
                                $this$dataset.setLineColor((Paint)JBColor.ORANGE);
                                JBColor jBColor = JBColor.ORANGE;
                                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"JBColor.ORANGE");
                                $this$dataset.setFillColor($this$dataset.transparent((Color)jBColor, 0.5));
                                $this$dataset.setModificationFirst(true);
                                this.this$0.$this_lineChart.setOverlays(CollectionsKt.listOf((Object[])new Overlay[]{new ValueDotPainter<T>(this.this$0.this$0.this$0, (Dataset)$this$dataset, "", 0), new ValueDisplay<T>($this$dataset, CommonProfilerBundleKt.profilerMessage("cpumemory.chart.threads", new Object[0]), "", 0, false, 16, null)}));
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$this_lineChart = xYLineChart;
                        super(1);
                    }
                });
                $this$lineChart.setBorderPainted(true);
            }
            {
                this.this$0 = cpuAndMemoryPanel;
                super(1);
            }
        });
        final OnePixelSplitter central = new OnePixelSplitter(true, 0.65f);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Component component2 = e.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"e.component");
                double d = component2.getHeight();
                Component component3 = e.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"e.component");
                central.setOrientation(d / (double)component3.getWidth() >= 0.5);
            }
        });
        initialValue$iv = new OpaquePanel();
        $i$f$observable = false;
        boolean bl = false;
        Integer n = initialValue$iv;
        Object object = central;
        boolean bl2 = false;
        $this$apply.setLayout((LayoutManager)new BoxLayout((Container)$this$apply, 0));
        $this$apply.add((Component)this.cpu.getComponent());
        $this$apply.add((Component)this.mem.getComponent());
        Object object2 = Unit.INSTANCE;
        object.setFirstComponent((JComponent)((Object)initialValue$iv));
        initialValue$iv = new OpaquePanel();
        $i$f$observable = false;
        bl = false;
        $this$apply = initialValue$iv;
        object = central;
        boolean bl3 = false;
        $this$apply.setLayout((LayoutManager)new BoxLayout((Container)$this$apply, 0));
        $this$apply.add((Component)this.thread.getComponent());
        $this$apply.add((Component)this.nonheap.getComponent());
        object2 = Unit.INSTANCE;
        object.setSecondComponent((JComponent)((Object)initialValue$iv));
        this.addToCenter((Component)central);
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])new XYLineChart[]{this.cpu, this.mem, this.nonheap, this.thread});
        boolean $i$f$map = false;
        $this$apply = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            XYLineChart xYLineChart = (XYLineChart)item$iv$iv;
            object = destination$iv$iv;
            boolean bl4 = false;
            object2 = it.getComponent();
            object.add(object2);
        }
        List charts = (List)destination$iv$iv;
        MouseAdapter ma2 = new MouseAdapter(charts){
            final /* synthetic */ List $charts;

            private final void repaintOtherCharts(MouseEvent e) {
                Iterable $this$forEach$iv = this.$charts;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JComponent it = (JComponent)element$iv;
                    boolean bl = false;
                    if (it == e.getSource()) continue;
                    it.repaint();
                }
            }

            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.repaintOtherCharts(e);
            }

            public void mouseEntered(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.repaintOtherCharts(e);
            }

            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.repaintOtherCharts(e);
            }
            {
                this.$charts = $captured_local_variable$0;
            }
        };
        Iterable $this$forEach$iv = charts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JComponent it = (JComponent)element$iv;
            boolean bl5 = false;
            it.addMouseMotionListener(ma2);
            it.addMouseListener(ma2);
        }
        this.forEachDataset((Function2)new Function2<XYLineChart<Long, ?>, LineDataset<Long, ?>, Unit>(){

            public final void invoke(@NotNull XYLineChart<Long, ?> $noName_0, @NotNull LineDataset<Long, ?> dataset2) {
                Intrinsics.checkNotNullParameter($noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(dataset2, (String)"dataset");
                lineColors.put(dataset2, dataset2.getLineColor());
                fillColors.put(dataset2, dataset2.getFillColor());
            }
        });
    }

    public static final /* synthetic */ void access$updateChartAxis(CpuAndMemoryPanel $this, XYLineChart chart2, long currentTime) {
        $this.updateChartAxis(chart2, currentTime);
    }

    public static final /* synthetic */ VirtualMachineDescriptor access$getProcessDescriptor$p(CpuAndMemoryPanel $this) {
        return $this.processDescriptor;
    }

    public static final /* synthetic */ void access$setProcessDescriptor$p(CpuAndMemoryPanel $this, VirtualMachineDescriptor virtualMachineDescriptor) {
        $this.processDescriptor = virtualMachineDescriptor;
    }

    public static final /* synthetic */ void access$updateChart(CpuAndMemoryPanel $this) {
        $this.updateChart();
    }

    public static final /* synthetic */ JavaProcessMonitor access$getJavaProcessMonitor$p(CpuAndMemoryPanel $this) {
        return $this.javaProcessMonitor;
    }

    public static final /* synthetic */ void access$setJavaProcessMonitor$p(CpuAndMemoryPanel $this, JavaProcessMonitor javaProcessMonitor) {
        $this.javaProcessMonitor = javaProcessMonitor;
    }

    public static final /* synthetic */ void access$updateChart(CpuAndMemoryPanel $this, CpuAndMemoryInfo info2) {
        $this.updateChart(info2);
    }

    public static final /* synthetic */ SingleAlarm access$getAlarm$p(CpuAndMemoryPanel $this) {
        return $this.alarm;
    }

    public static final /* synthetic */ void access$xLines(CpuAndMemoryPanel $this, Grid $this$access_u24xLines, XYLineChart chart2) {
        $this.xLines($this$access_u24xLines, chart2);
    }

    public static final /* synthetic */ Insets access$getChartInsets$p(CpuAndMemoryPanel $this) {
        return $this.chartInsets;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u0001\u0012\u0002\b\u00030\u00040\u0003B1\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R#\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/intellij/profiler/api/monitor/CpuAndMemoryPanel$ValueDotPainter;", "T", "", "Lcom/intellij/profiler/charts/Overlay;", "Lcom/intellij/profiler/charts/LineChart;", "", "data", "Lcom/intellij/profiler/charts/Dataset;", "Lcom/intellij/profiler/charts/Coordinates;", "postfix", "", "digits", "", "(Lcom/intellij/profiler/api/monitor/CpuAndMemoryPanel;Lcom/intellij/profiler/charts/Dataset;Ljava/lang/String;I)V", "getData", "()Lcom/intellij/profiler/charts/Dataset;", "getPostfix", "()Ljava/lang/String;", "paintComponent", "", "g", "Ljava/awt/Graphics2D;", "intellij.profiler.common"})
    private final class ValueDotPainter<T extends Number>
    extends Overlay<LineChart<Long, T, ?>> {
        @NotNull
        private final Dataset<Coordinates<Long, T>> data;
        @NotNull
        private final String postfix;
        private final int digits;
        final /* synthetic */ CpuAndMemoryPanel this$0;

        /*
         * WARNING - void declaration
         */
        @Override
        public void paintComponent(@NotNull Graphics2D g) {
            block5: {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Iterable $this$mapNotNull$iv = this.this$0.dotPainters;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Point point;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    ValueDotPainter it = (ValueDotPainter)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getMouseLocation() == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Point it$iv$iv = point;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Point point = (Point)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                if (point == null) break block5;
                Point point2 = point;
                boolean bl = false;
                boolean bl6 = false;
                Point it = point2;
                boolean bl7 = false;
                MinMax xy = ((LineChart)this.getChart()).findMinMax();
                if (xy.isInitialized() && it.x >= ((LineChart)this.getChart()).getMargins().left && it.x <= ((LineChart)this.getChart()).getWidth() - ((LineChart)this.getChart()).getMargins().right) {
                    int x = it.x - ((LineChart)this.getChart()).getMargins().left;
                    double rat = (double)x * 1.0 / (double)(((LineChart)this.getChart()).getWidth() - (((LineChart)this.getChart()).getMargins().left + ((LineChart)this.getChart()).getMargins().right));
                    long value2 = MathKt.roundToLong((double)((double)(((Number)xy.getXMax()).longValue() - ((Number)xy.getXMin()).longValue()) * rat)) + ((Number)xy.getXMin()).longValue();
                    Coordinates<Long, T> res2 = null;
                    for (Coordinates<Long, T> datum : this.data.getData()) {
                        if (datum.getX() <= value2) continue;
                        res2 = datum;
                        break;
                    }
                    if (res2 != null) {
                        Point2D.Double p = ((LineChart)this.getChart()).findLocation(xy, res2);
                        int radius = 4;
                        g.setPaint(this.data.getLineColor());
                        g.fillOval(MathKt.roundToInt((double)p.x) - radius, MathKt.roundToInt((double)p.y) - radius, radius * 2, radius * 2);
                        g.setPaint(((LineChart)this.getChart()).getBackground());
                        g.drawOval(MathKt.roundToInt((double)p.x) - radius, MathKt.roundToInt((double)p.y) - radius, radius * 2, radius * 2);
                        if (this.digits >= 0) {
                            g.setColor(JBColor.foreground());
                            String string = "%." + this.digits + 'f' + this.postfix;
                            Object object = new Object[]{((Number)res2.getY()).doubleValue()};
                            boolean bl8 = false;
                            String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
                            String test = string2;
                            String tm = this.this$0.time(res2.getX());
                            object = g.getFontMetrics();
                            bl8 = false;
                            boolean bl9 = false;
                            Object $this$with = object;
                            boolean bl10 = false;
                            Rectangle2D bounds2 = ((FontMetrics)$this$with).getStringBounds(test, null);
                            int n = MathKt.roundToInt((double)p.x);
                            Rectangle2D rectangle2D = bounds2;
                            Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"bounds");
                            int n2 = MathKt.roundToInt((double)p.y) - (int)bounds2.getHeight();
                            int n3 = (int)bounds2.getHeight() + 30;
                            boolean bl11 = false;
                            g.drawString(test, n - (int)rectangle2D.getWidth() / 2, Math.max(n2, n3));
                            g.setPaint(((LineChart)this.getChart()).getGridLabelColor());
                            Rectangle2D bounds22 = ((FontMetrics)$this$with).getStringBounds(tm, null);
                            int n4 = MathKt.roundToInt((double)p.x);
                            Rectangle2D rectangle2D2 = bounds22;
                            Intrinsics.checkNotNullExpressionValue((Object)rectangle2D2, (String)"bounds2");
                            g.drawString(tm, n4 - (int)rectangle2D2.getWidth() / 2, ((LineChart)this.getChart()).getHeight() - ((LineChart)this.getChart()).getMargins().bottom + (int)bounds22.getHeight());
                        }
                    }
                }
            }
        }

        @NotNull
        public final Dataset<Coordinates<Long, T>> getData() {
            return this.data;
        }

        @NotNull
        public final String getPostfix() {
            return this.postfix;
        }

        public ValueDotPainter(@NotNull CpuAndMemoryPanel this$0, @NotNull Dataset<Coordinates<Long, T>> data2, String postfix, int digits) {
            Intrinsics.checkNotNullParameter(data2, (String)"data");
            Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
            this.this$0 = this$0;
            this.data = data2;
            this.postfix = postfix;
            this.digits = digits;
            this$0.dotPainters.add(this);
        }

        public /* synthetic */ ValueDotPainter(CpuAndMemoryPanel cpuAndMemoryPanel, Dataset dataset2, String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                n = 2;
            }
            this(cpuAndMemoryPanel, dataset2, string, n);
        }
    }
}

