/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.charts;

import com.intellij.profiler.charts.ChartComponent;
import com.intellij.profiler.charts.Overlay;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0002/0B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010)\u001a\u00020\nH\u0014J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0006\u0010.\u001a\u00020+R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R(\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b@BX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R0\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010!2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010!@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001e\u0010'\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0013\u00a8\u00061"}, d2={"Lcom/intellij/profiler/charts/ChartWrapper;", "Lcom/intellij/profiler/charts/ChartComponent;", "()V", "background", "Ljava/awt/Color;", "getBackground", "()Ljava/awt/Color;", "setBackground", "(Ljava/awt/Color;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "component$delegate", "Lkotlin/Lazy;", "<set-?>", "", "height", "getHeight", "()I", "margins", "Ljava/awt/Insets;", "getMargins", "()Ljava/awt/Insets;", "setMargins", "(Ljava/awt/Insets;)V", "value", "Ljava/awt/Point;", "mouseLocation", "getMouseLocation", "()Ljava/awt/Point;", "setMouseLocation", "(Ljava/awt/Point;)V", "", "overlays", "getOverlays", "()Ljava/util/List;", "setOverlays", "(Ljava/util/List;)V", "width", "getWidth", "createCentralPanel", "paintOverlay", "", "g", "Ljava/awt/Graphics2D;", "update", "CentralPanel", "MouseAware", "intellij.profiler.common"})
public abstract class ChartWrapper
implements ChartComponent {
    private int width;
    private int height;
    @NotNull
    private Color background;
    @NotNull
    private List<? extends ChartComponent> overlays;
    @NotNull
    private Insets margins;
    @NotNull
    private final Lazy component$delegate;
    @Nullable
    private Point mouseLocation;

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final Color getBackground() {
        return this.background;
    }

    public final void setBackground(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.background = color;
    }

    @NotNull
    public final List<ChartComponent> getOverlays() {
        return this.overlays;
    }

    public final void setOverlays(@NotNull List<? extends ChartComponent> value2) {
        ChartComponent it;
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        Iterable $this$forEach$iv = this.overlays;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ChartComponent)element$iv;
            boolean bl = false;
            if (!(it instanceof Overlay)) continue;
            ((Overlay)it).setWrapper(null);
        }
        List<? extends ChartComponent> list2 = this.overlays;
        if (list2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.profiler.charts.ChartComponent>");
        }
        TypeIntrinsics.asMutableList(list2).addAll((Collection)value2);
        $this$forEach$iv = this.overlays;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ChartComponent)element$iv;
            boolean bl = false;
            if (!(it instanceof Overlay)) continue;
            ((Overlay)it).setWrapper(this);
        }
    }

    @NotNull
    public final Insets getMargins() {
        return this.margins;
    }

    public final void setMargins(@NotNull Insets insets) {
        Intrinsics.checkNotNullParameter((Object)insets, (String)"<set-?>");
        this.margins = insets;
    }

    public void paintOverlay(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Iterable $this$forEach$iv = this.overlays;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChartComponent it = (ChartComponent)element$iv;
            boolean bl = false;
            it.paintComponent(g);
        }
    }

    @NotNull
    public JComponent getComponent() {
        Lazy lazy = this.component$delegate;
        ChartWrapper chartWrapper2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (JComponent)lazy.getValue();
    }

    public final void update() {
        this.getComponent().repaint();
    }

    @NotNull
    protected JComponent createCentralPanel() {
        return new CentralPanel();
    }

    @Nullable
    protected final Point getMouseLocation() {
        return this.mouseLocation;
    }

    private final void setMouseLocation(Point value2) {
        this.mouseLocation = value2;
        Iterable $this$forEach$iv = this.overlays;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChartComponent it = (ChartComponent)element$iv;
            boolean bl = false;
            if (!(it instanceof Overlay)) continue;
            ((Overlay)it).setMouseLocation(value2);
        }
    }

    public ChartWrapper() {
        Color color = JBColor.background();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"JBColor.background()");
        this.background = color;
        boolean bl = false;
        this.overlays = new ArrayList();
        this.margins = new Insets(0, 0, 0, 0);
        this.component$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JComponent>(this){
            final /* synthetic */ ChartWrapper this$0;

            @NotNull
            public final JComponent invoke() {
                JComponent jComponent = this.this$0.createCentralPanel();
                boolean bl = false;
                boolean bl2 = false;
                JComponent $this$apply = jComponent;
                boolean bl3 = false;
                MouseAware mouseAware = this.this$0.new MouseAware();
                boolean bl4 = false;
                boolean bl5 = false;
                MouseAware $this$with = mouseAware;
                boolean bl6 = false;
                $this$apply.addMouseMotionListener($this$with);
                $this$apply.addMouseListener($this$with);
                return jComponent;
            }
            {
                this.this$0 = chartWrapper2;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ Point access$getMouseLocation$p(ChartWrapper $this) {
        return $this.mouseLocation;
    }

    public static final /* synthetic */ int access$getHeight$p(ChartWrapper $this) {
        return $this.height;
    }

    public static final /* synthetic */ int access$getWidth$p(ChartWrapper $this) {
        return $this.width;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/charts/ChartWrapper$MouseAware;", "Ljava/awt/event/MouseAdapter;", "(Lcom/intellij/profiler/charts/ChartWrapper;)V", "mouseDragged", "", "e", "Ljava/awt/event/MouseEvent;", "mouseEntered", "mouseExited", "mouseMoved", "intellij.profiler.common"})
    private final class MouseAware
    extends MouseAdapter {
        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ChartWrapper.this.setMouseLocation(e.getPoint());
            ChartWrapper.this.getComponent().repaint();
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ChartWrapper.this.setMouseLocation(e.getPoint());
            ChartWrapper.this.getComponent().repaint();
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ChartWrapper.this.setMouseLocation(null);
            ChartWrapper.this.getComponent().repaint();
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ChartWrapper.this.setMouseLocation(e.getPoint());
            ChartWrapper.this.getComponent().repaint();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/charts/ChartWrapper$CentralPanel;", "Ljavax/swing/JComponent;", "(Lcom/intellij/profiler/charts/ChartWrapper;)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.profiler.common"})
    private final class CentralPanel
    extends JComponent {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            g.setClip(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            g.setColor(ChartWrapper.this.getBackground());
            ((Graphics2D)g).fill(((Graphics2D)g).getClip());
            ChartWrapper.this.height = this.getHeight();
            ChartWrapper.this.width = this.getWidth();
            Graphics graphics = g.create(0, 0, ChartWrapper.this.getWidth(), ChartWrapper.this.getHeight());
            if (graphics == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            boolean bl = false;
            boolean bl2 = false;
            Graphics2D $this$apply = graphics2D;
            boolean bl3 = false;
            $this$apply.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            $this$apply.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            $this$apply.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            GraphicsUtil.setupAntialiasing((Graphics)$this$apply);
            Graphics2D gridGraphics = graphics2D;
            try {
                ChartWrapper.this.paintComponent(gridGraphics);
            }
            finally {
                gridGraphics.dispose();
            }
            Graphics graphics2 = g.create();
            if (graphics2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
            }
            Graphics2D graphics2D2 = (Graphics2D)graphics2;
            bl2 = false;
            boolean bl4 = false;
            Graphics2D $this$apply2 = graphics2D2;
            boolean bl5 = false;
            $this$apply2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            $this$apply2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            $this$apply2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            GraphicsUtil.setupAntialiasing((Graphics)$this$apply2);
            Graphics2D overlayGraphics = graphics2D2;
            try {
                ChartWrapper.this.paintOverlay(overlayGraphics);
            }
            finally {
                overlayGraphics.dispose();
            }
        }
    }
}

