/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.model;

import com.intellij.profiler.model.Transformation;
import com.intellij.profiler.model.TransformationResult;
import com.intellij.profiler.model.TreeNode;
import com.intellij.profiler.model.TreeTransformer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001am\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\u0004\b\u0000\u0010\u0004\"\u000e\b\u0001\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00040\u0006\"\u0004\b\u0002\u0010\u0002\"\u000e\b\u0003\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00062\u001e\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\b2\u0006\u0010\t\u001a\u0002H\u0005H\u0002\u00a2\u0006\u0002\u0010\n\u001a_\u0010\u000b\u001a\u0002H\u0003\"\u0004\b\u0000\u0010\u0004\"\u000e\b\u0001\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00040\u0006\"\u0004\b\u0002\u0010\u0002\"\u000e\b\u0003\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00062\u001e\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\b2\u0006\u0010\t\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"applyTransformer", "Lcom/intellij/profiler/model/TransformationResult;", "ToData", "To", "FromData", "From", "Lcom/intellij/profiler/model/TreeNode;", "transformer", "Lcom/intellij/profiler/model/TreeTransformer;", "node", "(Lcom/intellij/profiler/model/TreeTransformer;Lcom/intellij/profiler/model/TreeNode;)Lcom/intellij/profiler/model/TransformationResult;", "transformTree", "(Lcom/intellij/profiler/model/TreeTransformer;Lcom/intellij/profiler/model/TreeNode;)Lcom/intellij/profiler/model/TreeNode;", "intellij.profiler.common"})
public final class TreeTransformerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <FromData, From extends TreeNode<? extends FromData>, ToData, To extends TreeNode<? extends ToData>> To transformTree(@NotNull TreeTransformer<FromData, From, ToData, To> transformer, @NotNull From node2) {
        void returnValue;
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        boolean bl = transformer.preConditionChecker(node2);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "precondition check failed for " + transformer;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        TransformationResult<ToData, To> transformationResult = TreeTransformerKt.applyTransformer(transformer, node2);
        To To = transformationResult.component1();
        To newHead = transformationResult.component2();
        List oldStack = CollectionsKt.mutableListOf((Object[])new TreeNode[]{node2});
        List newStack = CollectionsKt.mutableListOf((Object[])new TreeNode[]{newHead});
        block0: while (true) {
            Collection collection = oldStack;
            boolean bl5 = false;
            if (!(!collection.isEmpty())) break;
            TreeNode oldTop = (TreeNode)oldStack.remove(CollectionsKt.getLastIndex((List)oldStack));
            TreeNode newTop = (TreeNode)newStack.remove(CollectionsKt.getLastIndex((List)newStack));
            Iterable $this$forEach$iv = transformer.children(oldTop);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (true) {
                void newChild;
                if (!iterator2.hasNext()) continue block0;
                Object element$iv = iterator2.next();
                TreeNode oldChild = (TreeNode)element$iv;
                boolean bl6 = false;
                Object object = TreeTransformerKt.applyTransformer(transformer, oldChild);
                To To2 = ((TransformationResult)object).component1();
                To newListHead = ((TransformationResult)object).component2();
                transformer.postProcess((void)newTop, newChild);
                object = newStack;
                boolean bl7 = false;
                object.add(newListHead);
                object = oldStack;
                bl7 = false;
                object.add(oldChild);
            }
            break;
        }
        return returnValue;
    }

    private static final <FromData, From extends TreeNode<? extends FromData>, ToData, To extends TreeNode<? extends ToData>> TransformationResult<ToData, To> applyTransformer(TreeTransformer<FromData, From, ToData, To> transformer, From node2) {
        TransformationResult transformationResult;
        Transformation<To> transformation = transformer.transform(node2);
        if (transformation instanceof Transformation.Single) {
            transformationResult = new TransformationResult((TreeNode)((Transformation.Single)transformation).getData(), (TreeNode)((Transformation.Single)transformation).getData());
        } else if (transformation instanceof Transformation.ListOf) {
            TreeNode head;
            TreeNode currentNode = head = (TreeNode)CollectionsKt.first(transformation.getList());
            List rest = CollectionsKt.drop((Iterable)transformation.getList(), (int)1);
            while (true) {
                Collection collection = rest;
                boolean bl = false;
                if (!(!collection.isEmpty())) break;
                TreeNode child2 = (TreeNode)CollectionsKt.first((List)rest);
                transformer.postProcess(currentNode, child2);
                currentNode = child2;
                rest = CollectionsKt.drop((Iterable)rest, (int)1);
            }
            transformationResult = new TransformationResult(head, currentNode);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return transformationResult;
    }
}

