/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.model.AllThreadsMerged;
import com.intellij.profiler.model.JVMThread;
import com.intellij.profiler.model.NativeThread;
import com.intellij.profiler.model.ThreadInfo;
import com.intellij.profiler.ui.ThreadInfoRenderer;
import com.intellij.profiler.ui.timeline.DefaultNode;
import com.intellij.profiler.ui.timeline.DefaultTimelineCellRenderer;
import com.intellij.profiler.ui.timeline.TimelineComponent;
import com.intellij.profiler.ui.timeline.TimelineModel;
import com.intellij.profiler.ui.timeline.TimelinePanel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020!0 0\u001f2\u0006\u0010\"\u001a\u00020\u0004H\u0002J\"\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020!0 0\u001f2\u0006\u0010\"\u001a\u00020\u0004H\u0002J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%J\u000e\u0010&\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0004J8\u0010'\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H*0)\u0012\u0004\u0012\u0002H+0(\"\u0004\b\u0000\u0010*\"\u0004\b\u0001\u0010+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H+\u0012\u0004\u0012\u00020.0-J\u0006\u0010/\u001a\u000200J$\u00101\u001a\u000202*\u0002032\u0006\u00104\u001a\u0002052\b\u0010\"\u001a\u0004\u0018\u00010\u00012\u0006\u00106\u001a\u00020\u001dR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0010\"\u0004\b\u001b\u0010\u0012R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/profiler/ui/ThreadInfoRenderer;", "", "threads", "", "Lcom/intellij/profiler/model/ThreadInfo;", "(Ljava/util/Collection;)V", "maxMetricWidth", "", "myMetricsColor", "Ljava/awt/Color;", "getMyMetricsColor", "()Ljava/awt/Color;", "setMyMetricsColor", "(Ljava/awt/Color;)V", "myMetricsOffset", "getMyMetricsOffset", "()I", "setMyMetricsOffset", "(I)V", "myMetricsText", "", "getMyMetricsText", "()Ljava/lang/String;", "setMyMetricsText", "(Ljava/lang/String;)V", "myMetricsWidth", "getMyMetricsWidth", "setMyMetricsWidth", "oneType", "", "attributedText", "", "Lkotlin/Pair;", "Lcom/intellij/ui/SimpleTextAttributes;", "value", "attributedTextWithSpaces", "listCellRenderer", "Lcom/intellij/ui/ColoredListCellRenderer;", "speedSearchText", "timelineCellRenderer", "Lcom/intellij/profiler/ui/timeline/DefaultTimelineCellRenderer;", "Lcom/intellij/profiler/ui/timeline/DefaultNode;", "T", "F", "eventColor", "Lkotlin/Function1;", "Lcom/intellij/ui/JBColor;", "treeCellRenderer", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "commonCustomizeCellRenderer", "", "Lcom/intellij/ui/SimpleColoredComponent;", "parent", "Ljavax/swing/JComponent;", "selected", "intellij.profiler.common"})
public final class ThreadInfoRenderer {
    private final boolean oneType;
    @Nullable
    private String myMetricsText;
    @Nullable
    private Color myMetricsColor;
    private int myMetricsWidth;
    private int myMetricsOffset;
    private int maxMetricWidth;

    /*
     * WARNING - void declaration
     */
    public final void commonCustomizeCellRenderer(@NotNull SimpleColoredComponent $this$commonCustomizeCellRenderer, @NotNull JComponent parent, @Nullable Object value2, boolean selected2) {
        Intrinsics.checkNotNullParameter((Object)$this$commonCustomizeCellRenderer, (String)"$this$commonCustomizeCellRenderer");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.myMetricsText = null;
        this.myMetricsWidth = 0;
        if (!(value2 instanceof ThreadInfo)) {
            return;
        }
        Object $this$forEach$iv = this.attributedTextWithSpaces((ThreadInfo)value2);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            void str;
            Object element$iv = iterator2.next();
            Pair $dstr$str$attr = (Pair)element$iv;
            boolean bl = false;
            String string = (String)$dstr$str$attr.component1();
            SimpleTextAttributes attr = (SimpleTextAttributes)$dstr$str$attr.component2();
            $this$commonCustomizeCellRenderer.append((String)str, attr);
        }
        SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)parent, (SimpleColoredComponent)$this$commonCustomizeCellRenderer, (boolean)false, (boolean)selected2);
        if ($this$commonCustomizeCellRenderer.getFont() == null) {
            return;
        }
        this.myMetricsText = ((ThreadInfo)value2).getMetrics().getPrimaryMetric().getRepresentation();
        $this$forEach$iv = this.myMetricsText;
        int n = 0;
        int n2 = 0;
        if (!($this$forEach$iv == null || $this$forEach$iv.length() == 0)) {
            Color color;
            FontMetrics fontMetrics = $this$commonCustomizeCellRenderer.getFontMetrics(RelativeFont.SMALL.derive($this$commonCustomizeCellRenderer.getFont()));
            String string = this.myMetricsText;
            Intrinsics.checkNotNull((Object)string);
            this.myMetricsWidth = fontMetrics.stringWidth(string);
            n = this.maxMetricWidth;
            n2 = this.myMetricsWidth;
            boolean bl = false;
            this.maxMetricWidth = Math.max(n, n2);
            FontMetrics fontMetrics2 = fontMetrics;
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics2, (String)"fontMetrics");
            this.myMetricsOffset = fontMetrics2.getHeight() / 2;
            if (selected2) {
                color = UIUtil.getListSelectionForeground((boolean)true);
            } else {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAY_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.GRAY_ATTRIBUTES");
                color = simpleTextAttributes.getFgColor();
            }
            this.myMetricsColor = color;
        }
    }

    @Nullable
    public final String getMyMetricsText() {
        return this.myMetricsText;
    }

    public final void setMyMetricsText(@Nullable String string) {
        this.myMetricsText = string;
    }

    @Nullable
    public final Color getMyMetricsColor() {
        return this.myMetricsColor;
    }

    public final void setMyMetricsColor(@Nullable Color color) {
        this.myMetricsColor = color;
    }

    public final int getMyMetricsWidth() {
        return this.myMetricsWidth;
    }

    public final void setMyMetricsWidth(int n) {
        this.myMetricsWidth = n;
    }

    public final int getMyMetricsOffset() {
        return this.myMetricsOffset;
    }

    public final void setMyMetricsOffset(int n) {
        this.myMetricsOffset = n;
    }

    @NotNull
    public final ColoredListCellRenderer<ThreadInfo> listCellRenderer() {
        return (ColoredListCellRenderer)new ColoredListCellRenderer<ThreadInfo>(this){
            final /* synthetic */ ThreadInfoRenderer this$0;

            protected void customizeCellRenderer(@NotNull JList<? extends ThreadInfo> list2, @Nullable ThreadInfo value2, int index2, boolean selected2, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                this.this$0.commonCustomizeCellRenderer((SimpleColoredComponent)this, list2, value2, selected2);
            }

            protected void paintComponent(@NotNull Graphics g) {
                Point point;
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                UISettings.Companion.setupAntialiasing(g);
                String text2 = this.this$0.getMyMetricsText();
                if (this.getFont() != null && text2 != null && (point = this.getStartingPointToRenderMetrics()) != null) {
                    int w = point.x;
                    int h = point.y;
                    g.setColor(this.this$0.getMyMetricsColor());
                    g.setFont(RelativeFont.SMALL.derive(this.getFont()));
                    g.drawString(text2, w + this.this$0.getMyMetricsOffset() / 2, SimpleColoredComponent.getTextBaseLine((FontMetrics)g.getFontMetrics(), (int)h));
                    g.clipRect(0, 0, w + this.this$0.getMyMetricsWidth() - ThreadInfoRenderer.access$getMaxMetricWidth$p(this.this$0), h);
                }
                super.paintComponent(g);
            }

            private final Point getStartingPointToRenderMetrics() {
                listCellRenderer.getStartingPointToRenderMetrics.1 $fun$getWidthIfNeededToAdjustMetricPosition$1 = listCellRenderer.getStartingPointToRenderMetrics.1.INSTANCE;
                if (this.this$0.getMyMetricsWidth() > 0) {
                    int n;
                    JBScrollPane scrollPane = (JBScrollPane)ComponentUtil.getParentOfType(JBScrollPane.class, (Component)((Component)((Object)this)));
                    Object object = scrollPane;
                    if (object != null && (object = object.getViewport()) != null) {
                        Object object2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object2;
                        boolean bl3 = false;
                        n = ((JViewport)it).getExtentSize().width + ((JViewport)it).getViewPosition().x;
                    } else {
                        n = this.getWidth();
                    }
                    int w = n;
                    Object object3 = scrollPane;
                    int scrollPaneWidth = object3 != null && (object3 = object3.getVerticalScrollBar()) != null ? $fun$getWidthIfNeededToAdjustMetricPosition$1.invoke((JScrollBar)object3) : 0;
                    int h = this.getHeight();
                    if ((w -= this.this$0.getMyMetricsWidth() + this.this$0.getMyMetricsOffset() + scrollPaneWidth) > 0 && h > 0) {
                        return new Point(w, h);
                    }
                }
                return null;
            }

            @NotNull
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"super.getPreferredSize()");
                Dimension dimension2 = dimension;
                boolean bl = false;
                boolean bl2 = false;
                Dimension $this$apply = dimension2;
                boolean bl3 = false;
                if (this.this$0.getMyMetricsWidth() > 0) {
                    $this$apply.width += this.this$0.getMyMetricsWidth() + this.this$0.getMyMetricsOffset();
                }
                return dimension2;
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    @NotNull
    public final <T, F> DefaultTimelineCellRenderer<DefaultNode<T>, F> timelineCellRenderer(@NotNull Function1<? super F, ? extends JBColor> eventColor) {
        Intrinsics.checkNotNullParameter(eventColor, (String)"eventColor");
        return new DefaultTimelineCellRenderer<DefaultNode<T>, F>(this, eventColor){
            final /* synthetic */ ThreadInfoRenderer this$0;
            final /* synthetic */ Function1 $eventColor;

            public void customizeCellRenderer(@NotNull TimelinePanel<DefaultNode<T>, ?> panel2, @NotNull DefaultNode<T> value2, boolean isSelected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(panel2, (String)"panel");
                Intrinsics.checkNotNullParameter(value2, (String)"value");
                this.this$0.commonCustomizeCellRenderer(this, (JComponent)((Object)panel2), value2.getData(), isSelected);
            }

            @NotNull
            public JBColor getBackground(@NotNull TimelineComponent<?, F> panel2, @NotNull TimelineModel.TimelineInterval<F> node2) {
                Object object;
                block3: {
                    block2: {
                        Intrinsics.checkNotNullParameter(panel2, (String)"panel");
                        Intrinsics.checkNotNullParameter(node2, (String)"node");
                        object = node2.getContent();
                        if (object == null) break block2;
                        F f = object;
                        Function1 function1 = this.$eventColor;
                        boolean bl = false;
                        boolean bl2 = false;
                        object = (JBColor)function1.invoke(f);
                        if (object != null) break block3;
                    }
                    object = super.getBackground(panel2, node2);
                }
                return object;
            }
            {
                this.this$0 = this$0;
                this.$eventColor = $captured_local_variable$1;
            }
        };
    }

    @NotNull
    public final ColoredTreeCellRenderer treeCellRenderer() {
        return new ColoredTreeCellRenderer(this){
            final /* synthetic */ ThreadInfoRenderer this$0;

            public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value2, boolean selected2, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                this.this$0.commonCustomizeCellRenderer((SimpleColoredComponent)this, tree, value2, selected2);
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, SimpleTextAttributes>> attributedTextWithSpaces(ThreadInfo value2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.attributedText(value2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List list2 = CollectionsKt.mutableListOf((Object[])new Pair[]{it});
            collection.add(list2);
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void part;
            List $i$f$mapTo2 = (List)iterator$iv.next();
            List acc = (List)accumulator$iv;
            boolean bl = false;
            accumulator$iv = CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)acc, (Object)new Pair((Object)" ", (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES)), (Iterable)((Iterable)part)));
        }
        return (List)accumulator$iv;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final List<Pair<String, SimpleTextAttributes>> attributedText(ThreadInfo value2) {
        boolean bl;
        if (value2 instanceof AllThreadsMerged) {
            return CollectionsKt.listOf((Object)TuplesKt.to((Object)CommonProfilerBundleKt.profilerMessage("ui.allThreadsMerged", new Object[0]), (Object)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
        }
        boolean bl2 = false;
        List result2 = new ArrayList();
        if (!this.oneType) {
            Collection collection = result2;
            Pair pair = TuplesKt.to((Object)(value2 instanceof JVMThread ? "JVM:" : "Native:"), (Object)SimpleTextAttributes.GRAY_ATTRIBUTES);
            bl = false;
            collection.add(pair);
        }
        Object object = value2.getName();
        boolean bl3 = false;
        if (object.length() == 0) {
            object = value2.getNativeId();
            bl3 = false;
            if (object.length() == 0) {
                object = result2;
                Pair pair = TuplesKt.to((Object)('<' + CommonProfilerBundleKt.profilerMessage("ui.noThreadInfo", new Object[0]) + '>'), (Object)SimpleTextAttributes.GRAY_ATTRIBUTES);
                bl = false;
                object.add(pair);
                return result2;
            }
        }
        object = value2.getName();
        bl3 = false;
        if (object.length() > 0) {
            object = result2;
            Pair pair = TuplesKt.to((Object)value2.getName(), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES);
            bl = false;
            object.add(pair);
        }
        String metricsRepresentation = value2.getMetrics().secondaryMetricsAsString();
        Object object2 = metricsRepresentation;
        bl = false;
        if (!(object2.length() > 0)) return result2;
        object2 = result2;
        Pair pair = TuplesKt.to((Object)metricsRepresentation, (Object)SimpleTextAttributes.GRAY_ATTRIBUTES);
        boolean bl4 = false;
        object2.add(pair);
        return result2;
    }

    @NotNull
    public final String speedSearchText(@NotNull ThreadInfo value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return CollectionsKt.joinToString$default((Iterable)this.attributedText(value2), (CharSequence)" ", null, null, (int)0, null, (Function1)speedSearchText.1.INSTANCE, (int)30, null);
    }

    /*
     * Unable to fully structure code
     */
    public ThreadInfoRenderer(@NotNull Collection<? extends ThreadInfo> threads) {
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter(threads, (String)"threads");
                super();
                var2_2 = threads;
                var13_3 = this;
                $i$f$filter = false;
                var4_5 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ThreadInfo)element$iv$iv;
                    $i$a$-filter-ThreadInfoRenderer$oneType$1 = false;
                    if (!(it instanceof AllThreadsMerged == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                var14_16 = (List)destination$iv$iv;
                var2_2 = var14_16;
                var3_4 = false;
                var4_6 = false;
                destination$iv$iv = var2_2;
                $i$a$-let-ThreadInfoRenderer$oneType$2 = false;
                $this$all$iv = (Iterable)real;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v0 = true;
                } else {
                    for (T element$iv : $this$all$iv) {
                        it = (ThreadInfo)element$iv;
                        $i$a$-all-ThreadInfoRenderer$oneType$2$1 = false;
                        if (it instanceof JVMThread) continue;
                        v0 = false;
                        break block9;
                    }
                    v0 = true;
                }
            }
            if (v0) ** GOTO lbl-1000
            $this$all$iv = (Iterable)real;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v1 = true;
            } else {
                for (T element$iv : $this$all$iv) {
                    it = (ThreadInfo)element$iv;
                    $i$a$-all-ThreadInfoRenderer$oneType$2$2 = false;
                    if (it instanceof NativeThread) continue;
                    v1 = false;
                    break block10;
                }
                v1 = true;
            }
        }
        if (v1) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        var13_3.oneType = var14_17 = v2;
    }

    public static final /* synthetic */ int access$getMaxMetricWidth$p(ThreadInfoRenderer $this) {
        return $this.maxMetricWidth;
    }

    public static final /* synthetic */ void access$setMaxMetricWidth$p(ThreadInfoRenderer $this, int n) {
        $this.maxMetricWidth = n;
    }
}

