/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.callusage;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.profiler.ui.callusage.Percentage;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0002#$B\u001c\u0012\u0015\b\u0002\u0010\u0003\u001a\u000f\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0003J:\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u000f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0015H\u0003J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0003\u001a\u000f\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Lcom/intellij/profiler/ui/callusage/CallUsageTableCellRenderer;", "Lcom/intellij/ui/components/JBLabel;", "Ljavax/swing/table/TableCellRenderer;", "undefined", "Lkotlin/Function0;", "", "Lorg/jetbrains/annotations/Nls;", "(Lkotlin/jvm/functions/Function0;)V", "SPARK_LINE_COLOR", "Lcom/intellij/ui/JBColor;", "percentage", "Lcom/intellij/profiler/ui/callusage/CallUsageTableCellRenderer$PercentageState;", "getUndefined", "()Lkotlin/jvm/functions/Function0;", "formatValue", "value", "", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "", "isSelected", "", "hasFocus", "row", "", "column", "isOpaque", "nlsSafe", "any", "paintComponent", "", "g", "Ljava/awt/Graphics;", "Companion", "PercentageState", "intellij.profiler.common"})
public final class CallUsageTableCellRenderer
extends JBLabel
implements TableCellRenderer {
    private final JBColor SPARK_LINE_COLOR;
    private final PercentageState percentage;
    @Nullable
    private final Function0<String> undefined;
    public static final int SPACING_SIZE = 8;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        CallUsageTableCellRenderer callUsageTableCellRenderer = this;
        if (callUsageTableCellRenderer == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.components.JBLabel");
        }
        JBLabel comp = callUsageTableCellRenderer;
        TableColumn tableColumn = table.getColumnModel().getColumn(column2);
        Intrinsics.checkNotNullExpressionValue((Object)tableColumn, (String)"table.columnModel.getColumn(column)");
        int width = tableColumn.getWidth();
        this.setBackground(RenderingUtil.getBackground((JTable)table, (boolean)isSelected));
        this.setForeground(RenderingUtil.getForeground((JTable)table, (boolean)isSelected));
        this.percentage.clear();
        Object object = value2;
        if (object instanceof Percentage) {
            this.percentage.setWidth(MathKt.roundToInt((double)((double)width * ((Percentage)value2).getValue())));
            this.percentage.setX(0);
            this.percentage.setColor(isSelected ? ColorUtil.mix((Color)this.getBackground(), (Color)this.getForeground(), (double)0.2) : (Color)this.SPARK_LINE_COLOR);
            string = this.formatValue(((Percentage)value2).getNatureValue());
        } else if (object instanceof Long) {
            string = this.formatValue((Number)value2);
        } else {
            if (!isSelected) {
                this.setForeground(UIUtil.getLabelDisabledForeground());
            }
            if (value2 != null) {
                string = this.nlsSafe(value2);
            } else {
                Function0<String> function0 = this.undefined;
                string = function0 != null ? (String)function0.invoke() : null;
            }
        }
        comp.setText(string);
        return (Component)((Object)this);
    }

    @NlsSafe
    private final String formatValue(Number value2) {
        Object object = value2;
        object = object instanceof Integer || object instanceof Long ? "%,d" : (object instanceof Float || object instanceof Double ? "%.2f" : "%s");
        Object[] objectArray = new Object[]{value2};
        boolean bl = false;
        String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(this, *args)");
        return string;
    }

    @NlsSafe
    private final String nlsSafe(Object any) {
        return any.toString();
    }

    public boolean isOpaque() {
        return false;
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.percentage.getColor());
        int pad = JBUI.scale((int)1);
        int n = this.percentage.getWidth();
        int n2 = 1;
        boolean bl = false;
        g.fillRect(this.percentage.getX(), pad, Math.max(n, n2), this.getHeight() - pad * 2);
        super.paintComponent(g);
    }

    @Nullable
    public final Function0<String> getUndefined() {
        return this.undefined;
    }

    public CallUsageTableCellRenderer(@Nullable Function0<String> undefined) {
        this.undefined = undefined;
        this.SPARK_LINE_COLOR = new JBColor(12769014, 4543843);
        this.percentage = new PercentageState();
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
        this.setHorizontalAlignment(4);
    }

    public /* synthetic */ CallUsageTableCellRenderer(Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = null;
        }
        this((Function0<String>)function0);
    }

    public CallUsageTableCellRenderer() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/ui/callusage/CallUsageTableCellRenderer$PercentageState;", "", "()V", "color", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "width", "", "getWidth", "()I", "setWidth", "(I)V", "x", "getX", "setX", "clear", "", "updateState", "intellij.profiler.common"})
    private static final class PercentageState {
        private int x;
        private int width;
        @Nullable
        private Color color;

        public final int getX() {
            return this.x;
        }

        public final void setX(int n) {
            this.x = n;
        }

        public final int getWidth() {
            return this.width;
        }

        public final void setWidth(int n) {
            this.width = n;
        }

        @Nullable
        public final Color getColor() {
            return this.color;
        }

        public final void setColor(@Nullable Color color) {
            this.color = color;
        }

        public final void updateState(int x, int width, @Nullable Color color) {
            this.x = x;
            this.width = width;
            this.color = color;
        }

        public final void clear() {
            this.updateState(0, 0, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/profiler/ui/callusage/CallUsageTableCellRenderer$Companion;", "", "()V", "SPACING_SIZE", "", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

