/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.callusage;

import com.intellij.ide.TextCopyProvider;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.util.Disposer;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.CallWithValue;
import com.intellij.profiler.ui.MainCallTreeDataComponent;
import com.intellij.profiler.ui.calltree.TreeWithActionsKt;
import com.intellij.profiler.ui.callusage.ActionsKt;
import com.intellij.profiler.ui.callusage.CallUsageNodeKt;
import com.intellij.profiler.ui.callusage.CallUsagePopup;
import com.intellij.profiler.ui.callusage.FlameChartColorsRenderer;
import com.intellij.profiler.ui.callusage.FlameGraphComponent;
import com.intellij.profiler.ui.flamegraph.CallUsageNodeFlameGraphModel;
import com.intellij.profiler.ui.flamegraph.FlameGraphModel;
import com.intellij.profiler.ui.flamegraph.FlameGraphMouseListener;
import com.intellij.profiler.ui.flamegraph.FlameGraphNode;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanel;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanelKt;
import com.intellij.profiler.ui.flamegraph.FlameGraphRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 $2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001$B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"J\u001c\u0010#\u001a\u00020\u001b2\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rj\u0004\u0018\u0001`\u000fR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000e0\rj\u0002`\u000f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R@\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rj\u0004\u0018\u0001`\u000f2\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rj\u0004\u0018\u0001`\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/profiler/ui/callusage/FlameGraphComponent;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "parentComponent", "Lcom/intellij/profiler/ui/MainCallTreeDataComponent;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "(Lcom/intellij/profiler/ui/MainCallTreeDataComponent;Lcom/intellij/profiler/api/ValueMetric;)V", "filterSlider", "Ljavax/swing/JSlider;", "flameGraphPanel", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "Lcom/intellij/profiler/model/CallTreeNode;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lcom/intellij/profiler/ui/callusage/CallUsageNode;", "getFlameGraphPanel", "()Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "value", "model", "getModel", "()Lcom/intellij/profiler/model/CallTreeNode;", "setModel", "(Lcom/intellij/profiler/model/CallTreeNode;)V", "popup", "Lcom/intellij/profiler/ui/callusage/CallUsagePopup;", "dispose", "", "getData", "", "dataId", "", "setFilterSliderVisible", "isVisible", "", "update", "Companion", "intellij.profiler.common"})
public final class FlameGraphComponent
extends BorderLayoutPanel
implements Disposable,
DataProvider {
    private final CallUsagePopup popup;
    @NotNull
    private final FlameGraphPanel<CallTreeNode<BaseCallStackElement>> flameGraphPanel;
    private JSlider filterSlider;
    @Nullable
    private CallTreeNode<BaseCallStackElement> model;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final FlameGraphPanel<CallTreeNode<BaseCallStackElement>> getFlameGraphPanel() {
        return this.flameGraphPanel;
    }

    @Nullable
    public final CallTreeNode<BaseCallStackElement> getModel() {
        return this.model;
    }

    public final void setModel(@Nullable CallTreeNode<BaseCallStackElement> value2) {
        if (Intrinsics.areEqual(this.model, value2)) {
            return;
        }
        this.model = value2;
        this.update(value2);
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        CallTreeNode<BaseCallStackElement> usage;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        FlameGraphNode<CallTreeNode<BaseCallStackElement>> flameGraphNode = this.flameGraphPanel.getSearchResultNode();
        if (flameGraphNode == null) {
            flameGraphNode = this.flameGraphPanel.getSelectedNode();
        }
        CallTreeNode<BaseCallStackElement> callTreeNode = usage = flameGraphNode != null ? flameGraphNode.getContent() : null;
        if (CallUsageNodeKt.getSELECTED_CALL_USAGE().is(dataId)) {
            return usage;
        }
        if (TreeWithActionsKt.getSELECTED_ELEMENT().is(dataId)) {
            CallTreeNode<BaseCallStackElement> callTreeNode2 = usage;
            return callTreeNode2 != null && (callTreeNode2 = (CallWithValue)callTreeNode2.getData()) != null ? (BaseCallStackElement)callTreeNode2.getCall() : null;
        }
        if (PlatformDataKeys.CONTEXT_MENU_POINT.is(dataId) && usage != null) {
            return FlameGraphPanelKt.getContextMenuPointData(this.flameGraphPanel, usage);
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return new TextCopyProvider(this, usage){
                final /* synthetic */ FlameGraphComponent this$0;
                final /* synthetic */ CallTreeNode $usage;

                @NotNull
                public List<String> getTextLinesToCopy() {
                    String string;
                    CallTreeNode callTreeNode = this.$usage;
                    if (callTreeNode != null) {
                        CallTreeNode callTreeNode2 = callTreeNode;
                        boolean bl = false;
                        boolean bl2 = false;
                        CallTreeNode it = callTreeNode2;
                        boolean bl3 = false;
                        string = this.this$0.getFlameGraphPanel().getRenderer().getDisplayableText(this.this$0.getFlameGraphPanel().getModel(), it);
                    } else {
                        string = null;
                    }
                    String text2 = string;
                    return CollectionsKt.listOfNotNull(text2);
                }
                {
                    this.this$0 = this$0;
                    this.$usage = $captured_local_variable$1;
                }
            };
        }
        return null;
    }

    public final void setFilterSliderVisible(boolean isVisible2) {
        if (this.filterSlider != null) {
            this.remove(this.filterSlider);
            this.filterSlider = null;
        }
        if (isVisible2) {
            JSlider jSlider = this.filterSlider = Companion.createFilterSlider(this.flameGraphPanel);
            Intrinsics.checkNotNull((Object)jSlider);
            Intrinsics.checkNotNullExpressionValue((Object)this.addToRight(jSlider), (String)"addToRight(filterSlider!!)");
        } else {
            FlameGraphRenderer<CallTreeNode<BaseCallStackElement>> flameGraphRenderer = this.flameGraphPanel.getRenderer();
            if (!(flameGraphRenderer instanceof FlameChartColorsRenderer)) {
                flameGraphRenderer = null;
            }
            FlameChartColorsRenderer flameChartColorsRenderer = (FlameChartColorsRenderer)flameGraphRenderer;
            if (flameChartColorsRenderer != null) {
                flameChartColorsRenderer.setFilterValue(0.0);
            }
        }
        this.revalidate();
        this.repaint();
    }

    public final void update(@Nullable CallTreeNode<BaseCallStackElement> model2) {
        CallTreeNode<BaseCallStackElement> callTreeNode = model2;
        this.flameGraphPanel.setModel(callTreeNode == null ? FlameGraphModel.Companion.createEmptyModel() : (FlameGraphModel)new CallUsageNodeFlameGraphModel<BaseCallStackElement>(model2));
    }

    public void dispose() {
    }

    public FlameGraphComponent(@NotNull MainCallTreeDataComponent parentComponent, @NotNull ValueMetric metric) {
        Object $this$apply;
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.popup = CallUsagePopup.Companion.of((Component)((Object)this), parentComponent);
        Object object = new FlameGraphPanel();
        boolean bl = false;
        boolean bl2 = false;
        FlameGraphPanel flameGraphPanel = object;
        FlameGraphComponent flameGraphComponent = this;
        boolean bl3 = false;
        ((FlameGraphPanel)((Object)$this$apply)).setModel(FlameGraphModel.Companion.createEmptyModel());
        ((FlameGraphPanel)((Object)$this$apply)).setRenderer(new FlameChartColorsRenderer(parentComponent.getCallStackElementRenderer(), metric));
        ((FlameGraphPanel)((Object)$this$apply)).setInverted(((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getFlameGraphState().getIcicleGraph());
        $this$apply.addMouseListener((MouseListener)new FlameGraphMouseListener($this$apply, (ActionGroup)this.popup));
        Unit unit = Unit.INSTANCE;
        flameGraphComponent.flameGraphPanel = object;
        Disposer.register((Disposable)parentComponent, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.flameGraphPanel);
        object = ActionsKt.createActionToolbar(this).getComponent();
        bl = false;
        bl2 = false;
        $this$apply = object;
        flameGraphComponent = this;
        boolean bl4 = false;
        ((JComponent)$this$apply).setBorder(IdeBorderFactory.createBorder((int)4));
        unit = Unit.INSTANCE;
        flameGraphComponent.addToLeft((Component)object);
        this.addToCenter(this.flameGraphPanel.createScrollPane());
        this.setFilterSliderVisible(((CommonProfilerUiOptions)CallUsageNodeKt.getSettings().getState()).getFlameGraphState().getFilterSlider());
        this.update(this.model);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/ui/callusage/FlameGraphComponent$Companion;", "", "()V", "createFilterSlider", "Ljavax/swing/JSlider;", "flameGraphPanel", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "intellij.profiler.common"})
    public static final class Companion {
        @NotNull
        public final JSlider createFilterSlider(@NotNull FlameGraphPanel<?> flameGraphPanel) {
            JSlider filterSlider;
            block1: {
                Intrinsics.checkNotNullParameter(flameGraphPanel, (String)"flameGraphPanel");
                createFilterSlider.1 $fun$getFilterValue$1 = createFilterSlider.1.INSTANCE;
                filterSlider = new JSlider(1, 1, 100, 1);
                filterSlider.addChangeListener(new ChangeListener(filterSlider, flameGraphPanel){
                    final /* synthetic */ JSlider $filterSlider;
                    final /* synthetic */ FlameGraphPanel $flameGraphPanel;

                    public final void stateChanged(ChangeEvent it) {
                        double filterValue = createFilterSlider.1.INSTANCE.invoke(this.$filterSlider);
                        FlameGraphRenderer<T> flameGraphRenderer = this.$flameGraphPanel.getRenderer();
                        if (!(flameGraphRenderer instanceof FlameChartColorsRenderer)) {
                            flameGraphRenderer = null;
                        }
                        FlameChartColorsRenderer flameChartColorsRenderer = (FlameChartColorsRenderer)flameGraphRenderer;
                        if (flameChartColorsRenderer != null) {
                            flameChartColorsRenderer.setFilterValue(filterValue);
                        }
                        PropertiesComponent.getInstance().setValue("idea.profiler.flame.chart.filter.value", (float)filterValue, 0.005f);
                        this.$flameGraphPanel.repaint();
                    }
                    {
                        this.$filterSlider = jSlider;
                        this.$flameGraphPanel = flameGraphPanel;
                    }
                });
                float value2 = PropertiesComponent.getInstance().getFloat("idea.profiler.flame.chart.filter.value", 0.005f);
                filterSlider.setValue((int)((1.0 - (double)value2 / 0.05) * (double)filterSlider.getMaximum()));
                filterSlider.setBorder(IdeBorderFactory.createBorder((int)1));
                FlameGraphRenderer<?> flameGraphRenderer = flameGraphPanel.getRenderer();
                if (!(flameGraphRenderer instanceof FlameChartColorsRenderer)) {
                    flameGraphRenderer = null;
                }
                FlameChartColorsRenderer flameChartColorsRenderer = (FlameChartColorsRenderer)flameGraphRenderer;
                if (flameChartColorsRenderer == null) break block1;
                flameChartColorsRenderer.setFilterValue($fun$getFilterValue$1.invoke(filterSlider));
            }
            return filterSlider;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

