/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamechart;

import com.intellij.profiler.ui.flamechart.ColorType;
import com.intellij.profiler.ui.flamechart.FlameChartColorsKt;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.NotNullProducer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.UIManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0005J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0005H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0005H$J\f\u0010\u0011\u001a\u00020\u0006*\u00020\u0005H\u0004J\f\u0010\u0012\u001a\u00020\u0006*\u00020\u0005H\u0004R'\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/ui/flamechart/FlameChartColorScheme;", "", "()V", "colorScheme", "", "Lcom/intellij/profiler/ui/flamechart/ColorType;", "Lcom/intellij/ui/JBColor;", "getColorScheme", "()Ljava/util/Map;", "colorScheme$delegate", "Lkotlin/Lazy;", "color", "type", "convert", "getPrefix", "", "produce", "colorize", "shadow", "intellij.profiler.common"})
public abstract class FlameChartColorScheme {
    private final Lazy colorScheme$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<ColorType, ? extends JBColor>>(this){
        final /* synthetic */ FlameChartColorScheme this$0;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<ColorType, JBColor> invoke() {
            void $this$mapTo$iv$iv;
            ColorType[] $this$map$iv = ColorType.values();
            boolean $i$f$map = false;
            ColorType[] colorTypeArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var6_6 = $this$mapTo$iv$iv;
            int n = ((void)var6_6).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var10_10 = item$iv$iv = var6_6[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it, (Object)FlameChartColorScheme.access$convert(this.this$0, (ColorType)it));
                collection.add(pair);
            }
            return MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }
        {
            this.this$0 = flameChartColorScheme;
            super(0);
        }
    }));

    private final Map<ColorType, JBColor> getColorScheme() {
        Lazy lazy = this.colorScheme$delegate;
        FlameChartColorScheme flameChartColorScheme = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Map)lazy.getValue();
    }

    private final JBColor convert(ColorType type) {
        String propName = "FlameGraph." + this.getPrefix() + "Cell." + FlameChartColorsKt.access$toStyle(type);
        return new JBColor(new NotNullProducer(this, propName, type){
            final /* synthetic */ FlameChartColorScheme this$0;
            final /* synthetic */ String $propName;
            final /* synthetic */ ColorType $type;

            @NotNull
            public final Color produce() {
                Color color = UIManager.getColor(this.$propName);
                if (color == null) {
                    FlameChartColorScheme flameChartColorScheme = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    FlameChartColorScheme it = flameChartColorScheme;
                    boolean bl3 = false;
                    JBColor defaultColor = this.this$0.produce(this.$type);
                    UIManager.put(this.$propName, defaultColor);
                    color = (Color)defaultColor;
                }
                return color;
            }
            {
                this.this$0 = flameChartColorScheme;
                this.$propName = string;
                this.$type = colorType;
            }
        });
    }

    @NotNull
    public String getPrefix() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        return string;
    }

    @NotNull
    protected final JBColor colorize(@NotNull ColorType $this$colorize) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$colorize), (String)"$this$colorize");
        return new JBColor(new NotNullProducer(this, $this$colorize){
            final /* synthetic */ FlameChartColorScheme this$0;
            final /* synthetic */ ColorType $this_colorize;

            @NotNull
            public final Color produce() {
                return ColorUtil.mix((Color)((Color)this.this$0.color(this.$this_colorize)), (Color)Color.BLACK, (double)0.75);
            }
            {
                this.this$0 = flameChartColorScheme;
                this.$this_colorize = colorType;
            }
        });
    }

    @NotNull
    protected final JBColor shadow(@NotNull ColorType $this$shadow) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$shadow), (String)"$this$shadow");
        return new JBColor(new NotNullProducer(this, $this$shadow){
            final /* synthetic */ FlameChartColorScheme this$0;
            final /* synthetic */ ColorType $this_shadow;

            @NotNull
            public final Color produce() {
                return ColorUtil.mix((Color)((Color)this.this$0.color(this.$this_shadow)), (Color)Color.DARK_GRAY, (double)0.3);
            }
            {
                this.this$0 = flameChartColorScheme;
                this.$this_shadow = colorType;
            }
        });
    }

    @NotNull
    public final JBColor color(@NotNull ColorType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        JBColor jBColor = this.getColorScheme().get((Object)type);
        if (jBColor == null) {
            throw (Throwable)new NoSuchElementException("Cannot find color for type " + this + '}');
        }
        return jBColor;
    }

    @NotNull
    protected abstract JBColor produce(@NotNull ColorType var1);

    public static final /* synthetic */ JBColor access$convert(FlameChartColorScheme $this, ColorType type) {
        return $this.convert(type);
    }
}

