/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamegraph;

import com.intellij.util.animation.Easing;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00014B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tBA\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000fJ0\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J8\u0010(\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010,\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010-\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u00020%2\u0006\u00100\u001a\u00020'J\u0014\u00101\u001a\u00020\u0005*\u00020\u00052\u0006\u00102\u001a\u000203H\u0002R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u000e\u0010\u000e\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011\u00a8\u00065"}, d2={"Lcom/intellij/profiler/ui/flamegraph/BoxShadowPainter;", "", "size", "", "color", "Ljava/awt/Color;", "spline", "easing", "Lcom/intellij/util/animation/Easing;", "(ILjava/awt/Color;ILcom/intellij/util/animation/Easing;)V", "top", "left", "bottom", "right", "segments", "(IIIILjava/awt/Color;ILcom/intellij/util/animation/Easing;)V", "getBottom", "()I", "getColor", "()Ljava/awt/Color;", "colors", "", "[Ljava/awt/Color;", "getLeft", "getRight", "", "getTop", "createAffineTransform", "Ljava/awt/geom/AffineTransform;", "src", "x", "y", "width", "height", "fillBottom", "", "g", "Ljava/awt/Graphics2D;", "r", "Ljava/awt/Rectangle;", "fillCorner", "corner", "Lcom/intellij/profiler/ui/flamegraph/BoxShadowPainter$Corner;", "fillLeft", "fillRight", "fillTop", "paintShadow", "graphics", "rectangle", "alpha", "multiplier", "", "Corner", "intellij.profiler.common"})
public final class BoxShadowPainter {
    private final Color[] colors;
    private final float[] segments;
    private final int top;
    private final int left;
    private final int bottom;
    private final int right;
    @NotNull
    private final Color color;
    private final Easing easing;

    private final Color alpha(Color $this$alpha, double multiplier) {
        return new Color($this$alpha.getRed(), $this$alpha.getGreen(), $this$alpha.getBlue(), MathKt.roundToInt((double)((double)$this$alpha.getAlpha() * multiplier)));
    }

    public final void paintShadow(@NotNull Graphics2D graphics, @NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this.fillLeft(graphics, rectangle);
        this.fillCorner(graphics, rectangle.x, rectangle.y, this.left, this.top, Corner.UL);
        this.fillTop(graphics, rectangle);
        this.fillCorner(graphics, rectangle.x + rectangle.width, rectangle.y, this.right, this.top, Corner.UR);
        this.fillRight(graphics, rectangle);
        this.fillCorner(graphics, rectangle.x + rectangle.width, rectangle.y + rectangle.height, this.right, this.bottom, Corner.BR);
        this.fillBottom(graphics, rectangle);
        this.fillCorner(graphics, rectangle.x, rectangle.y + rectangle.height, this.left, this.bottom, Corner.BL);
    }

    private final void fillTop(Graphics2D g, Rectangle r) {
        double x = r.x;
        double y1 = r.y;
        double y2 = r.y - this.top;
        g.setPaint(new LinearGradientPaint(new Point2D.Double(x, y1), new Point2D.Double(x, y2), this.segments, this.colors));
        g.fillRect(r.x, r.y - this.top, r.width, this.top);
    }

    private final void fillLeft(Graphics2D g, Rectangle r) {
        double x1 = r.x;
        double x2 = r.x - this.left;
        double y = r.y;
        g.setPaint(new LinearGradientPaint(new Point2D.Double(x1, y), new Point2D.Double(x2, y), this.segments, this.colors));
        g.fillRect(r.x - this.left, r.y, this.left, r.height);
    }

    private final void fillBottom(Graphics2D g, Rectangle r) {
        double x = r.x;
        double y1 = r.y + r.height;
        double y2 = r.y + r.height + this.bottom;
        g.setPaint(new LinearGradientPaint(new Point2D.Double(x, y1), new Point2D.Double(x, y2), this.segments, this.colors));
        g.fillRect(r.x, r.y + r.height, r.width, this.bottom);
    }

    private final void fillRight(Graphics2D g, Rectangle r) {
        double x1 = r.x + r.width;
        double x2 = r.x + r.width + this.right;
        double y = r.y;
        g.setPaint(new LinearGradientPaint(new Point2D.Double(x1, y), new Point2D.Double(x2, y), this.segments, this.colors));
        g.fillRect(r.x + r.width, r.y, this.right, r.height);
    }

    private final void fillCorner(Graphics2D g, int x, int y, int width, int height, Corner corner) {
        Point2D.Double center = new Point2D.Double(x, y);
        AffineTransform oldTransform = g.getTransform();
        boolean bl = false;
        int size2 = Math.max(width, height);
        AffineTransform affineTransform = oldTransform;
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"oldTransform");
        g.setTransform(this.createAffineTransform(affineTransform, x, y, width, height));
        g.setPaint(new RadialGradientPaint(center, size2, this.segments, this.colors));
        int cx = corner == Corner.UL || corner == Corner.BL ? x - size2 : x;
        int cy = corner == Corner.UL || corner == Corner.UR ? y - size2 : y;
        g.fillRect(cx, cy, size2, size2);
        g.setTransform(oldTransform);
    }

    private final AffineTransform createAffineTransform(AffineTransform src, int x, int y, int width, int height) {
        boolean bl = false;
        int size2 = Math.max(width, height);
        double sx = (double)size2 / (double)width;
        double sy = (double)size2 / (double)height;
        AffineTransform transform = new AffineTransform(src);
        transform.translate((double)x - (double)x / sx, (double)y - (double)y / sy);
        transform.scale(1.0 / sx, 1.0 / sy);
        return transform;
    }

    public final int getTop() {
        return this.top;
    }

    public final int getLeft() {
        return this.left;
    }

    public final int getBottom() {
        return this.bottom;
    }

    public final int getRight() {
        return this.right;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public BoxShadowPainter(int top, int left, int bottom, int right, @NotNull Color color, int segments, @NotNull Easing easing2) {
        int i2;
        Color[] colorArray;
        int n;
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)easing2, (String)"easing");
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.color = color;
        this.easing = easing2;
        if (segments < 2) {
            throw (Throwable)new IllegalArgumentException("Segment count can not be less than 2, actual value is " + segments);
        }
        BoxShadowPainter boxShadowPainter = this;
        Object[] objectArray = new Color[segments];
        int n2 = 0;
        while (n2 < segments) {
            Color color2;
            int n3 = n2;
            n = n2++;
            colorArray = objectArray;
            boolean bl = false;
            colorArray[n] = color2 = this.alpha(this.color, 1.0 - (double)i2 / ((double)segments - 1.0));
        }
        colorArray = objectArray;
        boxShadowPainter.colors = colorArray;
        boxShadowPainter = this;
        objectArray = new float[segments];
        n2 = 0;
        while (n2 < segments) {
            i2 = n2;
            n = n2++;
            colorArray = objectArray;
            boolean bl = false;
            float f = (float)this.easing.calc((double)i2 / ((double)segments - 1.0));
            colorArray[n] = (Color)f;
        }
        colorArray = objectArray;
        boxShadowPainter.segments = (float[])colorArray;
    }

    public /* synthetic */ BoxShadowPainter(int n, int n2, int n3, int n4, Color color, int n5, Easing easing2, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 0x20) != 0) {
            n5 = 2;
        }
        if ((n6 & 0x40) != 0) {
            easing2 = 1.INSTANCE;
        }
        this(n, n2, n3, n4, color, n5, easing2);
    }

    public BoxShadowPainter(int size2, @NotNull Color color, int spline, @NotNull Easing easing2) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)easing2, (String)"easing");
        this(size2, size2, size2, size2, color, spline, easing2);
    }

    public /* synthetic */ BoxShadowPainter(int n, Color color, int n2, Easing easing2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = 2;
        }
        if ((n3 & 8) != 0) {
            easing2 = 2.INSTANCE;
        }
        this(n, color, n2, easing2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/ui/flamegraph/BoxShadowPainter$Corner;", "", "(Ljava/lang/String;I)V", "UL", "UR", "BL", "BR", "intellij.profiler.common"})
    private static final class Corner
    extends Enum<Corner> {
        public static final /* enum */ Corner UL;
        public static final /* enum */ Corner UR;
        public static final /* enum */ Corner BL;
        public static final /* enum */ Corner BR;
        private static final /* synthetic */ Corner[] $VALUES;

        static {
            Corner[] cornerArray = new Corner[4];
            Corner[] cornerArray2 = cornerArray;
            cornerArray[0] = UL = new Corner();
            cornerArray[1] = UR = new Corner();
            cornerArray[2] = BL = new Corner();
            cornerArray[3] = BR = new Corner();
            $VALUES = cornerArray;
        }

        public static Corner[] values() {
            return (Corner[])$VALUES.clone();
        }

        public static Corner valueOf(String string) {
            return Enum.valueOf(Corner.class, string);
        }
    }
}

