/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.treetable;

import com.intellij.openapi.Disposable;
import com.intellij.ui.CellRendererPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MouseAwareTreeCellRendererPanel
extends CellRendererPanel
implements TreeCellRenderer,
Disposable {
    protected final JTree tree;
    protected boolean isUpdateCursor = true;
    private final HighlightState highlight = new HighlightState();
    private final MouseAdapter listener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (MouseAwareTreeCellRendererPanel.this.highlight.component != null) {
                MouseAwareTreeCellRendererPanel.this.mousePressed(e);
                MouseAwareTreeCellRendererPanel.this.processMouseMovements(e.getPoint());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (MouseAwareTreeCellRendererPanel.this.highlight.component != null) {
                MouseAwareTreeCellRendererPanel.this.mouseClicked(e);
                MouseAwareTreeCellRendererPanel.this.processMouseMovements(e.getPoint());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (MouseAwareTreeCellRendererPanel.this.highlight.component != null) {
                MouseAwareTreeCellRendererPanel.this.mouseReleased(e);
                MouseAwareTreeCellRendererPanel.this.processMouseMovements(e.getPoint());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            MouseAwareTreeCellRendererPanel.this.processMouseMovements(Objects.requireNonNull(e).getPoint());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            MouseAwareTreeCellRendererPanel.this.processMouseMovements(Objects.requireNonNull(e).getPoint());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            MouseAwareTreeCellRendererPanel.this.processMouseMovements(Objects.requireNonNull(e).getPoint());
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            MouseAwareTreeCellRendererPanel.this.tree.getParent().dispatchEvent(e);
            MouseAwareTreeCellRendererPanel.this.update();
        }
    };

    protected MouseAwareTreeCellRendererPanel(JTree tree) {
        this.tree = tree;
        this.tree.addMouseListener(this.listener);
        this.tree.addMouseMotionListener(this.listener);
        this.tree.addMouseWheelListener(this.listener);
    }

    public int getHighlightedRow() {
        return this.highlight.row;
    }

    @Nullable
    public Object getHighlightedValue() {
        return this.highlight.value;
    }

    @Nullable
    public JComponent getHighlightedComponent() {
        return this.highlight.component;
    }

    protected void mousePressed(MouseEvent event) {
    }

    protected void mouseClicked(MouseEvent event) {
    }

    protected void mouseReleased(MouseEvent event) {
    }

    public boolean isHighlightEnabled(int row2, Object value2) {
        return true;
    }

    public void update() {
        Point location = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(location, this.tree);
        this.processMouseMovements(location);
    }

    protected abstract JComponent @NotNull [] getHighlightables();

    public void dispose() {
        this.tree.removeMouseListener(this.listener);
        this.tree.removeMouseMotionListener(this.listener);
        this.tree.removeMouseWheelListener(this.listener);
    }

    private void processMouseMovements(@NotNull Point mousePosition) {
        TreePath path2;
        int row2;
        if (mousePosition == null) {
            MouseAwareTreeCellRendererPanel.$$$reportNull$$$0(0);
        }
        if ((row2 = this.tree.getRowForPath(path2 = this.tree.getClosestPathForLocation(mousePosition.x, mousePosition.y))) >= 0 && this.isHighlightEnabled(row2, Objects.requireNonNull(path2).getLastPathComponent())) {
            boolean focus;
            boolean leaf;
            boolean selected2 = this.tree.isRowSelected(row2);
            boolean expanded = this.tree.isExpanded(row2);
            Object value2 = Objects.requireNonNull(path2).getLastPathComponent();
            Component component2 = this.getTreeCellRendererComponent(this.tree, value2, selected2, expanded, leaf = this.tree.getModel().isLeaf(value2), row2, focus = this.tree.hasFocus());
            if (component2 != this) {
                throw new IllegalStateException("MouseAwareTreeCellRendererPanel must return itself");
            }
            Rectangle bounds2 = this.tree.getRowBounds(row2);
            component2.setBounds(bounds2);
            component2.validate();
            for (JComponent highlightable : this.getHighlightables()) {
                Rectangle b = highlightable.getBounds();
                b.x += bounds2.x;
                b.y += bounds2.y;
                if (!b.contains(mousePosition)) continue;
                if (!this.highlight.equalsTo(highlightable, b, value2, row2)) {
                    this.highlight.repaint(this.tree);
                    this.highlight.setComponent(highlightable, b, value2, row2);
                    if (this.isUpdateCursor) {
                        this.tree.setCursor(Cursor.getPredefinedCursor(12));
                    }
                    this.tree.repaint(b);
                }
                return;
            }
        }
        this.highlight.repaint(this.tree);
        this.highlight.clear();
        if (this.isUpdateCursor && this.tree.getRowCount() > 0) {
            this.tree.setCursor(Cursor.getDefaultCursor());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mousePosition", "com/intellij/profiler/ui/treetable/MouseAwareTreeCellRendererPanel", "processMouseMovements"));
    }

    private static final class HighlightState {
        private JComponent component;
        private final Rectangle componentBounds = new Rectangle();
        private Object value;
        private int row = -1;

        private HighlightState() {
        }

        public void setComponent(JComponent component2, Rectangle componentBounds, Object value2, int row2) {
            this.component = component2;
            this.componentBounds.setBounds(componentBounds);
            this.value = value2;
            this.row = row2;
        }

        public void clear() {
            this.component = null;
            this.componentBounds.setBounds(0, 0, 0, 0);
            this.value = null;
            this.row = -1;
        }

        public boolean equalsTo(JComponent component2, Rectangle componentBounds, Object value2, int row2) {
            return row2 == this.row && component2 == this.component && Objects.equals(componentBounds, this.componentBounds) && Objects.equals(value2, this.value);
        }

        public void repaint(JTree tree) {
            if (this.component != null) {
                tree.repaint(this.componentBounds);
            }
        }
    }
}

