/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class IndexCacheManagerImpl
implements CacheManager {
    @NotNull
    private final Project myProject;

    public IndexCacheManagerImpl(@NotNull Project project) {
        if (project == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public PsiFile @NotNull [] getFilesWithWord(@NotNull String word, short occurenceMask, @NotNull GlobalSearchScope scope2, boolean caseSensitively) {
        if (word == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(1);
        }
        if (scope2 == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDefault()) {
            if (PsiFile.EMPTY_ARRAY == null) {
                IndexCacheManagerImpl.$$$reportNull$$$0(3);
            }
            return PsiFile.EMPTY_ARRAY;
        }
        ArrayList result2 = new ArrayList();
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        this.processFilesWithWord((Processor<? super PsiFile>)processor2, word, occurenceMask, scope2, caseSensitively);
        PsiFile[] psiFileArray = result2.isEmpty() ? PsiFile.EMPTY_ARRAY : result2.toArray(PsiFile.EMPTY_ARRAY);
        if (psiFileArray == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(4);
        }
        return psiFileArray;
    }

    public VirtualFile @NotNull [] getVirtualFilesWithWord(@NotNull String word, short occurenceMask, @NotNull GlobalSearchScope scope2, boolean caseSensitively) {
        if (word == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(5);
        }
        if (scope2 == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(6);
        }
        if (this.myProject.isDefault()) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                IndexCacheManagerImpl.$$$reportNull$$$0(7);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        ArrayList result2 = new ArrayList(5);
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE.ignoreDumbMode(() -> this.collectVirtualFilesWithWord(word, occurenceMask, scope2, caseSensitively, (Processor<? super VirtualFile>)processor2));
        VirtualFile[] virtualFileArray = result2.isEmpty() ? VirtualFile.EMPTY_ARRAY : result2.toArray(VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(8);
        }
        return virtualFileArray;
    }

    public boolean processVirtualFilesWithAllWords(@NotNull Collection<String> words, short occurenceMask, @NotNull GlobalSearchScope scope2, boolean caseSensitively, @NotNull Processor<? super VirtualFile> processor2) {
        if (words == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(9);
        }
        if (scope2 == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(10);
        }
        if (processor2 == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(11);
        }
        if (this.myProject.isDefault()) {
            return true;
        }
        PsiSearchHelperImpl.TextIndexQuery query2 = PsiSearchHelperImpl.TextIndexQuery.fromWords(words, caseSensitively, false, occurenceMask);
        if (PsiSearchHelperImpl.LOG.isTraceEnabled()) {
            PsiSearchHelperImpl.LOG.trace("searching for words " + words + " in " + scope2);
        }
        try {
            return FileBasedIndex.getInstance().processFilesContainingAllKeys(query2.toFileBasedIndexQueries(), scope2, processor2);
        }
        catch (IndexNotReadyException e) {
            throw new ProcessCanceledException();
        }
    }

    private void collectVirtualFilesWithWord(@NotNull String word, short occurrenceMask, @NotNull GlobalSearchScope scope2, boolean caseSensitively, @NotNull Processor<? super VirtualFile> fileProcessor) {
        if (word == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(12);
        }
        if (scope2 == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(13);
        }
        if (fileProcessor == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(14);
        }
        this.processVirtualFilesWithAllWords(Collections.singleton(word), occurrenceMask, scope2, caseSensitively, fileProcessor);
    }

    public boolean processFilesWithWord(final @NotNull Processor<? super PsiFile> psiFileProcessor, @NotNull String word, short occurrenceMask, @NotNull GlobalSearchScope scope2, boolean caseSensitively) {
        if (psiFileProcessor == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(15);
        }
        if (word == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(16);
        }
        if (scope2 == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(17);
        }
        ArrayList result2 = new ArrayList(5);
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        this.collectVirtualFilesWithWord(word, occurrenceMask, scope2, caseSensitively, (Processor<? super VirtualFile>)processor2);
        if (result2.isEmpty()) {
            return true;
        }
        final PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ReadActionProcessor<VirtualFile> virtualFileProcessor = new ReadActionProcessor<VirtualFile>(){

            public boolean processInReadAction(VirtualFile virtualFile2) {
                if (virtualFile2.isValid()) {
                    PsiFile psiFile = psiManager.findFile(virtualFile2);
                    return psiFile == null || psiFileProcessor.process((Object)psiFile);
                }
                return true;
            }
        };
        for (VirtualFile vFile : result2) {
            ProgressIndicatorProvider.checkCanceled();
            if (virtualFileProcessor.process((Object)vFile)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileProcessor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFileProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithWord";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFilesWithWord";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithWord";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFilesWithWord";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processVirtualFilesWithAllWords";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectVirtualFilesWithWord";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processFilesWithWord";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

